/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.entity.item;

import com.flowpowered.math.vector.Vector3d;
import java.util.ArrayList;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.entity.vehicle.minecart.Minecart;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.entity.AttackEntityEvent;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.bridge.entity.item.EntityMinecartBridge;
import org.spongepowered.common.mixin.core.entity.EntityMixin;
import org.spongepowered.common.util.VectorSerializer;

@Mixin(value={EntityMinecart.class})
public abstract class EntityMinecartMixin
extends EntityMixin
implements EntityMinecartBridge {
    private double impl$maxSpeed = 0.4;
    private boolean impl$slowWhenEmpty = true;
    private Vector3d impl$airborneMod = new Vector3d((double)0.95f, (double)0.95f, (double)0.95f);
    private Vector3d impl$derailedMod = new Vector3d(0.5, 0.5, 0.5);

    @Overwrite
    protected double func_174898_m() {
        return this.impl$maxSpeed;
    }

    @ModifyConstant(method={"moveDerailedMinecart"}, constant={@Constant(doubleValue=0.5, ordinal=0)})
    private double onDecelerateX(double defaultValue) {
        return this.impl$derailedMod.getX();
    }

    @ModifyConstant(method={"moveDerailedMinecart"}, constant={@Constant(doubleValue=0.5, ordinal=1)})
    private double onDecelerateY(double defaultValue) {
        return this.impl$derailedMod.getY();
    }

    @ModifyConstant(method={"moveDerailedMinecart"}, constant={@Constant(doubleValue=0.5, ordinal=2)})
    private double onDecelerateZ(double defaultValue) {
        return this.impl$derailedMod.getZ();
    }

    @Redirect(method={"applyDrag"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/item/EntityMinecart;isBeingRidden()Z"))
    private boolean onIsRidden(EntityMinecart self) {
        return !this.impl$slowWhenEmpty || this.func_184207_aI();
    }

    @Inject(method={"attackEntityFrom"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/item/EntityMinecart;removePassengers()V")}, cancellable=true)
    private void onAttackEntityFrom(DamageSource source, float amount, CallbackInfoReturnable<Boolean> cir) {
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
            frame.pushCause(source);
            AttackEntityEvent event = SpongeEventFactory.createAttackEntityEvent(frame.getCurrentCause(), new ArrayList(), (Minecart)((Object)this), 0, amount);
            SpongeImpl.postEvent(event);
            if (event.isCancelled()) {
                cir.setReturnValue(true);
            }
        }
    }

    @Override
    public void spongeImpl$readFromSpongeCompound(NBTTagCompound compound) {
        super.spongeImpl$readFromSpongeCompound(compound);
        if (compound.func_74764_b("maxSpeed")) {
            this.impl$maxSpeed = compound.func_74769_h("maxSpeed");
        }
        if (compound.func_74764_b("slowWhenEmpty")) {
            this.impl$slowWhenEmpty = compound.func_74767_n("slowWhenEmpty");
        }
        if (compound.func_74764_b("airborneModifier")) {
            this.impl$airborneMod = VectorSerializer.fromNbt(compound.func_74775_l("airborneModifier"));
        }
        if (compound.func_74764_b("derailedModifier")) {
            this.impl$derailedMod = VectorSerializer.fromNbt(compound.func_74775_l("derailedModifier"));
        }
    }

    @Override
    public void spongeImpl$writeToSpongeCompound(NBTTagCompound compound) {
        super.spongeImpl$writeToSpongeCompound(compound);
        compound.func_74780_a("maxSpeed", this.impl$maxSpeed);
        compound.func_74757_a("slowWhenEmpty", this.impl$slowWhenEmpty);
        compound.func_74782_a("airborneModifier", (NBTBase)VectorSerializer.toNbt(this.impl$airborneMod));
        compound.func_74782_a("derailedModifier", (NBTBase)VectorSerializer.toNbt(this.impl$derailedMod));
    }

    @Override
    public Vector3d bridge$getAirboneVelocityModifier() {
        return this.impl$airborneMod;
    }
}

