/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.item;

import com.flowpowered.math.vector.Vector3d;
import net.minecraft.entity.item.EntityFireworkRocket;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFirework;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.entity.EntityTypes;
import org.spongepowered.api.entity.Transform;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.projectile.Firework;
import org.spongepowered.api.entity.projectile.source.ProjectileSource;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.cause.EventContextKeys;
import org.spongepowered.api.event.entity.ConstructEntityEvent;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.bridge.explosives.FusedExplosiveBridge;
import org.spongepowered.common.bridge.world.WorldBridge;
import org.spongepowered.common.event.ShouldFire;
import org.spongepowered.common.item.inventory.util.ItemStackUtil;

@Mixin(value={ItemFirework.class})
public class ItemFireworkMixin
extends Item {
    @Inject(method={"onItemRightClick"}, at={@At(value="NEW", target="net/minecraft/entity/item/EntityFireworkRocket")}, locals=LocalCapture.CAPTURE_FAILSOFT, cancellable=true)
    private void spongeImpl$ThrowPreBeforeSpawning(World worldIn, EntityPlayer playerIn, EnumHand handIn, CallbackInfoReturnable<ActionResult<ItemStack>> cir, ItemStack stack) {
        if (this.spongeImpl$ThrowConstructPreEvent(worldIn, playerIn, stack)) {
            cir.setReturnValue((ActionResult<ItemStack>)new ActionResult(EnumActionResult.SUCCESS, (Object)stack));
        }
    }

    @Inject(method={"onItemUse"}, at={@At(value="NEW", target="net/minecraft/entity/item/EntityFireworkRocket")}, locals=LocalCapture.CAPTURE_FAILSOFT, cancellable=true)
    private void spongeImpl$ThrowPrimeEventsIfCancelled(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ, CallbackInfoReturnable<EnumActionResult> cir, ItemStack stack) {
        if (this.spongeImpl$ThrowConstructPreEvent(worldIn, player, stack)) {
            cir.setReturnValue(EnumActionResult.SUCCESS);
        }
    }

    private boolean spongeImpl$ThrowConstructPreEvent(World world, EntityPlayer player, ItemStack usedItem) {
        if (ShouldFire.CONSTRUCT_ENTITY_EVENT_PRE && !((WorldBridge)world).bridge$isFake()) {
            Vector3d targetPosition = new Vector3d(player.field_70165_t, player.field_70163_u, player.field_70161_v);
            Transform<org.spongepowered.api.world.World> targetTransform = new Transform<org.spongepowered.api.world.World>((org.spongepowered.api.world.World)world, targetPosition);
            try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
                frame.addContext(EventContextKeys.USED_ITEM, ItemStackUtil.snapshotOf(usedItem));
                frame.addContext(EventContextKeys.PROJECTILE_SOURCE, (ProjectileSource)player);
                frame.pushCause(player);
                ConstructEntityEvent.Pre event = SpongeEventFactory.createConstructEntityEventPre(Sponge.getCauseStackManager().getCurrentCause(), EntityTypes.FIREWORK, targetTransform);
                boolean bl = SpongeImpl.postEvent(event);
                return bl;
            }
        }
        return false;
    }

    @Inject(method={"onItemUse"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/World;spawnEntity(Lnet/minecraft/entity/Entity;)Z")}, locals=LocalCapture.CAPTURE_FAILSOFT, cancellable=true)
    private void spongeImpl$InjectPrimeEventAndCancel(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ, CallbackInfoReturnable<EnumActionResult> cir, ItemStack usedItem, EntityFireworkRocket rocket) {
        if (this.spongeImpl$ThrowPrimeEventAndGetCancel(worldIn, player, rocket, usedItem)) {
            cir.setReturnValue(EnumActionResult.SUCCESS);
        }
    }

    @Inject(method={"onItemRightClick"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/World;spawnEntity(Lnet/minecraft/entity/Entity;)Z")}, locals=LocalCapture.CAPTURE_FAILSOFT, cancellable=true)
    private void spongeImpl$InjectPrimeEventAndCancel(World worldIn, EntityPlayer player, EnumHand handIn, CallbackInfoReturnable<ActionResult<ItemStack>> cir, ItemStack usedItem, EntityFireworkRocket rocket) {
        if (this.spongeImpl$ThrowPrimeEventAndGetCancel(worldIn, player, rocket, usedItem)) {
            cir.setReturnValue((ActionResult<ItemStack>)new ActionResult(EnumActionResult.SUCCESS, (Object)usedItem));
        }
    }

    private boolean spongeImpl$ThrowPrimeEventAndGetCancel(World world, EntityPlayer player, EntityFireworkRocket rocket, ItemStack usedItem) {
        if (((WorldBridge)world).bridge$isFake()) {
            return false;
        }
        ((Firework)rocket).setShooter((Player)player);
        if (ShouldFire.PRIME_EXPLOSIVE_EVENT_PRE) {
            try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
                frame.addContext(EventContextKeys.USED_ITEM, ItemStackUtil.snapshotOf(usedItem));
                frame.addContext(EventContextKeys.PROJECTILE_SOURCE, (ProjectileSource)player);
                frame.pushCause(player);
                if (!((FusedExplosiveBridge)rocket).bridge$shouldPrime()) {
                    boolean bl = true;
                    return bl;
                }
            }
        }
        return false;
    }
}

