/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.scoreboard;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketDisplayObjective;
import net.minecraft.network.play.server.SPacketScoreboardObjective;
import net.minecraft.network.play.server.SPacketTeams;
import net.minecraft.network.play.server.SPacketUpdateScore;
import net.minecraft.scoreboard.IScoreCriteria;
import net.minecraft.scoreboard.ScoreObjective;
import net.minecraft.scoreboard.ScorePlayerTeam;
import net.minecraft.scoreboard.ServerScoreboard;
import net.minecraft.server.management.PlayerList;
import org.spongepowered.api.scoreboard.Score;
import org.spongepowered.api.scoreboard.Scoreboard;
import org.spongepowered.api.scoreboard.critieria.Criterion;
import org.spongepowered.api.scoreboard.displayslot.DisplaySlot;
import org.spongepowered.api.scoreboard.objective.displaymode.ObjectiveDisplayMode;
import org.spongepowered.api.text.Text;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.bridge.scoreboard.ScoreObjectiveBridge;
import org.spongepowered.common.bridge.scoreboard.ServerScoreboardBridge;
import org.spongepowered.common.mixin.core.scoreboard.ScorePlayerTeamAccessor;
import org.spongepowered.common.registry.type.scoreboard.DisplaySlotRegistryModule;
import org.spongepowered.common.scoreboard.SpongeObjective;
import org.spongepowered.common.scoreboard.SpongeScore;
import org.spongepowered.common.text.SpongeTexts;

@Mixin(value={ServerScoreboard.class})
public abstract class ServerScoreboardMixin
extends net.minecraft.scoreboard.Scoreboard
implements ServerScoreboardBridge {
    private List<EntityPlayerMP> impl$scoreboardPlayers = new ArrayList<EntityPlayerMP>();

    @Shadow
    protected abstract void func_96551_b();

    public ScoreObjective func_96535_a(String name, IScoreCriteria criteria) {
        SpongeObjective objective = new SpongeObjective(name, (Criterion)criteria);
        objective.setDisplayMode((ObjectiveDisplayMode)criteria.func_178790_c());
        ((Scoreboard)((Object)this)).addObjective(objective);
        return objective.getObjectiveFor(this);
    }

    @Inject(method={"onScoreObjectiveAdded"}, at={@At(value="RETURN")})
    private void impl$UpdatePlayersScoreObjective(ScoreObjective objective, CallbackInfo ci) {
        this.bridge$sendToPlayers((Packet<?>)new SPacketScoreboardObjective(objective, 0));
    }

    @Overwrite
    public void func_96530_a(int slot, @Nullable ScoreObjective objective) {
        SpongeObjective apiObjective = objective == null ? null : ((ScoreObjectiveBridge)objective).bridge$getSpongeObjective();
        DisplaySlot displaySlot = DisplaySlotRegistryModule.getInstance().getForIndex(slot).get();
        ((Scoreboard)((Object)this)).updateDisplaySlot(apiObjective, displaySlot);
    }

    public void func_96519_k(ScoreObjective objective) {
        ((Scoreboard)((Object)this)).removeObjective(((ScoreObjectiveBridge)objective).bridge$getSpongeObjective());
    }

    public void func_96511_d(ScorePlayerTeam team) {
        super.func_96511_d(team);
        ((ScorePlayerTeamAccessor)team).accessor$setScoreboard(null);
    }

    public net.minecraft.scoreboard.Score func_96529_a(String name, ScoreObjective objective) {
        return ((SpongeScore)((ScoreObjectiveBridge)objective).bridge$getSpongeObjective().getOrCreateScore(SpongeTexts.fromLegacy(name))).getScoreFor(objective);
    }

    public void func_178822_d(String name, ScoreObjective objective) {
        if (objective != null) {
            SpongeObjective spongeObjective = ((ScoreObjectiveBridge)objective).bridge$getSpongeObjective();
            Optional<Score> score = spongeObjective.getScore(SpongeTexts.fromLegacy(name));
            if (score.isPresent()) {
                spongeObjective.removeScore(score.get());
            } else {
                SpongeImpl.getLogger().warn("Objective " + objective + " did have have the score " + name);
            }
        } else {
            Text textName = SpongeTexts.fromLegacy(name);
            for (ScoreObjective scoreObjective : this.func_96514_c()) {
                ((ScoreObjectiveBridge)scoreObjective).bridge$getSpongeObjective().removeScore(textName);
            }
        }
    }

    @Override
    public void bridge$sendToPlayers(Packet<?> packet) {
        for (EntityPlayerMP player : this.impl$scoreboardPlayers) {
            player.field_71135_a.func_147359_a(packet);
        }
    }

    @Override
    public void bridge$addPlayer(EntityPlayerMP player, boolean sendPackets) {
        this.impl$scoreboardPlayers.add(player);
        if (sendPackets) {
            for (ScorePlayerTeam team : this.func_96525_g()) {
                player.field_71135_a.func_147359_a((Packet)new SPacketTeams(team, 0));
            }
            for (ScoreObjective objective : this.func_96514_c()) {
                player.field_71135_a.func_147359_a((Packet)new SPacketScoreboardObjective(objective, 0));
                for (net.minecraft.scoreboard.Score score : this.func_96534_i(objective)) {
                    player.field_71135_a.func_147359_a((Packet)new SPacketUpdateScore(score));
                }
            }
            for (int i = 0; i < 19; ++i) {
                player.field_71135_a.func_147359_a((Packet)new SPacketDisplayObjective(i, this.func_96539_a(i)));
            }
        }
    }

    @Override
    public void bridge$removePlayer(EntityPlayerMP player, boolean sendPackets) {
        this.impl$scoreboardPlayers.remove(player);
        if (sendPackets) {
            this.impl$removeScoreboard(player);
        }
    }

    private void impl$removeScoreboard(EntityPlayerMP player) {
        this.impl$removeTeams(player);
        this.impl$removeObjectives(player);
    }

    private void impl$removeTeams(EntityPlayerMP player) {
        for (ScorePlayerTeam team : this.func_96525_g()) {
            player.field_71135_a.func_147359_a((Packet)new SPacketTeams(team, 1));
        }
    }

    private void impl$removeObjectives(EntityPlayerMP player) {
        for (ScoreObjective objective : this.func_96514_c()) {
            player.field_71135_a.func_147359_a((Packet)new SPacketScoreboardObjective(objective, 1));
        }
    }

    @Redirect(method={"onScoreUpdated"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/management/PlayerList;sendPacketToAllPlayers(Lnet/minecraft/network/Packet;)V"))
    private void onUpdateScoreValue(PlayerList manager, Packet<?> packet) {
        this.bridge$sendToPlayers(packet);
    }

    @Redirect(method={"onScoreUpdated"}, at=@At(value="INVOKE", target="Ljava/util/Set;contains(Ljava/lang/Object;)Z", remap=false))
    private boolean onUpdateScoreValue(Set<?> set, Object object) {
        return true;
    }

    @Redirect(method={"broadcastScoreUpdate(Ljava/lang/String;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/management/PlayerList;sendPacketToAllPlayers(Lnet/minecraft/network/Packet;)V"))
    private void impl$updatePlayersOnRemoval(PlayerList manager, Packet<?> packet) {
        this.bridge$sendToPlayers(packet);
    }

    @Redirect(method={"broadcastScoreUpdate(Ljava/lang/String;Lnet/minecraft/scoreboard/ScoreObjective;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/management/PlayerList;sendPacketToAllPlayers(Lnet/minecraft/network/Packet;)V"))
    private void impl$updatePlayersOnRemovalOfObjective(PlayerList manager, Packet<?> packet) {
        this.bridge$sendToPlayers(packet);
    }

    @Redirect(method={"addPlayerToTeam"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/management/PlayerList;sendPacketToAllPlayers(Lnet/minecraft/network/Packet;)V"))
    private void impl$updatePlayersOnPlayerAdd(PlayerList manager, Packet<?> packet) {
        this.bridge$sendToPlayers(packet);
    }

    @Redirect(method={"removePlayerFromTeam"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/management/PlayerList;sendPacketToAllPlayers(Lnet/minecraft/network/Packet;)V"))
    private void impl$updatePlayersOnPlayerRemoval(PlayerList manager, Packet<?> packet) {
        this.bridge$sendToPlayers(packet);
    }

    @Redirect(method={"onObjectiveDisplayNameChanged"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/management/PlayerList;sendPacketToAllPlayers(Lnet/minecraft/network/Packet;)V"))
    private void impl$updatePlayersOnObjectiveDisplay(PlayerList manager, Packet<?> packet) {
        this.bridge$sendToPlayers(packet);
    }

    @Redirect(method={"onObjectiveDisplayNameChanged"}, at=@At(value="INVOKE", target="Ljava/util/Set;contains(Ljava/lang/Object;)Z", remap=false))
    private boolean impl$alwaysReturnTrueForObjectivesDisplayName(Set<ScoreObjective> set, Object object) {
        return true;
    }

    @Redirect(method={"onScoreObjectiveRemoved"}, at=@At(value="INVOKE", target="Ljava/util/Set;contains(Ljava/lang/Object;)Z", remap=false))
    private boolean impl$alwaysReturnTrueForObjectiveRemoval(Set<ScoreObjective> set, Object object) {
        return true;
    }

    @Redirect(method={"broadcastTeamCreated"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/management/PlayerList;sendPacketToAllPlayers(Lnet/minecraft/network/Packet;)V"))
    private void impl$updateAllPlayersOnTeamCreation(PlayerList manager, Packet<?> packet) {
        this.bridge$sendToPlayers(packet);
    }

    @Redirect(method={"broadcastTeamInfoUpdate"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/management/PlayerList;sendPacketToAllPlayers(Lnet/minecraft/network/Packet;)V"))
    private void impl$updateAllPlayersOnTeamInfo(PlayerList manager, Packet<?> packet) {
        this.bridge$sendToPlayers(packet);
    }

    @Redirect(method={"broadcastTeamRemove"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/management/PlayerList;sendPacketToAllPlayers(Lnet/minecraft/network/Packet;)V"))
    private void impl$updateAllPlayersOnTeamRemoval(PlayerList manager, Packet<?> packet) {
        this.bridge$sendToPlayers(packet);
    }

    @Redirect(method={"addObjective"}, at=@At(value="INVOKE", target="Ljava/util/List;iterator()Ljava/util/Iterator;", ordinal=0, remap=false))
    private Iterator impl$useOurScoreboardForPlayers(List list) {
        return this.impl$scoreboardPlayers.iterator();
    }

    @Redirect(method={"sendDisplaySlotRemovalPackets"}, at=@At(value="INVOKE", target="Ljava/util/List;iterator()Ljava/util/Iterator;", ordinal=0, remap=false))
    private Iterator impl$useOurScoreboardForPlayersOnRemoval(List list) {
        return this.impl$scoreboardPlayers.iterator();
    }
}

