/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.stats;

import net.minecraft.item.Item;
import net.minecraft.stats.StatBase;
import net.minecraft.stats.StatCrafting;
import net.minecraft.stats.StatList;
import net.minecraft.util.text.ITextComponent;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.common.statistic.SpongeBlockStatistic;
import org.spongepowered.common.statistic.SpongeEntityStatistic;

@Mixin(value={StatList.class})
public class StatListMixin {
    @Redirect(method={"initMiningStats"}, at=@At(value="NEW", args={"class=net/minecraft/stats/StatCrafting"}))
    private static StatCrafting createBlockStat(String statId, String itemName, ITextComponent statName, Item item) {
        return new SpongeBlockStatistic(statId, itemName, statName, item);
    }

    @Redirect(method={"getStatKillEntity"}, at=@At(value="NEW", args={"class=net/minecraft/stats/StatBase"}))
    private static StatBase createKillEntityStat(String statId, ITextComponent statName) {
        String entityId = statId.substring(statId.lastIndexOf(".") + 1);
        return new SpongeEntityStatistic(statId, statName, entityId);
    }

    @Redirect(method={"getStatEntityKilledBy"}, at=@At(value="NEW", args={"class=net/minecraft/stats/StatBase"}))
    private static StatBase createKilledByEntityStat(String statId, ITextComponent statName) {
        String entityId = statId.substring(statId.lastIndexOf(".") + 1);
        return new SpongeEntityStatistic(statId, statName, entityId);
    }
}

