/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.world.storage;

import com.google.common.base.MoreObjects;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketServerDifficulty;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.GameType;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.WorldType;
import net.minecraft.world.storage.WorldInfo;
import org.apache.logging.log4j.Level;
import org.spongepowered.api.world.DimensionType;
import org.spongepowered.api.world.DimensionTypes;
import org.spongepowered.api.world.PortalAgentType;
import org.spongepowered.api.world.PortalAgentTypes;
import org.spongepowered.api.world.SerializationBehaviors;
import org.spongepowered.api.world.WorldArchetype;
import org.spongepowered.api.world.gen.WorldGeneratorModifier;
import org.spongepowered.api.world.storage.WorldProperties;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.util.PrettyPrinter;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.SpongeImplHooks;
import org.spongepowered.common.bridge.world.DimensionTypeBridge;
import org.spongepowered.common.bridge.world.WorldInfoBridge;
import org.spongepowered.common.bridge.world.WorldSettingsBridge;
import org.spongepowered.common.config.SpongeConfig;
import org.spongepowered.common.config.category.WorldCategory;
import org.spongepowered.common.config.type.WorldConfig;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.registry.type.world.DimensionTypeRegistryModule;
import org.spongepowered.common.registry.type.world.PortalAgentRegistryModule;
import org.spongepowered.common.registry.type.world.WorldGeneratorModifierRegistryModule;
import org.spongepowered.common.util.Constants;
import org.spongepowered.common.world.WorldManager;

@Mixin(value={WorldInfo.class})
public abstract class WorldInfoMixin
implements WorldInfoBridge {
    @Shadow
    private WorldType field_76098_b;
    @Shadow
    private int field_76099_c;
    @Shadow
    private int field_76096_d;
    @Shadow
    private int field_76097_e;
    @Shadow
    private String field_76106_k;
    @Shadow
    private GameType field_76113_q;
    @Shadow
    private boolean field_76111_s;
    @Shadow
    private EnumDifficulty field_176158_z;
    private final NBTTagList impl$playerUniqueIdNbt = new NBTTagList();
    private final BiMap<Integer, UUID> impl$playerUniqueIdMap = HashBiMap.create();
    private final List<UUID> impl$pendingUniqueIds = new ArrayList<UUID>();
    private int impl$trackedUniqueIdCount = 0;
    private boolean impl$hasCustomDifficulty = false;
    private boolean impl$isMod = false;
    private boolean impl$generateBonusChest;
    private DimensionType impl$dimensionType = DimensionTypes.OVERWORLD;
    private NBTTagCompound impl$spongeRootLevelNbt = new NBTTagCompound();
    private NBTTagCompound impl$spongeNbt = new NBTTagCompound();
    @Nullable
    private UUID impl$uuid;
    @Nullable
    private Integer impl$dimensionId;
    @Nullable
    private SpongeConfig<WorldConfig> impl$worldConfig;
    @Nullable
    private PortalAgentType impl$portalAgentType;

    @Shadow
    public abstract void func_176144_a(EnumDifficulty var1);

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void impl$vanillaConstruction(CallbackInfo ci) {
        this.impl$commonConstructionSetUpSpongeCompounds();
    }

    @Inject(method={"<init>(Lnet/minecraft/nbt/NBTTagCompound;)V"}, at={@At(value="RETURN")})
    private void impl$MaybeClientConstruction(NBTTagCompound nbt, CallbackInfo ci) {
        if (SpongeImplHooks.isMainThread() && !PhaseTracker.getInstance().getCurrentContext().state.isConvertingMaps()) {
            this.impl$commonConstructionSetUpSpongeCompounds();
        }
    }

    @Inject(method={"<init>(Lnet/minecraft/world/WorldSettings;Ljava/lang/String;)V"}, at={@At(value="RETURN")})
    private void impl$onFullConstruction(WorldSettings settings, String name, CallbackInfo ci) {
        if (!this.bridge$isValid()) {
            return;
        }
        this.impl$commonConstructionSetUpSpongeCompounds();
        WorldArchetype archetype = (WorldArchetype)settings;
        this.bridge$setDimensionType(archetype.getDimensionType());
        this.bridge$createWorldConfig();
        WorldConfig config = this.bridge$getConfigAdapter().getConfig();
        WorldCategory worldCat = config.getWorld();
        worldCat.setWorldEnabled(archetype.isEnabled());
        worldCat.setLoadOnStartup(archetype.loadOnStartup());
        if (((WorldSettingsBridge)settings).bridge$internalKeepSpawnLoaded() != null) {
            worldCat.setKeepSpawnLoaded(archetype.doesKeepSpawnLoaded());
        }
        worldCat.setGenerateSpawnOnLoad(archetype.doesGenerateSpawnOnLoad());
        this.bridge$forceSetDifficulty((EnumDifficulty)archetype.getDifficulty());
        Collection<WorldGeneratorModifier> modifiers = WorldGeneratorModifierRegistryModule.getInstance().toModifiers(config.getWorldGenModifiers());
        if (modifiers.isEmpty()) {
            config.getWorldGenModifiers().clear();
            config.getWorldGenModifiers().addAll((Collection<String>)WorldGeneratorModifierRegistryModule.getInstance().toIds(archetype.getGeneratorModifiers()));
        } else {
            config.getWorldGenModifiers().clear();
            config.getWorldGenModifiers().addAll((Collection<String>)WorldGeneratorModifierRegistryModule.getInstance().toIds(modifiers));
        }
        this.setDoesGenerateBonusChest(archetype.doesGenerateBonusChest());
        ((WorldProperties)((Object)this)).setSerializationBehavior(archetype.getSerializationBehavior());
    }

    @Inject(method={"<init>(Lnet/minecraft/world/storage/WorldInfo;)V"}, at={@At(value="RETURN")})
    private void impl$initialConstruction(WorldInfo worldInformation, CallbackInfo ci) {
        this.impl$commonConstructionSetUpSpongeCompounds();
        WorldInfoMixin info = (WorldInfoMixin)worldInformation;
        this.bridge$getConfigAdapter();
        this.impl$portalAgentType = info.impl$portalAgentType;
        this.bridge$setDimensionType(info.impl$dimensionType);
    }

    private void impl$commonConstructionSetUpSpongeCompounds() {
        this.impl$spongeNbt.func_74782_a("PlayerIdTable", (NBTBase)this.impl$playerUniqueIdNbt);
        this.impl$spongeRootLevelNbt.func_74782_a("SpongeData", (NBTBase)this.impl$spongeNbt);
    }

    @Inject(method={"updateTagCompound"}, at={@At(value="HEAD")})
    private void impl$ensureLevelNameMatchesDirectory(NBTTagCompound compound, NBTTagCompound player, CallbackInfo ci) {
        if (this.impl$dimensionId == null) {
            return;
        }
        String name = WorldManager.getWorldFolderByDimensionId(this.impl$dimensionId).orElse(this.field_76106_k);
        if (!this.field_76106_k.equalsIgnoreCase(name)) {
            this.field_76106_k = name;
        }
    }

    @Override
    public boolean bridge$createWorldConfig() {
        if (this.impl$worldConfig != null) {
            return false;
        }
        this.impl$worldConfig = this.bridge$isValid() ? new SpongeConfig(SpongeConfig.Type.WORLD, ((DimensionTypeBridge)((Object)this.impl$dimensionType)).bridge$getConfigPath().resolve(this.field_76106_k).resolve("world.conf"), "sponge", ((DimensionTypeBridge)((Object)this.impl$dimensionType)).bridge$getDimensionConfig(), false) : SpongeConfig.newDummyConfig(SpongeConfig.Type.WORLD);
        return true;
    }

    @Override
    public boolean bridge$isValid() {
        return this.field_76106_k != null && !this.field_76106_k.equals("") && !this.field_76106_k.equals("MpServer") && !this.field_76106_k.equals("sponge$dummy_world");
    }

    @Override
    public void bridge$setDimensionType(DimensionType type) {
        this.impl$dimensionType = type;
        String modId = SpongeImplHooks.getModIdFromClass(this.impl$dimensionType.getDimensionClass());
        if (!"minecraft".equals(modId)) {
            this.impl$isMod = true;
        }
    }

    @Inject(method={"setDifficulty"}, at={@At(value="HEAD")}, cancellable=true)
    private void onSetDifficultyVanilla(@Nullable EnumDifficulty newDifficulty, CallbackInfo ci) {
        if (newDifficulty == null) {
            new PrettyPrinter(60).add("Null Difficulty being set!").centre().hr().add("Someone (not Sponge) is attempting to set a null difficulty to this WorldInfo setup! Please report to the mod/plugin author!").add().addWrapped(60, " %s : %s", "WorldInfo", this).add().add(new Exception("Stacktrace")).log(SpongeImpl.getLogger(), Level.ERROR);
            ci.cancel();
            return;
        }
        this.impl$hasCustomDifficulty = true;
        this.field_176158_z = newDifficulty;
        this.bridge$updatePlayersForDifficulty();
    }

    @Override
    public boolean bridge$hasCustomDifficulty() {
        return this.impl$hasCustomDifficulty;
    }

    @Override
    public void bridge$forceSetDifficulty(EnumDifficulty difficulty) {
        this.field_176158_z = difficulty;
        this.bridge$updatePlayersForDifficulty();
    }

    @Override
    public void bridge$updatePlayersForDifficulty() {
        WorldManager.getWorlds().stream().filter(world -> world.func_72912_H() == (WorldInfo)this).flatMap(world -> world.field_73010_i.stream()).filter(player -> player instanceof EntityPlayerMP).map(player -> (EntityPlayerMP)player).forEach(player -> player.field_71135_a.func_147359_a((Packet)new SPacketServerDifficulty(this.field_176158_z, ((WorldInfo)this).func_176123_z())));
    }

    private void setDoesGenerateBonusChest(boolean state) {
        this.impl$generateBonusChest = state;
    }

    @Override
    public void bridge$setDimensionId(int id) {
        this.impl$dimensionId = id;
    }

    @Override
    public Integer bridge$getDimensionId() {
        return this.impl$dimensionId;
    }

    @Override
    public void bridge$setUniqueId(UUID uniqueId) {
        this.impl$uuid = uniqueId;
    }

    @Override
    public boolean bridge$getIsMod() {
        return this.impl$isMod;
    }

    @Override
    public void bridge$setIsMod(boolean flag) {
        this.impl$isMod = flag;
    }

    @Override
    public UUID bridge$getAssignedId() {
        return this.impl$uuid;
    }

    @Override
    public boolean bridge$getSpawnsBonusChest() {
        return this.impl$generateBonusChest;
    }

    @Override
    public PortalAgentType bridge$getPortalAgent() {
        if (this.impl$portalAgentType == null) {
            this.impl$portalAgentType = PortalAgentTypes.DEFAULT;
        }
        return this.impl$portalAgentType;
    }

    @Override
    public SpongeConfig<WorldConfig> bridge$getConfigAdapter() {
        if (this.impl$worldConfig == null) {
            this.bridge$createWorldConfig();
        }
        return this.impl$worldConfig;
    }

    @Override
    public DimensionType bridge$getDimensionType() {
        return this.impl$dimensionType;
    }

    @Override
    public int bridge$getIndexForUniqueId(UUID uuid) {
        Integer index = (Integer)this.impl$playerUniqueIdMap.inverse().get((Object)uuid);
        if (index != null) {
            return index;
        }
        this.impl$playerUniqueIdMap.put((Object)this.impl$trackedUniqueIdCount, (Object)uuid);
        this.impl$pendingUniqueIds.add(uuid);
        return this.impl$trackedUniqueIdCount++;
    }

    @Override
    public Optional<UUID> bridge$getUniqueIdForIndex(int index) {
        return Optional.ofNullable(this.impl$playerUniqueIdMap.get((Object)index));
    }

    @Override
    public NBTTagCompound bridge$getSpongeRootLevelNbt() {
        this.writeSpongeNbt();
        return this.impl$spongeRootLevelNbt;
    }

    @Override
    public void bridge$setSpongeRootLevelNBT(NBTTagCompound nbt) {
        this.impl$spongeRootLevelNbt = nbt;
        if (nbt.func_74764_b("SpongeData")) {
            this.impl$spongeNbt = nbt.func_74775_l("SpongeData");
        }
    }

    @Override
    public void bridge$readSpongeNbt(NBTTagCompound nbt) {
        UUID nbtUniqueId = nbt.func_186857_a("UUID");
        if (Constants.World.INVALID_WORLD_UUID.equals(nbtUniqueId)) {
            return;
        }
        this.impl$uuid = nbtUniqueId;
        this.impl$dimensionId = nbt.func_74762_e("dimensionId");
        String dimensionTypeId = nbt.func_74779_i("dimensionType");
        DimensionType dimensionType = WorldManager.getDimensionType(this.impl$dimensionId).orElse(null);
        this.bridge$setDimensionType(dimensionType != null ? dimensionType : DimensionTypeRegistryModule.getInstance().getById(dimensionTypeId).orElseThrow(() -> new IllegalArgumentException("Could not find a DimensionType registered for world '" + this.func_76065_j() + "' with dim id: " + this.impl$dimensionId)));
        this.impl$generateBonusChest = nbt.func_74767_n("GenerateBonusChest");
        this.impl$portalAgentType = PortalAgentRegistryModule.getInstance().validatePortalAgent(nbt.func_74779_i("portalAgentType"), this.field_76106_k);
        this.impl$hasCustomDifficulty = nbt.func_74767_n("HasCustomDifficulty");
        this.impl$trackedUniqueIdCount = 0;
        if (nbt.func_74764_b("serializationBehavior")) {
            short saveBehavior = nbt.func_74765_d("serializationBehavior");
            if (saveBehavior == 1) {
                ((WorldProperties)((Object)this)).setSerializationBehavior(SerializationBehaviors.AUTOMATIC);
            } else if (saveBehavior == 0) {
                ((WorldProperties)((Object)this)).setSerializationBehavior(SerializationBehaviors.MANUAL);
            } else {
                ((WorldProperties)((Object)this)).setSerializationBehavior(SerializationBehaviors.NONE);
            }
        }
        if (nbt.func_150297_b("PlayerIdTable", 9)) {
            NBTTagList playerIdList = nbt.func_150295_c("PlayerIdTable", 10);
            for (int i = 0; i < playerIdList.func_74745_c(); ++i) {
                NBTTagCompound playerId = playerIdList.func_150305_b(i);
                UUID playerUuid = playerId.func_186857_a("UUID");
                Integer playerIndex = (Integer)this.impl$playerUniqueIdMap.inverse().get((Object)playerUuid);
                if (playerIndex == null) {
                    this.impl$playerUniqueIdMap.put((Object)this.impl$trackedUniqueIdCount++, (Object)playerUuid);
                    continue;
                }
                playerIdList.func_74744_a(i);
            }
        }
    }

    private void writeSpongeNbt() {
        if (this.impl$uuid != null && this.bridge$isValid()) {
            this.impl$spongeNbt.func_74768_a("DataVersion", 1);
            this.impl$spongeNbt.func_186854_a("UUID", this.impl$uuid);
            this.impl$spongeNbt.func_74768_a("dimensionId", this.impl$dimensionId.intValue());
            this.impl$spongeNbt.func_74778_a("dimensionType", this.impl$dimensionType.getId());
            this.impl$spongeNbt.func_74757_a("GenerateBonusChest", this.impl$generateBonusChest);
            if (this.impl$portalAgentType == null) {
                this.impl$portalAgentType = PortalAgentTypes.DEFAULT;
            }
            this.impl$spongeNbt.func_74778_a("portalAgentType", this.impl$portalAgentType.getPortalAgentClass().getName());
            short saveBehavior = 1;
            if (((WorldProperties)((Object)this)).getSerializationBehavior() == SerializationBehaviors.NONE) {
                saveBehavior = -1;
            } else if (((WorldProperties)((Object)this)).getSerializationBehavior() == SerializationBehaviors.MANUAL) {
                saveBehavior = 0;
            }
            this.impl$spongeNbt.func_74777_a("serializationBehavior", saveBehavior);
            this.impl$spongeNbt.func_74757_a("HasCustomDifficulty", this.impl$hasCustomDifficulty);
            Iterator<UUID> iterator = this.impl$pendingUniqueIds.iterator();
            NBTTagList playerIdList = this.impl$spongeNbt.func_150295_c("PlayerIdTable", 10);
            while (iterator.hasNext()) {
                NBTTagCompound compound = new NBTTagCompound();
                compound.func_186854_a("UUID", iterator.next());
                playerIdList.func_74742_a((NBTBase)compound);
                iterator.remove();
            }
        }
    }

    @Overwrite
    public String func_76065_j() {
        if (this.field_76106_k == null) {
            this.field_76106_k = "";
        }
        return this.field_76106_k;
    }

    @Override
    public void bridge$saveConfig() {
        this.bridge$getConfigAdapter().save();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("levelName", (Object)this.field_76106_k).add("terrainType", (Object)this.field_76098_b).add("uuid", (Object)this.impl$uuid).add("dimensionId", (Object)this.impl$dimensionId).add("dimensionType", (Object)this.impl$dimensionType).add("spawnX", this.field_76099_c).add("spawnY", this.field_76096_d).add("spawnZ", this.field_76097_e).add("gameType", (Object)this.field_76113_q).add("hardcore", this.field_76111_s).add("difficulty", (Object)this.field_176158_z).add("isMod", this.impl$isMod).toString();
    }
}

