/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.optimization.entity;

import net.minecraft.entity.Entity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.bridge.world.chunk.ActiveChunkReferantBridge;
import org.spongepowered.common.bridge.world.chunk.ChunkBridge;

@Mixin(value={Entity.class}, priority=1500)
public class EntityMixin_UseActiveChunkForCollisions {
    @Inject(method={"doBlockCollisions"}, at={@At(value="HEAD")}, cancellable=true)
    private void activeCollision$checkForNeighboringChunkIfAvailable(CallbackInfo ci) {
        ChunkBridge activeChunk = ((ActiveChunkReferantBridge)((Object)this)).bridge$getActiveChunk();
        if (activeChunk == null || !activeChunk.bridge$areNeighborsLoaded() || activeChunk.bridge$isQueuedForUnload()) {
            ci.cancel();
        }
    }

    @Redirect(method={"doBlockCollisions"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/World;isAreaLoaded(Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/util/math/BlockPos;)Z"))
    private boolean activeCollision$ignoreWorldIsAreaLoaded(World world, BlockPos from, BlockPos to) {
        return true;
    }
}

