/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.plugin;

import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;
import org.spongepowered.common.SpongeImpl;

public class MultiWorldCommandPlugin
implements IMixinConfigPlugin {
    private static final Pattern MIXIN_OPTION_EXTRACTOR = Pattern.compile("^[a-z.]+\\.Command(?<option>[A-Za-z]+)Mixin_(MultiWorld|Global)Command$");
    private boolean configState;

    @Override
    public void onLoad(String mixinPackage) {
        this.configState = mixinPackage.endsWith(".multiworld");
    }

    @Override
    public String getRefMapperConfig() {
        return null;
    }

    @Override
    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        Map<String, Boolean> patches;
        Matcher matcher = MIXIN_OPTION_EXTRACTOR.matcher(mixinClassName);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Mixin class name \"" + mixinClassName + "\" does not match form expected by MIXIN_OPTION_EXTRACTOR.");
        }
        String name = matcher.group("option").toLowerCase(Locale.ENGLISH);
        if (name.equals("showseed")) {
            name = "seed";
        }
        if (!(patches = SpongeImpl.getGlobalConfigAdapter().getConfig().getCommands().getMultiWorldCommandPatches()).containsKey(name)) {
            patches.put(name, true);
            SpongeImpl.getGlobalConfigAdapter().save();
            return this.configState;
        }
        return patches.get(name) == this.configState;
    }

    @Override
    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    @Override
    public List<String> getMixins() {
        return null;
    }

    @Override
    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    @Override
    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }
}

