/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.tracking.bridge;

import java.lang.ref.WeakReference;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.IEntityOwnable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.profile.GameProfile;
import org.spongepowered.api.service.user.UserStorageService;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.bridge.OwnershipTrackedBridge;
import org.spongepowered.common.bridge.data.DataCompoundHolder;
import org.spongepowered.common.entity.PlayerTracker;
import org.spongepowered.common.profile.SpongeProfileManager;
import org.spongepowered.common.util.SpongeUsernameCache;

@Mixin(value={Entity.class, TileEntity.class}, priority=1100)
public class OwnershipTrackedBridgeMixin
implements OwnershipTrackedBridge {
    @Nullable
    private UUID tracked$owner;
    @Nullable
    private UUID tracked$notifier;
    @Nullable
    private WeakReference<User> tracked$ownerUser;
    @Nullable
    private WeakReference<User> tracked$notifierUser;
    @Nullable
    private SpongeProfileManager tracked$profileManager;
    @Nullable
    private UserStorageService tracked$userService;

    @Override
    public Optional<UUID> tracked$getOwnerUUID() {
        return Optional.ofNullable(this.tracked$owner);
    }

    @Override
    public Optional<UUID> tracked$getNotifierUUID() {
        return Optional.ofNullable(this.tracked$notifier);
    }

    @Override
    public void tracked$setOwnerReference(@Nullable User owner) {
        this.tracked$ownerUser = new WeakReference<User>(owner);
        this.tracked$owner = owner == null ? null : owner.getUniqueId();
    }

    @Override
    public Optional<User> tracked$getOwnerReference() {
        User value;
        User user = value = this.tracked$ownerUser == null ? null : (User)this.tracked$ownerUser.get();
        if (value == null && this.tracked$owner != null) {
            Optional<User> user2 = this.tracked$getTrackedUser(PlayerTracker.Type.OWNER);
            user2.ifPresent(owner -> {
                this.tracked$ownerUser = new WeakReference<User>((User)owner);
            });
            return user2;
        }
        return Optional.ofNullable(value);
    }

    @Override
    public void tracked$setNotifier(@Nullable User notifier) {
        this.tracked$notifierUser = new WeakReference<User>(notifier);
        this.tracked$notifier = notifier == null ? null : notifier.getUniqueId();
    }

    @Override
    public Optional<User> tracked$getNotifierReference() {
        User value;
        User user = value = this.tracked$notifierUser == null ? null : (User)this.tracked$notifierUser.get();
        if (value == null && this.tracked$owner != null) {
            Optional<User> user2 = this.tracked$getTrackedUser(PlayerTracker.Type.NOTIFIER);
            user2.ifPresent(owner -> {
                this.tracked$notifierUser = new WeakReference<User>((User)owner);
            });
            return user2;
        }
        return Optional.ofNullable(value);
    }

    @Override
    public Optional<User> tracked$getTrackedUser(PlayerTracker.Type nbtKey) {
        String username;
        UUID uuid = this.getTrackedUniqueId(nbtKey);
        if (uuid == null) {
            return Optional.empty();
        }
        Player player = Sponge.getServer().getPlayer(uuid).orElse(null);
        if (player != null) {
            return Optional.of(player);
        }
        if (this.tracked$profileManager == null) {
            this.tracked$profileManager = (SpongeProfileManager)Sponge.getServer().getGameProfileManager();
        }
        if (this.tracked$userService == null) {
            this.tracked$userService = SpongeImpl.getGame().getServiceManager().provide(UserStorageService.class).get();
        }
        if ((username = SpongeUsernameCache.getLastKnownUsername(uuid)) != null) {
            return this.tracked$userService.get(GameProfile.of(uuid, username));
        }
        GameProfile profile = this.tracked$profileManager.getCache().getById(uuid).orElse(null);
        if (profile != null) {
            return this.tracked$userService.get(profile);
        }
        this.tracked$profileManager.lookupUserAsync(uuid);
        return Optional.empty();
    }

    @Override
    public void tracked$setTrackedUUID(PlayerTracker.Type type, @Nullable UUID uuid) {
        if (PlayerTracker.Type.OWNER == type) {
            this.tracked$owner = uuid;
        } else if (PlayerTracker.Type.NOTIFIER == type) {
            this.tracked$notifier = uuid;
        }
        if (((DataCompoundHolder)((Object)this)).data$hasRootCompound()) {
            NBTTagCompound spongeData = ((DataCompoundHolder)((Object)this)).data$getSpongeCompound();
            if (uuid == null) {
                if (spongeData.func_74764_b(type.compoundKey)) {
                    spongeData.func_82580_o(type.compoundKey);
                }
                return;
            }
            if (!spongeData.func_74764_b(type.compoundKey)) {
                NBTTagCompound sourceNbt = new NBTTagCompound();
                sourceNbt.func_186854_a("UUID", uuid);
                spongeData.func_74782_a(type.compoundKey, (NBTBase)sourceNbt);
            } else {
                NBTTagCompound compoundTag = spongeData.func_74775_l(type.compoundKey);
                compoundTag.func_186854_a("UUID", uuid);
            }
        }
    }

    @Nullable
    private UUID getTrackedUniqueId(PlayerTracker.Type nbtKey) {
        NBTTagCompound nbt;
        if (this.tracked$owner != null && PlayerTracker.Type.OWNER == nbtKey) {
            return this.tracked$owner;
        }
        if (this instanceof IEntityOwnable) {
            IEntityOwnable ownable = (IEntityOwnable)this;
            Entity owner = ownable.func_70902_q();
            if (owner instanceof EntityPlayer) {
                this.tracked$setTrackedUUID(PlayerTracker.Type.OWNER, owner.func_110124_au());
                return owner.func_110124_au();
            }
        } else if (this.tracked$notifier != null && PlayerTracker.Type.NOTIFIER == nbtKey) {
            return this.tracked$notifier;
        }
        if (!(nbt = ((DataCompoundHolder)((Object)this)).data$getSpongeCompound()).func_74764_b(nbtKey.compoundKey)) {
            return null;
        }
        NBTTagCompound creatorNbt = nbt.func_74775_l(nbtKey.compoundKey);
        if (!creatorNbt.func_74764_b("UUIDMost") && !creatorNbt.func_74764_b("UUIDLeast")) {
            return null;
        }
        UUID uniqueId = creatorNbt.func_186857_a("UUID");
        if (PlayerTracker.Type.OWNER == nbtKey) {
            this.tracked$owner = uniqueId;
        } else if (PlayerTracker.Type.NOTIFIER == nbtKey) {
            this.tracked$notifier = uniqueId;
        }
        return uniqueId;
    }
}

