/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.tracking.world;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import org.apache.logging.log4j.Level;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.profile.GameProfile;
import org.spongepowered.api.service.user.UserStorageService;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.util.PrettyPrinter;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.SpongeImplHooks;
import org.spongepowered.common.bridge.OwnershipTrackedBridge;
import org.spongepowered.common.bridge.world.WorldBridge;
import org.spongepowered.common.bridge.world.WorldInfoBridge;
import org.spongepowered.common.bridge.world.chunk.ChunkBridge;
import org.spongepowered.common.config.SpongeConfig;
import org.spongepowered.common.config.type.WorldConfig;
import org.spongepowered.common.entity.PlayerTracker;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.phase.generation.ChunkLoadContext;
import org.spongepowered.common.event.tracking.phase.generation.GenerationPhase;
import org.spongepowered.common.profile.SpongeProfileManager;
import org.spongepowered.common.util.Constants;
import org.spongepowered.common.util.SpongeHooks;
import org.spongepowered.common.util.SpongeUsernameCache;

@Mixin(value={Chunk.class})
public abstract class ChunkMixin_Tracker
implements ChunkBridge {
    @Shadow
    @Final
    private World field_76637_e;
    @Shadow
    @Final
    public int field_76635_g;
    @Shadow
    @Final
    public int field_76647_h;
    @Shadow
    @Final
    private Map<BlockPos, TileEntity> field_150816_i;
    @Nullable
    private UserStorageService trackerImpl$userStorageService;
    private Map<Integer, PlayerTracker> trackerImpl$trackedIntBlockPositions = new HashMap<Integer, PlayerTracker>();
    private Map<Short, PlayerTracker> trackerImpl$trackedShortBlockPositions = new HashMap<Short, PlayerTracker>();

    @Inject(method={"<init>(Lnet/minecraft/world/World;II)V"}, at={@At(value="RETURN")})
    private void tracker$setUpUserService(@Nullable World worldIn, int x, int z, CallbackInfo ci) {
        this.trackerImpl$userStorageService = worldIn != null && ((WorldBridge)worldIn).bridge$isFake() ? null : SpongeImpl.getGame().getServiceManager().provideUnchecked(UserStorageService.class);
    }

    @Override
    public void bridge$addTrackedBlockPosition(Block block, BlockPos pos, User user, PlayerTracker.Type trackerType) {
        SpongeConfig<WorldConfig> configAdapter;
        if (((WorldBridge)this.field_76637_e).bridge$isFake()) {
            return;
        }
        if (!PhaseTracker.getInstance().getCurrentState().tracksOwnersAndNotifiers()) {
            return;
        }
        if (user instanceof EntityPlayerMP && SpongeImplHooks.isFakePlayer((Entity)((EntityPlayerMP)user))) {
            return;
        }
        TileEntity tileEntity = this.field_150816_i.get(pos);
        if (tileEntity != null && tileEntity instanceof OwnershipTrackedBridge) {
            OwnershipTrackedBridge ownerBridge = (OwnershipTrackedBridge)tileEntity;
            if (trackerType == PlayerTracker.Type.NOTIFIER) {
                if (ownerBridge.tracked$getNotifierReference().orElse(null) == user) {
                    return;
                }
                ownerBridge.tracked$setNotifier(user);
            } else {
                if (ownerBridge.tracked$getOwnerReference().orElse(null) == user) {
                    return;
                }
                ownerBridge.tracked$setOwnerReference(user);
            }
        }
        if ((configAdapter = ((WorldInfoBridge)this.field_76637_e.func_72912_H()).bridge$getConfigAdapter()).getConfig().getLogging().blockTrackLogging()) {
            if (!configAdapter.getConfig().getBlockTracking().getBlockBlacklist().contains(((BlockType)block).getId())) {
                SpongeHooks.logBlockTrack(this.field_76637_e, block, pos, user, true);
            } else {
                SpongeHooks.logBlockTrack(this.field_76637_e, block, pos, user, false);
            }
        }
        WorldInfoBridge worldInfo = (WorldInfoBridge)this.field_76637_e.func_72912_H();
        int indexForUniqueId = worldInfo.bridge$getIndexForUniqueId(user.getUniqueId());
        if (pos.func_177956_o() <= 255) {
            short blockPos = Constants.Sponge.blockPosToShort(pos);
            PlayerTracker playerTracker = this.trackerImpl$trackedShortBlockPositions.get(blockPos);
            if (playerTracker != null) {
                if (trackerType == PlayerTracker.Type.OWNER) {
                    playerTracker.ownerIndex = indexForUniqueId;
                    playerTracker.notifierIndex = indexForUniqueId;
                } else {
                    playerTracker.notifierIndex = indexForUniqueId;
                }
            } else {
                this.trackerImpl$trackedShortBlockPositions.put(blockPos, new PlayerTracker(indexForUniqueId, trackerType));
            }
        } else {
            int blockPos = Constants.Sponge.blockPosToInt(pos);
            PlayerTracker playerTracker = this.trackerImpl$trackedIntBlockPositions.get(blockPos);
            if (playerTracker != null) {
                if (trackerType == PlayerTracker.Type.OWNER) {
                    playerTracker.ownerIndex = indexForUniqueId;
                    playerTracker.notifierIndex = indexForUniqueId;
                } else {
                    playerTracker.notifierIndex = indexForUniqueId;
                }
            } else {
                this.trackerImpl$trackedIntBlockPositions.put(blockPos, new PlayerTracker(indexForUniqueId, trackerType));
            }
        }
    }

    @Override
    public Map<Integer, PlayerTracker> bridge$getTrackedIntPlayerPositions() {
        return this.trackerImpl$trackedIntBlockPositions;
    }

    @Override
    public Map<Short, PlayerTracker> bridge$getTrackedShortPlayerPositions() {
        return this.trackerImpl$trackedShortBlockPositions;
    }

    @Override
    public Optional<User> bridge$getBlockOwner(BlockPos pos) {
        if (((WorldBridge)this.field_76637_e).bridge$isFake()) {
            return Optional.empty();
        }
        int intKey = Constants.Sponge.blockPosToInt(pos);
        PlayerTracker intTracker = this.trackerImpl$trackedIntBlockPositions.get(intKey);
        if (intTracker != null) {
            int notifierIndex = intTracker.ownerIndex;
            return this.tracker$getValidatedUser(intKey, notifierIndex);
        }
        short shortKey = Constants.Sponge.blockPosToShort(pos);
        PlayerTracker shortTracker = this.trackerImpl$trackedShortBlockPositions.get(shortKey);
        if (shortTracker != null) {
            int notifierIndex = shortTracker.ownerIndex;
            return this.tracker$getValidatedUser(shortKey, notifierIndex);
        }
        return Optional.empty();
    }

    @Override
    public Optional<UUID> bridge$getBlockOwnerUUID(BlockPos pos) {
        if (((WorldBridge)this.field_76637_e).bridge$isFake()) {
            return Optional.empty();
        }
        int key = Constants.Sponge.blockPosToInt(pos);
        PlayerTracker intTracker = this.trackerImpl$trackedIntBlockPositions.get(key);
        if (intTracker != null) {
            int ownerIndex = intTracker.ownerIndex;
            return this.tracker$getValidatedUUID(key, ownerIndex);
        }
        short shortKey = Constants.Sponge.blockPosToShort(pos);
        PlayerTracker shortTracker = this.trackerImpl$trackedShortBlockPositions.get(shortKey);
        if (shortTracker != null) {
            int ownerIndex = shortTracker.ownerIndex;
            return this.tracker$getValidatedUUID(shortKey, ownerIndex);
        }
        return Optional.empty();
    }

    @Override
    public Optional<User> bridge$getBlockNotifier(BlockPos pos) {
        if (((WorldBridge)this.field_76637_e).bridge$isFake()) {
            return Optional.empty();
        }
        int intKey = Constants.Sponge.blockPosToInt(pos);
        PlayerTracker intTracker = this.trackerImpl$trackedIntBlockPositions.get(intKey);
        if (intTracker != null) {
            return this.tracker$getValidatedUser(intKey, intTracker.notifierIndex);
        }
        short shortKey = Constants.Sponge.blockPosToShort(pos);
        PlayerTracker shortTracker = this.trackerImpl$trackedShortBlockPositions.get(shortKey);
        if (shortTracker != null) {
            return this.tracker$getValidatedUser(shortKey, shortTracker.notifierIndex);
        }
        return Optional.empty();
    }

    @Override
    public Optional<UUID> bridge$getBlockNotifierUUID(BlockPos pos) {
        if (((WorldBridge)this.field_76637_e).bridge$isFake()) {
            return Optional.empty();
        }
        int key = Constants.Sponge.blockPosToInt(pos);
        PlayerTracker intTracker = this.trackerImpl$trackedIntBlockPositions.get(key);
        if (intTracker != null) {
            return this.tracker$getValidatedUUID(key, intTracker.notifierIndex);
        }
        short shortKey = Constants.Sponge.blockPosToShort(pos);
        PlayerTracker shortTracker = this.trackerImpl$trackedShortBlockPositions.get(shortKey);
        if (shortTracker != null) {
            return this.tracker$getValidatedUUID(shortKey, shortTracker.notifierIndex);
        }
        return Optional.empty();
    }

    private Optional<User> tracker$getValidatedUser(int key, int ownerIndex) {
        Optional<UUID> uuid = this.tracker$getValidatedUUID(key, ownerIndex);
        if (uuid.isPresent()) {
            UUID userUniqueId = uuid.get();
            EntityPlayer player = this.field_76637_e.func_152378_a(userUniqueId);
            if (player != null) {
                return Optional.of((User)player);
            }
            return this.tracker$getUserFromId(userUniqueId);
        }
        return Optional.empty();
    }

    private Optional<UUID> tracker$getValidatedUUID(int key, int ownerIndex) {
        UUID uuid = ((WorldInfoBridge)this.field_76637_e.func_72912_H()).bridge$getUniqueIdForIndex(ownerIndex).orElse(null);
        if (uuid != null) {
            if (SpongeImpl.getGlobalConfigAdapter().getConfig().getWorld().getInvalidLookupUuids().contains(uuid)) {
                this.trackerImpl$trackedIntBlockPositions.remove(key);
                return Optional.empty();
            }
            return Optional.of(uuid);
        }
        return Optional.empty();
    }

    private Optional<User> tracker$getUserFromId(UUID uuid) {
        String username = SpongeUsernameCache.getLastKnownUsername(uuid);
        if (username != null && this.trackerImpl$userStorageService != null) {
            return this.trackerImpl$userStorageService.get(GameProfile.of(uuid, username));
        }
        GameProfile profile = Sponge.getServer().getGameProfileManager().getCache().getById(uuid).orElse(null);
        if (profile != null && this.trackerImpl$userStorageService != null) {
            return this.trackerImpl$userStorageService.get(profile);
        }
        ((SpongeProfileManager)Sponge.getServer().getGameProfileManager()).lookupUserAsync(uuid);
        return Optional.empty();
    }

    @Override
    public void bridge$setBlockNotifier(BlockPos pos, @Nullable UUID uuid) {
        if (((WorldBridge)this.field_76637_e).bridge$isFake()) {
            return;
        }
        if (pos.func_177956_o() <= 255) {
            short blockPos = Constants.Sponge.blockPosToShort(pos);
            PlayerTracker shortTracker = this.trackerImpl$trackedShortBlockPositions.get(blockPos);
            if (shortTracker != null) {
                shortTracker.notifierIndex = uuid == null ? -1 : ((WorldInfoBridge)this.field_76637_e.func_72912_H()).bridge$getIndexForUniqueId(uuid);
            } else {
                this.trackerImpl$trackedShortBlockPositions.put(blockPos, new PlayerTracker(uuid == null ? -1 : ((WorldInfoBridge)this.field_76637_e.func_72912_H()).bridge$getIndexForUniqueId(uuid), PlayerTracker.Type.NOTIFIER));
            }
        } else {
            int blockPos = Constants.Sponge.blockPosToInt(pos);
            PlayerTracker intTracker = this.trackerImpl$trackedIntBlockPositions.get(blockPos);
            if (intTracker != null) {
                intTracker.notifierIndex = uuid == null ? -1 : ((WorldInfoBridge)this.field_76637_e.func_72912_H()).bridge$getIndexForUniqueId(uuid);
            } else {
                this.trackerImpl$trackedIntBlockPositions.put(blockPos, new PlayerTracker(uuid == null ? -1 : ((WorldInfoBridge)this.field_76637_e.func_72912_H()).bridge$getIndexForUniqueId(uuid), PlayerTracker.Type.NOTIFIER));
            }
        }
    }

    @Override
    public void bridge$setBlockCreator(BlockPos pos, @Nullable UUID uuid) {
        if (((WorldBridge)this.field_76637_e).bridge$isFake()) {
            return;
        }
        if (pos.func_177956_o() <= 255) {
            short blockPos = Constants.Sponge.blockPosToShort(pos);
            PlayerTracker shortTracker = this.trackerImpl$trackedShortBlockPositions.get(blockPos);
            if (shortTracker != null) {
                shortTracker.ownerIndex = uuid == null ? -1 : ((WorldInfoBridge)this.field_76637_e.func_72912_H()).bridge$getIndexForUniqueId(uuid);
            } else {
                this.trackerImpl$trackedShortBlockPositions.put(blockPos, new PlayerTracker(uuid == null ? -1 : ((WorldInfoBridge)this.field_76637_e.func_72912_H()).bridge$getIndexForUniqueId(uuid), PlayerTracker.Type.OWNER));
            }
        } else {
            int blockPos = Constants.Sponge.blockPosToInt(pos);
            PlayerTracker intTracker = this.trackerImpl$trackedIntBlockPositions.get(blockPos);
            if (intTracker != null) {
                intTracker.ownerIndex = uuid == null ? -1 : ((WorldInfoBridge)this.field_76637_e.func_72912_H()).bridge$getIndexForUniqueId(uuid);
            } else {
                this.trackerImpl$trackedIntBlockPositions.put(blockPos, new PlayerTracker(uuid == null ? -1 : ((WorldInfoBridge)this.field_76637_e.func_72912_H()).bridge$getIndexForUniqueId(uuid), PlayerTracker.Type.OWNER));
            }
        }
    }

    @Override
    public void bridge$setTrackedIntPlayerPositions(Map<Integer, PlayerTracker> trackedPositions) {
        this.trackerImpl$trackedIntBlockPositions = trackedPositions;
    }

    @Override
    public void bridge$setTrackedShortPlayerPositions(Map<Short, PlayerTracker> trackedPositions) {
        this.trackerImpl$trackedShortBlockPositions = trackedPositions;
    }

    @Inject(method={"onLoad"}, at={@At(value="HEAD")})
    private void trackerImpl$startLoad(CallbackInfo callbackInfo) {
        boolean isFake = ((WorldBridge)this.field_76637_e).bridge$isFake();
        if (!isFake) {
            if (!SpongeImplHooks.isMainThread()) {
                PrettyPrinter printer = new PrettyPrinter(60).add("Illegal Async Chunk Load").centre().hr().addWrapped("Sponge relies on knowing when chunks are being loaded as chunks add entities to the parented world for management. These operations are generally not threadsafe and shouldn't be considered a \"Sponge bug \". Adding/removing entities from another thread to the world is never ok.", new Object[0]).add().add(" %s : %d, %d", "Chunk Pos", this.field_76635_g, this.field_76647_h).add().add(new Exception("Async Chunk Load Detected")).log(SpongeImpl.getLogger(), Level.ERROR);
                return;
            }
            if (PhaseTracker.getInstance().getCurrentState() == GenerationPhase.State.CHUNK_REGENERATING_LOAD_EXISTING) {
                return;
            }
            ((ChunkLoadContext)((ChunkLoadContext)GenerationPhase.State.CHUNK_LOADING.createPhaseContext().source(this)).world(this.field_76637_e)).chunk((Chunk)this).buildAndSwitch();
        }
    }

    @Inject(method={"onLoad"}, at={@At(value="RETURN")})
    private void trackerImpl$endLoad(CallbackInfo callbackInfo) {
        if (!((WorldBridge)this.field_76637_e).bridge$isFake() && SpongeImplHooks.isMainThread()) {
            if (PhaseTracker.getInstance().getCurrentState() == GenerationPhase.State.CHUNK_REGENERATING_LOAD_EXISTING) {
                return;
            }
            PhaseTracker.getInstance().getCurrentContext().close();
        }
    }
}

