/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.network;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.Optional;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.server.SPacketCustomPayload;
import org.spongepowered.api.network.ChannelBinding;
import org.spongepowered.api.network.ChannelBuf;
import org.spongepowered.api.network.ChannelRegistrar;
import org.spongepowered.api.network.ChannelRegistrationException;
import org.spongepowered.api.plugin.PluginContainer;
import org.spongepowered.common.SpongeImpl;

public abstract class SpongeNetworkManager
implements ChannelRegistrar {
    protected PluginContainer checkCreateChannelArgs(Object plugin, String channel) {
        if (((String)Preconditions.checkNotNull((Object)channel, (Object)"channel")).length() > 20) {
            throw new ChannelRegistrationException("Channel name cannot be greater than 20 characters");
        }
        Optional<PluginContainer> optPlugin = SpongeImpl.getGame().getPluginManager().fromInstance(Preconditions.checkNotNull((Object)plugin, (Object)"plugin"));
        Preconditions.checkArgument((boolean)optPlugin.isPresent(), (Object)"Provided plugin argument is not a plugin instance");
        return optPlugin.get();
    }

    protected static SPacketCustomPayload getRegPacket(String channelName) {
        return new SPacketCustomPayload("REGISTER", new PacketBuffer(Unpooled.wrappedBuffer((byte[])channelName.getBytes(Charsets.UTF_8))));
    }

    protected static SPacketCustomPayload getUnregPacket(String channelName) {
        return new SPacketCustomPayload("UNREGISTER", new PacketBuffer(Unpooled.wrappedBuffer((byte[])channelName.getBytes(Charsets.UTF_8))));
    }

    public static ChannelBuf toChannelBuf(ByteBuf buf) {
        return (ChannelBuf)(buf instanceof PacketBuffer ? buf : new PacketBuffer(buf));
    }

    public static abstract class AbstractChannelBinding
    implements ChannelBinding {
        private final ChannelRegistrar registrar;
        private final String channelName;
        private final PluginContainer owner;

        public AbstractChannelBinding(ChannelRegistrar registrar, String channelName, PluginContainer owner) {
            this.registrar = registrar;
            this.channelName = channelName;
            this.owner = owner;
        }

        @Override
        public ChannelRegistrar getRegistrar() {
            return this.registrar;
        }

        @Override
        public String getName() {
            return this.channelName;
        }

        @Override
        public PluginContainer getOwner() {
            return this.owner;
        }
    }
}

