/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.registry.type;

import com.flowpowered.math.vector.Vector3i;
import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.block.BlockTypes;
import org.spongepowered.api.block.trait.BlockTrait;
import org.spongepowered.api.block.trait.BooleanTrait;
import org.spongepowered.api.block.trait.EnumTrait;
import org.spongepowered.api.block.trait.IntegerTrait;
import org.spongepowered.api.registry.AlternateCatalogRegistryModule;
import org.spongepowered.api.registry.util.RegisterCatalog;
import org.spongepowered.api.registry.util.RegistrationDependency;
import org.spongepowered.common.block.SpongeBlockSnapshot;
import org.spongepowered.common.block.SpongeBlockSnapshotBuilder;
import org.spongepowered.common.bridge.block.BlockBridge;
import org.spongepowered.common.registry.RegistryHelper;
import org.spongepowered.common.registry.SpongeAdditionalCatalogRegistryModule;
import org.spongepowered.common.registry.provider.BlockPropertyIdProvider;
import org.spongepowered.common.registry.type.BlockStateRegistryModule;
import org.spongepowered.common.registry.type.block.BooleanTraitRegistryModule;
import org.spongepowered.common.registry.type.block.EnumTraitRegistryModule;
import org.spongepowered.common.registry.type.block.IntegerTraitRegistryModule;
import org.spongepowered.common.registry.type.world.BlockChangeFlagRegistryModule;
import org.spongepowered.common.util.Constants;

@RegistrationDependency(value={BlockChangeFlagRegistryModule.class})
public class BlockTypeRegistryModule
implements SpongeAdditionalCatalogRegistryModule<BlockType>,
AlternateCatalogRegistryModule<BlockType> {
    @RegisterCatalog(value=BlockTypes.class)
    private final Map<String, BlockType> blockTypeMappings = Maps.newHashMap();
    private final BiMap<String, BlockTrait<?>> blockTraitMap = HashBiMap.create();

    public static BlockTypeRegistryModule getInstance() {
        return Holder.INSTANCE;
    }

    public String getIdFor(IProperty<?> blockTrait) {
        return (String)Preconditions.checkNotNull((Object)this.blockTraitMap.inverse().get(blockTrait), (Object)"BlockTrait doesn't have a registered id!");
    }

    @Override
    public Map<String, BlockType> provideCatalogMap() {
        HashMap<String, BlockType> blockMap = new HashMap<String, BlockType>();
        for (Map.Entry<String, BlockType> entry : this.blockTypeMappings.entrySet()) {
            blockMap.put(entry.getKey().replace("minecraft:", ""), entry.getValue());
        }
        return blockMap;
    }

    @Override
    public Optional<BlockType> getById(String id) {
        Preconditions.checkNotNull((Object)id);
        if (!id.contains(":") && !id.equals("none")) {
            id = "minecraft:" + id;
        }
        return Optional.ofNullable(this.blockTypeMappings.get(((String)Preconditions.checkNotNull((Object)id)).toLowerCase(Locale.ENGLISH)));
    }

    @Override
    public Collection<BlockType> getAll() {
        return ImmutableSet.copyOf(this.blockTypeMappings.values());
    }

    @Override
    public boolean allowsApiRegistration() {
        return false;
    }

    @Override
    public void registerAdditionalCatalog(BlockType extraCatalog) {
        this.registerCustomBlock(extraCatalog.getId(), extraCatalog);
    }

    public void registerFromGameData(String id, BlockType blockType) {
        this.registerCustomBlock(id, blockType);
    }

    private void registerCustomBlock(String id, BlockType blockType) {
        this.blockTypeMappings.put(id.toLowerCase(Locale.ENGLISH), blockType);
        this.registerBlockTrait(id, blockType);
        ((BlockBridge)((Object)blockType)).bridge$initializeTrackerState();
    }

    private void registerBlockTrait(String id, BlockType block) {
        Block nmsBlock = (Block)block;
        for (IBlockState iBlockState : nmsBlock.func_176194_O().func_177619_a()) {
            BlockStateRegistryModule.getInstance().registerBlockState((BlockState)iBlockState);
        }
        for (Map.Entry entry : block.getDefaultState().getTraitMap().entrySet()) {
            BlockTrait property = (BlockTrait)entry.getKey();
            String propertyId = BlockPropertyIdProvider.getIdAndTryRegistration((IProperty)property, (Block)block, id);
            if (property instanceof EnumTrait) {
                EnumTraitRegistryModule.getInstance().registerBlock(propertyId, block, (EnumTrait)property);
                continue;
            }
            if (property instanceof IntegerTrait) {
                IntegerTraitRegistryModule.getInstance().registerBlock(propertyId, block, (IntegerTrait)property);
                continue;
            }
            if (!(property instanceof BooleanTrait)) continue;
            BooleanTraitRegistryModule.getInstance().registerBlock(propertyId, block, (BooleanTrait)property);
        }
    }

    @Override
    public void registerDefaults() {
        SpongeBlockSnapshot NONE_SNAPSHOT = SpongeBlockSnapshotBuilder.pooled().worldId(Constants.World.INVALID_WORLD_UUID).position(new Vector3i(0, 0, 0)).blockState(Blocks.field_150350_a.func_176223_P()).build();
        RegistryHelper.setFinalStatic(BlockSnapshot.class, "NONE", NONE_SNAPSHOT);
        this.blockTypeMappings.put("none", (BlockType)Blocks.field_150350_a);
    }

    BlockTypeRegistryModule() {
    }

    private static final class Holder {
        static final BlockTypeRegistryModule INSTANCE = new BlockTypeRegistryModule();

        private Holder() {
        }
    }
}

