/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.registry.type.entity;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.spongepowered.api.data.type.RabbitType;
import org.spongepowered.api.data.type.RabbitTypes;
import org.spongepowered.api.registry.CatalogRegistryModule;
import org.spongepowered.api.registry.util.RegisterCatalog;
import org.spongepowered.common.entity.SpongeRabbitType;

public class RabbitTypeRegistryModule
implements CatalogRegistryModule<RabbitType> {
    public static final Map<String, RabbitType> RABBIT_TYPES = Maps.newHashMap();
    public static final Int2ObjectMap<RabbitType> RABBIT_IDMAP = new Int2ObjectOpenHashMap();
    public static final SpongeRabbitType BROWN_RABBIT = new SpongeRabbitType(0, "BROWN");
    public static final RabbitType WHITE_RABBIT = new SpongeRabbitType(1, "WHITE");
    public static final RabbitType BLACK_RABBIT = new SpongeRabbitType(2, "BLACK");
    public static final RabbitType BLACK_AND_WHITE_RABBIT = new SpongeRabbitType(3, "BLACK_AND_WHITE");
    public static final RabbitType GOLD_RABBIT = new SpongeRabbitType(4, "GOLD");
    public static final RabbitType SALT_AND_PEPPER_RABBIT = new SpongeRabbitType(5, "SALT_AND_PEPPER");
    public static final RabbitType KILLER_RABBIT = new SpongeRabbitType(99, "KILLER");
    @RegisterCatalog(value=RabbitTypes.class)
    private final Map<String, RabbitType> rabbitTypeMap = new HashMap<String, RabbitType>();

    @Override
    public Optional<RabbitType> getById(String id) {
        return Optional.ofNullable(this.rabbitTypeMap.get(((String)Preconditions.checkNotNull((Object)id)).toLowerCase(Locale.ENGLISH)));
    }

    @Override
    public Collection<RabbitType> getAll() {
        return ImmutableList.copyOf(this.rabbitTypeMap.values());
    }

    @Override
    public void registerDefaults() {
        RABBIT_TYPES.put("brown", BROWN_RABBIT);
        RABBIT_TYPES.put("white", WHITE_RABBIT);
        RABBIT_TYPES.put("black", BLACK_RABBIT);
        RABBIT_TYPES.put("black_and_white", BLACK_AND_WHITE_RABBIT);
        RABBIT_TYPES.put("gold", GOLD_RABBIT);
        RABBIT_TYPES.put("salt_and_pepper", SALT_AND_PEPPER_RABBIT);
        RABBIT_TYPES.put("killer", KILLER_RABBIT);
        RABBIT_IDMAP.put(0, (Object)BROWN_RABBIT);
        RABBIT_IDMAP.put(1, (Object)WHITE_RABBIT);
        RABBIT_IDMAP.put(2, (Object)BLACK_RABBIT);
        RABBIT_IDMAP.put(3, (Object)BLACK_AND_WHITE_RABBIT);
        RABBIT_IDMAP.put(4, (Object)GOLD_RABBIT);
        RABBIT_IDMAP.put(5, (Object)SALT_AND_PEPPER_RABBIT);
        RABBIT_IDMAP.put(99, (Object)KILLER_RABBIT);
        this.rabbitTypeMap.putAll(RABBIT_TYPES);
    }
}

