/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.registry.type.item;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.spongepowered.api.data.type.GoldenApple;
import org.spongepowered.api.data.type.GoldenApples;
import org.spongepowered.api.registry.CatalogRegistryModule;
import org.spongepowered.api.registry.util.RegisterCatalog;
import org.spongepowered.common.item.SpongeGoldenApple;

public final class GoldenAppleRegistryModule
implements CatalogRegistryModule<GoldenApple> {
    @RegisterCatalog(value=GoldenApples.class)
    private final Map<String, GoldenApple> goldenAppleMap = new HashMap<String, GoldenApple>();

    @Override
    public Optional<GoldenApple> getById(String id) {
        return Optional.ofNullable(this.goldenAppleMap.get(((String)Preconditions.checkNotNull((Object)id)).toLowerCase(Locale.ENGLISH)));
    }

    @Override
    public Collection<GoldenApple> getAll() {
        return ImmutableList.copyOf(this.goldenAppleMap.values());
    }

    @Override
    public void registerDefaults() {
        this.goldenAppleMap.put("golden_apple", new SpongeGoldenApple(0, "GOLDEN_APPLE"));
        this.goldenAppleMap.put("enchanted_golden_apple", new SpongeGoldenApple(1, "ENCHANTED_GOLDEN_APPLE"));
    }
}

