/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.registry.type.world;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.spongepowered.api.registry.util.RegisterCatalog;
import org.spongepowered.api.registry.util.RegistrationDependency;
import org.spongepowered.api.world.biome.BiomeType;
import org.spongepowered.api.world.schematic.BlockPaletteTypes;
import org.spongepowered.api.world.schematic.PaletteType;
import org.spongepowered.api.world.schematic.PaletteTypes;
import org.spongepowered.common.registry.SpongeAdditionalCatalogRegistryModule;
import org.spongepowered.common.registry.type.world.BlockPaletteTypeRegistryModule;
import org.spongepowered.common.world.schematic.BimapPalette;
import org.spongepowered.common.world.schematic.GlobalPalette;
import org.spongepowered.common.world.schematic.SpongePaletteType;

@RegistrationDependency(value={BlockPaletteTypeRegistryModule.class})
public class PaletteTypeRegistryModule
implements SpongeAdditionalCatalogRegistryModule<PaletteType<?>> {
    @RegisterCatalog(value=PaletteTypes.class)
    private final Map<String, PaletteType<?>> paletteMappings = Maps.newConcurrentMap();

    @Override
    public void registerAdditionalCatalog(PaletteType<?> extraCatalog) {
        Preconditions.checkNotNull(extraCatalog);
        String id = extraCatalog.getId();
        Preconditions.checkArgument((id.indexOf(32) == -1 ? 1 : 0) != 0, (Object)("Palette Type ID " + id + " may not contain a space"));
        this.paletteMappings.put(id.toLowerCase(Locale.ENGLISH), extraCatalog);
    }

    @Override
    public Optional<PaletteType<?>> getById(String id) {
        return Optional.ofNullable(this.paletteMappings.get(id));
    }

    @Override
    public Collection<PaletteType<?>> getAll() {
        return ImmutableList.copyOf(this.paletteMappings.values());
    }

    @Override
    public void registerDefaults() {
        this.registerAdditionalCatalog(BlockPaletteTypes.GLOBAL);
        this.registerAdditionalCatalog(BlockPaletteTypes.LOCAL);
        this.registerAdditionalCatalog(new SpongePaletteType("global_biomes", GlobalPalette::getBiomePalette));
        this.registerAdditionalCatalog(new SpongePaletteType("local_biomes", () -> new BimapPalette<BiomeType>(PaletteTypes.LOCAL_BIOMES)));
    }

    @Override
    public boolean allowsApiRegistration() {
        return true;
    }
}

