/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.registry.type.world.gen;

import javax.annotation.Nullable;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockOldLeaf;
import net.minecraft.block.BlockOldLog;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.world.gen.feature.WorldGenBigTree;
import net.minecraft.world.gen.feature.WorldGenBirchTree;
import net.minecraft.world.gen.feature.WorldGenCanopyTree;
import net.minecraft.world.gen.feature.WorldGenMegaJungle;
import net.minecraft.world.gen.feature.WorldGenMegaPineTree;
import net.minecraft.world.gen.feature.WorldGenSavannaTree;
import net.minecraft.world.gen.feature.WorldGenShrub;
import net.minecraft.world.gen.feature.WorldGenSwamp;
import net.minecraft.world.gen.feature.WorldGenTaiga1;
import net.minecraft.world.gen.feature.WorldGenTaiga2;
import net.minecraft.world.gen.feature.WorldGenTrees;
import net.minecraft.world.gen.feature.WorldGenerator;
import org.spongepowered.api.registry.util.RegisterCatalog;
import org.spongepowered.api.util.weighted.VariableAmount;
import org.spongepowered.api.world.gen.PopulatorObject;
import org.spongepowered.api.world.gen.type.BiomeTreeType;
import org.spongepowered.api.world.gen.type.BiomeTreeTypes;
import org.spongepowered.common.bridge.world.gen.WorldGenTreesBridge;
import org.spongepowered.common.registry.type.AbstractPrefixAlternateCatalogTypeRegistryModule;
import org.spongepowered.common.world.gen.type.SpongeBiomeTreeType;

@RegisterCatalog(value=BiomeTreeTypes.class)
public class BiomeTreeTypeRegistryModule
extends AbstractPrefixAlternateCatalogTypeRegistryModule<BiomeTreeType> {
    public BiomeTreeTypeRegistryModule() {
        super("minecraft");
    }

    @Override
    public void registerDefaults() {
        this.register(this.create("oak", (WorldGenerator)new WorldGenTrees(false), (WorldGenerator)new WorldGenBigTree(false)));
        this.register(this.create("birch", (WorldGenerator)new WorldGenBirchTree(false, false), (WorldGenerator)new WorldGenBirchTree(false, true)));
        WorldGenMegaPineTree tall_megapine = new WorldGenMegaPineTree(false, true);
        WorldGenMegaPineTree megapine = new WorldGenMegaPineTree(false, false);
        this.register(this.create("tall_taiga", (WorldGenerator)new WorldGenTaiga2(false), (WorldGenerator)tall_megapine));
        this.register(this.create("pointy_taiga", (WorldGenerator)new WorldGenTaiga1(), (WorldGenerator)megapine));
        IBlockState jlog = Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockOldLog.field_176301_b, (Comparable)BlockPlanks.EnumType.JUNGLE);
        IBlockState jleaf = Blocks.field_150362_t.func_176223_P().func_177226_a((IProperty)BlockOldLeaf.field_176239_P, (Comparable)BlockPlanks.EnumType.JUNGLE).func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(false));
        IBlockState leaf = Blocks.field_150362_t.func_176223_P().func_177226_a((IProperty)BlockOldLeaf.field_176239_P, (Comparable)BlockPlanks.EnumType.JUNGLE).func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(false));
        WorldGenTreesBridge trees = (WorldGenTreesBridge)new WorldGenTrees(false, 4, jlog, jleaf, true);
        trees.bridge$setMinHeight(VariableAmount.baseWithRandomAddition(4.0, 7.0));
        WorldGenMegaJungle mega = new WorldGenMegaJungle(false, 10, 20, jlog, jleaf);
        this.register(this.create("jungle", (WorldGenerator)((WorldGenTrees)trees), (WorldGenerator)mega));
        WorldGenShrub bush = new WorldGenShrub(jlog, leaf);
        this.register(this.create("jungle_bush", (WorldGenerator)bush, null));
        this.register(this.create("savanna", (WorldGenerator)new WorldGenSavannaTree(false), null));
        this.register(this.create("canopy", (WorldGenerator)new WorldGenCanopyTree(false), null));
        this.register(this.create("swamp", (WorldGenerator)new WorldGenSwamp(), null));
    }

    private SpongeBiomeTreeType create(String name, WorldGenerator small, @Nullable WorldGenerator large) {
        return new SpongeBiomeTreeType("minecraft:" + name, name, (PopulatorObject)small, (PopulatorObject)large);
    }
}

