/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.registry.type.world.gen;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import org.spongepowered.api.registry.AdditionalCatalogRegistryModule;
import org.spongepowered.api.registry.util.AdditionalRegistration;
import org.spongepowered.api.registry.util.RegisterCatalog;
import org.spongepowered.api.world.biome.BiomeType;
import org.spongepowered.api.world.biome.BiomeTypes;
import org.spongepowered.api.world.biome.VirtualBiomeType;
import org.spongepowered.common.bridge.world.biome.BiomeBridge;
import org.spongepowered.common.registry.RegistryHelper;
import org.spongepowered.common.registry.type.AbstractPrefixAlternateCatalogTypeRegistryModule;

@RegisterCatalog(value=BiomeTypes.class)
public final class BiomeTypeRegistryModule
extends AbstractPrefixAlternateCatalogTypeRegistryModule<BiomeType>
implements AdditionalCatalogRegistryModule<BiomeType> {
    private final List<BiomeType> biomeTypes = new ArrayList<BiomeType>();
    public static final ImmutableMap<String, String> MINECRAFT_TO_SPONGE_FIELD_NAMES = ImmutableMap.builder().put((Object)"ice_flats", (Object)"ice_plains").put((Object)"beaches", (Object)"beach").put((Object)"smaller_extreme_hills", (Object)"extreme_hills_edge").put((Object)"birch_forest_hills", (Object)"birch_forest_hills").put((Object)"roofed_forest", (Object)"roofed_forest").put((Object)"taiga_cold", (Object)"cold_taiga").put((Object)"taiga_cold_hills", (Object)"cold_taiga_hills").put((Object)"redwood_taiga", (Object)"mega_taiga").put((Object)"redwood_taiga_hills", (Object)"mega_taiga_hills").put((Object)"extreme_hills_with_trees", (Object)"extreme_hills_plus").put((Object)"savanna_rock", (Object)"savanna_plateau").put((Object)"mesa_rock", (Object)"mesa_plateau_forest").put((Object)"mesa_clear_rock", (Object)"mesa_plateau").put((Object)"mutated_plains", (Object)"sunflower_plains").put((Object)"mutated_desert", (Object)"desert_mountains").put((Object)"mutated_extreme_hills", (Object)"extreme_hills_mountains").put((Object)"mutated_forest", (Object)"flower_forest").put((Object)"mutated_taiga", (Object)"taiga_mountains").put((Object)"mutated_swampland", (Object)"swampland_mountains").put((Object)"mutated_ice_flats", (Object)"ice_plains_spikes").put((Object)"mutated_jungle", (Object)"jungle_mountains").put((Object)"mutated_jungle_edge", (Object)"jungle_edge_mountains").put((Object)"mutated_birch_forest", (Object)"birch_forest_mountains").put((Object)"mutated_birch_forest_hills", (Object)"birch_forest_hills_mountains").put((Object)"mutated_roofed_forest", (Object)"roofed_forest_mountains").put((Object)"mutated_taiga_cold", (Object)"cold_taiga_mountains").put((Object)"mutated_redwood_taiga", (Object)"mega_spruce_taiga").put((Object)"mutated_redwood_taiga_hills", (Object)"mega_spruce_taiga_hills").put((Object)"mutated_extreme_hills_with_trees", (Object)"extreme_hills_plus_mountains").put((Object)"mutated_savanna", (Object)"savanna_mountains").put((Object)"mutated_savanna_rock", (Object)"savanna_plateau_mountains").put((Object)"mutated_mesa", (Object)"mesa_bryce").put((Object)"mutated_mesa_rock", (Object)"mesa_plateau_forest_mountains").put((Object)"mutated_mesa_clear_rock", (Object)"mesa_plateau_mountains").build();

    public BiomeTypeRegistryModule() {
        super("minecraft", new String[]{"minecraft:"}, string -> {
            String alternateKey = (String)MINECRAFT_TO_SPONGE_FIELD_NAMES.get(string);
            return alternateKey == null ? string : alternateKey;
        });
    }

    @Override
    public void registerDefaults() {
        for (Biome biome : Biome.field_185377_q) {
            if (biome == null) continue;
            String id = ((BiomeType)biome).getId();
            if (id == null) {
                ResourceLocation reg_id = (ResourceLocation)Biome.field_185377_q.func_177774_c((Object)biome);
                ((BiomeBridge)biome).bridge$setModId(reg_id.func_110624_b());
                id = reg_id.toString();
                ((BiomeBridge)biome).bridge$setId(id);
            }
            this.biomeTypes.add((BiomeType)biome);
            this.catalogTypeMap.put(id, (BiomeType)biome);
        }
    }

    @AdditionalRegistration
    public void registerAdditional() {
        for (Biome biome : Biome.field_185377_q) {
            if (biome == null || this.biomeTypes.contains(biome)) continue;
            String id = ((BiomeType)biome).getId();
            if (id == null) {
                ResourceLocation reg_id = (ResourceLocation)Biome.field_185377_q.func_177774_c((Object)biome);
                ((BiomeBridge)biome).bridge$setModId(reg_id.func_110624_b());
                id = reg_id.toString();
                ((BiomeBridge)biome).bridge$setId(id);
            }
            this.biomeTypes.add((BiomeType)biome);
            this.catalogTypeMap.put(id, (BiomeType)biome);
        }
        RegistryHelper.mapFields(BiomeTypes.class, this.provideCatalogMap());
    }

    @Override
    public void registerAdditionalCatalog(BiomeType biome) {
        Preconditions.checkNotNull((Object)biome);
        Preconditions.checkArgument((boolean)(biome instanceof VirtualBiomeType), (Object)"Cannot register non-virtual biomes at this time.");
        Preconditions.checkArgument((!this.getById(biome.getId()).isPresent() ? 1 : 0) != 0, (Object)"Duplicate biome id");
        this.biomeTypes.add(biome);
    }
}

