/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.scoreboard;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.scoreboard.IScoreCriteria;
import net.minecraft.scoreboard.ScoreObjective;
import org.spongepowered.api.scoreboard.Score;
import org.spongepowered.api.scoreboard.Scoreboard;
import org.spongepowered.api.scoreboard.critieria.Criterion;
import org.spongepowered.api.scoreboard.objective.Objective;
import org.spongepowered.api.scoreboard.objective.displaymode.ObjectiveDisplayMode;
import org.spongepowered.api.scoreboard.objective.displaymode.ObjectiveDisplayModes;
import org.spongepowered.api.text.Text;
import org.spongepowered.common.bridge.scoreboard.ScoreObjectiveBridge;
import org.spongepowered.common.mixin.core.scoreboard.ScoreAccessor;
import org.spongepowered.common.mixin.core.scoreboard.ScoreObjectiveAccessor;
import org.spongepowered.common.mixin.core.scoreboard.ScoreboardAccessor;
import org.spongepowered.common.scoreboard.SpongeScore;
import org.spongepowered.common.text.SpongeTexts;

public class SpongeObjective
implements Objective {
    private Map<net.minecraft.scoreboard.Scoreboard, ScoreObjective> objectives = new HashMap<net.minecraft.scoreboard.Scoreboard, ScoreObjective>();
    private String name;
    private Text displayName;
    private Criterion criterion;
    private ObjectiveDisplayMode displayMode;
    private Map<Text, Score> scores = new HashMap<Text, Score>();

    public SpongeObjective(String name, Criterion criterion) {
        this.name = name;
        this.displayName = SpongeTexts.fromLegacy(name);
        this.displayMode = ObjectiveDisplayModes.INTEGER;
        this.criterion = criterion;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Text getDisplayName() {
        return this.displayName;
    }

    @Override
    public void setDisplayName(Text displayName) throws IllegalArgumentException {
        this.displayName = displayName;
        this.updateDisplayName();
    }

    private void updateDisplayName() {
        for (ScoreObjective objective : this.objectives.values()) {
            ((ScoreObjectiveAccessor)objective).accessor$setDisplayName(SpongeTexts.toLegacy(this.displayName));
            ((ScoreObjectiveAccessor)objective).accessor$getScoreboard().func_96532_b(objective);
        }
    }

    @Override
    public Criterion getCriterion() {
        return this.criterion;
    }

    @Override
    public ObjectiveDisplayMode getDisplayMode() {
        return this.displayMode;
    }

    @Override
    public void setDisplayMode(ObjectiveDisplayMode displayMode) {
        this.displayMode = displayMode;
        this.updateDisplayMode();
    }

    private void updateDisplayMode() {
        for (ScoreObjective objective : this.objectives.values()) {
            ((ScoreObjectiveAccessor)objective).accessor$setRenderType((IScoreCriteria.EnumRenderType)this.displayMode);
            ((ScoreObjectiveAccessor)objective).accessor$getScoreboard().func_96532_b(objective);
        }
    }

    @Override
    public Map<Text, Score> getScores() {
        return new HashMap<Text, Score>(this.scores);
    }

    @Override
    public boolean hasScore(Text name) {
        return this.scores.containsKey(name);
    }

    @Override
    public void addScore(Score score) throws IllegalArgumentException {
        if (this.scores.containsKey(score.getName())) {
            throw new IllegalArgumentException(String.format("A score with the name %s already exists!", SpongeTexts.toLegacy(score.getName())));
        }
        this.scores.put(score.getName(), score);
        SpongeScore spongeScore = (SpongeScore)score;
        for (ScoreObjective objective : this.objectives.values()) {
            this.addScoreToScoreboard(((ScoreObjectiveAccessor)objective).accessor$getScoreboard(), spongeScore.getScoreFor(objective));
        }
    }

    public void updateScores(net.minecraft.scoreboard.Scoreboard scoreboard) {
        ScoreObjective objective = this.getObjectiveFor(scoreboard);
        for (Score score : this.getScores().values()) {
            SpongeScore spongeScore = (SpongeScore)score;
            this.addScoreToScoreboard(scoreboard, spongeScore.getScoreFor(objective));
        }
    }

    private void addScoreToScoreboard(net.minecraft.scoreboard.Scoreboard scoreboard, net.minecraft.scoreboard.Score score) {
        String name = score.func_96653_e();
        Map scoreMap = ((ScoreboardAccessor)scoreboard).accessor$getEntitiesScoreObjectivesMap().computeIfAbsent(name, k -> Maps.newHashMap());
        scoreMap.put(((ScoreAccessor)score).accessor$getObjective(), score);
        ((ScoreAccessor)score).accessor$setForceUpdate(true);
        score.func_96647_c(((ScoreAccessor)score).accessor$getScorePoints());
    }

    @Override
    public Optional<Score> getScore(Text name) {
        return Optional.ofNullable(this.scores.get(name));
    }

    @Override
    public Score getOrCreateScore(Text name) {
        if (this.scores.containsKey(name)) {
            return this.scores.get(name);
        }
        SpongeScore score = new SpongeScore(name);
        this.addScore(score);
        return score;
    }

    @Override
    public boolean removeScore(Score spongeScore) {
        String name = ((SpongeScore)spongeScore).legacyName;
        if (!this.scores.containsKey(spongeScore.getName())) {
            return false;
        }
        for (ScoreObjective objective : this.objectives.values()) {
            net.minecraft.scoreboard.Scoreboard scoreboard = ((ScoreObjectiveAccessor)objective).accessor$getScoreboard();
            Map<ScoreObjective, net.minecraft.scoreboard.Score> map = ((ScoreboardAccessor)scoreboard).accessor$getEntitiesScoreObjectivesMap().get(name);
            if (map != null) {
                net.minecraft.scoreboard.Score score = map.remove(objective);
                if (map.size() < 1) {
                    Map<ScoreObjective, net.minecraft.scoreboard.Score> map1 = ((ScoreboardAccessor)scoreboard).accessor$getEntitiesScoreObjectivesMap().remove(name);
                    if (map1 != null) {
                        scoreboard.func_96516_a(name);
                    }
                } else if (score != null) {
                    scoreboard.func_178820_a(name, objective);
                }
            }
            ((SpongeScore)spongeScore).removeScoreFor(objective);
        }
        this.scores.remove(spongeScore.getName());
        return true;
    }

    @Override
    public boolean removeScore(Text name) {
        Optional<Score> score = this.getScore(name);
        return score.filter(this::removeScore).isPresent();
    }

    public ScoreObjective getObjectiveFor(net.minecraft.scoreboard.Scoreboard scoreboard) {
        if (this.objectives.containsKey(scoreboard)) {
            return this.objectives.get(scoreboard);
        }
        ScoreObjective objective = new ScoreObjective(scoreboard, this.name, (IScoreCriteria)this.criterion);
        ((ScoreObjectiveAccessor)objective).accessor$setDisplayName(SpongeTexts.toLegacy(this.displayName));
        ((ScoreObjectiveAccessor)objective).accessor$setRenderType((IScoreCriteria.EnumRenderType)this.displayMode);
        ((ScoreObjectiveBridge)objective).bridge$setSpongeObjective(this);
        this.objectives.put(scoreboard, objective);
        return objective;
    }

    public void removeObjectiveFor(net.minecraft.scoreboard.Scoreboard scoreboard) {
        if (this.objectives.remove(scoreboard) == null) {
            throw new IllegalStateException("Attempting to remove an objective without an entry!");
        }
    }

    @Override
    public Set<Scoreboard> getScoreboards() {
        return new HashSet<net.minecraft.scoreboard.Scoreboard>(this.objectives.keySet());
    }

    public Collection<ScoreObjective> getObjectives() {
        return this.objectives.values();
    }
}

