/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.text.serializer;

import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.serializer.FormattingCodeTextSerializer;
import org.spongepowered.common.bridge.api.text.TextBridge;
import org.spongepowered.common.text.serializer.LegacyTexts;

public final class SpongeFormattingCodeTextSerializer
implements FormattingCodeTextSerializer {
    private final String id;
    private final String name;
    private final char formattingChar;

    public SpongeFormattingCodeTextSerializer(char formattingChar) {
        this("sponge:formatting_code_" + formattingChar, "Formatting Codes (" + formattingChar + ")", formattingChar);
    }

    public SpongeFormattingCodeTextSerializer(String id, String name, char formattingChar) {
        this.id = id;
        this.name = name;
        this.formattingChar = formattingChar;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public char getCharacter() {
        return this.formattingChar;
    }

    @Override
    public String serialize(Text text) {
        return ((TextBridge)((Object)text)).bridge$toLegacy(this.formattingChar);
    }

    @Override
    public String serializeSingle(Text text) {
        return ((TextBridge)((Object)text)).bridge$toLegacy(this.formattingChar);
    }

    @Override
    public Text deserialize(String input) {
        return LegacyTexts.parse(input, this.formattingChar);
    }

    @Override
    public String stripCodes(String text) {
        return LegacyTexts.strip(text, this.formattingChar);
    }

    @Override
    public String replaceCodes(String text, char to) {
        return LegacyTexts.replace(text, this.formattingChar, to);
    }
}

