/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.util;

import com.google.common.base.Preconditions;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.ClassUtils;
import org.spongepowered.common.SpongeImpl;

public final class ReflectionUtil {
    private ReflectionUtil() {
    }

    public static <T> T createUnsafeInstance(Class<T> objectClass, Object ... args) throws IllegalAccessException, InvocationTargetException, InstantiationException {
        if (args == null) {
            args = new Object[]{null};
        }
        Constructor<T> tConstructor = ReflectionUtil.findConstructor(objectClass, args);
        try {
            return tConstructor.newInstance(args);
        }
        catch (Exception e) {
            Object[] deconstructedArgs = ReflectionUtil.deconstructArray(args).toArray();
            return tConstructor.newInstance(deconstructedArgs);
        }
    }

    public static <T> T createInstance(Class<T> objectClass, Object ... args) {
        Preconditions.checkArgument((!Modifier.isAbstract(objectClass.getModifiers()) ? 1 : 0) != 0, (Object)"Cannot construct an instance of an abstract class!");
        Preconditions.checkArgument((!Modifier.isInterface(objectClass.getModifiers()) ? 1 : 0) != 0, (Object)"Cannot construct an instance of an interface!");
        if (args == null) {
            args = new Object[]{null};
        }
        Constructor<T> ctor = ReflectionUtil.findConstructor(objectClass, args);
        try {
            return ctor.newInstance(args);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            SpongeImpl.getLogger().error("Couldn't find an appropriate constructor for " + objectClass.getCanonicalName() + "with the args: " + Arrays.toString(args), (Throwable)e);
            throw new IllegalArgumentException("Couldn't find an appropriate constructor for " + objectClass.getCanonicalName() + "the args: " + Arrays.toString(args));
        }
    }

    public static <T> Constructor<T> findConstructor(Class<T> objectClass, Object ... args) {
        Constructor<?>[] ctors = objectClass.getConstructors();
        if (args == null) {
            args = new Object[]{null};
        }
        block0: for (Constructor<?> ctor : ctors) {
            Class<?>[] paramTypes = ctor.getParameterTypes();
            if (paramTypes.length != args.length) {
                for (Object object : args) {
                    if (object == null || !object.getClass().isArray()) continue;
                    Object[] objects = ReflectionUtil.deconstructArray(args).toArray();
                    return ReflectionUtil.findConstructor(objectClass, objects);
                }
                continue;
            }
            for (int i = 0; i < paramTypes.length; ++i) {
                Class<?> parameter;
                if (!ClassUtils.isAssignable(args[i] == null ? null : args[i].getClass(), parameter = paramTypes[i], (boolean)true)) continue block0;
            }
            return ctor;
        }
        throw new IllegalArgumentException("Applicable constructor not found for class: " + objectClass.getCanonicalName() + " with args: " + Arrays.toString(args));
    }

    private static List<Object> deconstructArray(Object[] objects) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (Object object : objects) {
            if (object == null) {
                list.add(null);
                continue;
            }
            if (object.getClass().isArray()) {
                list.addAll(ReflectionUtil.deconstructArray((Object[])object));
                continue;
            }
            list.add(object);
        }
        return list;
    }
}

