/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.gen.builders;

import com.google.common.base.Preconditions;
import net.minecraft.world.gen.feature.WorldGenCactus;
import org.spongepowered.api.util.weighted.VariableAmount;
import org.spongepowered.api.world.gen.populator.Cactus;

public class CactusBuilder
implements Cactus.Builder {
    private VariableAmount count;
    private VariableAmount height;

    public CactusBuilder() {
        this.reset();
    }

    @Override
    public Cactus.Builder cactiPerChunk(VariableAmount count) {
        this.count = (VariableAmount)Preconditions.checkNotNull((Object)count, (Object)"count");
        return this;
    }

    @Override
    public Cactus.Builder height(VariableAmount height) {
        this.height = (VariableAmount)Preconditions.checkNotNull((Object)height, (Object)"height");
        return this;
    }

    @Override
    public Cactus.Builder from(Cactus value) {
        this.cactiPerChunk(value.getCactiPerChunk());
        this.height(value.getHeight());
        return this;
    }

    @Override
    public Cactus.Builder reset() {
        this.count = VariableAmount.fixed(10.0);
        this.height = VariableAmount.baseWithRandomAddition(1.0, VariableAmount.baseWithRandomAddition(1.0, 3.0));
        return this;
    }

    @Override
    public Cactus build() throws IllegalStateException {
        Cactus populator = (Cactus)new WorldGenCactus();
        populator.setCactiPerChunk(this.count);
        populator.setHeight(this.height);
        return populator;
    }
}

