/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.storage;

import com.google.common.collect.Sets;
import java.io.DataInputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.Set;
import net.minecraft.world.chunk.storage.RegionFile;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.world.storage.ChunkDataStream;
import org.spongepowered.common.bridge.world.chunk.storage.RegionFileAccessor;
import org.spongepowered.common.world.storage.WorldStorageUtil;

public class SpongeChunkDataStream
implements ChunkDataStream {
    private final Set<Path> openedFiles = Sets.newHashSet();
    private RegionFileItr regionFileItr;
    private final Path worldDir;

    public SpongeChunkDataStream(Path worldDir) {
        this.worldDir = worldDir;
    }

    private boolean itrAvailable() {
        if (this.regionFileItr != null) {
            return true;
        }
        Iterable<Path> files = WorldStorageUtil.listRegionFiles(this.worldDir);
        for (Path file : files) {
            if (this.openedFiles.contains(file)) continue;
            this.regionFileItr = new RegionFileItr(WorldStorageUtil.getRegionFile(file));
            this.openedFiles.add(file);
            return true;
        }
        return false;
    }

    private int getNextIndex() {
        while (this.itrAvailable()) {
            int next = this.regionFileItr.getNext();
            if (next == -1) {
                this.regionFileItr = null;
                continue;
            }
            return next;
        }
        return -1;
    }

    @Override
    public DataContainer next() {
        int next = this.getNextIndex();
        if (next == -1) {
            throw new NoSuchElementException();
        }
        this.regionFileItr.index = next + 1;
        DataInputStream stream = this.regionFileItr.getStreamAt(next);
        try {
            return WorldStorageUtil.readDataFromRegion(stream);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean hasNext() {
        return this.getNextIndex() != -1;
    }

    @Override
    public int available() {
        RegionFileItr currentItr = this.regionFileItr;
        HashSet currentOpenedFiles = Sets.newHashSet(this.openedFiles);
        int count = 0;
        int index = this.getNextIndex();
        while (index != -1) {
            ++count;
            this.regionFileItr.index = index + 1;
            index = this.getNextIndex();
        }
        this.regionFileItr = currentItr;
        this.openedFiles.clear();
        this.openedFiles.addAll(currentOpenedFiles);
        return count;
    }

    @Override
    public void reset() {
        this.regionFileItr = null;
        this.openedFiles.clear();
    }

    private static class RegionFileItr {
        private final RegionFile file;
        public int index;

        public RegionFileItr(RegionFile regionFile) {
            this.file = regionFile;
        }

        public int getNext() {
            int index;
            int[] offsets = ((RegionFileAccessor)this.file).accessor$getOffsets();
            for (index = this.index; index != -1 && index < offsets.length && offsets[index] == 0; ++index) {
            }
            if (index >= offsets.length) {
                return -1;
            }
            return index;
        }

        public DataInputStream getStreamAt(int index) {
            int x = index & 0x1F;
            int z = index >>> 5;
            return this.file.func_76704_a(x, z);
        }
    }
}

