/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.storage;

import com.google.common.base.Preconditions;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.DirectoryIteratorException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.DataQuery;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.data.persistence.NbtTranslator;
import org.spongepowered.common.world.WorldManager;
import org.spongepowered.common.world.storage.SpongePlayerData;

public final class SpongePlayerDataHandler {
    private static final String SPONGE_DATA = "sponge";
    private boolean hasInitialized = false;
    private Path playerDir;
    private Map<UUID, SpongePlayerData> playerDataMap;

    public static void init() {
        SpongePlayerDataHandler handlerInstance = Holder.INSTANCE;
        if (!Sponge.isServerAvailable()) {
            return;
        }
        handlerInstance.playerDataMap = new ConcurrentHashMap<UUID, SpongePlayerData>();
        Path filePath = WorldManager.getCurrentSavesDirectory().get().resolve("data").resolve(SPONGE_DATA);
        try {
            handlerInstance.playerDir = filePath;
            Files.createDirectories(handlerInstance.playerDir, new FileAttribute[0]);
            ArrayList<Path> playerFiles = new ArrayList<Path>();
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(filePath, "*.{dat}");){
                for (Path entry : stream) {
                    playerFiles.add(entry);
                }
            }
            catch (DirectoryIteratorException e) {
                SpongeImpl.getLogger().error("Something happened when trying to gather all player files", (Throwable)e);
            }
            for (Path playerFile : playerFiles) {
                NBTTagCompound compound;
                if (!Files.isReadable(playerFile)) continue;
                try (InputStream stream = Files.newInputStream(playerFile, new OpenOption[0]);){
                    compound = CompressedStreamTools.func_74796_a((InputStream)stream);
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to decompress playerdata for playerfile " + playerFile, e);
                }
                if (compound == null) {
                    throw new RuntimeException("Failed to decompress player data within [" + playerFile + "]!");
                }
                DataContainer container = NbtTranslator.getInstance().translateFrom(compound);
                SpongePlayerData data = container.getSerializable(DataQuery.of(), SpongePlayerData.class).get();
                handlerInstance.playerDataMap.put(data.uuid, data);
            }
            playerFiles.clear();
        }
        catch (FileAlreadyExistsException e) {
            SpongeImpl.getLogger().error("Someone went and created a file for the desired path: {}", (Object)filePath);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        handlerInstance.hasInitialized = true;
    }

    public static void savePlayer(UUID id) {
        Preconditions.checkState((boolean)Holder.INSTANCE.hasInitialized, (Object)"PlayerDataHandler hasn't initialized yet!");
        SpongePlayerDataHandler instance = Holder.INSTANCE;
        SpongePlayerData data = instance.playerDataMap.get(Preconditions.checkNotNull((Object)id, (Object)"Player id cannot be null!"));
        if (data != null) {
            SpongePlayerDataHandler.saveFile(id.toString(), SpongePlayerDataHandler.createCompoundFor(data));
        } else {
            SpongeImpl.getLogger().error("Couldn't find a player data for the uuid: " + id.toString());
        }
    }

    private static NBTTagCompound createCompoundFor(SpongePlayerData data) {
        return NbtTranslator.getInstance().translateData(data.toContainer());
    }

    private static void saveFile(String id, NBTTagCompound compound) {
        Preconditions.checkState((boolean)Holder.INSTANCE.hasInitialized, (Object)"PlayerDataHandler hasn't initialized yet!");
        SpongePlayerDataHandler instance = Holder.INSTANCE;
        try {
            Files.createDirectories(instance.playerDir, new FileAttribute[0]);
            Path finalDatPath = instance.playerDir.resolve(id + ".dat");
            Path newDatPath = instance.playerDir.resolve(id + ".dat.tmp");
            try (OutputStream stream = Files.newOutputStream(newDatPath, StandardOpenOption.CREATE);){
                CompressedStreamTools.func_74799_a((NBTTagCompound)compound, (OutputStream)stream);
            }
            Files.move(newDatPath, finalDatPath, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (Exception e) {
            SpongeImpl.getLogger().error("Failed to save player data for [{}]!", (Object)id, (Object)e);
        }
    }

    public static void setPlayerInfo(UUID playerId, Instant join, Instant last) {
        Preconditions.checkState((boolean)Holder.INSTANCE.hasInitialized, (Object)"PlayerDataHandler hasn't initialized yet!");
        Preconditions.checkNotNull((Object)join, (Object)"Joined date cannot be null!");
        Preconditions.checkNotNull((Object)last, (Object)"Last joined date cannot be null!");
        SpongePlayerDataHandler instance = Holder.INSTANCE;
        SpongePlayerData data = instance.playerDataMap.get(Preconditions.checkNotNull((Object)playerId, (Object)"Player UUID cannot be null!"));
        if (data == null) {
            data = new SpongePlayerData();
            data.uuid = playerId;
        }
        data.firstJoined = join.toEpochMilli();
        data.lastJoined = last.toEpochMilli();
        instance.playerDataMap.put(playerId, data);
    }

    public static Optional<Instant> getFirstJoined(UUID player) {
        Preconditions.checkState((boolean)Holder.INSTANCE.hasInitialized, (Object)"PlayerDataHandler hasn't initialized yet!");
        SpongePlayerData data = Holder.INSTANCE.playerDataMap.get(player);
        return Optional.ofNullable(data == null ? null : Instant.ofEpochMilli(data.firstJoined));
    }

    public static Optional<Instant> getLastPlayed(UUID player) {
        Preconditions.checkState((boolean)Holder.INSTANCE.hasInitialized, (Object)"PlayerDataHandler hasn't initialized yet!");
        SpongePlayerData data = Holder.INSTANCE.playerDataMap.get(player);
        return Optional.ofNullable(data == null ? null : Instant.ofEpochMilli(data.lastJoined));
    }

    SpongePlayerDataHandler() {
    }

    private static final class Holder {
        static final SpongePlayerDataHandler INSTANCE = new SpongePlayerDataHandler();

        private Holder() {
        }
    }
}

