/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.plugin.meta.gson;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.spongepowered.plugin.meta.PluginDependency;
import org.spongepowered.plugin.meta.PluginMetadata;

public final class ModMetadataAdapter
extends TypeAdapter<PluginMetadata> {
    public static final ModMetadataAdapter DEFAULT = new ModMetadataAdapter(new Gson(), ImmutableMap.of());
    private static final char VERSION_SEPARATOR = '@';
    private final Gson gson;
    private final ImmutableMap<String, Class<?>> extensions;

    public ModMetadataAdapter(Gson gson, ImmutableMap<String, Class<?>> extensions) {
        this.gson = gson;
        this.extensions = extensions;
    }

    public Gson getGson() {
        return this.gson;
    }

    public ImmutableMap<String, Class<?>> getExtensions() {
        return this.extensions;
    }

    public Class<?> getExtension(String key) {
        Class<Object> result = (Class<Object>)this.extensions.get((Object)key);
        return result != null ? result : Object.class;
    }

    public PluginMetadata read(JsonReader in) throws IOException {
        in.beginObject();
        HashSet<String> processedKeys = new HashSet<String>();
        PluginMetadata result = new PluginMetadata("unknown");
        String id = null;
        HashMap<String, PluginDependency> requiredDependencies = new HashMap<String, PluginDependency>();
        block22: while (in.hasNext()) {
            String name = in.nextName();
            if (!processedKeys.add(name)) {
                throw new JsonParseException("Duplicate key '" + name + "' in " + in);
            }
            switch (name) {
                case "modid": {
                    id = in.nextString();
                    result.setId(id);
                    continue block22;
                }
                case "name": {
                    result.setName(in.nextString());
                    continue block22;
                }
                case "version": {
                    result.setVersion(in.nextString());
                    continue block22;
                }
                case "description": {
                    result.setDescription(in.nextString());
                    continue block22;
                }
                case "url": {
                    result.setUrl(in.nextString());
                    continue block22;
                }
                case "authorList": {
                    in.beginArray();
                    while (in.hasNext()) {
                        result.addAuthor(in.nextString());
                    }
                    in.endArray();
                    continue block22;
                }
                case "requiredMods": {
                    in.beginArray();
                    while (in.hasNext()) {
                        PluginDependency dependency = ModMetadataAdapter.readDependency(in, PluginDependency.LoadOrder.NONE, false);
                        PluginDependency existing = result.getDependency(dependency.getId());
                        if (existing != null) {
                            result.replaceDependency(existing.required());
                            continue;
                        }
                        requiredDependencies.put(dependency.getId(), dependency);
                    }
                    in.endArray();
                    continue block22;
                }
                case "dependencies": {
                    ModMetadataAdapter.readDependencies(in, result, PluginDependency.LoadOrder.BEFORE, requiredDependencies);
                    continue block22;
                }
                case "dependants": {
                    ModMetadataAdapter.readDependencies(in, result, PluginDependency.LoadOrder.AFTER, requiredDependencies);
                    continue block22;
                }
            }
            result.setExtension(name, this.gson.fromJson(in, this.getExtension(name)));
        }
        in.endObject();
        if (id == null) {
            throw new JsonParseException("Mod metadata is missing required element 'modid'");
        }
        requiredDependencies.values().forEach(result::addDependency);
        return result;
    }

    private static void readDependencies(JsonReader in, PluginMetadata result, PluginDependency.LoadOrder loadOrder, Map<String, PluginDependency> requiredDependencies) throws IOException {
        in.beginArray();
        while (in.hasNext()) {
            PluginDependency dependency = ModMetadataAdapter.readDependency(in, loadOrder, true);
            PluginDependency required = requiredDependencies.remove(dependency.getId());
            if (required != null) {
                if (required.getVersion() != null && !required.getVersion().equals(dependency.getVersion())) {
                    throw new IllegalArgumentException("Found conflicting version in required dependency: " + dependency.getVersion() + " != " + required.getVersion());
                }
                dependency = dependency.required();
            }
            result.addDependency(dependency);
        }
        in.endArray();
    }

    private static PluginDependency readDependency(JsonReader in, PluginDependency.LoadOrder loadOrder, boolean optional) throws IOException {
        String version = in.nextString();
        int pos = version.indexOf(64);
        if (pos < 0) {
            return new PluginDependency(loadOrder, version, null, optional);
        }
        return new PluginDependency(loadOrder, version.substring(0, pos), version.substring(pos + 1), optional);
    }

    public void write(JsonWriter out, PluginMetadata meta) throws IOException {
        Map<PluginDependency.LoadOrder, Set<PluginDependency>> dependencies;
        Set<PluginDependency> loadOrderNone;
        out.beginObject();
        out.name("modid").value(meta.getId());
        ModMetadataAdapter.writeIfPresent(out, "name", meta.getName());
        ModMetadataAdapter.writeIfPresent(out, "version", meta.getVersion());
        ModMetadataAdapter.writeIfPresent(out, "description", meta.getDescription());
        ModMetadataAdapter.writeIfPresent(out, "url", meta.getUrl());
        if (!meta.getAuthors().isEmpty()) {
            out.name("authorList").beginArray();
            for (String author : meta.getAuthors()) {
                out.value(author);
            }
            out.endArray();
        }
        if ((loadOrderNone = (dependencies = meta.groupDependenciesByLoadOrder()).get((Object)PluginDependency.LoadOrder.NONE)) != null) {
            for (PluginDependency pluginDependency : loadOrderNone) {
                if (!pluginDependency.isOptional()) continue;
                throw new IllegalArgumentException("Cannot represent optional dependency with LoadOrder.NONE: " + pluginDependency);
            }
        }
        ModMetadataAdapter.writeDependencies(out, "dependencies", dependencies.get((Object)PluginDependency.LoadOrder.BEFORE));
        ModMetadataAdapter.writeDependencies(out, "dependants", dependencies.get((Object)PluginDependency.LoadOrder.AFTER));
        ModMetadataAdapter.writeDependencies(out, "requiredMods", meta.collectRequiredDependencies());
        for (Map.Entry entry : meta.getExtensions().entrySet()) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            out.name(key);
            this.gson.toJson(value, this.getExtension(key), out);
        }
        out.endObject();
    }

    private static void writeIfPresent(JsonWriter out, String key, @Nullable String value) throws IOException {
        if (value != null) {
            out.name(key).value(value);
        }
    }

    private static void writeDependencies(JsonWriter out, String key, @Nullable Set<PluginDependency> dependencies) throws IOException {
        if (dependencies != null && !dependencies.isEmpty()) {
            out.name(key).beginArray();
            for (PluginDependency dependency : dependencies) {
                ModMetadataAdapter.writeDependency(out, dependency);
            }
            out.endArray();
        }
    }

    private static void writeDependency(JsonWriter out, PluginDependency dependency) throws IOException {
        if (dependency.getVersion() == null) {
            out.value(dependency.getId());
        } else {
            out.value(dependency.getId() + '@' + dependency.getVersion());
        }
    }
}

