/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.server.network;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.bytes.Byte2ObjectMap;
import it.unimi.dsi.fastutil.bytes.Byte2ObjectOpenHashMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.Packet;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.server.SPacketCustomPayload;
import org.spongepowered.api.Platform;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.network.ChannelBinding;
import org.spongepowered.api.network.ChannelRegistrar;
import org.spongepowered.api.network.Message;
import org.spongepowered.api.network.MessageHandler;
import org.spongepowered.api.network.RemoteConnection;
import org.spongepowered.api.plugin.PluginContainer;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.network.SpongeNetworkManager;
import org.spongepowered.server.bridge.network.NetHandlerPlayServerBridge_Vanilla;
import org.spongepowered.server.network.VanillaChannelBinding;

public final class VanillaIndexedMessageChannel
extends VanillaChannelBinding
implements ChannelBinding.IndexedMessageChannel {
    private final Byte2ObjectMap<IndexedMessageType<?>> messageIds = new Byte2ObjectOpenHashMap();
    private final Map<Class<? extends Message>, IndexedMessageType<?>> messageClasses = new HashMap();

    public VanillaIndexedMessageChannel(ChannelRegistrar registrar, String name, PluginContainer owner) {
        super(registrar, name, owner);
    }

    @Override
    public void registerMessage(Class<? extends Message> messageClass, int messageId) {
        this.validate();
        Preconditions.checkNotNull(messageClass, (Object)"messageClass");
        byte id = (byte)messageId;
        IndexedMessageType type = (IndexedMessageType)this.messageIds.get(id);
        Preconditions.checkState((type == null ? 1 : 0) != 0, (String)"Message ID %s is already assigned to %s", (int)id, (Object)type);
        type = new IndexedMessageType(id, messageClass);
        this.messageIds.put(id, type);
        this.messageClasses.put(messageClass, type);
    }

    @Override
    public <M extends Message> void registerMessage(Class<M> messageClass, int messageId, MessageHandler<M> handler) {
        Preconditions.checkNotNull(handler, (Object)"handler");
        this.registerMessage(messageClass, messageId);
        this.registerHandler(messageClass, handler);
    }

    @Override
    public <M extends Message> void registerMessage(Class<M> messageClass, int messageId, Platform.Type side, MessageHandler<M> handler) {
        Preconditions.checkNotNull(handler, (Object)"handler");
        this.registerMessage(messageClass, messageId);
        this.registerHandler(messageClass, side, handler);
    }

    private <M extends Message> void registerHandler(Class<M> messageClass, MessageHandler<M> handler) {
        IndexedMessageType<?> message = this.messageClasses.get(messageClass);
        Preconditions.checkArgument((message != null ? 1 : 0) != 0, (String)"Unregistered message class: %s", messageClass);
        ((IndexedMessageType)message).handlers.add(handler);
    }

    private <M extends Message> void registerHandler(Class<M> messageClass, Platform.Type side, MessageHandler<M> handler) {
        if (side == Platform.Type.SERVER) {
            this.registerHandler(messageClass, handler);
        }
    }

    @Override
    public <M extends Message> void addHandler(Class<M> messageClass, MessageHandler<M> handler) {
        this.validate();
        Preconditions.checkNotNull(handler, (Object)"handler");
        this.registerHandler(messageClass, handler);
    }

    @Override
    public <M extends Message> void addHandler(Class<M> messageClass, Platform.Type side, MessageHandler<M> handler) {
        this.validate();
        Preconditions.checkNotNull(handler, (Object)"handler");
        this.registerHandler(messageClass, side, handler);
    }

    @Override
    public void post(RemoteConnection connection, PacketBuffer payload) {
        try {
            byte id = payload.readByte();
            IndexedMessageType type = (IndexedMessageType)this.messageIds.get(id);
            Preconditions.checkNotNull((Object)type, (String)"Unknown message with id %s", (int)id);
            type.post(connection, payload.slice());
        }
        catch (Throwable e) {
            this.getOwner().getLogger().error("Failed to read indexed message for channel {} of {}", this.getName(), this.getOwner(), e);
        }
    }

    private SPacketCustomPayload createPacket(Message message) {
        Class<?> messageClass = message.getClass();
        IndexedMessageType<?> type = this.messageClasses.get(messageClass);
        Preconditions.checkNotNull(type, (String)"Unknown message type %s of %s", messageClass, (Object)message);
        PacketBuffer buffer = new PacketBuffer(Unpooled.buffer());
        buffer.writeByte((int)((IndexedMessageType)type).id);
        buffer.markWriterIndex();
        message.writeTo(SpongeNetworkManager.toChannelBuf((ByteBuf)buffer));
        return new SPacketCustomPayload(this.getName(), buffer);
    }

    @Override
    public void sendTo(Player player, Message message) {
        this.validate();
        EntityPlayerMP playerMP = (EntityPlayerMP)player;
        if (((NetHandlerPlayServerBridge_Vanilla)playerMP.field_71135_a).vanillaBridge$supportsChannel(this.getName())) {
            playerMP.field_71135_a.func_147359_a((Packet)this.createPacket(message));
        }
    }

    @Override
    public void sendToServer(Message message) {
        this.validate();
    }

    @Override
    public void sendToAll(Message message) {
        this.validate();
        String name = this.getName();
        SPacketCustomPayload packet = null;
        for (EntityPlayerMP player : SpongeImpl.getServer().func_184103_al().func_181057_v()) {
            if (!((NetHandlerPlayServerBridge_Vanilla)player.field_71135_a).vanillaBridge$supportsChannel(name)) continue;
            if (packet == null) {
                packet = this.createPacket(message);
            }
            player.field_71135_a.func_147359_a((Packet)packet);
        }
    }

    private final class IndexedMessageType<T extends Message> {
        private final byte id;
        private final Class<T> messageClass;
        private final Set<MessageHandler<T>> handlers = Sets.newIdentityHashSet();

        private IndexedMessageType(byte id, Class<T> messageClass) {
            this.id = id;
            this.messageClass = messageClass;
        }

        private T read(ByteBuf buf) throws Exception {
            Message message = (Message)this.messageClass.newInstance();
            message.readFrom(SpongeNetworkManager.toChannelBuf(buf));
            return (T)message;
        }

        private void post(RemoteConnection connection, T message) {
            for (MessageHandler<T> listener : this.handlers) {
                try {
                    listener.handleMessage(message, connection, Platform.Type.SERVER);
                }
                catch (Throwable e) {
                    VanillaIndexedMessageChannel.this.getOwner().getLogger().error("Could not pass indexed message {} on channel '{}' to {}", message, VanillaIndexedMessageChannel.this.getName(), VanillaIndexedMessageChannel.this.getOwner(), e);
                }
            }
        }

        private void post(RemoteConnection connection, ByteBuf buf) throws Exception {
            this.post(connection, this.read(buf));
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("id", (int)this.id).add("class", this.messageClass).toString();
        }
    }
}

