from collections import abc
from pandas import DataFrame as DataFrame, MultiIndex as MultiIndex, Series as Series, isna as isna, to_datetime as to_datetime
from pandas._typing import JSONSerializable as JSONSerializable
from pandas.core.construction import create_series_with_explicit_dtype as create_series_with_explicit_dtype
from pandas.core.dtypes.common import ensure_str as ensure_str, is_period_dtype as is_period_dtype
from pandas.core.reshape.concat import concat as concat
from pandas.errors import AbstractMethodError as AbstractMethodError
from pandas.io.common import get_filepath_or_buffer as get_filepath_or_buffer, get_handle as get_handle, infer_compression as infer_compression, stringify_path as stringify_path
from pandas.io.json._normalize import convert_to_line_delimits as convert_to_line_delimits
from pandas.io.json._table_schema import build_table_schema as build_table_schema, parse_table_schema as parse_table_schema
from pandas.util._decorators import deprecate_kwarg as deprecate_kwarg
from typing import Any, Callable, Optional

loads: Any
dumps: Any
TABLE_SCHEMA_VERSION: str

def to_json(path_or_buf: Any, obj: Any, orient: Optional[str]=..., date_format: str=..., double_precision: int=..., force_ascii: bool=..., date_unit: str=..., default_handler: Optional[Callable[[Any], JSONSerializable]]=..., lines: bool=..., compression: Optional[str]=..., index: bool=..., indent: int=...) -> Any: ...

class Writer:
    obj: Any = ...
    orient: Any = ...
    date_format: Any = ...
    double_precision: Any = ...
    ensure_ascii: Any = ...
    date_unit: Any = ...
    default_handler: Any = ...
    index: Any = ...
    indent: Any = ...
    is_copy: Any = ...
    def __init__(self, obj: Any, orient: Optional[str], date_format: str, double_precision: int, ensure_ascii: bool, date_unit: str, index: bool, default_handler: Optional[Callable[[Any], JSONSerializable]]=..., indent: int=...) -> None: ...
    def write(self) -> Any: ...

class SeriesWriter(Writer): ...
class FrameWriter(Writer): ...

class JSONTableWriter(FrameWriter):
    schema: Any = ...
    obj: Any = ...
    date_format: str = ...
    orient: str = ...
    index: Any = ...
    def __init__(self, obj: Any, orient: Optional[str], date_format: str, double_precision: int, ensure_ascii: bool, date_unit: str, index: bool, default_handler: Optional[Callable[[Any], JSONSerializable]]=..., indent: int=...) -> None: ...

def read_json(path_or_buf: Optional[Any] = ..., orient: Optional[Any] = ..., typ: str = ..., dtype: Optional[Any] = ..., convert_axes: Optional[Any] = ..., convert_dates: bool = ..., keep_default_dates: bool = ..., numpy: bool = ..., precise_float: bool = ..., date_unit: Optional[Any] = ..., encoding: Optional[Any] = ..., lines: bool = ..., chunksize: Optional[Any] = ..., compression: str = ...) -> Any: ...

class JsonReader(abc.Iterator[Any]):
    path_or_buf: Any = ...
    orient: Any = ...
    typ: Any = ...
    dtype: Any = ...
    convert_axes: Any = ...
    convert_dates: Any = ...
    keep_default_dates: Any = ...
    numpy: Any = ...
    precise_float: Any = ...
    date_unit: Any = ...
    encoding: Any = ...
    compression: Any = ...
    lines: Any = ...
    chunksize: Any = ...
    nrows_seen: int = ...
    should_close: bool = ...
    data: Any = ...
    def __init__(self, filepath_or_buffer: Any, orient: Any, typ: Any, dtype: Any, convert_axes: Any, convert_dates: Any, keep_default_dates: Any, numpy: Any, precise_float: Any, date_unit: Any, encoding: Any, lines: Any, chunksize: Any, compression: Any) -> None: ...
    def read(self) -> Any: ...
    def close(self) -> None: ...
    def __next__(self) -> Any: ...

class Parser:
    json: Any = ...
    orient: Any = ...
    dtype: Any = ...
    min_stamp: Any = ...
    numpy: Any = ...
    precise_float: Any = ...
    convert_axes: Any = ...
    convert_dates: Any = ...
    date_unit: Any = ...
    keep_default_dates: Any = ...
    obj: Any = ...
    def __init__(self, json: Any, orient: Any, dtype: Optional[Any] = ..., convert_axes: bool = ..., convert_dates: bool = ..., keep_default_dates: bool = ..., numpy: bool = ..., precise_float: bool = ..., date_unit: Optional[Any] = ...) -> None: ...
    def check_keys_split(self, decoded: Any) -> None: ...
    def parse(self) -> Any: ...

class SeriesParser(Parser): ...
class FrameParser(Parser): ...
