import { IResolvable, ITerraformDependable, TerraformProvider, TerraformResourceLifecycle } from "cdktf";
import { LocalExec } from "cdktf-local-exec";
import { Construct } from "constructs";
/**
 * @stability stable
 */
export interface CargoOptions {
    /**
     * Architecture of the binary to build.
     *
     * @default "x86"
     * @stability stable
     */
    readonly arch?: "arm" | "x86";
    /**
     * @stability stable
     */
    readonly projectName: string;
    /**
     * @stability stable
     */
    readonly dependsOn?: ITerraformDependable[];
    /**
     * @stability stable
     */
    readonly provider?: TerraformProvider;
    /**
     * @stability stable
     */
    readonly lifecycle?: TerraformResourceLifecycle;
    /**
     * @stability stable
     */
    readonly triggers?: {
        [key: string]: string;
    } | IResolvable;
    /**
     * The working directory to run the command in.
     *
     * Defaults to process.pwd().
     * If copyBeforeRun is set to true it will copy the working directory to an asset directory and take that as the base to run.
     *
     * @stability stable
     */
    readonly cwd: string;
    /**
     * If set to true, the working directory will be copied to an asset directory.
     *
     * @default true
     * @stability stable
     */
    readonly copyBeforeRun?: boolean;
}
/**
 * Builds a binary using cargo inside a docker container.
 *
 * It is built to support https://github.com/awslabs/aws-lambda-rust-runtime
 *
 * @stability stable
 */
export declare class CargoBuild extends LocalExec {
    /**
     * @stability stable
     */
    constructor(scope: Construct, name: string, options: CargoOptions);
    /**
     * @stability stable
     */
    get binary(): string;
}
