from typing import Any, Dict, Final, List, Sequence, Tuple

from solders.instruction import Instruction
from solders.pubkey import Pubkey

ID: Final[Pubkey]

def create_account(params: Dict[str, Any]) -> Instruction: ...
def decode_create_account(instruction: Instruction) -> Dict[str, Any]: ...
def create_account_with_seed(params: Dict[str, Any]) -> Instruction: ...
def decode_create_account_with_seed(instruction: Instruction) -> Dict[str, Any]: ...
def assign(params: Dict[str, Any]) -> Instruction: ...
def decode_assign(instruction: Instruction) -> Dict[str, Any]: ...
def assign_with_seed(params: Dict[str, Any]) -> Instruction: ...
def decode_assign_with_seed(instruction: Instruction) -> Dict[str, Any]: ...
def transfer(params: Dict[str, Any]) -> Instruction: ...
def decode_transfer(instruction: Instruction) -> Dict[str, Any]: ...
def transfer_with_seed(params: Dict[str, Any]) -> Instruction: ...
def decode_transfer_with_seed(instruction: Instruction) -> Dict[str, Any]: ...
def allocate(params: Dict[str, Any]) -> Instruction: ...
def decode_allocate(instruction: Instruction) -> Dict[str, Any]: ...
def allocate_with_seed(params: Dict[str, Any]) -> Instruction: ...
def decode_allocate_with_seed(instruction: Instruction) -> Dict[str, Any]: ...
def transfer_many(
    from_pubkey: Pubkey,
    to_lamports: Sequence[Tuple[Pubkey, int]],
) -> List[Instruction]: ...
def create_nonce_account_with_seed(
    from_pubkey: Pubkey,
    nonce_pubkey: Pubkey,
    base: Pubkey,
    seed: str,
    authority: Pubkey,
    lamports: int,
) -> Tuple[Instruction, Instruction]: ...
def create_nonce_account(
    from_pubkey: Pubkey,
    nonce_pubkey: Pubkey,
    authority: Pubkey,
    lamports: int,
) -> Tuple[Instruction, Instruction]: ...
def initialize_nonce_account(params: Dict[str, Any]) -> Instruction: ...
def decode_initialize_nonce_account(instruction: Instruction) -> Dict[str, Any]: ...
def advance_nonce_account(params: Dict[str, Any]) -> Instruction: ...
def decode_advance_nonce_account(instruction: Instruction) -> Dict[str, Any]: ...
def withdraw_nonce_account(params: Dict[str, Any]) -> Instruction: ...
def decode_withdraw_nonce_account(instruction: Instruction) -> Dict[str, Any]: ...
def authorize_nonce_account(params: Dict[str, Any]) -> Instruction: ...
def decode_authorize_nonce_account(instruction: Instruction) -> Dict[str, Any]: ...
