from typing import Optional, Union

from solders.rpc.responses import RpcSimulateTransactionResult
from solders.transaction_status import TransactionErrorType

class BlockCleanedUp:
    slot: int
    first_available_block: int
    def __init__(self, slot: int, first_available_block: int) -> None: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> "BlockCleanedUp": ...
    @staticmethod
    def from_bytes(data: bytes) -> "BlockCleanedUp": ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class BlockCleanedUpMessage:
    message: str
    def __init__(self, message: str) -> None: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> "BlockCleanedUpMessage": ...
    @staticmethod
    def from_bytes(data: bytes) -> "BlockCleanedUpMessage": ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class SendTransactionPreflightFailure:
    message: str
    result: RpcSimulateTransactionResult
    def __init__(self, message: str, data: RpcSimulateTransactionResult) -> None: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> "SendTransactionPreflightFailure": ...
    @staticmethod
    def from_bytes(data: bytes) -> "SendTransactionPreflightFailure": ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class SendTransactionPreflightFailureMessage:
    message: str
    data: RpcSimulateTransactionResult
    def __init__(self, message: str, data: RpcSimulateTransactionResult) -> None: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> "SendTransactionPreflightFailureMessage": ...
    @staticmethod
    def from_bytes(data: bytes) -> "SendTransactionPreflightFailureMessage": ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class RpcCustomErrorFieldless:
    TransactionSignatureVerificationFailure: "RpcCustomErrorFieldless"
    NoSnapshot: "RpcCustomErrorFieldless"
    TransactionHistoryNotAvailable: "RpcCustomErrorFieldless"
    TransactionSignatureLenMismatch: "RpcCustomErrorFieldless"
    Base64Zstd: "RpcCustomErrorFieldless"
    def __int__(self) -> int: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...

class BlockNotAvailable:
    slot: int
    def __init__(self, slot: int) -> None: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> "BlockNotAvailable": ...
    @staticmethod
    def from_bytes(data: bytes) -> "BlockNotAvailable": ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class BlockNotAvailableMessage:
    message: str
    def __init__(self, message: str) -> None: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> "BlockNotAvailableMessage": ...
    @staticmethod
    def from_bytes(data: bytes) -> "BlockNotAvailableMessage": ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class NodeUnhealthy:
    num_slots_behind: Optional[int]
    def __init__(self, num_slots_behind: Optional[int] = None) -> None: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> "NodeUnhealthy": ...
    @staticmethod
    def from_bytes(data: bytes) -> "NodeUnhealthy": ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class NodeUnhealthyMessage:
    message: str
    data: NodeUnhealthy
    def __init__(self, message: str, data: NodeUnhealthy) -> None: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> "NodeUnhealthyMessage": ...
    @staticmethod
    def from_bytes(data: bytes) -> "NodeUnhealthyMessage": ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class TransactionPrecompileVerificationFailure:
    def __init__(self, error: TransactionErrorType) -> None: ...
    def error(self) -> TransactionErrorType: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> "TransactionPrecompileVerificationFailure": ...
    @staticmethod
    def from_bytes(data: bytes) -> "TransactionPrecompileVerificationFailure": ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class TransactionPrecompileVerificationFailureMessage:
    message: str
    def __init__(self, message: str) -> None: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> "TransactionPrecompileVerificationFailureMessage": ...
    @staticmethod
    def from_bytes(
        data: bytes,
    ) -> "TransactionPrecompileVerificationFailureMessage": ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class SlotSkipped:
    slot: int
    def __init__(self, slot: int) -> None: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> "SlotSkipped": ...
    @staticmethod
    def from_bytes(data: bytes) -> "SlotSkipped": ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class SlotSkippedMessage:
    message: str
    def __init__(self, message: str) -> None: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> "SlotSkippedMessage": ...
    @staticmethod
    def from_bytes(data: bytes) -> "SlotSkippedMessage": ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class LongTermStorageSlotSkipped:
    slot: int
    def __init__(self, slot: int) -> None: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> "LongTermStorageSlotSkipped": ...
    @staticmethod
    def from_bytes(data: bytes) -> "LongTermStorageSlotSkipped": ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class LongTermStorageSlotSkippedMessage:
    message: str
    def __init__(self, message: str) -> None: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> "LongTermStorageSlotSkippedMessage": ...
    @staticmethod
    def from_bytes(data: bytes) -> "LongTermStorageSlotSkippedMessage": ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class KeyExcludedFromSecondaryIndex:
    index_key: str
    def __init__(self, index_key: str) -> None: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> "KeyExcludedFromSecondaryIndex": ...
    @staticmethod
    def from_bytes(data: bytes) -> "KeyExcludedFromSecondaryIndex": ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class KeyExcludedFromSecondaryIndexMessage:
    message: str
    def __init__(self, message: str) -> None: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> "KeyExcludedFromSecondaryIndexMessage": ...
    @staticmethod
    def from_bytes(data: bytes) -> "KeyExcludedFromSecondaryIndexMessage": ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class ScanError:
    message: str
    def __init__(self, message: str) -> None: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> "ScanError": ...
    @staticmethod
    def from_bytes(data: bytes) -> "ScanError": ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class ScanErrorMessage:
    message: str
    def __init__(self, message: str) -> None: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> "ScanErrorMessage": ...
    @staticmethod
    def from_bytes(data: bytes) -> "ScanErrorMessage": ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class BlockStatusNotAvailableYet:
    slot: int
    def __init__(self, slot: int) -> None: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> "BlockStatusNotAvailableYet": ...
    @staticmethod
    def from_bytes(data: bytes) -> "BlockStatusNotAvailableYet": ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class BlockStatusNotAvailableYetMessage:
    message: str
    def __init__(self, message: str) -> None: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> "BlockStatusNotAvailableYetMessage": ...
    @staticmethod
    def from_bytes(data: bytes) -> "BlockStatusNotAvailableYetMessage": ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class MinContextSlotNotReached:
    context_slot: int
    def __init__(self, context_slot: int) -> None: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> "MinContextSlotNotReached": ...
    @staticmethod
    def from_bytes(data: bytes) -> "MinContextSlotNotReached": ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class MinContextSlotNotReachedMessage:
    message: str
    data: MinContextSlotNotReached
    def __init__(self, message: str, data: MinContextSlotNotReached) -> None: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> "MinContextSlotNotReachedMessage": ...
    @staticmethod
    def from_bytes(data: bytes) -> "MinContextSlotNotReachedMessage": ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class UnsupportedTransactionVersion:
    def __init__(self, value: int) -> None: ...
    def value(self) -> int: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> "UnsupportedTransactionVersion": ...
    @staticmethod
    def from_bytes(data: bytes) -> "UnsupportedTransactionVersion": ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class UnsupportedTransactionVersionMessage:
    message: str
    def __init__(self, message: str) -> None: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> "UnsupportedTransactionVersionMessage": ...
    @staticmethod
    def from_bytes(data: bytes) -> "UnsupportedTransactionVersionMessage": ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class ParseErrorMessage:
    message: str
    def __init__(self, message: str) -> None: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> "ParseErrorMessage": ...
    @staticmethod
    def from_bytes(data: bytes) -> "ParseErrorMessage": ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class InvalidRequestMessage:
    message: str
    def __init__(self, message: str) -> None: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> "InvalidRequestMessage": ...
    @staticmethod
    def from_bytes(data: bytes) -> "InvalidRequestMessage": ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class MethodNotFoundMessage:
    message: str
    def __init__(self, message: str) -> None: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> "MethodNotFoundMessage": ...
    @staticmethod
    def from_bytes(data: bytes) -> "MethodNotFoundMessage": ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class InvalidParamsMessage:
    message: str
    def __init__(self, message: str) -> None: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> "InvalidParamsMessage": ...
    @staticmethod
    def from_bytes(data: bytes) -> "InvalidParamsMessage": ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class InternalErrorMessage:
    message: str
    def __init__(self, message: str) -> None: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> "InternalErrorMessage": ...
    @staticmethod
    def from_bytes(data: bytes) -> "InternalErrorMessage": ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

RpcCustomError = Union[
    RpcCustomErrorFieldless,
    BlockCleanedUp,
    SendTransactionPreflightFailure,
    BlockNotAvailable,
    NodeUnhealthy,
    TransactionPrecompileVerificationFailure,
    SlotSkipped,
    LongTermStorageSlotSkipped,
    BlockCleanedUp,
    KeyExcludedFromSecondaryIndex,
    ScanError,
    BlockStatusNotAvailableYet,
    MinContextSlotNotReached,
    UnsupportedTransactionVersion,
]
