from __future__ import annotations

from typing import Any, Dict, List, Optional, Sequence, Tuple, TypeVar, Union

from solders.account import Account, AccountJSON
from solders.account_decoder import UiTokenAmount
from solders.epoch_schedule import EpochSchedule
from solders.hash import Hash
from solders.pubkey import Pubkey
from solders.rpc.errors import (
    BlockCleanedUpMessage,
    BlockNotAvailableMessage,
    BlockStatusNotAvailableYetMessage,
    InternalErrorMessage,
    InvalidParamsMessage,
    InvalidRequestMessage,
    KeyExcludedFromSecondaryIndexMessage,
    LongTermStorageSlotSkippedMessage,
    MethodNotFoundMessage,
    MinContextSlotNotReachedMessage,
    NodeUnhealthyMessage,
    ParseErrorMessage,
    RpcCustomErrorFieldless,
    ScanErrorMessage,
    SendTransactionPreflightFailureMessage,
    SlotSkippedMessage,
    TransactionPrecompileVerificationFailureMessage,
    UnsupportedTransactionVersion,
    UnsupportedTransactionVersionMessage,
)
from solders.signature import Signature
from solders.transaction_status import (
    EncodedConfirmedTransactionWithStatusMeta,
    TransactionConfirmationStatus,
    TransactionErrorType,
    TransactionReturnData,
    TransactionStatus,
    UiConfirmedBlock,
)

class RpcResponseContext:
    slot: int
    api_version: Optional[str]
    def __init__(self, slot: int, api_version: Optional[str] = None) -> None: ...

RPCError = Union[
    RpcCustomErrorFieldless,
    BlockCleanedUpMessage,
    SendTransactionPreflightFailureMessage,
    BlockNotAvailableMessage,
    NodeUnhealthyMessage,
    TransactionPrecompileVerificationFailureMessage,
    SlotSkippedMessage,
    LongTermStorageSlotSkippedMessage,
    KeyExcludedFromSecondaryIndexMessage,
    ScanErrorMessage,
    BlockStatusNotAvailableYetMessage,
    MinContextSlotNotReachedMessage,
    UnsupportedTransactionVersionMessage,
    ParseErrorMessage,
    InvalidRequestMessage,
    MethodNotFoundMessage,
    InvalidParamsMessage,
    InternalErrorMessage,
]

T = TypeVar("T")
Resp = Union[RPCError, T]

class GetAccountInfoResp:
    context: RpcResponseContext
    value: Optional[Account]
    def __init__(
        self, value: Optional[Account], context: RpcResponseContext
    ) -> None: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> Resp[GetAccountInfoResp]: ...
    @staticmethod
    def from_bytes(data: bytes) -> GetAccountInfoResp: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class GetAccountInfoJsonParsedResp:
    context: RpcResponseContext
    value: Optional[AccountJSON]
    def __init__(
        self, value: Optional[AccountJSON], context: RpcResponseContext
    ) -> None: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> Resp[GetAccountInfoJsonParsedResp]: ...
    @staticmethod
    def from_bytes(data: bytes) -> GetAccountInfoJsonParsedResp: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class GetAccountInfoMaybeJsonParsedResp:
    context: RpcResponseContext
    value: Optional[Union[AccountJSON, Account]]
    def __init__(
        self, value: Optional[Union[AccountJSON, Account]], context: RpcResponseContext
    ) -> None: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> Resp[GetAccountInfoMaybeJsonParsedResp]: ...
    @staticmethod
    def from_bytes(data: bytes) -> GetAccountInfoMaybeJsonParsedResp: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class GetBalanceResp:
    context: RpcResponseContext
    value: int
    def __init__(self, value: int, context: RpcResponseContext) -> None: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> Resp[GetBalanceResp]: ...
    @staticmethod
    def from_bytes(data: bytes) -> GetBalanceResp: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class GetBlockCommitmentResp:
    commitment: Optional[List[int]]
    total_stake: int
    def __init__(
        self, commitment: Optional[Sequence[int]], total_stake: int
    ) -> None: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> Resp[GetBlockCommitmentResp]: ...
    @staticmethod
    def from_bytes(data: bytes) -> GetBlockCommitmentResp: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class GetBlockHeightResp:
    def __init__(self, value: int) -> None: ...
    @property
    def value(self) -> int: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> Resp[GetBlockHeightResp]: ...
    @staticmethod
    def from_bytes(data: bytes) -> GetBlockHeightResp: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class RpcBlockProductionRange:
    def __init__(
        self,
        first_slot: int,
        last_slot: int,
    ) -> None: ...
    @property
    def first_slot(self) -> int: ...
    @property
    def last_slot(self) -> int: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> RpcBlockProductionRange: ...
    @staticmethod
    def from_bytes(data: bytes) -> RpcBlockProductionRange: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class RpcBlockProduction:
    def __init__(
        self,
        by_identity: Dict[Pubkey, Tuple[int, int]],
        range: RpcBlockProductionRange,
    ) -> None: ...
    @property
    def by_identity(self) -> Dict[Pubkey, Tuple[int, int]]: ...
    @property
    def range(self) -> RpcBlockProductionRange: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> RpcBlockProduction: ...
    @staticmethod
    def from_bytes(data: bytes) -> RpcBlockProduction: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class GetBlockProductionResp:
    value: RpcBlockProduction
    context: RpcResponseContext
    def __init__(
        self, value: RpcBlockProduction, context: RpcResponseContext
    ) -> None: ...
    @property
    def height(self) -> int: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> Resp[GetBlockProductionResp]: ...
    @staticmethod
    def from_bytes(data: bytes) -> GetBlockProductionResp: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class GetBlockResp:
    def __init__(self, value: UiConfirmedBlock) -> None: ...
    @property
    def value(self) -> UiConfirmedBlock: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> Resp[GetBlockResp]: ...
    @staticmethod
    def from_bytes(data: bytes) -> GetBlockResp: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class GetBlocksResp:
    def __init__(self, value: List[int]) -> None: ...
    @property
    def value(self) -> List[int]: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> Resp[GetBlocksResp]: ...
    @staticmethod
    def from_bytes(data: bytes) -> GetBlocksResp: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class GetBlocksWithLimitResp:
    def __init__(self, value: List[int]) -> None: ...
    @property
    def value(self) -> List[int]: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> Resp[GetBlocksWithLimitResp]: ...
    @staticmethod
    def from_bytes(data: bytes) -> GetBlocksWithLimitResp: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class GetBlockTimeResp:
    def __init__(self, value: Optional[int] = None) -> None: ...
    @property
    def value(self) -> Optional[int]: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> Resp[GetBlockTimeResp]: ...
    @staticmethod
    def from_bytes(data: bytes) -> GetBlockTimeResp: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class RpcContactInfo:
    pubkey: Pubkey
    gossip: Optional[str]
    tpu: Optional[str]
    rpc: Optional[str]
    version: Optional[str]
    feature_set: Optional[int]
    shred_version: Optional[int]
    def __init__(
        self,
        pubkey: Pubkey,
        gossip: Optional[str] = None,
        tpu: Optional[str] = None,
        rpc: Optional[str] = None,
        version: Optional[str] = None,
        feature_set: Optional[int] = None,
        shred_version: Optional[int] = None,
    ) -> None: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> RpcContactInfo: ...
    @staticmethod
    def from_bytes(data: bytes) -> RpcContactInfo: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class GetClusterNodesResp:
    def __init__(self, value: Sequence[RpcContactInfo]) -> None: ...
    @property
    def value(self) -> List[RpcContactInfo]: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> Resp[GetClusterNodesResp]: ...
    @staticmethod
    def from_bytes(data: bytes) -> GetClusterNodesResp: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class EpochInfo:
    epoch: int
    slot_index: int
    slots_in_epoch: int
    absolute_slot: int
    block_height: int
    transaction_count: Optional[int]
    def __init__(
        self,
        epoch: int,
        slot_index: int,
        slots_in_epoch: int,
        absolute_slot: int,
        block_height: int,
        transaction_count: Optional[int] = None,
    ) -> None: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> EpochInfo: ...
    @staticmethod
    def from_bytes(data: bytes) -> EpochInfo: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class GetEpochInfoResp:
    def __init__(self, value: EpochInfo) -> None: ...
    @property
    def value(self) -> EpochInfo: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> Resp[GetEpochInfoResp]: ...
    @staticmethod
    def from_bytes(data: bytes) -> GetEpochInfoResp: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class GetEpochScheduleResp:
    def __init__(self, value: EpochSchedule) -> None: ...
    @property
    def value(self) -> EpochSchedule: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> Resp[GetEpochScheduleResp]: ...
    @staticmethod
    def from_bytes(data: bytes) -> GetEpochScheduleResp: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class GetFeeForMessageResp:
    context: RpcResponseContext
    value: Optional[int]
    def __init__(self, value: Optional[int], context: RpcResponseContext) -> None: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> Resp[GetFeeForMessageResp]: ...
    @staticmethod
    def from_bytes(data: bytes) -> GetFeeForMessageResp: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class GetFirstAvailableBlockResp:
    def __init__(self, value: int) -> None: ...
    @property
    def value(self) -> int: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> Resp[GetFirstAvailableBlockResp]: ...
    @staticmethod
    def from_bytes(data: bytes) -> GetFirstAvailableBlockResp: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class GetGenesisHashResp:
    def __init__(self, value: Hash) -> None: ...
    @property
    def value(self) -> Hash: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> Resp[GetGenesisHashResp]: ...
    @staticmethod
    def from_bytes(data: bytes) -> GetGenesisHashResp: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class GetHealthResp:
    def __init__(self, value: str) -> None: ...
    @property
    def value(self) -> str: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> Resp[GetHealthResp]: ...
    @staticmethod
    def from_bytes(data: bytes) -> GetHealthResp: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class RpcSimulateTransactionResult:
    err: Optional[TransactionErrorType]
    logs: Optional[List[str]]
    accounts: Optional[List[Optional[Account]]]
    units_consumed: Optional[int]
    return_data: Optional[TransactionReturnData]
    def __init__(
        self,
        err: Optional[TransactionErrorType] = None,
        logs: Optional[Sequence[str]] = None,
        accounts: Optional[Sequence[Optional[Account]]] = None,
        units_consumed: Optional[int] = None,
        return_data: Optional[TransactionReturnData] = None,
    ) -> None: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> RpcSimulateTransactionResult: ...
    @staticmethod
    def from_bytes(data: bytes) -> RpcSimulateTransactionResult: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class RpcSnapshotSlotInfo:
    def __init__(self, full: int, incremental: Optional[int] = None) -> None: ...
    @property
    def full(self) -> int: ...
    @property
    def incremental(self) -> Optional[int]: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> RpcSnapshotSlotInfo: ...
    @staticmethod
    def from_bytes(data: bytes) -> RpcSnapshotSlotInfo: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class GetHighestSnapshotSlotResp:
    def __init__(self, value: RpcSnapshotSlotInfo) -> None: ...
    @property
    def value(self) -> RpcSnapshotSlotInfo: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> Resp[GetHighestSnapshotSlotResp]: ...
    @staticmethod
    def from_bytes(data: bytes) -> GetHighestSnapshotSlotResp: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class RpcIdentity:
    identity: Pubkey
    def __init__(self, identity: Pubkey) -> None: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> RpcIdentity: ...
    @staticmethod
    def from_bytes(data: bytes) -> RpcIdentity: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class GetIdentityResp:
    def __init__(self, value: RpcIdentity) -> None: ...
    @property
    def value(self) -> RpcIdentity: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> Resp[GetIdentityResp]: ...
    @staticmethod
    def from_bytes(data: bytes) -> GetIdentityResp: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class RpcInflationGovernor:
    def __init__(
        self,
        initial: float,
        terminal: float,
        taper: float,
        foundation: float,
        foundation_term: float,
    ) -> None: ...
    @staticmethod
    def from_json(raw: str) -> RpcInflationGovernor: ...
    @staticmethod
    def from_bytes(data: bytes) -> RpcInflationGovernor: ...
    @property
    def initial(self) -> float: ...
    @property
    def terminal(self) -> float: ...
    @property
    def taper(self) -> float: ...
    @property
    def foundation(self) -> float: ...
    @property
    def foundation_term(self) -> float: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class GetInflationGovernorResp:
    def __init__(self, value: RpcInflationGovernor) -> None: ...
    @property
    def value(self) -> RpcInflationGovernor: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> Resp[GetInflationGovernorResp]: ...
    @staticmethod
    def from_bytes(data: bytes) -> GetInflationGovernorResp: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class RpcInflationRate:
    def __init__(
        self, total: float, validator: float, foundation: float, epoch: int
    ) -> None: ...
    @staticmethod
    def from_json(raw: str) -> RpcInflationRate: ...
    @staticmethod
    def from_bytes(data: bytes) -> RpcInflationRate: ...
    @property
    def total(self) -> float: ...
    @property
    def validator(self) -> float: ...
    @property
    def foundation(self) -> float: ...
    @property
    def epoch(self) -> int: ...
    @property
    def foundation_term(self) -> float: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class GetInflationRateResp:
    def __init__(self, value: RpcInflationRate) -> None: ...
    @property
    def value(self) -> RpcInflationRate: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> Resp[GetInflationRateResp]: ...
    @staticmethod
    def from_bytes(data: bytes) -> GetInflationRateResp: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class RpcInflationReward:
    def __init__(
        self,
        epoch: int,
        effective_slot: int,
        amount: int,
        post_balance: int,
        commission: Optional[int] = None,
    ) -> None: ...
    @staticmethod
    def from_json(raw: str) -> RpcInflationReward: ...
    @staticmethod
    def from_bytes(data: bytes) -> RpcInflationReward: ...
    @property
    def epoch(self) -> int: ...
    @property
    def effective_slot(self) -> int: ...
    @property
    def amount(self) -> int: ...
    @property
    def post_balance(self) -> int: ...
    @property
    def commission(self) -> Optional[int]: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class GetInflationRewardResp:
    def __init__(self, value: Sequence[Optional[RpcInflationReward]]) -> None: ...
    @property
    def value(self) -> Sequence[Optional[RpcInflationReward]]: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> Resp[GetInflationRewardResp]: ...
    @staticmethod
    def from_bytes(data: bytes) -> GetInflationRewardResp: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class RpcAccountBalance:
    def __init__(
        self,
        address: Pubkey,
        lamports: int,
    ) -> None: ...
    @staticmethod
    def from_json(raw: str) -> RpcAccountBalance: ...
    @staticmethod
    def from_bytes(data: bytes) -> RpcAccountBalance: ...
    @property
    def address(self) -> Pubkey: ...
    @property
    def lamports(self) -> int: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class GetLargestAccountsResp:
    context: RpcResponseContext
    value: List[RpcAccountBalance]
    def __init__(
        self, value: Sequence[RpcAccountBalance], context: RpcResponseContext
    ) -> None: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> Resp[GetLargestAccountsResp]: ...
    @staticmethod
    def from_bytes(data: bytes) -> GetLargestAccountsResp: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class RpcBlockhash:
    blockhash: Hash
    last_valid_block_height: int
    def __init__(self, blockhash: Hash, last_valid_block_height: int) -> None: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> RpcBlockhash: ...
    @staticmethod
    def from_bytes(data: bytes) -> RpcBlockhash: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class GetLatestBlockhashResp:
    context: RpcResponseContext
    value: RpcBlockhash
    def __init__(self, value: RpcBlockhash, context: RpcResponseContext) -> None: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> Resp[GetLatestBlockhashResp]: ...
    @staticmethod
    def from_bytes(data: bytes) -> GetLatestBlockhashResp: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class GetLeaderScheduleResp:
    def __init__(self, value: Optional[Dict[Pubkey, Sequence[int]]] = None) -> None: ...
    @property
    def value(self) -> Optional[Dict[Pubkey, List[int]]]: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> Resp[GetLatestBlockhashResp]: ...
    @staticmethod
    def from_bytes(data: bytes) -> GetLatestBlockhashResp: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class GetMaxRetransmitSlotResp:
    def __init__(self, value: int) -> None: ...
    @property
    def value(self) -> int: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> Resp[GetMaxRetransmitSlotResp]: ...
    @staticmethod
    def from_bytes(data: bytes) -> GetMaxRetransmitSlotResp: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class GetMaxShredInsertSlotResp:
    def __init__(self, value: int) -> None: ...
    @property
    def value(self) -> int: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> Resp[GetMaxShredInsertSlotResp]: ...
    @staticmethod
    def from_bytes(data: bytes) -> GetMaxShredInsertSlotResp: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class GetMinimumBalanceForRentExemptionResp:
    def __init__(self, value: int) -> None: ...
    @property
    def value(self) -> int: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> Resp[GetMinimumBalanceForRentExemptionResp]: ...
    @staticmethod
    def from_bytes(data: bytes) -> GetMinimumBalanceForRentExemptionResp: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class GetMultipleAccountsResp:
    context: RpcResponseContext
    value: List[Optional[Account]]
    def __init__(
        self, value: Sequence[Optional[Account]], context: RpcResponseContext
    ) -> None: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> Resp[GetAccountInfoResp]: ...
    @staticmethod
    def from_bytes(data: bytes) -> GetAccountInfoResp: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class GetMultipleAccountsJsonParsedResp:
    context: RpcResponseContext
    value: List[Optional[AccountJSON]]
    def __init__(
        self, value: Sequence[Optional[AccountJSON]], context: RpcResponseContext
    ) -> None: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> Resp[GetMultipleAccountsJsonParsedResp]: ...
    @staticmethod
    def from_bytes(data: bytes) -> GetMultipleAccountsJsonParsedResp: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class GetMultipleAccountsMaybeJsonParsedResp:
    context: RpcResponseContext
    value: List[Optional[Union[Account, AccountJSON]]]
    def __init__(
        self,
        value: Sequence[Optional[Union[Account, AccountJSON]]],
        context: RpcResponseContext,
    ) -> None: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> Resp[GetMultipleAccountsMaybeJsonParsedResp]: ...
    @staticmethod
    def from_bytes(data: bytes) -> GetMultipleAccountsMaybeJsonParsedResp: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class RpcKeyedAccount:
    pubkey: Pubkey
    account: Account
    def __init__(self, pubkey: Pubkey, account: Account) -> None: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> RpcKeyedAccount: ...
    @staticmethod
    def from_bytes(data: bytes) -> RpcKeyedAccount: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class RpcKeyedAccountJsonParsed:
    pubkey: Pubkey
    account: AccountJSON
    def __init__(self, pubkey: Pubkey, account: AccountJSON) -> None: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> RpcKeyedAccountJsonParsed: ...
    @staticmethod
    def from_bytes(data: bytes) -> RpcKeyedAccountJsonParsed: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class GetProgramAccountsWithContextResp:
    context: RpcResponseContext
    value: List[RpcKeyedAccount]
    def __init__(
        self, value: Sequence[RpcKeyedAccount], context: RpcResponseContext
    ) -> None: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> Resp[GetProgramAccountsWithContextResp]: ...
    @staticmethod
    def from_bytes(data: bytes) -> GetProgramAccountsWithContextResp: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class GetProgramAccountsWithContextJsonParsedResp:
    context: RpcResponseContext
    value: List[RpcKeyedAccountJsonParsed]
    def __init__(
        self, value: Sequence[RpcKeyedAccountJsonParsed], context: RpcResponseContext
    ) -> None: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> Resp[GetProgramAccountsWithContextJsonParsedResp]: ...
    @staticmethod
    def from_bytes(data: bytes) -> GetProgramAccountsWithContextJsonParsedResp: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class GetProgramAccountsResp:
    def __init__(self, value: Sequence[RpcKeyedAccount]) -> None: ...
    @property
    def value(self) -> List[RpcKeyedAccount]: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> Resp[GetProgramAccountsResp]: ...
    @staticmethod
    def from_bytes(data: bytes) -> GetProgramAccountsResp: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class GetProgramAccountsJsonParsedResp:
    def __init__(self, value: Sequence[RpcKeyedAccountJsonParsed]) -> None: ...
    @property
    def value(self) -> List[RpcKeyedAccountJsonParsed]: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> Resp[GetProgramAccountsJsonParsedResp]: ...
    @staticmethod
    def from_bytes(data: bytes) -> GetProgramAccountsJsonParsedResp: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class GetProgramAccountsWithContextMaybeJsonParsedResp:
    context: RpcResponseContext
    value: List[Union[RpcKeyedAccountJsonParsed, RpcKeyedAccount]]
    def __init__(
        self,
        value: Sequence[Union[RpcKeyedAccountJsonParsed, RpcKeyedAccount]],
        context: RpcResponseContext,
    ) -> None: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(
        raw: str,
    ) -> Resp[GetProgramAccountsWithContextMaybeJsonParsedResp]: ...
    @staticmethod
    def from_bytes(data: bytes) -> GetProgramAccountsWithContextMaybeJsonParsedResp: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class GetProgramAccountsMaybeJsonParsedResp:
    def __init__(
        self, value: Sequence[Union[RpcKeyedAccountJsonParsed, RpcKeyedAccount]]
    ) -> None: ...
    @property
    def value(self) -> List[Union[RpcKeyedAccountJsonParsed, RpcKeyedAccount]]: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> Resp[GetProgramAccountsMaybeJsonParsedResp]: ...
    @staticmethod
    def from_bytes(data: bytes) -> GetProgramAccountsMaybeJsonParsedResp: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class RpcPerfSample:
    def __init__(
        self, slot: int, num_transactions: int, num_slots: int, sample_period_secs: int
    ) -> None: ...
    @property
    def slot(self) -> int: ...
    @property
    def num_transactions(self) -> int: ...
    @property
    def num_slots(self) -> int: ...
    @property
    def sample_period_secs(self) -> int: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> RpcPerfSample: ...
    @staticmethod
    def from_bytes(data: bytes) -> RpcPerfSample: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class GetRecentPerformanceSamplesResp:
    def __init__(self, value: Sequence[RpcPerfSample]) -> None: ...
    @property
    def value(self) -> List[RpcPerfSample]: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> Resp[GetRecentPerformanceSamplesResp]: ...
    @staticmethod
    def from_bytes(data: bytes) -> GetRecentPerformanceSamplesResp: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class RpcConfirmedTransactionStatusWithSignature:
    def __init__(
        self,
        signature: Signature,
        slot: int,
        err: Optional[TransactionErrorType] = None,
        memo: Optional[str] = None,
        block_time: Optional[int] = None,
        confirmation_status: Optional[TransactionConfirmationStatus] = None,
    ) -> None: ...
    @property
    def signature(self) -> Signature: ...
    @property
    def slot(self) -> int: ...
    @property
    def err(self) -> Optional[TransactionErrorType]: ...
    @property
    def memo(self) -> Optional[str]: ...
    @property
    def block_time(self) -> Optional[int]: ...
    @property
    def confirmation_status(self) -> Optional[TransactionConfirmationStatus]: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> RpcConfirmedTransactionStatusWithSignature: ...
    @staticmethod
    def from_bytes(data: bytes) -> RpcConfirmedTransactionStatusWithSignature: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class GetSignaturesForAddressResp:
    def __init__(
        self, value: Sequence[RpcConfirmedTransactionStatusWithSignature]
    ) -> None: ...
    @property
    def value(self) -> List[RpcConfirmedTransactionStatusWithSignature]: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> Resp[GetSignaturesForAddressResp]: ...
    @staticmethod
    def from_bytes(data: bytes) -> GetSignaturesForAddressResp: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class GetSignatureStatusesResp:
    context: RpcResponseContext
    value: List[Optional[TransactionStatus]]
    def __init__(
        self, value: Sequence[Optional[TransactionStatus]], context: RpcResponseContext
    ) -> None: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> Resp[GetSignatureStatusesResp]: ...
    @staticmethod
    def from_bytes(data: bytes) -> GetSignatureStatusesResp: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class GetSlotResp:
    def __init__(self, value: int) -> None: ...
    @property
    def value(self) -> int: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> Resp[GetSlotResp]: ...
    @staticmethod
    def from_bytes(data: bytes) -> GetSlotResp: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class GetSlotLeaderResp:
    def __init__(self, value: Pubkey) -> None: ...
    @property
    def value(self) -> Pubkey: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> Resp[GetSlotLeaderResp]: ...
    @staticmethod
    def from_bytes(data: bytes) -> GetSlotLeaderResp: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class GetSlotLeadersResp:
    def __init__(self, value: Sequence[Pubkey]) -> None: ...
    @property
    def value(self) -> List[Pubkey]: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> Resp[GetSlotLeadersResp]: ...
    @staticmethod
    def from_bytes(data: bytes) -> GetSlotLeadersResp: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class StakeActivationState:
    Activating: "StakeActivationState"
    Active: "StakeActivationState"
    Deactivating: "StakeActivationState"
    Inactive: "StakeActivationState"
    def __int__(self) -> int: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...

class RpcStakeActivation:
    def __init__(
        self, state: StakeActivationState, active: int, inactive: int
    ) -> None: ...
    @property
    def state(self) -> StakeActivationState: ...
    @property
    def active(self) -> int: ...
    @property
    def inactive(self) -> int: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> RpcStakeActivation: ...
    @staticmethod
    def from_bytes(data: bytes) -> RpcStakeActivation: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class GetStakeActivationResp:
    def __init__(self, value: RpcStakeActivation) -> None: ...
    @property
    def value(self) -> RpcStakeActivation: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> Resp[GetStakeActivationResp]: ...
    @staticmethod
    def from_bytes(data: bytes) -> GetStakeActivationResp: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class RpcSupply:
    def __init__(
        self,
        total: int,
        circulating: int,
        non_circulating: int,
        non_circulating_accounts: Sequence[Pubkey],
    ) -> None: ...
    @property
    def total(self) -> int: ...
    @property
    def circulating(self) -> int: ...
    @property
    def non_circulating(self) -> int: ...
    @property
    def non_circulating_accounts(self) -> Sequence[Pubkey]: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> RpcSupply: ...
    @staticmethod
    def from_bytes(data: bytes) -> RpcSupply: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class GetSupplyResp:
    context: RpcResponseContext
    value: RpcSupply
    def __init__(
        self, value: Sequence[Optional[TransactionStatus]], context: RpcResponseContext
    ) -> None: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> Resp[GetSupplyResp]: ...
    @staticmethod
    def from_bytes(data: bytes) -> GetSupplyResp: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class GetTokenAccountBalanceResp:
    context: RpcResponseContext
    value: UiTokenAmount
    def __init__(self, value: UiTokenAmount, context: RpcResponseContext) -> None: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> Resp[GetTokenAccountBalanceResp]: ...
    @staticmethod
    def from_bytes(data: bytes) -> GetTokenAccountBalanceResp: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class GetTokenAccountsByDelegateResp:
    context: RpcResponseContext
    value: List[RpcKeyedAccount]
    def __init__(
        self, value: Sequence[RpcKeyedAccount], context: RpcResponseContext
    ) -> None: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> Resp[GetTokenAccountsByDelegateResp]: ...
    @staticmethod
    def from_bytes(data: bytes) -> GetTokenAccountsByDelegateResp: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class GetTokenAccountsByDelegateJsonParsedResp:
    context: RpcResponseContext
    value: List[RpcKeyedAccountJsonParsed]
    def __init__(
        self, value: Sequence[RpcKeyedAccountJsonParsed], context: RpcResponseContext
    ) -> None: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> Resp[GetTokenAccountsByDelegateJsonParsedResp]: ...
    @staticmethod
    def from_bytes(data: bytes) -> GetTokenAccountsByDelegateJsonParsedResp: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class GetTokenAccountsByOwnerResp:
    context: RpcResponseContext
    value: List[RpcKeyedAccount]
    def __init__(
        self, value: Sequence[RpcKeyedAccount], context: RpcResponseContext
    ) -> None: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> Resp[GetTokenAccountsByOwnerResp]: ...
    @staticmethod
    def from_bytes(data: bytes) -> GetTokenAccountsByOwnerResp: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class GetTokenAccountsByOwnerJsonParsedResp:
    context: RpcResponseContext
    value: List[RpcKeyedAccountJsonParsed]
    def __init__(
        self, value: Sequence[RpcKeyedAccountJsonParsed], context: RpcResponseContext
    ) -> None: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> Resp[GetTokenAccountsByOwnerJsonParsedResp]: ...
    @staticmethod
    def from_bytes(data: bytes) -> GetTokenAccountsByOwnerJsonParsedResp: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class RpcTokenAccountBalance:
    def __init__(self, address: Pubkey, amount: UiTokenAmount) -> None: ...
    @property
    def address(self) -> Pubkey: ...
    @property
    def amount(self) -> UiTokenAmount: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> RpcTokenAccountBalance: ...
    @staticmethod
    def from_bytes(data: bytes) -> RpcTokenAccountBalance: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class GetTokenLargestAccountsResp:
    context: RpcResponseContext
    value: List[RpcTokenAccountBalance]
    def __init__(
        self, value: Sequence[RpcTokenAccountBalance], context: RpcResponseContext
    ) -> None: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> Resp[GetTokenLargestAccountsResp]: ...
    @staticmethod
    def from_bytes(data: bytes) -> GetTokenLargestAccountsResp: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class GetTokenSupplyResp:
    context: RpcResponseContext
    value: UiTokenAmount
    def __init__(self, value: UiTokenAmount, context: RpcResponseContext) -> None: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> Resp[GetTokenSupplyResp]: ...
    @staticmethod
    def from_bytes(data: bytes) -> GetTokenSupplyResp: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class GetTransactionResp:
    def __init__(
        self, value: Optional[EncodedConfirmedTransactionWithStatusMeta]
    ) -> None: ...
    @property
    def value(self) -> Optional[EncodedConfirmedTransactionWithStatusMeta]: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> Resp[GetTransactionResp]: ...
    @staticmethod
    def from_bytes(data: bytes) -> GetTransactionResp: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class GetTransactionCountResp:
    def __init__(self, value: int) -> None: ...
    @property
    def value(self) -> int: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> Resp[GetTransactionCountResp]: ...
    @staticmethod
    def from_bytes(data: bytes) -> GetTransactionCountResp: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class RpcVersionInfo:
    def __init__(self, solana_core: str, feature_set: Optional[int] = None) -> None: ...
    @property
    def solana_core(self) -> str: ...
    @property
    def feature_set(self) -> Optional[int]: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> RpcVersionInfo: ...
    @staticmethod
    def from_bytes(data: bytes) -> RpcVersionInfo: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class GetVersionResp:
    def __init__(self, value: RpcVersionInfo) -> None: ...
    @property
    def value(self) -> RpcVersionInfo: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> Resp[GetVersionResp]: ...
    @staticmethod
    def from_bytes(data: bytes) -> GetVersionResp: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class RpcVoteAccountInfo:
    def __init__(
        self,
        vote_pubkey: Pubkey,
        node_pubkey: Pubkey,
        activated_stake: int,
        commission: int,
        epoch_vote_account: bool,
        epoch_credits: Sequence[Tuple[int, int, int]],
        last_vote: int,
        root_slot: int,
    ) -> None: ...
    @property
    def vote_pubkey(self) -> Pubkey: ...
    @property
    def node_pubkey(self) -> Pubkey: ...
    @property
    def activated_stake(self) -> int: ...
    @property
    def commission(self) -> int: ...
    @property
    def epoch_vote_account(self) -> bool: ...
    @property
    def epoch_credits(self) -> List[Tuple[int, int, int]]: ...
    @property
    def last_vote(self) -> int: ...
    @property
    def root_slot(self) -> int: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> RpcVersionInfo: ...
    @staticmethod
    def from_bytes(data: bytes) -> RpcVersionInfo: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class RpcVoteAccountStatus:
    def __init__(
        self,
        current: Sequence[RpcVoteAccountInfo],
        delinquent: Sequence[RpcVoteAccountInfo],
    ) -> None: ...
    @property
    def current(self) -> List[RpcVoteAccountInfo]: ...
    @property
    def delinquent(self) -> List[RpcVoteAccountInfo]: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> RpcVersionInfo: ...
    @staticmethod
    def from_bytes(data: bytes) -> RpcVersionInfo: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class GetVoteAccountsResp:
    def __init__(self, value: RpcVoteAccountStatus) -> None: ...
    @property
    def value(self) -> RpcVoteAccountStatus: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> Resp[GetVoteAccountsResp]: ...
    @staticmethod
    def from_bytes(data: bytes) -> GetVoteAccountsResp: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class IsBlockhashValidResp:
    context: RpcResponseContext
    value: bool
    def __init__(self, value: bool) -> None: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> Resp[IsBlockhashValidResp]: ...
    @staticmethod
    def from_bytes(data: bytes) -> IsBlockhashValidResp: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class MinimumLedgerSlotResp:
    def __init__(self, value: int) -> None: ...
    @property
    def value(self) -> int: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> Resp[MinimumLedgerSlotResp]: ...
    @staticmethod
    def from_bytes(data: bytes) -> MinimumLedgerSlotResp: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class RequestAirdropResp:
    def __init__(self, value: Signature) -> None: ...
    @property
    def value(self) -> Signature: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> Resp[RequestAirdropResp]: ...
    @staticmethod
    def from_bytes(data: bytes) -> RequestAirdropResp: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class ValidatorExitResp:
    def __init__(self, value: bool) -> None: ...
    @property
    def value(self) -> bool: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> Resp[ValidatorExitResp]: ...
    @staticmethod
    def from_bytes(data: bytes) -> ValidatorExitResp: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class SendTransactionResp:
    def __init__(self, value: Signature) -> None: ...
    @property
    def value(self) -> Signature: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> Resp[SendTransactionResp]: ...
    @staticmethod
    def from_bytes(data: bytes) -> SendTransactionResp: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class SimulateTransactionResp:
    context: RpcResponseContext
    value: RpcSimulateTransactionResult
    def __init__(self, value: RpcSimulateTransactionResult) -> None: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> Resp[SimulateTransactionResp]: ...
    @staticmethod
    def from_bytes(data: bytes) -> SimulateTransactionResp: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class RpcLogsResponse:
    def __init__(
        self,
        signature: Signature,
        err: Optional[TransactionErrorType],
        logs: Sequence[str],
    ) -> None: ...
    @property
    def signature(self) -> Signature: ...
    @property
    def err(self) -> Optional[TransactionErrorType]: ...
    @property
    def logs(self) -> List[str]: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> RpcLogsResponse: ...
    @staticmethod
    def from_bytes(data: bytes) -> RpcLogsResponse: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class RpcVote:
    def __init__(
        self,
        vote_pubkey: Pubkey,
        slots: Sequence[int],
        hash: Hash,
        timestamp: Optional[int],
        signature: Signature,
    ) -> None: ...
    @property
    def vote_pubkey(self) -> Pubkey: ...
    @property
    def slots(self) -> List[int]: ...
    @property
    def hash(self) -> Hash: ...
    @property
    def timestamp(self) -> Optional[int]: ...
    @property
    def signature(self) -> Signature: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> RpcVote: ...
    @staticmethod
    def from_bytes(data: bytes) -> RpcVote: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class SlotTransactionStats:
    def __init__(
        self,
        num_transaction_entries: int,
        num_successful_transactions: int,
        num_failed_transactions: int,
        max_transactions_per_entry: int,
    ) -> None: ...
    @property
    def num_transaction_entries(self) -> int: ...
    @property
    def num_successful_transactions(self) -> int: ...
    @property
    def num_failed_transactions(self) -> int: ...
    @property
    def max_transactions_per_entry(self) -> int: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> SlotTransactionStats: ...
    @staticmethod
    def from_bytes(data: bytes) -> SlotTransactionStats: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class SlotUpdateFirstShredReceived:
    slot: int
    timestamp: int
    def __init__(
        self,
        slot: int,
        timestamp: int,
    ) -> None: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> SlotUpdateFirstShredReceived: ...
    @staticmethod
    def from_bytes(data: bytes) -> SlotUpdateFirstShredReceived: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class SlotUpdateCompleted:
    slot: int
    timestamp: int
    def __init__(
        self,
        slot: int,
        timestamp: int,
    ) -> None: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> SlotUpdateCompleted: ...
    @staticmethod
    def from_bytes(data: bytes) -> SlotUpdateCompleted: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class SlotUpdateCreatedBank:
    slot: int
    timestamp: int
    parent: int
    def __init__(
        self,
        slot: int,
        timestamp: int,
        parent: int,
    ) -> None: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> SlotUpdateCreatedBank: ...
    @staticmethod
    def from_bytes(data: bytes) -> SlotUpdateCreatedBank: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class SlotUpdateDead:
    slot: int
    timestamp: int
    err: str
    def __init__(
        self,
        slot: int,
        timestamp: int,
    ) -> None: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> SlotUpdateDead: ...
    @staticmethod
    def from_bytes(data: bytes) -> SlotUpdateDead: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class SlotUpdateOptimisticConfirmation:
    slot: int
    timestamp: int
    def __init__(
        self,
        slot: int,
        timestamp: int,
    ) -> None: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> SlotUpdateOptimisticConfirmation: ...
    @staticmethod
    def from_bytes(data: bytes) -> SlotUpdateOptimisticConfirmation: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class SlotUpdateRoot:
    slot: int
    timestamp: int
    def __init__(
        self,
        slot: int,
        timestamp: int,
    ) -> None: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> SlotUpdateRoot: ...
    @staticmethod
    def from_bytes(data: bytes) -> SlotUpdateRoot: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class SlotUpdateFrozen:
    slot: int
    timestamp: int
    stats: SlotTransactionStats
    def __init__(
        self,
        slot: int,
        timestamp: int,
    ) -> None: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> SlotUpdateFrozen: ...
    @staticmethod
    def from_bytes(data: bytes) -> SlotUpdateFrozen: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class AccountNotificationResult:
    context: RpcResponseContext
    value: Account
    def __init__(self, value: Account, context: RpcResponseContext) -> None: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> AccountNotificationResult: ...
    @staticmethod
    def from_bytes(data: bytes) -> AccountNotificationResult: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class AccountNotification:
    result: AccountNotificationResult
    subscription: int
    def __init__(
        self, result: AccountNotificationResult, subscription: int
    ) -> None: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> AccountNotification: ...
    @staticmethod
    def from_bytes(data: bytes) -> AccountNotification: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class AccountNotificationJsonParsedResult:
    context: RpcResponseContext
    value: AccountJSON
    def __init__(self, value: AccountJSON, context: RpcResponseContext) -> None: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> AccountNotificationJsonParsedResult: ...
    @staticmethod
    def from_bytes(data: bytes) -> AccountNotificationJsonParsedResult: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class AccountNotificationJsonParsed:
    result: AccountNotificationJsonParsedResult
    subscription: int
    def __init__(
        self, result: AccountNotificationJsonParsedResult, subscription: int
    ) -> None: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> AccountNotificationJsonParsed: ...
    @staticmethod
    def from_bytes(data: bytes) -> AccountNotificationJsonParsed: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class BlockNotificationResult:
    context: RpcResponseContext
    value: RpcBlockUpdate
    def __init__(self, value: RpcBlockUpdate, context: RpcResponseContext) -> None: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> BlockNotificationResult: ...
    @staticmethod
    def from_bytes(data: bytes) -> BlockNotificationResult: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class BlockNotification:
    result: BlockNotificationResult
    subscription: int
    def __init__(self, result: BlockNotificationResult, subscription: int) -> None: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> BlockNotification: ...
    @staticmethod
    def from_bytes(data: bytes) -> BlockNotification: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class LogsNotificationResult:
    context: RpcResponseContext
    value: RpcLogsResponse
    def __init__(self, value: RpcLogsResponse, context: RpcResponseContext) -> None: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> LogsNotificationResult: ...
    @staticmethod
    def from_bytes(data: bytes) -> LogsNotificationResult: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class LogsNotification:
    result: LogsNotificationResult
    subscription: int
    def __init__(self, result: LogsNotificationResult, subscription: int) -> None: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> LogsNotification: ...
    @staticmethod
    def from_bytes(data: bytes) -> LogsNotification: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class ProgramNotificationResult:
    context: RpcResponseContext
    value: RpcKeyedAccount
    def __init__(self, value: RpcKeyedAccount, context: RpcResponseContext) -> None: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> ProgramNotificationResult: ...
    @staticmethod
    def from_bytes(data: bytes) -> ProgramNotificationResult: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class ProgramNotification:
    result: ProgramNotificationResult
    subscription: int
    def __init__(
        self, result: ProgramNotificationResult, subscription: int
    ) -> None: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> ProgramNotification: ...
    @staticmethod
    def from_bytes(data: bytes) -> ProgramNotification: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class ProgramNotificationJsonParsedResult:
    context: RpcResponseContext
    value: RpcKeyedAccountJsonParsed
    def __init__(
        self, value: RpcKeyedAccountJsonParsed, context: RpcResponseContext
    ) -> None: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> ProgramNotificationJsonParsedResult: ...
    @staticmethod
    def from_bytes(data: bytes) -> ProgramNotificationJsonParsedResult: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class ProgramNotificationJsonParsed:
    result: ProgramNotificationJsonParsedResult
    subscription: int
    def __init__(
        self, result: ProgramNotificationJsonParsedResult, subscription: int
    ) -> None: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> ProgramNotificationJsonParsed: ...
    @staticmethod
    def from_bytes(data: bytes) -> ProgramNotificationJsonParsed: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class RpcSignatureResponse:
    err: Optional[TransactionErrorType]
    def __init__(
        self,
        err: Optional[TransactionErrorType] = None,
    ) -> None: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> RpcSignatureResponse: ...
    @staticmethod
    def from_bytes(data: bytes) -> RpcSignatureResponse: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class SignatureNotificationResult:
    context: RpcResponseContext
    value: RpcSignatureResponse
    def __init__(
        self, value: RpcSignatureResponse, context: RpcResponseContext
    ) -> None: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> SignatureNotificationResult: ...
    @staticmethod
    def from_bytes(data: bytes) -> SignatureNotificationResult: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class SignatureNotification:
    result: SignatureNotificationResult
    subscription: int
    def __init__(
        self, result: SignatureNotificationResult, subscription: int
    ) -> None: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> SignatureNotification: ...
    @staticmethod
    def from_bytes(data: bytes) -> SignatureNotification: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class SlotInfo:
    def __init__(self, slot: int, parent: int, root: int) -> None: ...
    @property
    def slot(self) -> int: ...
    @property
    def parent(self) -> int: ...
    @property
    def root(self) -> int: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> SlotInfo: ...
    @staticmethod
    def from_bytes(data: bytes) -> SlotInfo: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class SlotNotification:
    result: SlotInfo
    subscription: int
    def __init__(self, result: SlotInfo, subscription: int) -> None: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> SlotInfo: ...
    @staticmethod
    def from_bytes(data: bytes) -> SlotInfo: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class SlotUpdateNotification:
    result: SlotUpdate
    subscription: int
    def __init__(self, result: SlotUpdate, subscription: int) -> None: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> SlotUpdateNotification: ...
    @staticmethod
    def from_bytes(data: bytes) -> SlotUpdateNotification: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class RootNotification:
    result: int
    subscription: int
    def __init__(self, result: int, subscription: int) -> None: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> RootNotification: ...
    @staticmethod
    def from_bytes(data: bytes) -> RootNotification: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class VoteNotification:
    result: RpcVote
    subscription: int
    def __init__(self, result: RpcVote, subscription: int) -> None: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> VoteNotification: ...
    @staticmethod
    def from_bytes(data: bytes) -> VoteNotification: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

Notification = Union[
    AccountNotification,
    AccountNotificationJsonParsed,
    BlockNotification,
    LogsNotification,
    ProgramNotification,
    ProgramNotificationJsonParsed,
    SignatureNotification,
    SlotNotification,
    SlotUpdateNotification,
    RootNotification,
    VoteNotification,
]

class SubscriptionResult:
    id: int
    result: int
    def __init__(
        self,
        id: int,
        result: int,
    ) -> None: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> SubscriptionResult: ...
    @staticmethod
    def from_bytes(data: bytes) -> SubscriptionResult: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class SubscriptionError:
    id: int
    error: RPCError
    def __init__(
        self,
        id: int,
        error: RPCError,
    ) -> None: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> SubscriptionError: ...
    @staticmethod
    def from_bytes(data: bytes) -> SubscriptionError: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

WebsocketMessage = Union[Notification, SubscriptionResult, SubscriptionError]

class BlockStoreError:
    BlockStoreError: "BlockStoreError"
    def __int__(self) -> int: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...

RpcBlockUpdateError = Union[UnsupportedTransactionVersion, BlockStoreError]

class RpcBlockUpdate:
    def __init__(
        self,
        slot: int,
        block: Optional[UiConfirmedBlock] = None,
        err: Optional[RpcBlockUpdateError] = None,
    ) -> None: ...
    @property
    def slot(self) -> int: ...
    @property
    def block(self) -> Optional[UiConfirmedBlock]: ...
    @property
    def err(self) -> Optional[RpcBlockUpdateError]: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> RpcVote: ...
    @staticmethod
    def from_bytes(data: bytes) -> RpcVote: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

SlotUpdate = Union[
    SlotUpdateFirstShredReceived,
    SlotUpdateCompleted,
    SlotUpdateCreatedBank,
    SlotUpdateDead,
    SlotUpdateOptimisticConfirmation,
    SlotUpdateRoot,
    SlotUpdateFrozen,
]

RPCResult = Union[
    RPCError,
    GetAccountInfoResp,
    GetAccountInfoJsonParsedResp,
    GetAccountInfoMaybeJsonParsedResp,
    GetBalanceResp,
    GetBlockProductionResp,
    GetBlockResp,
    GetBlockCommitmentResp,
    GetBlockHeightResp,
    GetBlocksResp,
    GetBlocksWithLimitResp,
    GetBlockTimeResp,
    GetClusterNodesResp,
    GetEpochInfoResp,
    GetEpochScheduleResp,
    GetFeeForMessageResp,
    GetFirstAvailableBlockResp,
    GetGenesisHashResp,
    GetHealthResp,
    GetHighestSnapshotSlotResp,
    GetIdentityResp,
    GetInflationGovernorResp,
    GetInflationRateResp,
    GetInflationRewardResp,
    GetLargestAccountsResp,
    GetLatestBlockhashResp,
    GetLeaderScheduleResp,
    GetMaxRetransmitSlotResp,
    GetMaxShredInsertSlotResp,
    GetMinimumBalanceForRentExemptionResp,
    GetMultipleAccountsResp,
    GetMultipleAccountsJsonParsedResp,
    GetMultipleAccountsMaybeJsonParsedResp,
    GetProgramAccountsWithContextResp,
    GetProgramAccountsResp,
    GetProgramAccountsWithContextJsonParsedResp,
    GetProgramAccountsJsonParsedResp,
    GetProgramAccountsMaybeJsonParsedResp,
    GetProgramAccountsWithContextMaybeJsonParsedResp,
    GetRecentPerformanceSamplesResp,
    GetSignaturesForAddressResp,
    GetSignatureStatusesResp,
    GetSlotResp,
    GetSlotLeaderResp,
    GetSlotLeadersResp,
    GetStakeActivationResp,
    GetSupplyResp,
    GetTokenAccountBalanceResp,
    GetTokenAccountsByDelegateResp,
    GetTokenAccountsByDelegateJsonParsedResp,
    GetTokenAccountsByOwnerResp,
    GetTokenAccountsByOwnerJsonParsedResp,
    GetTokenLargestAccountsResp,
    GetTokenSupplyResp,
    GetTransactionResp,
    GetTransactionCountResp,
    GetVersionResp,
    RpcVersionInfo,
    GetVoteAccountsResp,
    IsBlockhashValidResp,
    MinimumLedgerSlotResp,
    RequestAirdropResp,
    SendTransactionResp,
    SimulateTransactionResp,
]

def batch_to_json(resps: Sequence[RPCResult]) -> str: ...
def batch_from_json(raw: str, parsers: Sequence[Any]) -> List[RPCResult]: ...
def parse_notification(raw: str) -> Notification: ...
def parse_websocket_message(raw: str) -> List[WebsocketMessage]: ...
