# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import json
import warnings
import pulumi
import pulumi.runtime
from typing import Union
from . import utilities, tables

class Domain(pulumi.CustomResource):
    ip_address: pulumi.Output[str]
    """
    The IP address of the domain. If specified, this IP
    is used to created an initial A record for the domain.
    """
    name: pulumi.Output[str]
    """
    The name of the domain
    """
    urn: pulumi.Output[str]
    """
    The uniform resource name of the domain
    """
    def __init__(__self__, resource_name, opts=None, ip_address=None, name=None, __props__=None, __name__=None, __opts__=None):
        """
        Provides a DigitalOcean domain resource.

        ## Example Usage



        ```python
        import pulumi
        import pulumi_digitalocean as digitalocean

        # Create a new domain
        default = digitalocean.Domain("default",
            name="example.com",
            ip_address=digitalocean_droplet["foo"]["ipv4_address"])
        ```


        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] ip_address: The IP address of the domain. If specified, this IP
               is used to created an initial A record for the domain.
        :param pulumi.Input[str] name: The name of the domain
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['ip_address'] = ip_address
            if name is None:
                raise TypeError("Missing required property 'name'")
            __props__['name'] = name
            __props__['urn'] = None
        super(Domain, __self__).__init__(
            'digitalocean:index/domain:Domain',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name, id, opts=None, ip_address=None, name=None, urn=None):
        """
        Get an existing Domain resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param str id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] ip_address: The IP address of the domain. If specified, this IP
               is used to created an initial A record for the domain.
        :param pulumi.Input[str] name: The name of the domain
        :param pulumi.Input[str] urn: The uniform resource name of the domain
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["ip_address"] = ip_address
        __props__["name"] = name
        __props__["urn"] = urn
        return Domain(resource_name, opts=opts, __props__=__props__)
    def translate_output_property(self, prop):
        return tables._CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return tables._SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

