# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['samsung_mdc_ctl', 'samsung_mdc_ctl.helpers', 'samsung_mdc_ctl.protocol']

package_data = \
{'': ['*']}

install_requires = \
['rich>=9.8.2,<10.0.0', 'typer[all]>=0.3.2,<0.4.0']

extras_require = \
{':python_version < "3.8"': ['importlib_metadata>=3.7.3,<4.0.0']}

entry_points = \
{'console_scripts': ['samsung-mdc-ctl = samsung_mdc_ctl.__main__:app']}

setup_kwargs = {
    'name': 'samsung-mdc-ctl',
    'version': '0.1.0',
    'description': 'Awesome `samsung-mdc-ctl` is a Python cli/package created with https://github.com/TezRomacH/python-package-template',
    'long_description': '# samsung-mdc-ctl\n\n<div align="center">\n\n[![Build status](https://github.com/matthijs2704/samsung-mdc-ctl/workflows/build/badge.svg?branch=main&event=push)](https://github.com/matthijs2704/samsung-mdc-ctl/actions?query=workflow%3Abuild)\n[![Python Version](https://img.shields.io/pypi/pyversions/samsung-mdc-ctl.svg)](https://pypi.org/project/samsung-mdc-ctl/)\n[![Dependencies Status](https://img.shields.io/badge/dependencies-up%20to%20date-brightgreen.svg)](https://github.com/matthijs2704/samsung-mdc-ctl/pulls?utf8=%E2%9C%93&q=is%3Apr%20author%3Aapp%2Fdependabot)\n\n[![Code style: black](https://img.shields.io/badge/code%20style-black-000000.svg)](https://github.com/psf/black)\n[![Security: bandit](https://img.shields.io/badge/security-bandit-green.svg)](https://github.com/PyCQA/bandit)\n[![Pre-commit](https://img.shields.io/badge/pre--commit-enabled-brightgreen?logo=pre-commit&logoColor=white)](https://github.com/matthijs2704/samsung-mdc-ctl/blob/main/.pre-commit-config.yaml)\n[![Semantic Versions](https://img.shields.io/badge/%F0%9F%9A%80-semantic%20versions-informational.svg)](https://github.com/matthijs2704/samsung-mdc-ctl/releases)\n[![License](https://img.shields.io/github/license/matthijs2704/samsung-mdc-ctl)](https://github.com/matthijs2704/samsung-mdc-ctl/blob/main/LICENSE)\n\nClean and full(ler)-featured Python package for controlling Samsung Displays using the Multiple Display Control (MDC) Protocol over IP.\n\n### :rotating_light: Work-In-Progress, breaking changes will happen :rotating_light:\n\n</div>\n\n## Installation\n\n```bash\npip install -U samsung-mdc-ctl\n```\n\nor install with `Poetry`\n\n```bash\npoetry add samsung-mdc-ctl\n```\n\nThen you can run\n\n```bash\nsamsung-mdc-ctl --help\n```\n\n```bash\nsamsung-mdc-ctl --name Roman\n```\n\nor if installed with `Poetry`:\n\n```bash\npoetry run samsung-mdc-ctl --help\n```\n\n```bash\npoetry run samsung-mdc-ctl --name Roman\n```\n\n### Makefile usage\n\n[`Makefile`](https://github.com/matthijs2704/samsung-mdc-ctl/blob/main/Makefile) contains many functions for fast assembling and convenient work.\n\n<details>\n<summary>1. Download Poetry</summary>\n<p>\n\n```bash\nmake download-poetry\n```\n\n</p>\n</details>\n\n<details>\n<summary>2. Install all dependencies and pre-commit hooks</summary>\n<p>\n\n```bash\nmake install\n```\n\nIf you do not want to install pre-commit hooks, run the command with the NO_PRE_COMMIT flag:\n\n```bash\nmake install NO_PRE_COMMIT=1\n```\n\n</p>\n</details>\n\n<details>\n<summary>3. Check the security of your code</summary>\n<p>\n\n```bash\nmake check-safety\n```\n\nThis command launches a `Poetry` and `Pip` integrity check as well as identifies security issues with `Safety` and `Bandit`. By default, the build will not crash if any of the items fail. But you can set `STRICT=1` for the entire build, or you can configure strictness for each item separately.\n\n```bash\nmake check-safety STRICT=1\n```\n\nor only for `safety`:\n\n```bash\nmake check-safety SAFETY_STRICT=1\n```\n\nmultiple\n\n```bash\nmake check-safety PIP_STRICT=1 SAFETY_STRICT=1\n```\n\n> List of flags for `check-safety` (can be set to `1` or `0`): `STRICT`, `POETRY_STRICT`, `PIP_STRICT`, `SAFETY_STRICT`, `BANDIT_STRICT`.\n\n</p>\n</details>\n\n<details>\n<summary>4. Check the codestyle</summary>\n<p>\n\nThe command is similar to `check-safety` but to check the code style, obviously. It uses `Black`, `Darglint`, `Isort`, and `Mypy` inside.\n\n```bash\nmake check-style\n```\n\nIt may also contain the `STRICT` flag.\n\n```bash\nmake check-style STRICT=1\n```\n\n> List of flags for `check-style` (can be set to `1` or `0`): `STRICT`, `BLACK_STRICT`, `DARGLINT_STRICT`, `ISORT_STRICT`, `MYPY_STRICT`.\n\n</p>\n</details>\n\n<details>\n<summary>5. Run all the codestyle formaters</summary>\n<p>\n\nCodestyle uses `pre-commit` hooks, so ensure you\'ve run `make install` before.\n\n```bash\nmake codestyle\n```\n\n</p>\n</details>\n\n<details>\n<summary>6. Run tests</summary>\n<p>\n\n```bash\nmake test\n```\n\n</p>\n</details>\n\n<details>\n<summary>7. Run all the linters</summary>\n<p>\n\n```bash\nmake lint\n```\n\nthe same as:\n\n```bash\nmake test && make check-safety && make check-style\n```\n\n> List of flags for `lint` (can be set to `1` or `0`): `STRICT`, `POETRY_STRICT`, `PIP_STRICT`, `SAFETY_STRICT`, `BANDIT_STRICT`, `BLACK_STRICT`, `DARGLINT_STRICT`, `ISORT_STRICT`, `MYPY_STRICT`.\n\n</p>\n</details>\n\n<details>\n<summary>8. Build docker</summary>\n<p>\n\n```bash\nmake docker\n```\n\nwhich is equivalent to:\n\n```bash\nmake docker VERSION=latest\n```\n\nMore information [here](https://github.com/matthijs2704/samsung-mdc-ctl/tree/main/docker).\n\n</p>\n</details>\n\n<details>\n<summary>9. Cleanup docker</summary>\n<p>\n\n```bash\nmake clean_docker\n```\n\nor to remove all build\n\n```bash\nmake clean\n```\n\nMore information [here](https://github.com/matthijs2704/samsung-mdc-ctl/tree/main/docker).\n\n</p>\n</details>\n\n## 📈 Releases\n\nYou can see the list of available releases on the [GitHub Releases](https://github.com/matthijs2704/samsung-mdc-ctl/releases) page.\n\nWe follow [Semantic Versions](https://semver.org/) specification.\n\nWe use [`Release Drafter`](https://github.com/marketplace/actions/release-drafter). As pull requests are merged, a draft release is kept up-to-date listing the changes, ready to publish when you’re ready. With the categories option, you can categorize pull requests in release notes using labels.\n\nFor Pull Request this labels are configured, by default:\n\n|               **Label**               |  **Title in Releases**  |\n| :-----------------------------------: | :---------------------: |\n|       `enhancement`, `feature`        |       🚀 Features       |\n| `bug`, `refactoring`, `bugfix`, `fix` | 🔧 Fixes & Refactoring  |\n|       `build`, `ci`, `testing`        | 📦 Build System & CI/CD |\n|              `breaking`               |   💥 Breaking Changes   |\n|            `documentation`            |    📝 Documentation     |\n|            `dependencies`             | ⬆️ Dependencies updates |\n\nYou can update it in [`release-drafter.yml`](https://github.com/matthijs2704/samsung-mdc-ctl/blob/main/.github/release-drafter.yml).\n\nGitHub creates the `bug`, `enhancement`, and `documentation` labels for you. Dependabot creates the `dependencies` label. Create the remaining labels on the Issues tab of your GitHub repository, when you need them.\n\n## 🛡 License\n\n[![License](https://img.shields.io/github/license/matthijs2704/samsung-mdc-ctl)](https://github.com/matthijs2704/samsung-mdc-ctl/blob/main/LICENSE)\n\nThis project is licensed under the terms of the `MIT` license. See [LICENSE](https://github.com/matthijs2704/samsung-mdc-ctl/blob/main/LICENSE) for more details.\n\n## 📃 Citation\n\n```\n@misc{samsung-mdc-ctl,\n  author = {matthijs2704},\n  title = {Awesome `samsung-mdc-ctl` is a Python cli/package created with https://github.com/TezRomacH/python-package-template},\n  year = {2021},\n  publisher = {GitHub},\n  journal = {GitHub repository},\n  howpublished = {\\url{https://github.com/matthijs2704/samsung-mdc-ctl}}\n}\n```\n\n## Credits\n\nThis project was generated with [`python-package-template`](https://github.com/TezRomacH/python-package-template).\n',
    'author': 'matthijs2704',
    'author_email': 'matthijs@logemann.dev',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/matthijs2704/samsung-mdc-ctl',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'extras_require': extras_require,
    'entry_points': entry_points,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
