#!/usr/bin/env python

"""The setup script."""

from setuptools import setup, find_packages

with open("README.rst") as readme_file:
    readme = readme_file.read()

with open("HISTORY.rst") as history_file:
    history = history_file.read()

requirements = ["python-decouple", "xmltodict", "pydantic", "respx", "httpx"]

test_requirements = ["pytest>=3"]

setup(
    author="Hosni Dahmani",
    author_email="hosni@hellotanit.com",
    python_requires=">=3.6",
    classifiers=[
        "Development Status :: 2 - Pre-Alpha",
        "Intended Audience :: Developers",
        "License :: OSI Approved :: MIT License",
        "Natural Language :: English",
        "Programming Language :: Python :: 3",
        "Programming Language :: Python :: 3.6",
        "Programming Language :: Python :: 3.7",
        "Programming Language :: Python :: 3.8",
    ],
    description="API client for onlineafspraken.nl",
    install_requires=requirements,
    license="MIT license",
    long_description=readme + "\n\n" + history,
    include_package_data=True,
    keywords="onlineafspraken",
    name="onlineafspraken",
    packages=find_packages(include=["onlineafspraken", "onlineafspraken.*"]),
    test_suite="tests",
    tests_require=test_requirements,
    url="https://github.com/HosniD/onlineafspraken",
    version="0.2.1",
    zip_safe=False,
)
