import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGitlabProjectMilestonesConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/d/project_milestones#id DataGitlabProjectMilestones#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Return only the milestones having the given `iid` (Note: ignored if `include_parent_milestones` is set as `true`).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/d/project_milestones#iids DataGitlabProjectMilestones#iids}
    */
    readonly iids?: number[];
    /**
    * Include group milestones from parent group and its ancestors. Introduced in GitLab 13.4.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/d/project_milestones#include_parent_milestones DataGitlabProjectMilestones#include_parent_milestones}
    */
    readonly includeParentMilestones?: boolean | cdktf.IResolvable;
    /**
    * The ID or URL-encoded path of the project owned by the authenticated user.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/d/project_milestones#project DataGitlabProjectMilestones#project}
    */
    readonly project: string;
    /**
    * Return only milestones with a title or description matching the provided string.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/d/project_milestones#search DataGitlabProjectMilestones#search}
    */
    readonly search?: string;
    /**
    * Return only `active` or `closed` milestones.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/d/project_milestones#state DataGitlabProjectMilestones#state}
    */
    readonly state?: string;
    /**
    * Return only the milestones having the given `title`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/d/project_milestones#title DataGitlabProjectMilestones#title}
    */
    readonly title?: string;
}
export interface DataGitlabProjectMilestonesMilestones {
}
export declare function dataGitlabProjectMilestonesMilestonesToTerraform(struct?: DataGitlabProjectMilestonesMilestones): any;
export declare class DataGitlabProjectMilestonesMilestonesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGitlabProjectMilestonesMilestones | undefined;
    set internalValue(value: DataGitlabProjectMilestonesMilestones | undefined);
    get createdAt(): string;
    get description(): string;
    get dueDate(): string;
    get expired(): cdktf.IResolvable;
    get iid(): number;
    get milestoneId(): number;
    get project(): string;
    get projectId(): number;
    get startDate(): string;
    get state(): string;
    get title(): string;
    get updatedAt(): string;
    get webUrl(): string;
}
export declare class DataGitlabProjectMilestonesMilestonesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGitlabProjectMilestonesMilestonesOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/gitlab/d/project_milestones gitlab_project_milestones}
*/
export declare class DataGitlabProjectMilestones extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "gitlab_project_milestones";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/gitlab/d/project_milestones gitlab_project_milestones} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGitlabProjectMilestonesConfig
    */
    constructor(scope: Construct, id: string, config: DataGitlabProjectMilestonesConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _iids?;
    get iids(): number[];
    set iids(value: number[]);
    resetIids(): void;
    get iidsInput(): number[] | undefined;
    private _includeParentMilestones?;
    get includeParentMilestones(): boolean | cdktf.IResolvable;
    set includeParentMilestones(value: boolean | cdktf.IResolvable);
    resetIncludeParentMilestones(): void;
    get includeParentMilestonesInput(): boolean | cdktf.IResolvable | undefined;
    private _milestones;
    get milestones(): DataGitlabProjectMilestonesMilestonesList;
    private _project?;
    get project(): string;
    set project(value: string);
    get projectInput(): string | undefined;
    private _search?;
    get search(): string;
    set search(value: string);
    resetSearch(): void;
    get searchInput(): string | undefined;
    private _state?;
    get state(): string;
    set state(value: string);
    resetState(): void;
    get stateInput(): string | undefined;
    private _title?;
    get title(): string;
    set title(value: string);
    resetTitle(): void;
    get titleInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
