import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ProjectMirrorConfig extends cdktf.TerraformMetaArguments {
    /**
    * Determines if the mirror is enabled.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project_mirror#enabled ProjectMirror#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project_mirror#id ProjectMirror#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Determines if divergent refs are skipped.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project_mirror#keep_divergent_refs ProjectMirror#keep_divergent_refs}
    */
    readonly keepDivergentRefs?: boolean | cdktf.IResolvable;
    /**
    * Determines if only protected branches are mirrored.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project_mirror#only_protected_branches ProjectMirror#only_protected_branches}
    */
    readonly onlyProtectedBranches?: boolean | cdktf.IResolvable;
    /**
    * The id of the project.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project_mirror#project ProjectMirror#project}
    */
    readonly project: string;
    /**
    * The URL of the remote repository to be mirrored.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project_mirror#url ProjectMirror#url}
    */
    readonly url: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/gitlab/r/project_mirror gitlab_project_mirror}
*/
export declare class ProjectMirror extends cdktf.TerraformResource {
    static readonly tfResourceType = "gitlab_project_mirror";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/gitlab/r/project_mirror gitlab_project_mirror} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ProjectMirrorConfig
    */
    constructor(scope: Construct, id: string, config: ProjectMirrorConfig);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _keepDivergentRefs?;
    get keepDivergentRefs(): boolean | cdktf.IResolvable;
    set keepDivergentRefs(value: boolean | cdktf.IResolvable);
    resetKeepDivergentRefs(): void;
    get keepDivergentRefsInput(): boolean | cdktf.IResolvable | undefined;
    get mirrorId(): number;
    private _onlyProtectedBranches?;
    get onlyProtectedBranches(): boolean | cdktf.IResolvable;
    set onlyProtectedBranches(value: boolean | cdktf.IResolvable);
    resetOnlyProtectedBranches(): void;
    get onlyProtectedBranchesInput(): boolean | cdktf.IResolvable | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    get projectInput(): string | undefined;
    private _url?;
    get url(): string;
    set url(value: string);
    get urlInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
