import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ComputePerInstanceConfigConfig extends cdktf.TerraformMetaArguments {
    /**
     * The instance group manager this instance config is part of.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_per_instance_config.html#instance_group_manager ComputePerInstanceConfig#instance_group_manager}
     *
     * @stability stable
     */
    readonly instanceGroupManager: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_per_instance_config.html#minimal_action ComputePerInstanceConfig#minimal_action}.
     *
     * @stability stable
     */
    readonly minimalAction?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_per_instance_config.html#most_disruptive_allowed_action ComputePerInstanceConfig#most_disruptive_allowed_action}.
     *
     * @stability stable
     */
    readonly mostDisruptiveAllowedAction?: string;
    /**
     * The name for this per-instance config and its corresponding instance.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_per_instance_config.html#name ComputePerInstanceConfig#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_per_instance_config.html#project ComputePerInstanceConfig#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_per_instance_config.html#remove_instance_state_on_destroy ComputePerInstanceConfig#remove_instance_state_on_destroy}.
     *
     * @stability stable
     */
    readonly removeInstanceStateOnDestroy?: boolean | cdktf.IResolvable;
    /**
     * Zone where the containing instance group manager is located.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_per_instance_config.html#zone ComputePerInstanceConfig#zone}
     *
     * @stability stable
     */
    readonly zone?: string;
    /**
     * preserved_state block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_per_instance_config.html#preserved_state ComputePerInstanceConfig#preserved_state}
     *
     * @stability stable
     */
    readonly preservedState?: ComputePerInstanceConfigPreservedState;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_per_instance_config.html#timeouts ComputePerInstanceConfig#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: ComputePerInstanceConfigTimeouts;
}
/**
 * @stability stable
 */
export interface ComputePerInstanceConfigPreservedStateDisk {
    /**
     * A value that prescribes what should happen to the stateful disk when the VM instance is deleted.
     *
     * The available options are 'NEVER' and 'ON_PERMANENT_INSTANCE_DELETION'.
     * 'NEVER' - detach the disk when the VM is deleted, but do not delete the disk.
     * 'ON_PERMANENT_INSTANCE_DELETION' will delete the stateful disk when the VM is permanently
     * deleted from the instance group. Default value: "NEVER" Possible values: ["NEVER", "ON_PERMANENT_INSTANCE_DELETION"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_per_instance_config.html#delete_rule ComputePerInstanceConfig#delete_rule}
     *
     * @stability stable
     */
    readonly deleteRule?: string;
    /**
     * A unique device name that is reflected into the /dev/ tree of a Linux operating system running within the instance.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_per_instance_config.html#device_name ComputePerInstanceConfig#device_name}
     *
     * @stability stable
     */
    readonly deviceName: string;
    /**
     * The mode of the disk. Default value: "READ_WRITE" Possible values: ["READ_ONLY", "READ_WRITE"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_per_instance_config.html#mode ComputePerInstanceConfig#mode}
     *
     * @stability stable
     */
    readonly mode?: string;
    /**
     * The URI of an existing persistent disk to attach under the specified device-name in the format 'projects/project-id/zones/zone/disks/disk-name'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_per_instance_config.html#source ComputePerInstanceConfig#source}
     *
     * @stability stable
     */
    readonly source: string;
}
export declare function computePerInstanceConfigPreservedStateDiskToTerraform(struct?: ComputePerInstanceConfigPreservedStateDisk): any;
/**
 * @stability stable
 */
export interface ComputePerInstanceConfigPreservedState {
    /**
     * Preserved metadata defined for this instance. This is a list of key->value pairs.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_per_instance_config.html#metadata ComputePerInstanceConfig#metadata}
     *
     * @stability stable
     */
    readonly metadata?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * disk block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_per_instance_config.html#disk ComputePerInstanceConfig#disk}
     *
     * @stability stable
     */
    readonly disk?: ComputePerInstanceConfigPreservedStateDisk[];
}
export declare function computePerInstanceConfigPreservedStateToTerraform(struct?: ComputePerInstanceConfigPreservedStateOutputReference | ComputePerInstanceConfigPreservedState): any;
/**
 * @stability stable
 */
export declare class ComputePerInstanceConfigPreservedStateOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ComputePerInstanceConfigPreservedState | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ComputePerInstanceConfigPreservedState | undefined);
    private _metadata?;
    /**
     * @stability stable
     */
    get metadata(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set metadata(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetMetadata(): void;
    /**
     * @stability stable
     */
    get metadataInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _disk?;
    /**
     * @stability stable
     */
    get disk(): ComputePerInstanceConfigPreservedStateDisk[];
    /**
     * @stability stable
     */
    set disk(value: ComputePerInstanceConfigPreservedStateDisk[]);
    /**
     * @stability stable
     */
    resetDisk(): void;
    /**
     * @stability stable
     */
    get diskInput(): ComputePerInstanceConfigPreservedStateDisk[] | undefined;
}
/**
 * @stability stable
 */
export interface ComputePerInstanceConfigTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_per_instance_config.html#create ComputePerInstanceConfig#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_per_instance_config.html#delete ComputePerInstanceConfig#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_per_instance_config.html#update ComputePerInstanceConfig#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function computePerInstanceConfigTimeoutsToTerraform(struct?: ComputePerInstanceConfigTimeoutsOutputReference | ComputePerInstanceConfigTimeouts): any;
/**
 * @stability stable
 */
export declare class ComputePerInstanceConfigTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ComputePerInstanceConfigTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ComputePerInstanceConfigTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_per_instance_config.html google_compute_per_instance_config}.
 *
 * @stability stable
 */
export declare class ComputePerInstanceConfig extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_per_instance_config.html google_compute_per_instance_config} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ComputePerInstanceConfigConfig);
    /**
     * @stability stable
     */
    get id(): string;
    private _instanceGroupManager?;
    /**
     * @stability stable
     */
    get instanceGroupManager(): string;
    /**
     * @stability stable
     */
    set instanceGroupManager(value: string);
    /**
     * @stability stable
     */
    get instanceGroupManagerInput(): string | undefined;
    private _minimalAction?;
    /**
     * @stability stable
     */
    get minimalAction(): string;
    /**
     * @stability stable
     */
    set minimalAction(value: string);
    /**
     * @stability stable
     */
    resetMinimalAction(): void;
    /**
     * @stability stable
     */
    get minimalActionInput(): string | undefined;
    private _mostDisruptiveAllowedAction?;
    /**
     * @stability stable
     */
    get mostDisruptiveAllowedAction(): string;
    /**
     * @stability stable
     */
    set mostDisruptiveAllowedAction(value: string);
    /**
     * @stability stable
     */
    resetMostDisruptiveAllowedAction(): void;
    /**
     * @stability stable
     */
    get mostDisruptiveAllowedActionInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _removeInstanceStateOnDestroy?;
    /**
     * @stability stable
     */
    get removeInstanceStateOnDestroy(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set removeInstanceStateOnDestroy(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetRemoveInstanceStateOnDestroy(): void;
    /**
     * @stability stable
     */
    get removeInstanceStateOnDestroyInput(): boolean | cdktf.IResolvable | undefined;
    private _zone?;
    /**
     * @stability stable
     */
    get zone(): string;
    /**
     * @stability stable
     */
    set zone(value: string);
    /**
     * @stability stable
     */
    resetZone(): void;
    /**
     * @stability stable
     */
    get zoneInput(): string | undefined;
    private _preservedState;
    /**
     * @stability stable
     */
    get preservedState(): ComputePerInstanceConfigPreservedStateOutputReference;
    /**
     * @stability stable
     */
    putPreservedState(value: ComputePerInstanceConfigPreservedState): void;
    /**
     * @stability stable
     */
    resetPreservedState(): void;
    /**
     * @stability stable
     */
    get preservedStateInput(): ComputePerInstanceConfigPreservedState | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): ComputePerInstanceConfigTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: ComputePerInstanceConfigTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): ComputePerInstanceConfigTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
