import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ProjectDefaultServiceAccountsConfig extends cdktf.TerraformMetaArguments {
    /**
     * The action to be performed in the default service accounts.
     *
     * Valid values are: DEPRIVILEGE, DELETE, DISABLE.
     * Note that DEPRIVILEGE action will ignore the REVERT configuration in the restore_policy.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/project_default_service_accounts.html#action ProjectDefaultServiceAccounts#action}
     *
     * @stability stable
     */
    readonly action: string;
    /**
     * The project ID where service accounts are created.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/project_default_service_accounts.html#project ProjectDefaultServiceAccounts#project}
     *
     * @stability stable
     */
    readonly project: string;
    /**
     * The action to be performed in the default service accounts on the resource destroy.
     *
     * Valid values are NONE, REVERT and REVERT_AND_IGNORE_FAILURE. It is applied for any action but in the DEPRIVILEGE.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/project_default_service_accounts.html#restore_policy ProjectDefaultServiceAccounts#restore_policy}
     *
     * @stability stable
     */
    readonly restorePolicy?: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/project_default_service_accounts.html#timeouts ProjectDefaultServiceAccounts#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: ProjectDefaultServiceAccountsTimeouts;
}
/**
 * @stability stable
 */
export interface ProjectDefaultServiceAccountsTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/project_default_service_accounts.html#create ProjectDefaultServiceAccounts#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/project_default_service_accounts.html#delete ProjectDefaultServiceAccounts#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/project_default_service_accounts.html#read ProjectDefaultServiceAccounts#read}.
     *
     * @stability stable
     */
    readonly read?: string;
}
export declare function projectDefaultServiceAccountsTimeoutsToTerraform(struct?: ProjectDefaultServiceAccountsTimeoutsOutputReference | ProjectDefaultServiceAccountsTimeouts): any;
/**
 * @stability stable
 */
export declare class ProjectDefaultServiceAccountsTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ProjectDefaultServiceAccountsTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ProjectDefaultServiceAccountsTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/project_default_service_accounts.html google_project_default_service_accounts}.
 *
 * @stability stable
 */
export declare class ProjectDefaultServiceAccounts extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/project_default_service_accounts.html google_project_default_service_accounts} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ProjectDefaultServiceAccountsConfig);
    private _action?;
    /**
     * @stability stable
     */
    get action(): string;
    /**
     * @stability stable
     */
    set action(value: string);
    /**
     * @stability stable
     */
    get actionInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _restorePolicy?;
    /**
     * @stability stable
     */
    get restorePolicy(): string;
    /**
     * @stability stable
     */
    set restorePolicy(value: string);
    /**
     * @stability stable
     */
    resetRestorePolicy(): void;
    /**
     * @stability stable
     */
    get restorePolicyInput(): string | undefined;
    /**
     * @stability stable
     */
    serviceAccounts(key: string): string;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): ProjectDefaultServiceAccountsTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: ProjectDefaultServiceAccountsTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): ProjectDefaultServiceAccountsTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
