import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface StorageTransferJobConfig extends cdktf.TerraformMetaArguments {
    /**
     * Unique description to identify the Transfer Job.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job.html#description StorageTransferJob#description}
     *
     * @stability stable
     */
    readonly description: string;
    /**
     * The project in which the resource belongs. If it is not provided, the provider project is used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job.html#project StorageTransferJob#project}
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * Status of the job.
     *
     * Default: ENABLED. NOTE: The effect of the new job status takes place during a subsequent job run. For example, if you change the job status from ENABLED to DISABLED, and an operation spawned by the transfer is running, the status change would not affect the current operation.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job.html#status StorageTransferJob#status}
     *
     * @stability stable
     */
    readonly status?: string;
    /**
     * schedule block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job.html#schedule StorageTransferJob#schedule}
     *
     * @stability stable
     */
    readonly schedule: StorageTransferJobSchedule;
    /**
     * transfer_spec block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job.html#transfer_spec StorageTransferJob#transfer_spec}
     *
     * @stability stable
     */
    readonly transferSpec: StorageTransferJobTransferSpec;
}
/**
 * @stability stable
 */
export interface StorageTransferJobScheduleScheduleEndDate {
    /**
     * Day of month. Must be from 1 to 31 and valid for the year and month.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job.html#day StorageTransferJob#day}
     *
     * @stability stable
     */
    readonly day: number;
    /**
     * Month of year. Must be from 1 to 12.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job.html#month StorageTransferJob#month}
     *
     * @stability stable
     */
    readonly month: number;
    /**
     * Year of date. Must be from 1 to 9999.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job.html#year StorageTransferJob#year}
     *
     * @stability stable
     */
    readonly year: number;
}
export declare function storageTransferJobScheduleScheduleEndDateToTerraform(struct?: StorageTransferJobScheduleScheduleEndDateOutputReference | StorageTransferJobScheduleScheduleEndDate): any;
/**
 * @stability stable
 */
export declare class StorageTransferJobScheduleScheduleEndDateOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): StorageTransferJobScheduleScheduleEndDate | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: StorageTransferJobScheduleScheduleEndDate | undefined);
    private _day?;
    /**
     * @stability stable
     */
    get day(): number;
    /**
     * @stability stable
     */
    set day(value: number);
    /**
     * @stability stable
     */
    get dayInput(): number | undefined;
    private _month?;
    /**
     * @stability stable
     */
    get month(): number;
    /**
     * @stability stable
     */
    set month(value: number);
    /**
     * @stability stable
     */
    get monthInput(): number | undefined;
    private _year?;
    /**
     * @stability stable
     */
    get year(): number;
    /**
     * @stability stable
     */
    set year(value: number);
    /**
     * @stability stable
     */
    get yearInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface StorageTransferJobScheduleScheduleStartDate {
    /**
     * Day of month. Must be from 1 to 31 and valid for the year and month.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job.html#day StorageTransferJob#day}
     *
     * @stability stable
     */
    readonly day: number;
    /**
     * Month of year. Must be from 1 to 12.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job.html#month StorageTransferJob#month}
     *
     * @stability stable
     */
    readonly month: number;
    /**
     * Year of date. Must be from 1 to 9999.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job.html#year StorageTransferJob#year}
     *
     * @stability stable
     */
    readonly year: number;
}
export declare function storageTransferJobScheduleScheduleStartDateToTerraform(struct?: StorageTransferJobScheduleScheduleStartDateOutputReference | StorageTransferJobScheduleScheduleStartDate): any;
/**
 * @stability stable
 */
export declare class StorageTransferJobScheduleScheduleStartDateOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): StorageTransferJobScheduleScheduleStartDate | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: StorageTransferJobScheduleScheduleStartDate | undefined);
    private _day?;
    /**
     * @stability stable
     */
    get day(): number;
    /**
     * @stability stable
     */
    set day(value: number);
    /**
     * @stability stable
     */
    get dayInput(): number | undefined;
    private _month?;
    /**
     * @stability stable
     */
    get month(): number;
    /**
     * @stability stable
     */
    set month(value: number);
    /**
     * @stability stable
     */
    get monthInput(): number | undefined;
    private _year?;
    /**
     * @stability stable
     */
    get year(): number;
    /**
     * @stability stable
     */
    set year(value: number);
    /**
     * @stability stable
     */
    get yearInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface StorageTransferJobScheduleStartTimeOfDay {
    /**
     * Hours of day in 24 hour format. Should be from 0 to 23.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job.html#hours StorageTransferJob#hours}
     *
     * @stability stable
     */
    readonly hours: number;
    /**
     * Minutes of hour of day. Must be from 0 to 59.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job.html#minutes StorageTransferJob#minutes}
     *
     * @stability stable
     */
    readonly minutes: number;
    /**
     * Fractions of seconds in nanoseconds. Must be from 0 to 999,999,999.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job.html#nanos StorageTransferJob#nanos}
     *
     * @stability stable
     */
    readonly nanos: number;
    /**
     * Seconds of minutes of the time. Must normally be from 0 to 59.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job.html#seconds StorageTransferJob#seconds}
     *
     * @stability stable
     */
    readonly seconds: number;
}
export declare function storageTransferJobScheduleStartTimeOfDayToTerraform(struct?: StorageTransferJobScheduleStartTimeOfDayOutputReference | StorageTransferJobScheduleStartTimeOfDay): any;
/**
 * @stability stable
 */
export declare class StorageTransferJobScheduleStartTimeOfDayOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): StorageTransferJobScheduleStartTimeOfDay | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: StorageTransferJobScheduleStartTimeOfDay | undefined);
    private _hours?;
    /**
     * @stability stable
     */
    get hours(): number;
    /**
     * @stability stable
     */
    set hours(value: number);
    /**
     * @stability stable
     */
    get hoursInput(): number | undefined;
    private _minutes?;
    /**
     * @stability stable
     */
    get minutes(): number;
    /**
     * @stability stable
     */
    set minutes(value: number);
    /**
     * @stability stable
     */
    get minutesInput(): number | undefined;
    private _nanos?;
    /**
     * @stability stable
     */
    get nanos(): number;
    /**
     * @stability stable
     */
    set nanos(value: number);
    /**
     * @stability stable
     */
    get nanosInput(): number | undefined;
    private _seconds?;
    /**
     * @stability stable
     */
    get seconds(): number;
    /**
     * @stability stable
     */
    set seconds(value: number);
    /**
     * @stability stable
     */
    get secondsInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface StorageTransferJobSchedule {
    /**
     * schedule_end_date block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job.html#schedule_end_date StorageTransferJob#schedule_end_date}
     *
     * @stability stable
     */
    readonly scheduleEndDate?: StorageTransferJobScheduleScheduleEndDate;
    /**
     * schedule_start_date block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job.html#schedule_start_date StorageTransferJob#schedule_start_date}
     *
     * @stability stable
     */
    readonly scheduleStartDate: StorageTransferJobScheduleScheduleStartDate;
    /**
     * start_time_of_day block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job.html#start_time_of_day StorageTransferJob#start_time_of_day}
     *
     * @stability stable
     */
    readonly startTimeOfDay?: StorageTransferJobScheduleStartTimeOfDay;
}
export declare function storageTransferJobScheduleToTerraform(struct?: StorageTransferJobScheduleOutputReference | StorageTransferJobSchedule): any;
/**
 * @stability stable
 */
export declare class StorageTransferJobScheduleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): StorageTransferJobSchedule | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: StorageTransferJobSchedule | undefined);
    private _scheduleEndDate;
    /**
     * @stability stable
     */
    get scheduleEndDate(): StorageTransferJobScheduleScheduleEndDateOutputReference;
    /**
     * @stability stable
     */
    putScheduleEndDate(value: StorageTransferJobScheduleScheduleEndDate): void;
    /**
     * @stability stable
     */
    resetScheduleEndDate(): void;
    /**
     * @stability stable
     */
    get scheduleEndDateInput(): StorageTransferJobScheduleScheduleEndDate | undefined;
    private _scheduleStartDate;
    /**
     * @stability stable
     */
    get scheduleStartDate(): StorageTransferJobScheduleScheduleStartDateOutputReference;
    /**
     * @stability stable
     */
    putScheduleStartDate(value: StorageTransferJobScheduleScheduleStartDate): void;
    /**
     * @stability stable
     */
    get scheduleStartDateInput(): StorageTransferJobScheduleScheduleStartDate | undefined;
    private _startTimeOfDay;
    /**
     * @stability stable
     */
    get startTimeOfDay(): StorageTransferJobScheduleStartTimeOfDayOutputReference;
    /**
     * @stability stable
     */
    putStartTimeOfDay(value: StorageTransferJobScheduleStartTimeOfDay): void;
    /**
     * @stability stable
     */
    resetStartTimeOfDay(): void;
    /**
     * @stability stable
     */
    get startTimeOfDayInput(): StorageTransferJobScheduleStartTimeOfDay | undefined;
}
/**
 * @stability stable
 */
export interface StorageTransferJobTransferSpecAwsS3DataSourceAwsAccessKey {
    /**
     * AWS Key ID.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job.html#access_key_id StorageTransferJob#access_key_id}
     *
     * @stability stable
     */
    readonly accessKeyId: string;
    /**
     * AWS Secret Access Key.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job.html#secret_access_key StorageTransferJob#secret_access_key}
     *
     * @stability stable
     */
    readonly secretAccessKey: string;
}
export declare function storageTransferJobTransferSpecAwsS3DataSourceAwsAccessKeyToTerraform(struct?: StorageTransferJobTransferSpecAwsS3DataSourceAwsAccessKeyOutputReference | StorageTransferJobTransferSpecAwsS3DataSourceAwsAccessKey): any;
/**
 * @stability stable
 */
export declare class StorageTransferJobTransferSpecAwsS3DataSourceAwsAccessKeyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): StorageTransferJobTransferSpecAwsS3DataSourceAwsAccessKey | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: StorageTransferJobTransferSpecAwsS3DataSourceAwsAccessKey | undefined);
    private _accessKeyId?;
    /**
     * @stability stable
     */
    get accessKeyId(): string;
    /**
     * @stability stable
     */
    set accessKeyId(value: string);
    /**
     * @stability stable
     */
    get accessKeyIdInput(): string | undefined;
    private _secretAccessKey?;
    /**
     * @stability stable
     */
    get secretAccessKey(): string;
    /**
     * @stability stable
     */
    set secretAccessKey(value: string);
    /**
     * @stability stable
     */
    get secretAccessKeyInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface StorageTransferJobTransferSpecAwsS3DataSource {
    /**
     * S3 Bucket name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job.html#bucket_name StorageTransferJob#bucket_name}
     *
     * @stability stable
     */
    readonly bucketName: string;
    /**
     * aws_access_key block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job.html#aws_access_key StorageTransferJob#aws_access_key}
     *
     * @stability stable
     */
    readonly awsAccessKey: StorageTransferJobTransferSpecAwsS3DataSourceAwsAccessKey;
}
export declare function storageTransferJobTransferSpecAwsS3DataSourceToTerraform(struct?: StorageTransferJobTransferSpecAwsS3DataSourceOutputReference | StorageTransferJobTransferSpecAwsS3DataSource): any;
/**
 * @stability stable
 */
export declare class StorageTransferJobTransferSpecAwsS3DataSourceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): StorageTransferJobTransferSpecAwsS3DataSource | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: StorageTransferJobTransferSpecAwsS3DataSource | undefined);
    private _bucketName?;
    /**
     * @stability stable
     */
    get bucketName(): string;
    /**
     * @stability stable
     */
    set bucketName(value: string);
    /**
     * @stability stable
     */
    get bucketNameInput(): string | undefined;
    private _awsAccessKey;
    /**
     * @stability stable
     */
    get awsAccessKey(): StorageTransferJobTransferSpecAwsS3DataSourceAwsAccessKeyOutputReference;
    /**
     * @stability stable
     */
    putAwsAccessKey(value: StorageTransferJobTransferSpecAwsS3DataSourceAwsAccessKey): void;
    /**
     * @stability stable
     */
    get awsAccessKeyInput(): StorageTransferJobTransferSpecAwsS3DataSourceAwsAccessKey | undefined;
}
/**
 * @stability stable
 */
export interface StorageTransferJobTransferSpecAzureBlobStorageDataSourceAzureCredentials {
    /**
     * Azure shared access signature.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job.html#sas_token StorageTransferJob#sas_token}
     *
     * @stability stable
     */
    readonly sasToken: string;
}
export declare function storageTransferJobTransferSpecAzureBlobStorageDataSourceAzureCredentialsToTerraform(struct?: StorageTransferJobTransferSpecAzureBlobStorageDataSourceAzureCredentialsOutputReference | StorageTransferJobTransferSpecAzureBlobStorageDataSourceAzureCredentials): any;
/**
 * @stability stable
 */
export declare class StorageTransferJobTransferSpecAzureBlobStorageDataSourceAzureCredentialsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): StorageTransferJobTransferSpecAzureBlobStorageDataSourceAzureCredentials | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: StorageTransferJobTransferSpecAzureBlobStorageDataSourceAzureCredentials | undefined);
    private _sasToken?;
    /**
     * @stability stable
     */
    get sasToken(): string;
    /**
     * @stability stable
     */
    set sasToken(value: string);
    /**
     * @stability stable
     */
    get sasTokenInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface StorageTransferJobTransferSpecAzureBlobStorageDataSource {
    /**
     * The container to transfer from the Azure Storage account.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job.html#container StorageTransferJob#container}
     *
     * @stability stable
     */
    readonly container: string;
    /**
     * Root path to transfer objects.
     *
     * Must be an empty string or full path name that ends with a '/'. This field is treated as an object prefix. As such, it should generally not begin with a '/'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job.html#path StorageTransferJob#path}
     *
     * @stability stable
     */
    readonly path?: string;
    /**
     * The name of the Azure Storage account.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job.html#storage_account StorageTransferJob#storage_account}
     *
     * @stability stable
     */
    readonly storageAccount: string;
    /**
     * azure_credentials block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job.html#azure_credentials StorageTransferJob#azure_credentials}
     *
     * @stability stable
     */
    readonly azureCredentials: StorageTransferJobTransferSpecAzureBlobStorageDataSourceAzureCredentials;
}
export declare function storageTransferJobTransferSpecAzureBlobStorageDataSourceToTerraform(struct?: StorageTransferJobTransferSpecAzureBlobStorageDataSourceOutputReference | StorageTransferJobTransferSpecAzureBlobStorageDataSource): any;
/**
 * @stability stable
 */
export declare class StorageTransferJobTransferSpecAzureBlobStorageDataSourceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): StorageTransferJobTransferSpecAzureBlobStorageDataSource | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: StorageTransferJobTransferSpecAzureBlobStorageDataSource | undefined);
    private _container?;
    /**
     * @stability stable
     */
    get container(): string;
    /**
     * @stability stable
     */
    set container(value: string);
    /**
     * @stability stable
     */
    get containerInput(): string | undefined;
    private _path?;
    /**
     * @stability stable
     */
    get path(): string;
    /**
     * @stability stable
     */
    set path(value: string);
    /**
     * @stability stable
     */
    resetPath(): void;
    /**
     * @stability stable
     */
    get pathInput(): string | undefined;
    private _storageAccount?;
    /**
     * @stability stable
     */
    get storageAccount(): string;
    /**
     * @stability stable
     */
    set storageAccount(value: string);
    /**
     * @stability stable
     */
    get storageAccountInput(): string | undefined;
    private _azureCredentials;
    /**
     * @stability stable
     */
    get azureCredentials(): StorageTransferJobTransferSpecAzureBlobStorageDataSourceAzureCredentialsOutputReference;
    /**
     * @stability stable
     */
    putAzureCredentials(value: StorageTransferJobTransferSpecAzureBlobStorageDataSourceAzureCredentials): void;
    /**
     * @stability stable
     */
    get azureCredentialsInput(): StorageTransferJobTransferSpecAzureBlobStorageDataSourceAzureCredentials | undefined;
}
/**
 * @stability stable
 */
export interface StorageTransferJobTransferSpecGcsDataSink {
    /**
     * Google Cloud Storage bucket name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job.html#bucket_name StorageTransferJob#bucket_name}
     *
     * @stability stable
     */
    readonly bucketName: string;
    /**
     * Google Cloud Storage path in bucket to transfer.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job.html#path StorageTransferJob#path}
     *
     * @stability stable
     */
    readonly path?: string;
}
export declare function storageTransferJobTransferSpecGcsDataSinkToTerraform(struct?: StorageTransferJobTransferSpecGcsDataSinkOutputReference | StorageTransferJobTransferSpecGcsDataSink): any;
/**
 * @stability stable
 */
export declare class StorageTransferJobTransferSpecGcsDataSinkOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): StorageTransferJobTransferSpecGcsDataSink | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: StorageTransferJobTransferSpecGcsDataSink | undefined);
    private _bucketName?;
    /**
     * @stability stable
     */
    get bucketName(): string;
    /**
     * @stability stable
     */
    set bucketName(value: string);
    /**
     * @stability stable
     */
    get bucketNameInput(): string | undefined;
    private _path?;
    /**
     * @stability stable
     */
    get path(): string;
    /**
     * @stability stable
     */
    set path(value: string);
    /**
     * @stability stable
     */
    resetPath(): void;
    /**
     * @stability stable
     */
    get pathInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface StorageTransferJobTransferSpecGcsDataSource {
    /**
     * Google Cloud Storage bucket name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job.html#bucket_name StorageTransferJob#bucket_name}
     *
     * @stability stable
     */
    readonly bucketName: string;
    /**
     * Google Cloud Storage path in bucket to transfer.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job.html#path StorageTransferJob#path}
     *
     * @stability stable
     */
    readonly path?: string;
}
export declare function storageTransferJobTransferSpecGcsDataSourceToTerraform(struct?: StorageTransferJobTransferSpecGcsDataSourceOutputReference | StorageTransferJobTransferSpecGcsDataSource): any;
/**
 * @stability stable
 */
export declare class StorageTransferJobTransferSpecGcsDataSourceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): StorageTransferJobTransferSpecGcsDataSource | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: StorageTransferJobTransferSpecGcsDataSource | undefined);
    private _bucketName?;
    /**
     * @stability stable
     */
    get bucketName(): string;
    /**
     * @stability stable
     */
    set bucketName(value: string);
    /**
     * @stability stable
     */
    get bucketNameInput(): string | undefined;
    private _path?;
    /**
     * @stability stable
     */
    get path(): string;
    /**
     * @stability stable
     */
    set path(value: string);
    /**
     * @stability stable
     */
    resetPath(): void;
    /**
     * @stability stable
     */
    get pathInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface StorageTransferJobTransferSpecHttpDataSource {
    /**
     * The URL that points to the file that stores the object list entries.
     *
     * This file must allow public access. Currently, only URLs with HTTP and HTTPS schemes are supported.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job.html#list_url StorageTransferJob#list_url}
     *
     * @stability stable
     */
    readonly listUrl: string;
}
export declare function storageTransferJobTransferSpecHttpDataSourceToTerraform(struct?: StorageTransferJobTransferSpecHttpDataSourceOutputReference | StorageTransferJobTransferSpecHttpDataSource): any;
/**
 * @stability stable
 */
export declare class StorageTransferJobTransferSpecHttpDataSourceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): StorageTransferJobTransferSpecHttpDataSource | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: StorageTransferJobTransferSpecHttpDataSource | undefined);
    private _listUrl?;
    /**
     * @stability stable
     */
    get listUrl(): string;
    /**
     * @stability stable
     */
    set listUrl(value: string);
    /**
     * @stability stable
     */
    get listUrlInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface StorageTransferJobTransferSpecObjectConditions {
    /**
     * exclude_prefixes must follow the requirements described for include_prefixes.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job.html#exclude_prefixes StorageTransferJob#exclude_prefixes}
     *
     * @stability stable
     */
    readonly excludePrefixes?: string[];
    /**
     * If include_refixes is specified, objects that satisfy the object conditions must have names that start with one of the include_prefixes and that do not start with any of the exclude_prefixes.
     *
     * If include_prefixes is not specified, all objects except those that have names starting with one of the exclude_prefixes must satisfy the object conditions.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job.html#include_prefixes StorageTransferJob#include_prefixes}
     *
     * @stability stable
     */
    readonly includePrefixes?: string[];
    /**
     * A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job.html#max_time_elapsed_since_last_modification StorageTransferJob#max_time_elapsed_since_last_modification}
     *
     * @stability stable
     */
    readonly maxTimeElapsedSinceLastModification?: string;
    /**
     * A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job.html#min_time_elapsed_since_last_modification StorageTransferJob#min_time_elapsed_since_last_modification}
     *
     * @stability stable
     */
    readonly minTimeElapsedSinceLastModification?: string;
}
export declare function storageTransferJobTransferSpecObjectConditionsToTerraform(struct?: StorageTransferJobTransferSpecObjectConditionsOutputReference | StorageTransferJobTransferSpecObjectConditions): any;
/**
 * @stability stable
 */
export declare class StorageTransferJobTransferSpecObjectConditionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): StorageTransferJobTransferSpecObjectConditions | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: StorageTransferJobTransferSpecObjectConditions | undefined);
    private _excludePrefixes?;
    /**
     * @stability stable
     */
    get excludePrefixes(): string[];
    /**
     * @stability stable
     */
    set excludePrefixes(value: string[]);
    /**
     * @stability stable
     */
    resetExcludePrefixes(): void;
    /**
     * @stability stable
     */
    get excludePrefixesInput(): string[] | undefined;
    private _includePrefixes?;
    /**
     * @stability stable
     */
    get includePrefixes(): string[];
    /**
     * @stability stable
     */
    set includePrefixes(value: string[]);
    /**
     * @stability stable
     */
    resetIncludePrefixes(): void;
    /**
     * @stability stable
     */
    get includePrefixesInput(): string[] | undefined;
    private _maxTimeElapsedSinceLastModification?;
    /**
     * @stability stable
     */
    get maxTimeElapsedSinceLastModification(): string;
    /**
     * @stability stable
     */
    set maxTimeElapsedSinceLastModification(value: string);
    /**
     * @stability stable
     */
    resetMaxTimeElapsedSinceLastModification(): void;
    /**
     * @stability stable
     */
    get maxTimeElapsedSinceLastModificationInput(): string | undefined;
    private _minTimeElapsedSinceLastModification?;
    /**
     * @stability stable
     */
    get minTimeElapsedSinceLastModification(): string;
    /**
     * @stability stable
     */
    set minTimeElapsedSinceLastModification(value: string);
    /**
     * @stability stable
     */
    resetMinTimeElapsedSinceLastModification(): void;
    /**
     * @stability stable
     */
    get minTimeElapsedSinceLastModificationInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface StorageTransferJobTransferSpecTransferOptions {
    /**
     * Whether objects should be deleted from the source after they are transferred to the sink.
     *
     * Note that this option and delete_objects_unique_in_sink are mutually exclusive.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job.html#delete_objects_from_source_after_transfer StorageTransferJob#delete_objects_from_source_after_transfer}
     *
     * @stability stable
     */
    readonly deleteObjectsFromSourceAfterTransfer?: boolean | cdktf.IResolvable;
    /**
     * Whether objects that exist only in the sink should be deleted.
     *
     * Note that this option and delete_objects_from_source_after_transfer are mutually exclusive.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job.html#delete_objects_unique_in_sink StorageTransferJob#delete_objects_unique_in_sink}
     *
     * @stability stable
     */
    readonly deleteObjectsUniqueInSink?: boolean | cdktf.IResolvable;
    /**
     * Whether overwriting objects that already exist in the sink is allowed.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job.html#overwrite_objects_already_existing_in_sink StorageTransferJob#overwrite_objects_already_existing_in_sink}
     *
     * @stability stable
     */
    readonly overwriteObjectsAlreadyExistingInSink?: boolean | cdktf.IResolvable;
}
export declare function storageTransferJobTransferSpecTransferOptionsToTerraform(struct?: StorageTransferJobTransferSpecTransferOptionsOutputReference | StorageTransferJobTransferSpecTransferOptions): any;
/**
 * @stability stable
 */
export declare class StorageTransferJobTransferSpecTransferOptionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): StorageTransferJobTransferSpecTransferOptions | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: StorageTransferJobTransferSpecTransferOptions | undefined);
    private _deleteObjectsFromSourceAfterTransfer?;
    /**
     * @stability stable
     */
    get deleteObjectsFromSourceAfterTransfer(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set deleteObjectsFromSourceAfterTransfer(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetDeleteObjectsFromSourceAfterTransfer(): void;
    /**
     * @stability stable
     */
    get deleteObjectsFromSourceAfterTransferInput(): boolean | cdktf.IResolvable | undefined;
    private _deleteObjectsUniqueInSink?;
    /**
     * @stability stable
     */
    get deleteObjectsUniqueInSink(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set deleteObjectsUniqueInSink(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetDeleteObjectsUniqueInSink(): void;
    /**
     * @stability stable
     */
    get deleteObjectsUniqueInSinkInput(): boolean | cdktf.IResolvable | undefined;
    private _overwriteObjectsAlreadyExistingInSink?;
    /**
     * @stability stable
     */
    get overwriteObjectsAlreadyExistingInSink(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set overwriteObjectsAlreadyExistingInSink(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetOverwriteObjectsAlreadyExistingInSink(): void;
    /**
     * @stability stable
     */
    get overwriteObjectsAlreadyExistingInSinkInput(): boolean | cdktf.IResolvable | undefined;
}
/**
 * @stability stable
 */
export interface StorageTransferJobTransferSpec {
    /**
     * aws_s3_data_source block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job.html#aws_s3_data_source StorageTransferJob#aws_s3_data_source}
     *
     * @stability stable
     */
    readonly awsS3DataSource?: StorageTransferJobTransferSpecAwsS3DataSource;
    /**
     * azure_blob_storage_data_source block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job.html#azure_blob_storage_data_source StorageTransferJob#azure_blob_storage_data_source}
     *
     * @stability stable
     */
    readonly azureBlobStorageDataSource?: StorageTransferJobTransferSpecAzureBlobStorageDataSource;
    /**
     * gcs_data_sink block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job.html#gcs_data_sink StorageTransferJob#gcs_data_sink}
     *
     * @stability stable
     */
    readonly gcsDataSink?: StorageTransferJobTransferSpecGcsDataSink;
    /**
     * gcs_data_source block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job.html#gcs_data_source StorageTransferJob#gcs_data_source}
     *
     * @stability stable
     */
    readonly gcsDataSource?: StorageTransferJobTransferSpecGcsDataSource;
    /**
     * http_data_source block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job.html#http_data_source StorageTransferJob#http_data_source}
     *
     * @stability stable
     */
    readonly httpDataSource?: StorageTransferJobTransferSpecHttpDataSource;
    /**
     * object_conditions block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job.html#object_conditions StorageTransferJob#object_conditions}
     *
     * @stability stable
     */
    readonly objectConditions?: StorageTransferJobTransferSpecObjectConditions;
    /**
     * transfer_options block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job.html#transfer_options StorageTransferJob#transfer_options}
     *
     * @stability stable
     */
    readonly transferOptions?: StorageTransferJobTransferSpecTransferOptions;
}
export declare function storageTransferJobTransferSpecToTerraform(struct?: StorageTransferJobTransferSpecOutputReference | StorageTransferJobTransferSpec): any;
/**
 * @stability stable
 */
export declare class StorageTransferJobTransferSpecOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): StorageTransferJobTransferSpec | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: StorageTransferJobTransferSpec | undefined);
    private _awsS3DataSource;
    /**
     * @stability stable
     */
    get awsS3DataSource(): StorageTransferJobTransferSpecAwsS3DataSourceOutputReference;
    /**
     * @stability stable
     */
    putAwsS3DataSource(value: StorageTransferJobTransferSpecAwsS3DataSource): void;
    /**
     * @stability stable
     */
    resetAwsS3DataSource(): void;
    /**
     * @stability stable
     */
    get awsS3DataSourceInput(): StorageTransferJobTransferSpecAwsS3DataSource | undefined;
    private _azureBlobStorageDataSource;
    /**
     * @stability stable
     */
    get azureBlobStorageDataSource(): StorageTransferJobTransferSpecAzureBlobStorageDataSourceOutputReference;
    /**
     * @stability stable
     */
    putAzureBlobStorageDataSource(value: StorageTransferJobTransferSpecAzureBlobStorageDataSource): void;
    /**
     * @stability stable
     */
    resetAzureBlobStorageDataSource(): void;
    /**
     * @stability stable
     */
    get azureBlobStorageDataSourceInput(): StorageTransferJobTransferSpecAzureBlobStorageDataSource | undefined;
    private _gcsDataSink;
    /**
     * @stability stable
     */
    get gcsDataSink(): StorageTransferJobTransferSpecGcsDataSinkOutputReference;
    /**
     * @stability stable
     */
    putGcsDataSink(value: StorageTransferJobTransferSpecGcsDataSink): void;
    /**
     * @stability stable
     */
    resetGcsDataSink(): void;
    /**
     * @stability stable
     */
    get gcsDataSinkInput(): StorageTransferJobTransferSpecGcsDataSink | undefined;
    private _gcsDataSource;
    /**
     * @stability stable
     */
    get gcsDataSource(): StorageTransferJobTransferSpecGcsDataSourceOutputReference;
    /**
     * @stability stable
     */
    putGcsDataSource(value: StorageTransferJobTransferSpecGcsDataSource): void;
    /**
     * @stability stable
     */
    resetGcsDataSource(): void;
    /**
     * @stability stable
     */
    get gcsDataSourceInput(): StorageTransferJobTransferSpecGcsDataSource | undefined;
    private _httpDataSource;
    /**
     * @stability stable
     */
    get httpDataSource(): StorageTransferJobTransferSpecHttpDataSourceOutputReference;
    /**
     * @stability stable
     */
    putHttpDataSource(value: StorageTransferJobTransferSpecHttpDataSource): void;
    /**
     * @stability stable
     */
    resetHttpDataSource(): void;
    /**
     * @stability stable
     */
    get httpDataSourceInput(): StorageTransferJobTransferSpecHttpDataSource | undefined;
    private _objectConditions;
    /**
     * @stability stable
     */
    get objectConditions(): StorageTransferJobTransferSpecObjectConditionsOutputReference;
    /**
     * @stability stable
     */
    putObjectConditions(value: StorageTransferJobTransferSpecObjectConditions): void;
    /**
     * @stability stable
     */
    resetObjectConditions(): void;
    /**
     * @stability stable
     */
    get objectConditionsInput(): StorageTransferJobTransferSpecObjectConditions | undefined;
    private _transferOptions;
    /**
     * @stability stable
     */
    get transferOptions(): StorageTransferJobTransferSpecTransferOptionsOutputReference;
    /**
     * @stability stable
     */
    putTransferOptions(value: StorageTransferJobTransferSpecTransferOptions): void;
    /**
     * @stability stable
     */
    resetTransferOptions(): void;
    /**
     * @stability stable
     */
    get transferOptionsInput(): StorageTransferJobTransferSpecTransferOptions | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job.html google_storage_transfer_job}.
 *
 * @stability stable
 */
export declare class StorageTransferJob extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job.html google_storage_transfer_job} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: StorageTransferJobConfig);
    /**
     * @stability stable
     */
    get creationTime(): string;
    /**
     * @stability stable
     */
    get deletionTime(): string;
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get lastModificationTime(): string;
    /**
     * @stability stable
     */
    get name(): string;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _status?;
    /**
     * @stability stable
     */
    get status(): string;
    /**
     * @stability stable
     */
    set status(value: string);
    /**
     * @stability stable
     */
    resetStatus(): void;
    /**
     * @stability stable
     */
    get statusInput(): string | undefined;
    private _schedule;
    /**
     * @stability stable
     */
    get schedule(): StorageTransferJobScheduleOutputReference;
    /**
     * @stability stable
     */
    putSchedule(value: StorageTransferJobSchedule): void;
    /**
     * @stability stable
     */
    get scheduleInput(): StorageTransferJobSchedule | undefined;
    private _transferSpec;
    /**
     * @stability stable
     */
    get transferSpec(): StorageTransferJobTransferSpecOutputReference;
    /**
     * @stability stable
     */
    putTransferSpec(value: StorageTransferJobTransferSpec): void;
    /**
     * @stability stable
     */
    get transferSpecInput(): StorageTransferJobTransferSpec | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
