import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataSnowflakeSequencesConfig extends cdktf.TerraformMetaArguments {
    /**
    * The database from which to return the schemas from.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/d/sequences#database DataSnowflakeSequences#database}
    */
    readonly database: string;
    /**
    * The schema from which to return the sequences from.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/d/sequences#schema DataSnowflakeSequences#schema}
    */
    readonly schema: string;
}
export declare class DataSnowflakeSequencesSequences extends cdktf.ComplexComputedList {
    get comment(): string;
    get database(): string;
    get name(): string;
    get schema(): string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/snowflake/d/sequences snowflake_sequences}
*/
export declare class DataSnowflakeSequences extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/snowflake/d/sequences snowflake_sequences} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataSnowflakeSequencesConfig
    */
    constructor(scope: Construct, id: string, config: DataSnowflakeSequencesConfig);
    private _database?;
    get database(): string;
    set database(value: string);
    get databaseInput(): string | undefined;
    get id(): string;
    private _schema?;
    get schema(): string;
    set schema(value: string);
    get schemaInput(): string | undefined;
    sequences(index: string): DataSnowflakeSequencesSequences;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
