# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from . import _utilities, _tables

__all__ = ['Plugin']


class Plugin(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 config_json: Optional[pulumi.Input[str]] = None,
                 consumer_id: Optional[pulumi.Input[str]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 route_id: Optional[pulumi.Input[str]] = None,
                 service_id: Optional[pulumi.Input[str]] = None,
                 strict_match: Optional[pulumi.Input[bool]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        Create a Plugin resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] config_json: plugin configuration in JSON format, configuration must be a valid JSON object.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['config_json'] = config_json
            __props__['consumer_id'] = consumer_id
            __props__['enabled'] = enabled
            __props__['name'] = name
            __props__['route_id'] = route_id
            __props__['service_id'] = service_id
            __props__['strict_match'] = strict_match
            __props__['computed_config'] = None
        super(Plugin, __self__).__init__(
            'kong:index/plugin:Plugin',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            computed_config: Optional[pulumi.Input[str]] = None,
            config_json: Optional[pulumi.Input[str]] = None,
            consumer_id: Optional[pulumi.Input[str]] = None,
            enabled: Optional[pulumi.Input[bool]] = None,
            name: Optional[pulumi.Input[str]] = None,
            route_id: Optional[pulumi.Input[str]] = None,
            service_id: Optional[pulumi.Input[str]] = None,
            strict_match: Optional[pulumi.Input[bool]] = None) -> 'Plugin':
        """
        Get an existing Plugin resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] config_json: plugin configuration in JSON format, configuration must be a valid JSON object.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["computed_config"] = computed_config
        __props__["config_json"] = config_json
        __props__["consumer_id"] = consumer_id
        __props__["enabled"] = enabled
        __props__["name"] = name
        __props__["route_id"] = route_id
        __props__["service_id"] = service_id
        __props__["strict_match"] = strict_match
        return Plugin(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="computedConfig")
    def computed_config(self) -> pulumi.Output[str]:
        return pulumi.get(self, "computed_config")

    @property
    @pulumi.getter(name="configJson")
    def config_json(self) -> pulumi.Output[Optional[str]]:
        """
        plugin configuration in JSON format, configuration must be a valid JSON object.
        """
        return pulumi.get(self, "config_json")

    @property
    @pulumi.getter(name="consumerId")
    def consumer_id(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "consumer_id")

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[Optional[bool]]:
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="routeId")
    def route_id(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "route_id")

    @property
    @pulumi.getter(name="serviceId")
    def service_id(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "service_id")

    @property
    @pulumi.getter(name="strictMatch")
    def strict_match(self) -> pulumi.Output[Optional[bool]]:
        return pulumi.get(self, "strict_match")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

