# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from . import _utilities, _tables

__all__ = ['Provider']


class Provider(pulumi.ProviderResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 kong_admin_password: Optional[pulumi.Input[str]] = None,
                 kong_admin_token: Optional[pulumi.Input[str]] = None,
                 kong_admin_uri: Optional[pulumi.Input[str]] = None,
                 kong_admin_username: Optional[pulumi.Input[str]] = None,
                 kong_api_key: Optional[pulumi.Input[str]] = None,
                 strict_plugins_match: Optional[pulumi.Input[bool]] = None,
                 tls_skip_verify: Optional[pulumi.Input[bool]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        The provider type for the kong package. By default, resources use package-wide configuration
        settings, however an explicit `Provider` instance may be created and passed during resource
        construction to achieve fine-grained programmatic control over provider settings. See the
        [documentation](https://www.pulumi.com/docs/reference/programming-model/#providers) for more information.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] kong_admin_password: An basic auth password for kong admin
        :param pulumi.Input[str] kong_admin_token: API key for the kong api (Enterprise Edition)
        :param pulumi.Input[str] kong_admin_uri: The address of the kong admin url e.g. http://localhost:8001
        :param pulumi.Input[str] kong_admin_username: An basic auth user for kong admin
        :param pulumi.Input[str] kong_api_key: API key for the kong api (if you have locked it down)
        :param pulumi.Input[bool] strict_plugins_match: Should plugins `config_json` field strictly match plugin configuration
        :param pulumi.Input[bool] tls_skip_verify: Whether to skip tls verify for https kong api endpoint using self signed or untrusted certs
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['kong_admin_password'] = kong_admin_password
            __props__['kong_admin_token'] = kong_admin_token
            if kong_admin_uri is None and not opts.urn:
                raise TypeError("Missing required property 'kong_admin_uri'")
            __props__['kong_admin_uri'] = kong_admin_uri
            __props__['kong_admin_username'] = kong_admin_username
            __props__['kong_api_key'] = kong_api_key
            if strict_plugins_match is None:
                strict_plugins_match = _utilities.get_env_bool('STRICT_PLUGINS_MATCH')
            __props__['strict_plugins_match'] = pulumi.Output.from_input(strict_plugins_match).apply(pulumi.runtime.to_json) if strict_plugins_match is not None else None
            if tls_skip_verify is None:
                tls_skip_verify = (_utilities.get_env_bool('TLS_SKIP_VERIFY') or False)
            __props__['tls_skip_verify'] = pulumi.Output.from_input(tls_skip_verify).apply(pulumi.runtime.to_json) if tls_skip_verify is not None else None
        super(Provider, __self__).__init__(
            'kong',
            resource_name,
            __props__,
            opts)

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

