# API Reference <a name="API Reference" id="api-reference"></a>

## Constructs <a name="Constructs" id="Constructs"></a>

### SecureBucket <a name="SecureBucket" id="vaughntech-secure-s3-bucket.SecureBucket"></a>

#### Initializers <a name="Initializers" id="vaughntech-secure-s3-bucket.SecureBucket.Initializer"></a>

```typescript
import { SecureBucket } from 'vaughntech-secure-s3-bucket'

new SecureBucket(parent: Stack, name: string, props?: BucketProps)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#vaughntech-secure-s3-bucket.SecureBucket.Initializer.parameter.parent">parent</a></code> | <code>aws-cdk-lib.Stack</code> | *No description.* |
| <code><a href="#vaughntech-secure-s3-bucket.SecureBucket.Initializer.parameter.name">name</a></code> | <code>string</code> | *No description.* |
| <code><a href="#vaughntech-secure-s3-bucket.SecureBucket.Initializer.parameter.props">props</a></code> | <code>aws-cdk-lib.aws_s3.BucketProps</code> | *No description.* |

---

##### `parent`<sup>Required</sup> <a name="parent" id="vaughntech-secure-s3-bucket.SecureBucket.Initializer.parameter.parent"></a>

- *Type:* aws-cdk-lib.Stack

---

##### `name`<sup>Required</sup> <a name="name" id="vaughntech-secure-s3-bucket.SecureBucket.Initializer.parameter.name"></a>

- *Type:* string

---

##### `props`<sup>Optional</sup> <a name="props" id="vaughntech-secure-s3-bucket.SecureBucket.Initializer.parameter.props"></a>

- *Type:* aws-cdk-lib.aws_s3.BucketProps

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#vaughntech-secure-s3-bucket.SecureBucket.toString">toString</a></code> | Returns a string representation of this construct. |

---

##### `toString` <a name="toString" id="vaughntech-secure-s3-bucket.SecureBucket.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#vaughntech-secure-s3-bucket.SecureBucket.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |

---

##### ~~`isConstruct`~~ <a name="isConstruct" id="vaughntech-secure-s3-bucket.SecureBucket.isConstruct"></a>

```typescript
import { SecureBucket } from 'vaughntech-secure-s3-bucket'

SecureBucket.isConstruct(x: any)
```

Checks if `x` is a construct.

###### `x`<sup>Required</sup> <a name="x" id="vaughntech-secure-s3-bucket.SecureBucket.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#vaughntech-secure-s3-bucket.SecureBucket.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#vaughntech-secure-s3-bucket.SecureBucket.property.bucket">bucket</a></code> | <code>aws-cdk-lib.aws_s3.Bucket</code> | the returned bucket instance. |
| <code><a href="#vaughntech-secure-s3-bucket.SecureBucket.property.bucketKMSKey">bucketKMSKey</a></code> | <code>aws-cdk-lib.aws_kms.Key</code> | the returned KMS Key instance. |
| <code><a href="#vaughntech-secure-s3-bucket.SecureBucket.property.encryption">encryption</a></code> | <code>aws-cdk-lib.aws_s3.BucketEncryption</code> | sets the bucket encryption type. |

---

##### `node`<sup>Required</sup> <a name="node" id="vaughntech-secure-s3-bucket.SecureBucket.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `bucket`<sup>Required</sup> <a name="bucket" id="vaughntech-secure-s3-bucket.SecureBucket.property.bucket"></a>

```typescript
public readonly bucket: Bucket;
```

- *Type:* aws-cdk-lib.aws_s3.Bucket

the returned bucket instance.

---

##### `bucketKMSKey`<sup>Required</sup> <a name="bucketKMSKey" id="vaughntech-secure-s3-bucket.SecureBucket.property.bucketKMSKey"></a>

```typescript
public readonly bucketKMSKey: Key;
```

- *Type:* aws-cdk-lib.aws_kms.Key

the returned KMS Key instance.

---

##### `encryption`<sup>Required</sup> <a name="encryption" id="vaughntech-secure-s3-bucket.SecureBucket.property.encryption"></a>

```typescript
public readonly encryption: BucketEncryption;
```

- *Type:* aws-cdk-lib.aws_s3.BucketEncryption

sets the bucket encryption type.

---





