"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.IntegTesting = void 0;
const aws_cdk_lib_1 = require("aws-cdk-lib");
//import { BucketEncryption } from 'aws-cdk-lib/aws-s3';
const index_1 = require("./index");
const aws_region = 'us-east-2';
const solution = 'secureS3bucketconstruct';
const environment = 'dev';
const costcenter = 'bex';
class IntegTesting {
    constructor() {
        const env = {
            account: process.env.CDK_DEFAULT_ACCOUNT,
            region: aws_region || process.env.CDK_DEFAULT_REGION,
        };
        const app = new aws_cdk_lib_1.App();
        const stack = new aws_cdk_lib_1.Stack(app, 'SecureBucketStack', {
            env,
            tags: {
                solution,
                environment,
                costcenter,
            },
        });
        new index_1.SecureBucket(stack, 'secure-bucket-construct', {
            bucketName: `projen-secure-bucket-construct-${aws_region}`,
            autoDeleteObjects: true,
        });
        this.stack = [stack];
    }
}
exports.IntegTesting = IntegTesting;
new IntegTesting();
//# sourceMappingURL=data:application/json;base64,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