from skidl import SKIDL, TEMPLATE, Part, Pin, SchLib

SKIDL_lib_version = '0.0.1'

_74xx = SchLib(tool=SKIDL).add_parts(*[
        Part(name='74469',dest=TEMPLATE,tool=SKIDL,do_erc=True),
        Part(name='74AHC1G04',dest=TEMPLATE,tool=SKIDL,do_erc=True),
        Part(name='74AHC1G14',dest=TEMPLATE,tool=SKIDL,description='inverting buffer with Schmitt trigger.',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='3',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='~',do_erc=True),
            Pin(num='4',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='2',name='~',do_erc=True),
            Pin(num='4',name='~',func=Pin.OUTPUT,do_erc=True)]),
        Part(name='74CBTLV3861',dest=TEMPLATE,tool=SKIDL,do_erc=True),
        Part(name='74HC240',dest=TEMPLATE,tool=SKIDL,keywords='octal buffer line driver inverting',description='8 bit buffer; 3-state; inverting',ref_prefix='U',num_units=1,fplist=['DIP*W7.62mm*', 'SOIC*7.5x12.8mm*Pitch1.27mm*', 'TSSOP*4.4x6.5mm*Pitch0.65mm*', 'SSOP*4.4x6.5mm*Pitch0.65mm*'],do_erc=True,aliases=['74HCT240'],pins=[
            Pin(num='10',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='20',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='1OE',do_erc=True),
            Pin(num='2',name='1A0',do_erc=True),
            Pin(num='3',name='2Y0',do_erc=True),
            Pin(num='4',name='1A1',do_erc=True),
            Pin(num='5',name='2Y1',do_erc=True),
            Pin(num='6',name='1A2',do_erc=True),
            Pin(num='7',name='2Y2',do_erc=True),
            Pin(num='8',name='1A3',do_erc=True),
            Pin(num='9',name='2Y3',do_erc=True),
            Pin(num='11',name='2A3',func=Pin.TRISTATE,do_erc=True),
            Pin(num='12',name='1Y3',func=Pin.TRISTATE,do_erc=True),
            Pin(num='13',name='2A2',func=Pin.TRISTATE,do_erc=True),
            Pin(num='14',name='1Y2',func=Pin.TRISTATE,do_erc=True),
            Pin(num='15',name='2A1',func=Pin.TRISTATE,do_erc=True),
            Pin(num='16',name='1Y1',func=Pin.TRISTATE,do_erc=True),
            Pin(num='17',name='2A0',func=Pin.TRISTATE,do_erc=True),
            Pin(num='18',name='1Y0',func=Pin.TRISTATE,do_erc=True),
            Pin(num='19',name='2OE',do_erc=True)]),
        Part(name='74HC244',dest=TEMPLATE,tool=SKIDL,keywords='TTL BUFFER 3State',description='8bits Buffer/Line Driver 3 state',ref_prefix='U',num_units=1,fplist=['TSSOP*4.4x6.5mm*Pitch0.65mm*', 'SSOP*4.4x6.5mm*Pitch0.65mm*'],do_erc=True,aliases=['74HCT244'],pins=[
            Pin(num='10',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='20',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='1OE',do_erc=True),
            Pin(num='2',name='1A0',do_erc=True),
            Pin(num='3',name='2Y0',func=Pin.OUTPUT,do_erc=True),
            Pin(num='4',name='1A1',do_erc=True),
            Pin(num='5',name='2Y1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='6',name='1A2',do_erc=True),
            Pin(num='7',name='2Y2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='8',name='1A3',do_erc=True),
            Pin(num='9',name='2Y3',func=Pin.OUTPUT,do_erc=True),
            Pin(num='11',name='2A3',do_erc=True),
            Pin(num='12',name='1Y3',func=Pin.OUTPUT,do_erc=True),
            Pin(num='13',name='2A2',do_erc=True),
            Pin(num='14',name='1Y2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='15',name='2A1',do_erc=True),
            Pin(num='16',name='1Y1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='17',name='2A0',do_erc=True),
            Pin(num='18',name='1Y0',func=Pin.OUTPUT,do_erc=True),
            Pin(num='19',name='2OE',do_erc=True)]),
        Part(name='74HC595',dest=TEMPLATE,tool=SKIDL,keywords='HCMOS SR OpenCol',description='8 bits serial in // out Shift Register Open Collect.',ref_prefix='U',num_units=1,do_erc=True,aliases=['74LS596', '74LS595'],pins=[
            Pin(num='1',name='QB',func=Pin.TRISTATE,do_erc=True),
            Pin(num='2',name='QC',func=Pin.TRISTATE,do_erc=True),
            Pin(num='3',name='QD',func=Pin.TRISTATE,do_erc=True),
            Pin(num='4',name='QE',func=Pin.TRISTATE,do_erc=True),
            Pin(num='5',name='QF',func=Pin.TRISTATE,do_erc=True),
            Pin(num='6',name='QG',func=Pin.TRISTATE,do_erc=True),
            Pin(num='7',name='QH',func=Pin.TRISTATE,do_erc=True),
            Pin(num='8',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='~QH',func=Pin.OUTPUT,do_erc=True),
            Pin(num='10',name='SRCLR',do_erc=True),
            Pin(num='11',name='SRCLK',do_erc=True),
            Pin(num='12',name='RCLK',do_erc=True),
            Pin(num='13',name='G',do_erc=True),
            Pin(num='14',name='SER',do_erc=True),
            Pin(num='15',name='QA',func=Pin.TRISTATE,do_erc=True),
            Pin(num='16',name='VCC',func=Pin.PWRIN,do_erc=True)]),
        Part(name='74HCT04',dest=TEMPLATE,tool=SKIDL,keywords='TTL not inv',description='Hex inverseur schmitt trigger',ref_prefix='U',num_units=6,do_erc=True,aliases=['74HC14', '74HC04', '74LS14'],pins=[
            Pin(num='7',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='14',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='~',do_erc=True),
            Pin(num='2',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='3',name='~',do_erc=True),
            Pin(num='4',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='5',name='~',do_erc=True),
            Pin(num='6',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='8',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='9',name='~',do_erc=True),
            Pin(num='10',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='11',name='~',do_erc=True),
            Pin(num='12',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='13',name='~',do_erc=True),
            Pin(num='1',name='~',do_erc=True),
            Pin(num='2',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='3',name='~',do_erc=True),
            Pin(num='4',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='5',name='~',do_erc=True),
            Pin(num='6',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='8',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='9',name='~',do_erc=True),
            Pin(num='10',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='11',name='~',do_erc=True),
            Pin(num='12',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='13',name='~',do_erc=True)]),
        Part(name='74HCT541_PWR',dest=TEMPLATE,tool=SKIDL,keywords='TTL BUFFER 3State BUS',description='8bits Buffer/Line Driver 3 state Out',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='10',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='20',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='G1',do_erc=True),
            Pin(num='2',name='A0',do_erc=True),
            Pin(num='3',name='A1',do_erc=True),
            Pin(num='4',name='A2',do_erc=True),
            Pin(num='5',name='A3',do_erc=True),
            Pin(num='6',name='A4',do_erc=True),
            Pin(num='7',name='A5',do_erc=True),
            Pin(num='8',name='A6',do_erc=True),
            Pin(num='9',name='A7',do_erc=True),
            Pin(num='11',name='Y7',func=Pin.TRISTATE,do_erc=True),
            Pin(num='12',name='Y6',func=Pin.TRISTATE,do_erc=True),
            Pin(num='13',name='Y5',func=Pin.TRISTATE,do_erc=True),
            Pin(num='14',name='Y4',func=Pin.TRISTATE,do_erc=True),
            Pin(num='15',name='Y3',func=Pin.TRISTATE,do_erc=True),
            Pin(num='16',name='Y2',func=Pin.TRISTATE,do_erc=True),
            Pin(num='17',name='Y1',func=Pin.TRISTATE,do_erc=True),
            Pin(num='18',name='Y0',func=Pin.TRISTATE,do_erc=True),
            Pin(num='19',name='G2',do_erc=True)]),
        Part(name='74HCT574_PWR',dest=TEMPLATE,tool=SKIDL,keywords='TTL REG DFF DFF8 3State',description='8 bits Register, 3 state Out, with visible Pins power',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='10',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='20',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='OE',do_erc=True),
            Pin(num='2',name='D0',do_erc=True),
            Pin(num='3',name='D1',do_erc=True),
            Pin(num='4',name='D2',do_erc=True),
            Pin(num='5',name='D3',do_erc=True),
            Pin(num='6',name='D4',do_erc=True),
            Pin(num='7',name='D5',do_erc=True),
            Pin(num='8',name='D6',do_erc=True),
            Pin(num='9',name='D7',do_erc=True),
            Pin(num='11',name='Cp',do_erc=True),
            Pin(num='12',name='Q7',func=Pin.TRISTATE,do_erc=True),
            Pin(num='13',name='Q6',func=Pin.TRISTATE,do_erc=True),
            Pin(num='14',name='Q5',func=Pin.TRISTATE,do_erc=True),
            Pin(num='15',name='Q4',func=Pin.TRISTATE,do_erc=True),
            Pin(num='16',name='Q3',func=Pin.TRISTATE,do_erc=True),
            Pin(num='17',name='Q2',func=Pin.TRISTATE,do_erc=True),
            Pin(num='18',name='Q1',func=Pin.TRISTATE,do_erc=True),
            Pin(num='19',name='Q0',func=Pin.TRISTATE,do_erc=True)]),
        Part(name='74LS00',dest=TEMPLATE,tool=SKIDL,keywords='TTL nand2 buffer',description='Quad Buffer nand2',ref_prefix='U',num_units=4,fplist=['14DIP300*', 'SO14*'],do_erc=True,aliases=['74LS37', '7400', '74HCT00', '74HC00'],pins=[
            Pin(num='7',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='14',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='~',do_erc=True),
            Pin(num='2',name='~',do_erc=True),
            Pin(num='3',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='4',name='~',do_erc=True),
            Pin(num='5',name='~',do_erc=True),
            Pin(num='6',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='8',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='9',name='~',do_erc=True),
            Pin(num='10',name='~',do_erc=True),
            Pin(num='11',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='12',name='~',do_erc=True),
            Pin(num='13',name='~',do_erc=True),
            Pin(num='1',name='~',do_erc=True),
            Pin(num='2',name='~',do_erc=True),
            Pin(num='3',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='4',name='~',do_erc=True),
            Pin(num='5',name='~',do_erc=True),
            Pin(num='6',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='8',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='9',name='~',do_erc=True),
            Pin(num='10',name='~',do_erc=True),
            Pin(num='11',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='12',name='~',do_erc=True),
            Pin(num='13',name='~',do_erc=True)]),
        Part(name='74LS01',dest=TEMPLATE,tool=SKIDL,keywords='TTL nand2 opencol',description='Quad nand2 open collect.',ref_prefix='U',num_units=4,do_erc=True,pins=[
            Pin(num='7',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='14',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='~',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='2',name='~',do_erc=True),
            Pin(num='3',name='~',do_erc=True),
            Pin(num='4',name='~',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='5',name='~',do_erc=True),
            Pin(num='6',name='~',do_erc=True),
            Pin(num='8',name='~',do_erc=True),
            Pin(num='9',name='~',do_erc=True),
            Pin(num='10',name='~',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='11',name='~',do_erc=True),
            Pin(num='12',name='~',do_erc=True),
            Pin(num='13',name='~',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='1',name='~',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='2',name='~',do_erc=True),
            Pin(num='3',name='~',do_erc=True),
            Pin(num='4',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='5',name='~',do_erc=True),
            Pin(num='6',name='~',do_erc=True),
            Pin(num='8',name='~',do_erc=True),
            Pin(num='9',name='~',do_erc=True),
            Pin(num='10',name='~',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='11',name='~',do_erc=True),
            Pin(num='12',name='~',do_erc=True),
            Pin(num='13',name='~',func=Pin.OPENCOLL,do_erc=True)]),
        Part(name='74LS02',dest=TEMPLATE,tool=SKIDL,keywords='TTL Nor2 Buffer',description='Quad Buffer Nor2',ref_prefix='U',num_units=4,fplist=['SO14*', '14DIP*'],do_erc=True,aliases=['74HC02', '74HCT02', '7402', '74LS28'],pins=[
            Pin(num='7',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='14',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='2',name='~',do_erc=True),
            Pin(num='3',name='~',do_erc=True),
            Pin(num='4',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='5',name='~',do_erc=True),
            Pin(num='6',name='~',do_erc=True),
            Pin(num='8',name='~',do_erc=True),
            Pin(num='9',name='~',do_erc=True),
            Pin(num='10',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='11',name='~',do_erc=True),
            Pin(num='12',name='~',do_erc=True),
            Pin(num='13',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='1',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='2',name='~',do_erc=True),
            Pin(num='3',name='~',do_erc=True),
            Pin(num='4',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='5',name='~',do_erc=True),
            Pin(num='6',name='~',do_erc=True),
            Pin(num='8',name='~',do_erc=True),
            Pin(num='9',name='~',do_erc=True),
            Pin(num='10',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='11',name='~',do_erc=True),
            Pin(num='12',name='~',do_erc=True),
            Pin(num='13',name='~',func=Pin.OUTPUT,do_erc=True)]),
        Part(name='74LS03',dest=TEMPLATE,tool=SKIDL,keywords='TTL Nand2 OpenCol',description='Quad Nand2 open collect',ref_prefix='U',num_units=4,do_erc=True,pins=[
            Pin(num='7',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='14',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='~',do_erc=True),
            Pin(num='2',name='~',do_erc=True),
            Pin(num='3',name='~',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='4',name='~',do_erc=True),
            Pin(num='5',name='~',do_erc=True),
            Pin(num='6',name='~',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='8',name='~',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='9',name='~',do_erc=True),
            Pin(num='10',name='~',do_erc=True),
            Pin(num='11',name='~',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='12',name='~',do_erc=True),
            Pin(num='13',name='~',do_erc=True),
            Pin(num='1',name='~',do_erc=True),
            Pin(num='2',name='~',do_erc=True),
            Pin(num='3',name='~',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='4',name='~',do_erc=True),
            Pin(num='5',name='~',do_erc=True),
            Pin(num='6',name='~',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='8',name='~',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='9',name='~',do_erc=True),
            Pin(num='10',name='~',do_erc=True),
            Pin(num='11',name='~',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='12',name='~',do_erc=True),
            Pin(num='13',name='~',do_erc=True)]),
        Part(name='74LS04',dest=TEMPLATE,tool=SKIDL,keywords='TTL not inv',description='Hex Inverseur',ref_prefix='U',num_units=6,do_erc=True,pins=[
            Pin(num='7',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='14',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='~',do_erc=True),
            Pin(num='2',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='3',name='~',do_erc=True),
            Pin(num='4',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='5',name='~',do_erc=True),
            Pin(num='6',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='8',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='9',name='~',do_erc=True),
            Pin(num='10',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='11',name='~',do_erc=True),
            Pin(num='12',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='13',name='~',do_erc=True),
            Pin(num='1',name='~',do_erc=True),
            Pin(num='2',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='3',name='~',do_erc=True),
            Pin(num='4',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='5',name='~',do_erc=True),
            Pin(num='6',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='8',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='9',name='~',do_erc=True),
            Pin(num='10',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='11',name='~',do_erc=True),
            Pin(num='12',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='13',name='~',do_erc=True)]),
        Part(name='74LS05',dest=TEMPLATE,tool=SKIDL,keywords='TTL not inv OpenCol',description='Inverseur Open Collect',ref_prefix='U',num_units=6,do_erc=True,aliases=['74LS06', '74LS06N'],pins=[
            Pin(num='7',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='14',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='~',do_erc=True),
            Pin(num='2',name='~',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='3',name='~',do_erc=True),
            Pin(num='4',name='~',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='5',name='~',do_erc=True),
            Pin(num='6',name='~',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='8',name='~',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='9',name='~',do_erc=True),
            Pin(num='10',name='~',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='11',name='~',do_erc=True),
            Pin(num='12',name='~',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='13',name='~',do_erc=True),
            Pin(num='1',name='~',do_erc=True),
            Pin(num='2',name='~',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='3',name='~',do_erc=True),
            Pin(num='4',name='~',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='5',name='~',do_erc=True),
            Pin(num='6',name='~',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='8',name='~',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='9',name='~',do_erc=True),
            Pin(num='10',name='~',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='11',name='~',do_erc=True),
            Pin(num='12',name='~',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='13',name='~',do_erc=True)]),
        Part(name='74LS08',dest=TEMPLATE,tool=SKIDL,keywords='TTL and2 OpenCol',description='Quad And2 Open Collect',ref_prefix='U',num_units=4,do_erc=True,aliases=['74LS09'],pins=[
            Pin(num='7',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='14',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='~',do_erc=True),
            Pin(num='2',name='~',do_erc=True),
            Pin(num='3',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='4',name='~',do_erc=True),
            Pin(num='5',name='~',do_erc=True),
            Pin(num='6',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='8',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='9',name='~',do_erc=True),
            Pin(num='10',name='~',do_erc=True),
            Pin(num='11',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='12',name='~',do_erc=True),
            Pin(num='13',name='~',do_erc=True),
            Pin(num='1',name='~',do_erc=True),
            Pin(num='2',name='~',do_erc=True),
            Pin(num='3',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='4',name='~',do_erc=True),
            Pin(num='5',name='~',do_erc=True),
            Pin(num='6',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='8',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='9',name='~',do_erc=True),
            Pin(num='10',name='~',do_erc=True),
            Pin(num='11',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='12',name='~',do_erc=True),
            Pin(num='13',name='~',do_erc=True)]),
        Part(name='74LS10',dest=TEMPLATE,tool=SKIDL,keywords='TTL Nand3',description='Triple Nand3',ref_prefix='U',num_units=3,do_erc=True,pins=[
            Pin(num='7',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='14',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='~',do_erc=True),
            Pin(num='2',name='~',do_erc=True),
            Pin(num='12',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='13',name='~',do_erc=True),
            Pin(num='3',name='~',do_erc=True),
            Pin(num='4',name='~',do_erc=True),
            Pin(num='5',name='~',do_erc=True),
            Pin(num='6',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='8',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='9',name='~',do_erc=True),
            Pin(num='10',name='~',do_erc=True),
            Pin(num='11',name='~',do_erc=True),
            Pin(num='1',name='~',do_erc=True),
            Pin(num='2',name='~',do_erc=True),
            Pin(num='12',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='13',name='~',do_erc=True),
            Pin(num='3',name='~',do_erc=True),
            Pin(num='4',name='~',do_erc=True),
            Pin(num='5',name='~',do_erc=True),
            Pin(num='6',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='8',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='9',name='~',do_erc=True),
            Pin(num='10',name='~',do_erc=True),
            Pin(num='11',name='~',do_erc=True)]),
        Part(name='74LS107',dest=TEMPLATE,tool=SKIDL,keywords='TTL JK',description='Double JK FlipFlop, reset',ref_prefix='U',num_units=2,do_erc=True,pins=[
            Pin(num='7',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='14',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='J',do_erc=True),
            Pin(num='2',name='~Q',func=Pin.OUTPUT,do_erc=True),
            Pin(num='3',name='Q',func=Pin.OUTPUT,do_erc=True),
            Pin(num='4',name='K',do_erc=True),
            Pin(num='12',name='Cp',do_erc=True),
            Pin(num='13',name='Cd',do_erc=True),
            Pin(num='5',name='Q',func=Pin.OUTPUT,do_erc=True),
            Pin(num='6',name='~Q',func=Pin.OUTPUT,do_erc=True),
            Pin(num='8',name='J',do_erc=True),
            Pin(num='9',name='Cp',do_erc=True),
            Pin(num='10',name='Cd',do_erc=True),
            Pin(num='11',name='K',do_erc=True)]),
        Part(name='74LS109',dest=TEMPLATE,tool=SKIDL,keywords='TTL JK',description='Double JK FlipFlop, Set & Reset',ref_prefix='U',num_units=2,do_erc=True,pins=[
            Pin(num='8',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='Cd',do_erc=True),
            Pin(num='2',name='J',do_erc=True),
            Pin(num='3',name='K',do_erc=True),
            Pin(num='4',name='Cp',do_erc=True),
            Pin(num='5',name='Sd',do_erc=True),
            Pin(num='6',name='Q',func=Pin.OUTPUT,do_erc=True),
            Pin(num='7',name='~Q',func=Pin.OUTPUT,do_erc=True),
            Pin(num='9',name='~Q',do_erc=True),
            Pin(num='10',name='Q',do_erc=True),
            Pin(num='11',name='Sd',do_erc=True),
            Pin(num='12',name='Cp',do_erc=True),
            Pin(num='13',name='K',do_erc=True),
            Pin(num='14',name='J',do_erc=True),
            Pin(num='15',name='Cd',do_erc=True)]),
        Part(name='74LS11',dest=TEMPLATE,tool=SKIDL,keywords='TTL And3',description='Triple And3',ref_prefix='U',num_units=3,do_erc=True,pins=[
            Pin(num='7',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='14',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='~',do_erc=True),
            Pin(num='2',name='~',do_erc=True),
            Pin(num='12',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='13',name='~',do_erc=True),
            Pin(num='3',name='~',do_erc=True),
            Pin(num='4',name='~',do_erc=True),
            Pin(num='5',name='~',do_erc=True),
            Pin(num='6',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='8',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='9',name='~',do_erc=True),
            Pin(num='10',name='~',do_erc=True),
            Pin(num='11',name='~',do_erc=True),
            Pin(num='1',name='~',do_erc=True),
            Pin(num='2',name='~',do_erc=True),
            Pin(num='12',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='13',name='~',do_erc=True),
            Pin(num='3',name='~',do_erc=True),
            Pin(num='4',name='~',do_erc=True),
            Pin(num='5',name='~',do_erc=True),
            Pin(num='6',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='8',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='9',name='~',do_erc=True),
            Pin(num='10',name='~',do_erc=True),
            Pin(num='11',name='~',do_erc=True)]),
        Part(name='74LS112',dest=TEMPLATE,tool=SKIDL,keywords='TTL JK',description='Double JK FlipFlop, Set & Reset',ref_prefix='U',num_units=2,do_erc=True,pins=[
            Pin(num='8',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='Cp',do_erc=True),
            Pin(num='2',name='K',do_erc=True),
            Pin(num='3',name='J',do_erc=True),
            Pin(num='4',name='Sd',do_erc=True),
            Pin(num='5',name='Q',func=Pin.OUTPUT,do_erc=True),
            Pin(num='6',name='~Q',func=Pin.OUTPUT,do_erc=True),
            Pin(num='15',name='Cd',do_erc=True),
            Pin(num='7',name='~Q',func=Pin.OUTPUT,do_erc=True),
            Pin(num='9',name='Q',func=Pin.OUTPUT,do_erc=True),
            Pin(num='10',name='Sd',do_erc=True),
            Pin(num='11',name='J',do_erc=True),
            Pin(num='12',name='K',do_erc=True),
            Pin(num='13',name='Cp',do_erc=True),
            Pin(num='14',name='Cd',do_erc=True)]),
        Part(name='74LS113',dest=TEMPLATE,tool=SKIDL,keywords='TTL JK',description='Double JK, Set',ref_prefix='U',num_units=2,do_erc=True,pins=[
            Pin(num='7',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='14',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='Cp',do_erc=True),
            Pin(num='2',name='K',do_erc=True),
            Pin(num='3',name='J',do_erc=True),
            Pin(num='4',name='Sd',do_erc=True),
            Pin(num='5',name='Q',func=Pin.OUTPUT,do_erc=True),
            Pin(num='6',name='~Q',func=Pin.OUTPUT,do_erc=True),
            Pin(num='8',name='~Q',do_erc=True),
            Pin(num='9',name='Q',do_erc=True),
            Pin(num='10',name='Sd',do_erc=True),
            Pin(num='11',name='J',do_erc=True),
            Pin(num='12',name='K',do_erc=True),
            Pin(num='13',name='Cp',do_erc=True)]),
        Part(name='74LS114',dest=TEMPLATE,tool=SKIDL,keywords='TTL JK',description='Double JK, common Clock & Reset, Set',ref_prefix='U',num_units=2,do_erc=True,pins=[
            Pin(num='7',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='14',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='~',do_erc=True),
            Pin(num='1',name='Cp',do_erc=True),
            Pin(num='2',name='K',do_erc=True),
            Pin(num='3',name='J',do_erc=True),
            Pin(num='4',name='Sd',do_erc=True),
            Pin(num='5',name='Q',func=Pin.OUTPUT,do_erc=True),
            Pin(num='6',name='~Q',func=Pin.OUTPUT,do_erc=True),
            Pin(num='8',name='~Q',do_erc=True),
            Pin(num='9',name='Q',do_erc=True),
            Pin(num='10',name='Sd',do_erc=True),
            Pin(num='11',name='J',do_erc=True),
            Pin(num='12',name='K',do_erc=True),
            Pin(num='13',name='Cp',do_erc=True)]),
        Part(name='74LS12',dest=TEMPLATE,tool=SKIDL,keywords='TTL Nand3 OpenCol',description='Triple Nand3 Open Collect',ref_prefix='U',num_units=3,do_erc=True,pins=[
            Pin(num='7',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='14',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='~',do_erc=True),
            Pin(num='2',name='~',do_erc=True),
            Pin(num='12',name='~',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='13',name='~',do_erc=True),
            Pin(num='3',name='~',do_erc=True),
            Pin(num='4',name='~',do_erc=True),
            Pin(num='5',name='~',do_erc=True),
            Pin(num='6',name='~',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='8',name='~',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='9',name='~',do_erc=True),
            Pin(num='10',name='~',do_erc=True),
            Pin(num='11',name='~',do_erc=True),
            Pin(num='1',name='~',do_erc=True),
            Pin(num='2',name='~',do_erc=True),
            Pin(num='12',name='~',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='13',name='~',do_erc=True),
            Pin(num='3',name='~',do_erc=True),
            Pin(num='4',name='~',do_erc=True),
            Pin(num='5',name='~',do_erc=True),
            Pin(num='6',name='~',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='8',name='~',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='9',name='~',do_erc=True),
            Pin(num='10',name='~',do_erc=True),
            Pin(num='11',name='~',do_erc=True)]),
        Part(name='74LS121',dest=TEMPLATE,tool=SKIDL,do_erc=True),
        Part(name='74LS122',dest=TEMPLATE,tool=SKIDL,keywords='TTL monostable',description='Retriggerable Monostable',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='7',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='A1',do_erc=True),
            Pin(num='2',name='A2',do_erc=True),
            Pin(num='3',name='B1',do_erc=True),
            Pin(num='4',name='B2',do_erc=True),
            Pin(num='5',name='Clr',do_erc=True),
            Pin(num='6',name='~Q',func=Pin.OUTPUT,do_erc=True),
            Pin(num='8',name='Q',func=Pin.OUTPUT,do_erc=True),
            Pin(num='9',name='Rint',do_erc=True),
            Pin(num='11',name='Cext',do_erc=True),
            Pin(num='13',name='R/Cext',do_erc=True),
            Pin(num='14',name='VCC',func=Pin.PWRIN,do_erc=True)]),
        Part(name='74LS123',dest=TEMPLATE,tool=SKIDL,keywords='TTL monostable',description='Dual retriggerable Monostable',ref_prefix='U',num_units=2,do_erc=True,pins=[
            Pin(num='8',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='A',do_erc=True),
            Pin(num='2',name='B',do_erc=True),
            Pin(num='3',name='Clr',do_erc=True),
            Pin(num='4',name='~Q',func=Pin.OUTPUT,do_erc=True),
            Pin(num='13',name='Q',func=Pin.OUTPUT,do_erc=True),
            Pin(num='14',name='Cext',do_erc=True),
            Pin(num='15',name='RCext',do_erc=True),
            Pin(num='5',name='Q',func=Pin.OUTPUT,do_erc=True),
            Pin(num='6',name='Cext',do_erc=True),
            Pin(num='7',name='RCext',do_erc=True),
            Pin(num='9',name='A',do_erc=True),
            Pin(num='10',name='B',do_erc=True),
            Pin(num='11',name='Clr',do_erc=True),
            Pin(num='12',name='~Q',func=Pin.OUTPUT,do_erc=True)]),
        Part(name='74LS125',dest=TEMPLATE,tool=SKIDL,keywords='TTL buffer 3State',description='Quad buffer 3 State out',ref_prefix='U',num_units=4,do_erc=True,aliases=['74LVC125'],pins=[
            Pin(num='7',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='14',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='E',do_erc=True),
            Pin(num='4',name='E',do_erc=True),
            Pin(num='10',name='E',do_erc=True),
            Pin(num='13',name='E',do_erc=True),
            Pin(num='2',name='D',do_erc=True),
            Pin(num='3',name='O',func=Pin.TRISTATE,do_erc=True),
            Pin(num='5',name='D',do_erc=True),
            Pin(num='6',name='O',func=Pin.TRISTATE,do_erc=True),
            Pin(num='8',name='O',func=Pin.TRISTATE,do_erc=True),
            Pin(num='9',name='D',do_erc=True),
            Pin(num='11',name='O',func=Pin.TRISTATE,do_erc=True),
            Pin(num='12',name='D',do_erc=True)]),
        Part(name='74LS126',dest=TEMPLATE,tool=SKIDL,keywords='TTL Buffer 3State',description='Quad buffer 3 State out',ref_prefix='U',num_units=4,do_erc=True,pins=[
            Pin(num='7',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='14',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='E',do_erc=True),
            Pin(num='4',name='E',do_erc=True),
            Pin(num='10',name='E',do_erc=True),
            Pin(num='13',name='E',do_erc=True),
            Pin(num='2',name='~',do_erc=True),
            Pin(num='3',name='~',func=Pin.TRISTATE,do_erc=True),
            Pin(num='5',name='D',do_erc=True),
            Pin(num='6',name='O',func=Pin.TRISTATE,do_erc=True),
            Pin(num='8',name='~',func=Pin.TRISTATE,do_erc=True),
            Pin(num='9',name='D',do_erc=True),
            Pin(num='11',name='~',func=Pin.TRISTATE,do_erc=True),
            Pin(num='12',name='~',do_erc=True)]),
        Part(name='74LS13',dest=TEMPLATE,tool=SKIDL,keywords='TTL Nand4',description='Double Nand4 schmitt trigger',ref_prefix='U',num_units=2,do_erc=True,pins=[
            Pin(num='7',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='14',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='~',do_erc=True),
            Pin(num='2',name='~',do_erc=True),
            Pin(num='4',name='~',do_erc=True),
            Pin(num='5',name='~',do_erc=True),
            Pin(num='6',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='8',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='9',name='~',do_erc=True),
            Pin(num='10',name='~',do_erc=True),
            Pin(num='12',name='~',do_erc=True),
            Pin(num='13',name='~',do_erc=True),
            Pin(num='1',name='~',do_erc=True),
            Pin(num='2',name='~',do_erc=True),
            Pin(num='4',name='~',do_erc=True),
            Pin(num='5',name='~',do_erc=True),
            Pin(num='6',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='8',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='9',name='~',do_erc=True),
            Pin(num='10',name='~',do_erc=True),
            Pin(num='12',name='~',do_erc=True),
            Pin(num='13',name='~',do_erc=True),
            Pin(num='8',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='9',name='~',do_erc=True),
            Pin(num='10',name='~',do_erc=True),
            Pin(num='11',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='12',name='~',do_erc=True),
            Pin(num='13',name='~',do_erc=True)]),
        Part(name='74LS132',dest=TEMPLATE,tool=SKIDL,keywords='TTL Nand2',description='Quad Nand2 schmitt trigger',ref_prefix='U',num_units=4,do_erc=True,pins=[
            Pin(num='7',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='14',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='~',do_erc=True),
            Pin(num='2',name='~',do_erc=True),
            Pin(num='3',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='4',name='~',do_erc=True),
            Pin(num='5',name='~',do_erc=True),
            Pin(num='6',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='8',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='9',name='~',do_erc=True),
            Pin(num='10',name='~',do_erc=True),
            Pin(num='11',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='12',name='~',do_erc=True),
            Pin(num='13',name='~',do_erc=True),
            Pin(num='1',name='~',do_erc=True),
            Pin(num='2',name='~',do_erc=True),
            Pin(num='3',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='4',name='~',do_erc=True),
            Pin(num='5',name='~',do_erc=True),
            Pin(num='6',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='8',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='9',name='~',do_erc=True),
            Pin(num='10',name='~',do_erc=True),
            Pin(num='11',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='12',name='~',do_erc=True),
            Pin(num='13',name='~',do_erc=True)]),
        Part(name='74LS133',dest=TEMPLATE,tool=SKIDL,keywords='TTL Nand13',description='Nand 13 inputs',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='8',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='~',do_erc=True),
            Pin(num='2',name='~',do_erc=True),
            Pin(num='3',name='~',do_erc=True),
            Pin(num='4',name='~',do_erc=True),
            Pin(num='5',name='~',do_erc=True),
            Pin(num='6',name='~',do_erc=True),
            Pin(num='7',name='~',do_erc=True),
            Pin(num='9',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='10',name='~',do_erc=True),
            Pin(num='11',name='~',do_erc=True),
            Pin(num='12',name='~',do_erc=True),
            Pin(num='13',name='~',do_erc=True),
            Pin(num='14',name='~',do_erc=True),
            Pin(num='15',name='~',do_erc=True),
            Pin(num='1',name='~',do_erc=True),
            Pin(num='2',name='~',do_erc=True),
            Pin(num='3',name='~',do_erc=True),
            Pin(num='4',name='~',do_erc=True),
            Pin(num='5',name='~',do_erc=True),
            Pin(num='6',name='~',do_erc=True),
            Pin(num='7',name='~',do_erc=True),
            Pin(num='9',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='10',name='~',do_erc=True),
            Pin(num='11',name='~',do_erc=True),
            Pin(num='12',name='~',do_erc=True),
            Pin(num='13',name='~',do_erc=True),
            Pin(num='14',name='~',do_erc=True),
            Pin(num='15',name='~',do_erc=True)]),
        Part(name='74LS136',dest=TEMPLATE,tool=SKIDL,keywords='TTL XOR2 OpenCol',description='Quad Exclusive Or 2-inputs, Open Collect.',ref_prefix='U',num_units=4,do_erc=True,pins=[
            Pin(num='7',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='14',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='~',do_erc=True),
            Pin(num='2',name='~',do_erc=True),
            Pin(num='3',name='~',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='4',name='~',do_erc=True),
            Pin(num='5',name='~',do_erc=True),
            Pin(num='6',name='~',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='8',name='~',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='9',name='~',do_erc=True),
            Pin(num='10',name='~',do_erc=True),
            Pin(num='11',name='~',do_erc=True),
            Pin(num='12',name='~',do_erc=True),
            Pin(num='13',name='~',do_erc=True)]),
        Part(name='74LS137',dest=TEMPLATE,tool=SKIDL,keywords='TTL DECOD8 DECOD',description='Decoder 3 to 8, addr latches.',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='16',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='A0',do_erc=True),
            Pin(num='2',name='A1',do_erc=True),
            Pin(num='3',name='A2',do_erc=True),
            Pin(num='4',name='~Gl',do_erc=True),
            Pin(num='5',name='~G2',do_erc=True),
            Pin(num='6',name='G1',do_erc=True),
            Pin(num='7',name='Y7',func=Pin.OUTPUT,do_erc=True),
            Pin(num='8',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='Y6',func=Pin.OUTPUT,do_erc=True),
            Pin(num='10',name='Y5',func=Pin.OUTPUT,do_erc=True),
            Pin(num='11',name='Y4',func=Pin.OUTPUT,do_erc=True),
            Pin(num='12',name='Y3',func=Pin.OUTPUT,do_erc=True),
            Pin(num='13',name='Y2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='14',name='Y1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='15',name='Y0',func=Pin.OUTPUT,do_erc=True)]),
        Part(name='74LS138',dest=TEMPLATE,tool=SKIDL,keywords='TTL DECOD DECOD8',description='Decoder 3 to 8 (active low outputs)',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='A0',do_erc=True),
            Pin(num='2',name='A1',do_erc=True),
            Pin(num='3',name='A2',do_erc=True),
            Pin(num='4',name='E1',do_erc=True),
            Pin(num='5',name='E2',do_erc=True),
            Pin(num='6',name='E3',do_erc=True),
            Pin(num='7',name='O7',func=Pin.OUTPUT,do_erc=True),
            Pin(num='8',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='O6',func=Pin.OUTPUT,do_erc=True),
            Pin(num='10',name='O5',func=Pin.OUTPUT,do_erc=True),
            Pin(num='11',name='O4',func=Pin.OUTPUT,do_erc=True),
            Pin(num='12',name='O3',func=Pin.OUTPUT,do_erc=True),
            Pin(num='13',name='O2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='14',name='O1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='15',name='O0',func=Pin.OUTPUT,do_erc=True),
            Pin(num='16',name='VCC',func=Pin.PWRIN,do_erc=True)]),
        Part(name='74LS139',dest=TEMPLATE,tool=SKIDL,keywords='TTL DECOD4',description='Dual Decoder 1 of 4, Active low outputs',ref_prefix='U',num_units=2,do_erc=True,pins=[
            Pin(num='8',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='E',do_erc=True),
            Pin(num='2',name='A0',do_erc=True),
            Pin(num='3',name='A1',do_erc=True),
            Pin(num='4',name='O0',func=Pin.OUTPUT,do_erc=True),
            Pin(num='5',name='O1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='6',name='O2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='7',name='O3',func=Pin.OUTPUT,do_erc=True),
            Pin(num='9',name='O3',func=Pin.OUTPUT,do_erc=True),
            Pin(num='10',name='O2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='11',name='O1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='12',name='O0',func=Pin.OUTPUT,do_erc=True),
            Pin(num='13',name='A1',do_erc=True),
            Pin(num='14',name='A0',do_erc=True),
            Pin(num='15',name='E',do_erc=True)]),
        Part(name='74LS145',dest=TEMPLATE,tool=SKIDL,keywords='TTL DECOD10 OpenColl',description='Decoder 1 to 10, Open Collect.',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='8',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='Q0',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='2',name='Q1',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='3',name='Q2',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='4',name='Q3',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='5',name='Q4',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='6',name='Q5',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='7',name='Q6',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='9',name='Q7',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='10',name='Q8',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='11',name='Q9',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='12',name='P3',do_erc=True),
            Pin(num='13',name='P2',do_erc=True),
            Pin(num='14',name='P1',do_erc=True),
            Pin(num='15',name='P0',do_erc=True)]),
        Part(name='74LS147',dest=TEMPLATE,tool=SKIDL,keywords='TTL ENCOD',description='Priority Encodeur, 10 to 4',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='8',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='E4',do_erc=True),
            Pin(num='2',name='E5',do_erc=True),
            Pin(num='3',name='E6',do_erc=True),
            Pin(num='4',name='E7',do_erc=True),
            Pin(num='5',name='E8',do_erc=True),
            Pin(num='6',name='S2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='7',name='S1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='9',name='S0',func=Pin.OUTPUT,do_erc=True),
            Pin(num='10',name='E9',do_erc=True),
            Pin(num='11',name='E1',do_erc=True),
            Pin(num='12',name='E2',do_erc=True),
            Pin(num='13',name='E3',do_erc=True),
            Pin(num='14',name='S3',func=Pin.OUTPUT,do_erc=True)]),
        Part(name='74LS148',dest=TEMPLATE,tool=SKIDL,keywords='TTL ENCOD',description='Priority Encoder 3 to 8 cascadable',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='8',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='I4',do_erc=True),
            Pin(num='2',name='I5',do_erc=True),
            Pin(num='3',name='I6',do_erc=True),
            Pin(num='4',name='I7',do_erc=True),
            Pin(num='5',name='EI',do_erc=True),
            Pin(num='6',name='S2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='7',name='S1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='9',name='S0',func=Pin.OUTPUT,do_erc=True),
            Pin(num='10',name='IO',do_erc=True),
            Pin(num='11',name='I1',do_erc=True),
            Pin(num='12',name='I2',do_erc=True),
            Pin(num='13',name='I3',do_erc=True),
            Pin(num='14',name='GS',func=Pin.OUTPUT,do_erc=True),
            Pin(num='15',name='EO',func=Pin.OUTPUT,do_erc=True)]),
        Part(name='74LS15',dest=TEMPLATE,tool=SKIDL,keywords='TTL And3',description='Triple And 3 inputs',ref_prefix='U',num_units=3,do_erc=True,pins=[
            Pin(num='7',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='14',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='~',do_erc=True),
            Pin(num='2',name='~',do_erc=True),
            Pin(num='12',name='~',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='13',name='~',do_erc=True),
            Pin(num='3',name='~',do_erc=True),
            Pin(num='4',name='~',do_erc=True),
            Pin(num='5',name='~',do_erc=True),
            Pin(num='6',name='~',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='8',name='~',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='9',name='~',do_erc=True),
            Pin(num='10',name='~',do_erc=True),
            Pin(num='11',name='~',do_erc=True),
            Pin(num='1',name='~',do_erc=True),
            Pin(num='2',name='~',do_erc=True),
            Pin(num='12',name='~',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='13',name='~',do_erc=True),
            Pin(num='3',name='~',do_erc=True),
            Pin(num='4',name='~',do_erc=True),
            Pin(num='5',name='~',do_erc=True),
            Pin(num='6',name='~',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='8',name='~',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='9',name='~',do_erc=True),
            Pin(num='10',name='~',do_erc=True),
            Pin(num='11',name='~',do_erc=True)]),
        Part(name='74LS151',dest=TEMPLATE,tool=SKIDL,keywords='TTL MUX8',description='Multiplexer 8 to 1',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='8',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='I3',do_erc=True),
            Pin(num='2',name='I2',do_erc=True),
            Pin(num='3',name='I1',do_erc=True),
            Pin(num='4',name='I0',do_erc=True),
            Pin(num='5',name='Z',func=Pin.OUTPUT,do_erc=True),
            Pin(num='6',name='~Z',func=Pin.OUTPUT,do_erc=True),
            Pin(num='7',name='~E',do_erc=True),
            Pin(num='9',name='S2',do_erc=True),
            Pin(num='10',name='S1',do_erc=True),
            Pin(num='11',name='S0',do_erc=True),
            Pin(num='12',name='I7',do_erc=True),
            Pin(num='13',name='I6',do_erc=True),
            Pin(num='14',name='I5',do_erc=True),
            Pin(num='15',name='I4',do_erc=True)]),
        Part(name='74LS153',dest=TEMPLATE,tool=SKIDL,keywords='TTL Mux4',description='Dual Multiplexer 4 to 1',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='8',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='Ea',do_erc=True),
            Pin(num='2',name='S1',do_erc=True),
            Pin(num='3',name='I3a',do_erc=True),
            Pin(num='4',name='I2a',do_erc=True),
            Pin(num='5',name='I1a',do_erc=True),
            Pin(num='6',name='I0a',do_erc=True),
            Pin(num='7',name='Za',func=Pin.OUTPUT,do_erc=True),
            Pin(num='9',name='Zb',func=Pin.OUTPUT,do_erc=True),
            Pin(num='10',name='I0b',do_erc=True),
            Pin(num='11',name='I1b',do_erc=True),
            Pin(num='12',name='I2b',do_erc=True),
            Pin(num='13',name='I3b',do_erc=True),
            Pin(num='14',name='S0',do_erc=True),
            Pin(num='15',name='Eb',do_erc=True)]),
        Part(name='74LS154',dest=TEMPLATE,tool=SKIDL,keywords='TTL DECOD16 DECOD',description='Decoder 4 to 16',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='12',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='24',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='S0',func=Pin.OUTPUT,do_erc=True),
            Pin(num='2',name='S1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='3',name='S2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='4',name='S3',func=Pin.OUTPUT,do_erc=True),
            Pin(num='5',name='S4',func=Pin.OUTPUT,do_erc=True),
            Pin(num='6',name='S5',func=Pin.OUTPUT,do_erc=True),
            Pin(num='7',name='S6',func=Pin.OUTPUT,do_erc=True),
            Pin(num='8',name='S7',func=Pin.OUTPUT,do_erc=True),
            Pin(num='9',name='S8',func=Pin.OUTPUT,do_erc=True),
            Pin(num='10',name='S9',func=Pin.OUTPUT,do_erc=True),
            Pin(num='20',name='A3',do_erc=True),
            Pin(num='11',name='S10',func=Pin.OUTPUT,do_erc=True),
            Pin(num='21',name='A2',do_erc=True),
            Pin(num='22',name='A1',do_erc=True),
            Pin(num='13',name='S11',func=Pin.OUTPUT,do_erc=True),
            Pin(num='23',name='A0',do_erc=True),
            Pin(num='14',name='S12',func=Pin.OUTPUT,do_erc=True),
            Pin(num='15',name='S13',do_erc=True),
            Pin(num='16',name='S14',func=Pin.OUTPUT,do_erc=True),
            Pin(num='17',name='S15',func=Pin.OUTPUT,do_erc=True),
            Pin(num='18',name='E0',do_erc=True),
            Pin(num='19',name='E1',do_erc=True)]),
        Part(name='74LS155',dest=TEMPLATE,tool=SKIDL,keywords='TTL DECOD8 DECOD4 DEMUX4 DEMUX8 OpenCol',description='Dual 2 to 4 lines Decoder/Demultiplexer, Open Collect.',ref_prefix='U',num_units=1,do_erc=True,aliases=['74LS156'],pins=[
            Pin(num='8',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='Ea1',do_erc=True),
            Pin(num='2',name='Ea2',do_erc=True),
            Pin(num='3',name='A1',do_erc=True),
            Pin(num='4',name='Q3a',func=Pin.OUTPUT,do_erc=True),
            Pin(num='5',name='Q2a',func=Pin.OUTPUT,do_erc=True),
            Pin(num='6',name='Q1a',func=Pin.OUTPUT,do_erc=True),
            Pin(num='7',name='Q0a',func=Pin.OUTPUT,do_erc=True),
            Pin(num='9',name='Q0b',func=Pin.OUTPUT,do_erc=True),
            Pin(num='10',name='Q1b',func=Pin.OUTPUT,do_erc=True),
            Pin(num='11',name='Q2b',func=Pin.OUTPUT,do_erc=True),
            Pin(num='12',name='Q3b',func=Pin.OUTPUT,do_erc=True),
            Pin(num='13',name='A0',do_erc=True),
            Pin(num='14',name='Eb1',do_erc=True),
            Pin(num='15',name='Eb2',do_erc=True)]),
        Part(name='74LS157',dest=TEMPLATE,tool=SKIDL,keywords='TTL MUX MUX2',description='Quad 2 to 1 line Multiplexer',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='8',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='S',do_erc=True),
            Pin(num='2',name='I0a',do_erc=True),
            Pin(num='3',name='I1a',do_erc=True),
            Pin(num='4',name='Za',func=Pin.OUTPUT,do_erc=True),
            Pin(num='5',name='I0b',do_erc=True),
            Pin(num='6',name='I1b',do_erc=True),
            Pin(num='7',name='Zb',func=Pin.OUTPUT,do_erc=True),
            Pin(num='9',name='Zd',func=Pin.OUTPUT,do_erc=True),
            Pin(num='10',name='I1d',do_erc=True),
            Pin(num='11',name='I0d',do_erc=True),
            Pin(num='12',name='Zc',func=Pin.OUTPUT,do_erc=True),
            Pin(num='13',name='I1c',do_erc=True),
            Pin(num='14',name='I0c',do_erc=True),
            Pin(num='15',name='E',do_erc=True)]),
        Part(name='74LS158',dest=TEMPLATE,tool=SKIDL,keywords='TTL Mux MUX2',description='Quad 2 to 1 multiplexer',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='8',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='S',do_erc=True),
            Pin(num='2',name='I0a',do_erc=True),
            Pin(num='3',name='I1a',do_erc=True),
            Pin(num='4',name='Za',func=Pin.OUTPUT,do_erc=True),
            Pin(num='5',name='I0b',do_erc=True),
            Pin(num='6',name='I1b',do_erc=True),
            Pin(num='7',name='Zb',func=Pin.OUTPUT,do_erc=True),
            Pin(num='9',name='Zd',func=Pin.OUTPUT,do_erc=True),
            Pin(num='10',name='I1d',do_erc=True),
            Pin(num='11',name='I0d',do_erc=True),
            Pin(num='12',name='Zc',func=Pin.OUTPUT,do_erc=True),
            Pin(num='13',name='I1c',do_erc=True),
            Pin(num='14',name='I0c',do_erc=True),
            Pin(num='15',name='E',do_erc=True)]),
        Part(name='74LS161',dest=TEMPLATE,tool=SKIDL,keywords='TTL CNT CNT4',description='Sychronous 4 bits programmable binary Counter',ref_prefix='U',num_units=1,do_erc=True,aliases=['74LS160', '74LS162', '74LS163'],pins=[
            Pin(num='8',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='~MR',do_erc=True),
            Pin(num='2',name='Cp',do_erc=True),
            Pin(num='3',name='P0',do_erc=True),
            Pin(num='4',name='P1',do_erc=True),
            Pin(num='5',name='P2',do_erc=True),
            Pin(num='6',name='P3',do_erc=True),
            Pin(num='7',name='Cep',do_erc=True),
            Pin(num='9',name='~Pe',do_erc=True),
            Pin(num='10',name='Cet',do_erc=True),
            Pin(num='11',name='Q3',func=Pin.OUTPUT,do_erc=True),
            Pin(num='12',name='Q2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='13',name='Q1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='14',name='Q0',func=Pin.OUTPUT,do_erc=True),
            Pin(num='15',name='Tc',func=Pin.OUTPUT,do_erc=True)]),
        Part(name='74LS165',dest=TEMPLATE,tool=SKIDL,keywords='TTL SR SR8',description='Shift Register 8 bits, parallel load',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='8',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='Pl',do_erc=True),
            Pin(num='2',name='CP',do_erc=True),
            Pin(num='3',name='P4',do_erc=True),
            Pin(num='4',name='P5',do_erc=True),
            Pin(num='5',name='P6',do_erc=True),
            Pin(num='6',name='P7',do_erc=True),
            Pin(num='7',name='~Q7',func=Pin.OUTPUT,do_erc=True),
            Pin(num='9',name='Q7',func=Pin.OUTPUT,do_erc=True),
            Pin(num='10',name='Ds',do_erc=True),
            Pin(num='11',name='P0',do_erc=True),
            Pin(num='12',name='P1',do_erc=True),
            Pin(num='13',name='P2',do_erc=True),
            Pin(num='14',name='P3',do_erc=True),
            Pin(num='15',name='CE',do_erc=True)]),
        Part(name='74LS166',dest=TEMPLATE,tool=SKIDL,keywords='TTL SR SR8',description='Shift Register 8 bits, parallel load',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='8',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='Ds',do_erc=True),
            Pin(num='2',name='A',do_erc=True),
            Pin(num='3',name='B',do_erc=True),
            Pin(num='4',name='C',do_erc=True),
            Pin(num='5',name='D',do_erc=True),
            Pin(num='6',name='CE',do_erc=True),
            Pin(num='7',name='Clk',do_erc=True),
            Pin(num='9',name='Clr',do_erc=True),
            Pin(num='10',name='E',do_erc=True),
            Pin(num='11',name='F',do_erc=True),
            Pin(num='12',name='G',do_erc=True),
            Pin(num='13',name='Qh',func=Pin.OUTPUT,do_erc=True),
            Pin(num='14',name='H',do_erc=True),
            Pin(num='15',name='PE',do_erc=True)]),
        Part(name='74LS168',dest=TEMPLATE,tool=SKIDL,keywords='TTL CNT CNT4',description='Synchronous 4 bits Up/Down binary counter',ref_prefix='U',num_units=1,do_erc=True,aliases=['74LS169'],pins=[
            Pin(num='8',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='U/D',do_erc=True),
            Pin(num='2',name='Cp',do_erc=True),
            Pin(num='3',name='P0',do_erc=True),
            Pin(num='4',name='P1',do_erc=True),
            Pin(num='5',name='P2',do_erc=True),
            Pin(num='6',name='P3',do_erc=True),
            Pin(num='7',name='Cep',do_erc=True),
            Pin(num='9',name='Pe',do_erc=True),
            Pin(num='10',name='Cet',do_erc=True),
            Pin(num='11',name='Q3',func=Pin.OUTPUT,do_erc=True),
            Pin(num='12',name='Q2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='13',name='Q1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='14',name='Q0',func=Pin.OUTPUT,do_erc=True),
            Pin(num='15',name='~Tc',func=Pin.OUTPUT,do_erc=True)]),
        Part(name='74LS170',dest=TEMPLATE,tool=SKIDL,keywords='TTL Register 3State',description='4 x 4 Register Files 3 State Out',ref_prefix='U',num_units=1,do_erc=True,aliases=['74ls670'],pins=[
            Pin(num='8',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='D2',do_erc=True),
            Pin(num='2',name='D3',do_erc=True),
            Pin(num='3',name='D4',do_erc=True),
            Pin(num='4',name='Rb',do_erc=True),
            Pin(num='5',name='Ra',do_erc=True),
            Pin(num='6',name='Q4',func=Pin.TRISTATE,do_erc=True),
            Pin(num='7',name='Q3',func=Pin.TRISTATE,do_erc=True),
            Pin(num='9',name='Q2',func=Pin.TRISTATE,do_erc=True),
            Pin(num='10',name='Q1',func=Pin.TRISTATE,do_erc=True),
            Pin(num='11',name='~Er',do_erc=True),
            Pin(num='12',name='~Ew',do_erc=True),
            Pin(num='13',name='Wb',do_erc=True),
            Pin(num='14',name='Wa',do_erc=True),
            Pin(num='15',name='D1',do_erc=True)]),
        Part(name='74LS173',dest=TEMPLATE,tool=SKIDL,keywords='TTL REG REG4 3State DFF',description='4 bits D-type Register, 3 state out',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='8',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='Oe1',do_erc=True),
            Pin(num='2',name='Oe2',do_erc=True),
            Pin(num='3',name='Q0',func=Pin.TRISTATE,do_erc=True),
            Pin(num='4',name='Q1',func=Pin.TRISTATE,do_erc=True),
            Pin(num='5',name='Q2',func=Pin.TRISTATE,do_erc=True),
            Pin(num='6',name='Q3',func=Pin.TRISTATE,do_erc=True),
            Pin(num='7',name='Cp',do_erc=True),
            Pin(num='9',name='E1',do_erc=True),
            Pin(num='10',name='E2',do_erc=True),
            Pin(num='11',name='D3',do_erc=True),
            Pin(num='12',name='D2',do_erc=True),
            Pin(num='13',name='D1',do_erc=True),
            Pin(num='14',name='D0',do_erc=True),
            Pin(num='15',name='Mr',do_erc=True)]),
        Part(name='74LS174',dest=TEMPLATE,tool=SKIDL,keywords='TTL REG REG6 DFF',description='Hex D-type FlipFlop, reset',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='8',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='~Mr',do_erc=True),
            Pin(num='2',name='Q0',do_erc=True),
            Pin(num='3',name='D0',do_erc=True),
            Pin(num='4',name='D1',do_erc=True),
            Pin(num='5',name='Q1',do_erc=True),
            Pin(num='6',name='D2',do_erc=True),
            Pin(num='7',name='Q2',do_erc=True),
            Pin(num='9',name='Cp',do_erc=True),
            Pin(num='10',name='Q3',do_erc=True),
            Pin(num='11',name='D3',do_erc=True),
            Pin(num='12',name='Q4',do_erc=True),
            Pin(num='13',name='D4',do_erc=True),
            Pin(num='14',name='D5',do_erc=True),
            Pin(num='15',name='Q5',do_erc=True)]),
        Part(name='74LS175',dest=TEMPLATE,tool=SKIDL,keywords='TTL REG REG4 DFF',description='4 bits D FlipFlop, reset',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='8',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='~Mr',do_erc=True),
            Pin(num='2',name='Q0',func=Pin.OUTPUT,do_erc=True),
            Pin(num='3',name='~Q0',func=Pin.OUTPUT,do_erc=True),
            Pin(num='4',name='D0',do_erc=True),
            Pin(num='5',name='D1',do_erc=True),
            Pin(num='6',name='~Q1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='7',name='Q1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='9',name='Cp',do_erc=True),
            Pin(num='10',name='Q2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='11',name='~Q2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='12',name='D2',do_erc=True),
            Pin(num='13',name='D3',do_erc=True),
            Pin(num='14',name='~Q3',func=Pin.OUTPUT,do_erc=True),
            Pin(num='15',name='Q3',func=Pin.OUTPUT,do_erc=True)]),
        Part(name='74LS181',dest=TEMPLATE,tool=SKIDL,keywords='TTL ALU ARITH',description='Arithmetic logic unit',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='12',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='24',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='B0',do_erc=True),
            Pin(num='2',name='A0',do_erc=True),
            Pin(num='3',name='S3',do_erc=True),
            Pin(num='4',name='S2',do_erc=True),
            Pin(num='5',name='S1',do_erc=True),
            Pin(num='6',name='S0',do_erc=True),
            Pin(num='7',name='Cn',do_erc=True),
            Pin(num='8',name='M',do_erc=True),
            Pin(num='9',name='F0',func=Pin.OUTPUT,do_erc=True),
            Pin(num='10',name='F1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='20',name='B2',do_erc=True),
            Pin(num='11',name='F2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='21',name='A2',do_erc=True),
            Pin(num='22',name='B1',do_erc=True),
            Pin(num='13',name='F3',func=Pin.OUTPUT,do_erc=True),
            Pin(num='23',name='A1',do_erc=True),
            Pin(num='14',name='A=B',func=Pin.OUTPUT,do_erc=True),
            Pin(num='15',name='X',func=Pin.OUTPUT,do_erc=True),
            Pin(num='16',name='Cn+4',func=Pin.OUTPUT,do_erc=True),
            Pin(num='17',name='Y',func=Pin.OUTPUT,do_erc=True),
            Pin(num='18',name='B3',do_erc=True),
            Pin(num='19',name='A3',do_erc=True)]),
        Part(name='74LS182',dest=TEMPLATE,tool=SKIDL,keywords='TTL ALU ARITH',description='Carry generator',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='8',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='G1',do_erc=True),
            Pin(num='2',name='P1',do_erc=True),
            Pin(num='3',name='G0',do_erc=True),
            Pin(num='4',name='P0',do_erc=True),
            Pin(num='5',name='G3',do_erc=True),
            Pin(num='6',name='P3',do_erc=True),
            Pin(num='7',name='P',func=Pin.OUTPUT,do_erc=True),
            Pin(num='9',name='Cn+z',func=Pin.OUTPUT,do_erc=True),
            Pin(num='10',name='G',func=Pin.OUTPUT,do_erc=True),
            Pin(num='11',name='Cn+y',func=Pin.OUTPUT,do_erc=True),
            Pin(num='12',name='Cn+x',func=Pin.OUTPUT,do_erc=True),
            Pin(num='13',name='Cn',do_erc=True),
            Pin(num='14',name='G2',do_erc=True),
            Pin(num='15',name='P2',do_erc=True)]),
        Part(name='74LS190',dest=TEMPLATE,tool=SKIDL,keywords='TTL CNT CNT4',description='4 bits Synchronous 4 bits Up/Down binary Counter',ref_prefix='U',num_units=1,do_erc=True,aliases=['74LS191'],pins=[
            Pin(num='8',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='P1',do_erc=True),
            Pin(num='2',name='Q1',do_erc=True),
            Pin(num='3',name='Q0',do_erc=True),
            Pin(num='4',name='Ce',do_erc=True),
            Pin(num='5',name='D/U',do_erc=True),
            Pin(num='6',name='Q2',do_erc=True),
            Pin(num='7',name='Q3',do_erc=True),
            Pin(num='9',name='P3',do_erc=True),
            Pin(num='10',name='P2',do_erc=True),
            Pin(num='11',name='Pl',do_erc=True),
            Pin(num='12',name='Tc',do_erc=True),
            Pin(num='13',name='~Rc',do_erc=True),
            Pin(num='14',name='Cp',do_erc=True),
            Pin(num='15',name='P0',do_erc=True)]),
        Part(name='74LS192',dest=TEMPLATE,tool=SKIDL,keywords='TTL CNT CNT4',description='Synchronous 4 bits Up/Down (2 clk) counter',ref_prefix='U',num_units=1,do_erc=True,aliases=['74LS193'],pins=[
            Pin(num='8',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='P1',do_erc=True),
            Pin(num='2',name='Q1',do_erc=True),
            Pin(num='3',name='Q0',do_erc=True),
            Pin(num='4',name='CpDw',do_erc=True),
            Pin(num='5',name='CpUp',do_erc=True),
            Pin(num='6',name='Q2',do_erc=True),
            Pin(num='7',name='Q3',do_erc=True),
            Pin(num='9',name='P3',do_erc=True),
            Pin(num='10',name='P2',do_erc=True),
            Pin(num='11',name='Pl',do_erc=True),
            Pin(num='12',name='TcUp',do_erc=True),
            Pin(num='13',name='TcDw',do_erc=True),
            Pin(num='14',name='Mr',do_erc=True),
            Pin(num='15',name='P0',do_erc=True)]),
        Part(name='74LS194',dest=TEMPLATE,tool=SKIDL,keywords='TTL RS SR4',description='Shift Register 4 bits Bidirectionnel',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='8',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='Mr',do_erc=True),
            Pin(num='2',name='Dsr',do_erc=True),
            Pin(num='3',name='P0',do_erc=True),
            Pin(num='4',name='P1',do_erc=True),
            Pin(num='5',name='P2',do_erc=True),
            Pin(num='6',name='P3',do_erc=True),
            Pin(num='7',name='Dsl',do_erc=True),
            Pin(num='9',name='S0',do_erc=True),
            Pin(num='10',name='S1',do_erc=True),
            Pin(num='11',name='Cp',do_erc=True),
            Pin(num='12',name='Q3',func=Pin.OUTPUT,do_erc=True),
            Pin(num='13',name='Q2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='14',name='Q1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='15',name='Q0',func=Pin.OUTPUT,do_erc=True)]),
        Part(name='74LS195',dest=TEMPLATE,tool=SKIDL,keywords='TTL SR SR4',description='Shift Register 4 bits, parallel',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='8',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='Mr',do_erc=True),
            Pin(num='2',name='J',do_erc=True),
            Pin(num='3',name='~K',do_erc=True),
            Pin(num='4',name='P0',do_erc=True),
            Pin(num='5',name='P1',do_erc=True),
            Pin(num='6',name='P2',do_erc=True),
            Pin(num='7',name='P3',do_erc=True),
            Pin(num='9',name='Pe',do_erc=True),
            Pin(num='10',name='Cp',do_erc=True),
            Pin(num='11',name='~Q3',func=Pin.OUTPUT,do_erc=True),
            Pin(num='12',name='Q3',func=Pin.OUTPUT,do_erc=True),
            Pin(num='13',name='Q2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='14',name='Q1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='15',name='Q0',func=Pin.OUTPUT,do_erc=True)]),
        Part(name='74LS196',dest=TEMPLATE,tool=SKIDL,keywords='TTL CNT CNT4',description='4 (3 + 1 ) bits presettable binary counter',ref_prefix='U',num_units=1,do_erc=True,aliases=['74LS197'],pins=[
            Pin(num='7',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='14',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='Pl',do_erc=True),
            Pin(num='2',name='Q2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='3',name='P2',do_erc=True),
            Pin(num='4',name='P0',do_erc=True),
            Pin(num='5',name='Q0',func=Pin.OUTPUT,do_erc=True),
            Pin(num='6',name='Cp1',do_erc=True),
            Pin(num='8',name='Cp0',do_erc=True),
            Pin(num='9',name='Q1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='10',name='P1',do_erc=True),
            Pin(num='11',name='P3',do_erc=True),
            Pin(num='12',name='Q3',func=Pin.OUTPUT,do_erc=True),
            Pin(num='13',name='Mr',do_erc=True)]),
        Part(name='74LS20',dest=TEMPLATE,tool=SKIDL,keywords='TTL Nand4',description='Dual Nand 4 inputs',ref_prefix='U',num_units=2,do_erc=True,aliases=['74LS22', '74LS40'],pins=[
            Pin(num='7',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='14',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='~',do_erc=True),
            Pin(num='2',name='~',do_erc=True),
            Pin(num='4',name='~',do_erc=True),
            Pin(num='5',name='~',do_erc=True),
            Pin(num='6',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='8',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='9',name='~',do_erc=True),
            Pin(num='10',name='~',do_erc=True),
            Pin(num='12',name='~',do_erc=True),
            Pin(num='13',name='~',do_erc=True),
            Pin(num='1',name='~',do_erc=True),
            Pin(num='2',name='~',do_erc=True),
            Pin(num='4',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='5',name='~',do_erc=True),
            Pin(num='6',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='8',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='9',name='~',do_erc=True),
            Pin(num='10',name='~',do_erc=True),
            Pin(num='12',name='~',do_erc=True),
            Pin(num='13',name='~',do_erc=True)]),
        Part(name='74LS21',dest=TEMPLATE,tool=SKIDL,keywords='TTL And4',description='Dual And 4 inputs',ref_prefix='U',num_units=2,do_erc=True,pins=[
            Pin(num='7',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='14',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='~',do_erc=True),
            Pin(num='2',name='~',do_erc=True),
            Pin(num='4',name='~',do_erc=True),
            Pin(num='5',name='~',do_erc=True),
            Pin(num='6',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='8',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='9',name='~',do_erc=True),
            Pin(num='10',name='~',do_erc=True),
            Pin(num='12',name='~',do_erc=True),
            Pin(num='13',name='~',do_erc=True),
            Pin(num='1',name='~',do_erc=True),
            Pin(num='2',name='~',do_erc=True),
            Pin(num='4',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='5',name='~',do_erc=True),
            Pin(num='6',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='8',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='9',name='~',do_erc=True),
            Pin(num='10',name='~',do_erc=True),
            Pin(num='12',name='~',do_erc=True),
            Pin(num='13',name='~',do_erc=True)]),
        Part(name='74LS221',dest=TEMPLATE,tool=SKIDL,keywords='TTL Monostable',description='Dual Monostable',ref_prefix='U',num_units=2,do_erc=True,pins=[
            Pin(num='8',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='A',do_erc=True),
            Pin(num='2',name='B',do_erc=True),
            Pin(num='3',name='Clr',do_erc=True),
            Pin(num='4',name='~Q',func=Pin.OUTPUT,do_erc=True),
            Pin(num='13',name='Q',func=Pin.OUTPUT,do_erc=True),
            Pin(num='14',name='Cext',do_erc=True),
            Pin(num='15',name='RCext',do_erc=True),
            Pin(num='5',name='Q',func=Pin.OUTPUT,do_erc=True),
            Pin(num='6',name='Cext',do_erc=True),
            Pin(num='7',name='RCext',do_erc=True),
            Pin(num='9',name='A',do_erc=True),
            Pin(num='10',name='B',do_erc=True),
            Pin(num='11',name='Clr',do_erc=True),
            Pin(num='12',name='~Q',func=Pin.OUTPUT,do_erc=True)]),
        Part(name='74LS240',dest=TEMPLATE,tool=SKIDL,keywords='TTL Buffer BUS 3State',description='8 bits BUS Buffer (Inverter) 3 State out',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='10',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='20',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='OEa',do_erc=True),
            Pin(num='2',name='I0a',do_erc=True),
            Pin(num='3',name='O3b',func=Pin.TRISTATE,do_erc=True),
            Pin(num='4',name='I1a',do_erc=True),
            Pin(num='5',name='O2b',func=Pin.TRISTATE,do_erc=True),
            Pin(num='6',name='I2a',do_erc=True),
            Pin(num='7',name='O1b',func=Pin.TRISTATE,do_erc=True),
            Pin(num='8',name='I3a',do_erc=True),
            Pin(num='9',name='O0b',func=Pin.TRISTATE,do_erc=True),
            Pin(num='11',name='I0b',do_erc=True),
            Pin(num='12',name='O3a',func=Pin.TRISTATE,do_erc=True),
            Pin(num='13',name='I1b',do_erc=True),
            Pin(num='14',name='O2a',func=Pin.TRISTATE,do_erc=True),
            Pin(num='15',name='I2b',do_erc=True),
            Pin(num='16',name='O1a',func=Pin.TRISTATE,do_erc=True),
            Pin(num='17',name='I3b',do_erc=True),
            Pin(num='18',name='O0a',func=Pin.TRISTATE,do_erc=True),
            Pin(num='19',name='OEb',do_erc=True)]),
        Part(name='74LS241',dest=TEMPLATE,tool=SKIDL,keywords='TTL Buffer BUS 3State',description='8 bits Bus Buffer 3 State out',ref_prefix='U',num_units=1,do_erc=True,aliases=['74LS244'],pins=[
            Pin(num='10',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='20',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='OEa',do_erc=True),
            Pin(num='2',name='I0a',do_erc=True),
            Pin(num='3',name='O3b',func=Pin.TRISTATE,do_erc=True),
            Pin(num='4',name='I1a',do_erc=True),
            Pin(num='5',name='O2b',func=Pin.TRISTATE,do_erc=True),
            Pin(num='6',name='I2a',do_erc=True),
            Pin(num='7',name='O1b',func=Pin.TRISTATE,do_erc=True),
            Pin(num='8',name='I3a',do_erc=True),
            Pin(num='9',name='O0b',func=Pin.TRISTATE,do_erc=True),
            Pin(num='11',name='I0b',do_erc=True),
            Pin(num='12',name='O3a',func=Pin.TRISTATE,do_erc=True),
            Pin(num='13',name='I1b',do_erc=True),
            Pin(num='14',name='O2a',func=Pin.TRISTATE,do_erc=True),
            Pin(num='15',name='I2b',do_erc=True),
            Pin(num='16',name='O1a',func=Pin.TRISTATE,do_erc=True),
            Pin(num='17',name='I3b',do_erc=True),
            Pin(num='18',name='O0a',func=Pin.TRISTATE,do_erc=True),
            Pin(num='19',name='OEb',do_erc=True)]),
        Part(name='74LS242',dest=TEMPLATE,tool=SKIDL,do_erc=True),
        Part(name='74LS243',dest=TEMPLATE,tool=SKIDL,keywords='TTL Buffer 3State BUS BIDI',description='4 bits Bus Tranceiver',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='7',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='14',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='OEa',do_erc=True),
            Pin(num='3',name='A0',do_erc=True),
            Pin(num='4',name='A1',do_erc=True),
            Pin(num='5',name='A2',do_erc=True),
            Pin(num='6',name='A3',do_erc=True),
            Pin(num='8',name='B3',func=Pin.TRISTATE,do_erc=True),
            Pin(num='9',name='B2',func=Pin.TRISTATE,do_erc=True),
            Pin(num='10',name='B1',func=Pin.TRISTATE,do_erc=True),
            Pin(num='11',name='B0',func=Pin.TRISTATE,do_erc=True),
            Pin(num='13',name='OEb',do_erc=True)]),
        Part(name='74LS245',dest=TEMPLATE,tool=SKIDL,keywords='TTL BUS 3State',description='Octal BUS Transceivers, 3 State out',ref_prefix='U',num_units=1,do_erc=True,aliases=['74HC245'],pins=[
            Pin(num='10',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='20',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='A->B',do_erc=True),
            Pin(num='2',name='A0',func=Pin.TRISTATE,do_erc=True),
            Pin(num='3',name='A1',func=Pin.TRISTATE,do_erc=True),
            Pin(num='4',name='A2',func=Pin.TRISTATE,do_erc=True),
            Pin(num='5',name='A3',func=Pin.TRISTATE,do_erc=True),
            Pin(num='6',name='A4',func=Pin.TRISTATE,do_erc=True),
            Pin(num='7',name='A5',func=Pin.TRISTATE,do_erc=True),
            Pin(num='8',name='A6',func=Pin.TRISTATE,do_erc=True),
            Pin(num='9',name='A7',func=Pin.TRISTATE,do_erc=True),
            Pin(num='11',name='B7',func=Pin.TRISTATE,do_erc=True),
            Pin(num='12',name='B6',func=Pin.TRISTATE,do_erc=True),
            Pin(num='13',name='B5',func=Pin.TRISTATE,do_erc=True),
            Pin(num='14',name='B4',func=Pin.TRISTATE,do_erc=True),
            Pin(num='15',name='B3',func=Pin.TRISTATE,do_erc=True),
            Pin(num='16',name='B2',func=Pin.TRISTATE,do_erc=True),
            Pin(num='17',name='B1',func=Pin.TRISTATE,do_erc=True),
            Pin(num='18',name='B0',func=Pin.TRISTATE,do_erc=True),
            Pin(num='19',name='CE',do_erc=True)]),
        Part(name='74LS247',dest=TEMPLATE,tool=SKIDL,keywords='TTL DECOD',description='BDC to 7 segments Decoder Open Collec. active Low',ref_prefix='U',num_units=1,do_erc=True,aliases=['74LS246'],pins=[
            Pin(num='8',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='B',do_erc=True),
            Pin(num='2',name='C',do_erc=True),
            Pin(num='3',name='Lt',do_erc=True),
            Pin(num='4',name='Rbo',func=Pin.OUTPUT,do_erc=True),
            Pin(num='5',name='Rbi',do_erc=True),
            Pin(num='6',name='D',do_erc=True),
            Pin(num='7',name='A',do_erc=True),
            Pin(num='9',name='e',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='10',name='d',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='11',name='c',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='12',name='b',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='13',name='a',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='14',name='g',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='15',name='f',func=Pin.OPENCOLL,do_erc=True)]),
        Part(name='74LS248',dest=TEMPLATE,tool=SKIDL,keywords='TTL DECOD OpenCol',description='BCD to 7 segments Decoder, Open collect, Active High',ref_prefix='U',num_units=1,do_erc=True,aliases=['74LS249'],pins=[
            Pin(num='8',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='B',do_erc=True),
            Pin(num='2',name='C',do_erc=True),
            Pin(num='3',name='Lt',do_erc=True),
            Pin(num='4',name='Rbo',func=Pin.OUTPUT,do_erc=True),
            Pin(num='5',name='Rbi',do_erc=True),
            Pin(num='6',name='D',do_erc=True),
            Pin(num='7',name='A',do_erc=True),
            Pin(num='9',name='e',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='10',name='d',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='11',name='c',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='12',name='b',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='13',name='a',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='14',name='g',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='15',name='f',func=Pin.OPENCOLL,do_erc=True)]),
        Part(name='74LS251',dest=TEMPLATE,tool=SKIDL,keywords='TTL MUX MUX8 3State',description='Multiplexer 8 to 1, 3 state Out',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='8',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='I3',do_erc=True),
            Pin(num='2',name='I2',do_erc=True),
            Pin(num='3',name='I1',do_erc=True),
            Pin(num='4',name='I0',do_erc=True),
            Pin(num='5',name='Z',func=Pin.TRISTATE,do_erc=True),
            Pin(num='6',name='~Z',func=Pin.TRISTATE,do_erc=True),
            Pin(num='7',name='~E',do_erc=True),
            Pin(num='9',name='S2',do_erc=True),
            Pin(num='10',name='S1',do_erc=True),
            Pin(num='11',name='S0',do_erc=True),
            Pin(num='12',name='I7',do_erc=True),
            Pin(num='13',name='I6',do_erc=True),
            Pin(num='14',name='I5',do_erc=True),
            Pin(num='15',name='I4',do_erc=True)]),
        Part(name='74LS253',dest=TEMPLATE,tool=SKIDL,keywords='TTL MUX MUX4 3State',description='Dual Multiplexer 4 to 1, 3 State Out',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='8',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='OEa',do_erc=True),
            Pin(num='2',name='A1',do_erc=True),
            Pin(num='3',name='I3a',do_erc=True),
            Pin(num='4',name='I2a',do_erc=True),
            Pin(num='5',name='I1a',do_erc=True),
            Pin(num='6',name='I0a',do_erc=True),
            Pin(num='7',name='Za',func=Pin.TRISTATE,do_erc=True),
            Pin(num='9',name='Zb',func=Pin.TRISTATE,do_erc=True),
            Pin(num='10',name='I0b',do_erc=True),
            Pin(num='11',name='I1b',do_erc=True),
            Pin(num='12',name='I2b',do_erc=True),
            Pin(num='13',name='I3b',do_erc=True),
            Pin(num='14',name='A0',do_erc=True),
            Pin(num='15',name='OEb',do_erc=True)]),
        Part(name='74LS256',dest=TEMPLATE,tool=SKIDL,do_erc=True),
        Part(name='74LS257',dest=TEMPLATE,tool=SKIDL,keywords='TTL MUX MUX2',description='Quad 2 to 1 Multiplexer',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='8',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='S',do_erc=True),
            Pin(num='2',name='I0a',do_erc=True),
            Pin(num='3',name='I1a',do_erc=True),
            Pin(num='4',name='Za',func=Pin.TRISTATE,do_erc=True),
            Pin(num='5',name='I0b',do_erc=True),
            Pin(num='6',name='I1b',do_erc=True),
            Pin(num='7',name='Zb',func=Pin.TRISTATE,do_erc=True),
            Pin(num='9',name='Zd',func=Pin.TRISTATE,do_erc=True),
            Pin(num='10',name='I1d',do_erc=True),
            Pin(num='11',name='I0d',do_erc=True),
            Pin(num='12',name='Zc',func=Pin.TRISTATE,do_erc=True),
            Pin(num='13',name='I1c',do_erc=True),
            Pin(num='14',name='I0c',do_erc=True),
            Pin(num='15',name='OE',do_erc=True)]),
        Part(name='74LS258',dest=TEMPLATE,tool=SKIDL,keywords='TTL MUX MUX2',description='Quad 2 to 1 Multiplexer,invert',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='8',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='S',do_erc=True),
            Pin(num='2',name='I0a',do_erc=True),
            Pin(num='3',name='I1a',do_erc=True),
            Pin(num='4',name='Za',func=Pin.TRISTATE,do_erc=True),
            Pin(num='5',name='I0b',do_erc=True),
            Pin(num='6',name='I1b',do_erc=True),
            Pin(num='7',name='Zb',func=Pin.TRISTATE,do_erc=True),
            Pin(num='9',name='Zd',func=Pin.TRISTATE,do_erc=True),
            Pin(num='10',name='I1d',do_erc=True),
            Pin(num='11',name='I0d',do_erc=True),
            Pin(num='12',name='Zc',func=Pin.TRISTATE,do_erc=True),
            Pin(num='13',name='I1c',do_erc=True),
            Pin(num='14',name='I0c',do_erc=True),
            Pin(num='15',name='OE',do_erc=True)]),
        Part(name='74LS259',dest=TEMPLATE,tool=SKIDL,keywords='TTL REG DFF',description='8 bits addressable latch',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='8',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='A0',do_erc=True),
            Pin(num='2',name='A1',do_erc=True),
            Pin(num='3',name='A2',do_erc=True),
            Pin(num='4',name='Q0',func=Pin.OUTPUT,do_erc=True),
            Pin(num='5',name='Q1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='6',name='Q2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='7',name='Q3',func=Pin.OUTPUT,do_erc=True),
            Pin(num='9',name='Q4',func=Pin.OUTPUT,do_erc=True),
            Pin(num='10',name='Q5',func=Pin.OUTPUT,do_erc=True),
            Pin(num='11',name='Q6',func=Pin.OUTPUT,do_erc=True),
            Pin(num='12',name='Q7',func=Pin.OUTPUT,do_erc=True),
            Pin(num='13',name='D',do_erc=True),
            Pin(num='14',name='E',do_erc=True),
            Pin(num='15',name='Clr',do_erc=True)]),
        Part(name='74LS26',dest=TEMPLATE,tool=SKIDL,keywords='TTL Nand2 OpenCol Buffer',description='Quad Buffer Nand 2 inputs Open collect.',ref_prefix='U',num_units=4,do_erc=True,aliases=['74LS38'],pins=[
            Pin(num='7',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='14',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='~',do_erc=True),
            Pin(num='2',name='~',do_erc=True),
            Pin(num='3',name='~',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='4',name='~',do_erc=True),
            Pin(num='5',name='~',do_erc=True),
            Pin(num='6',name='~',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='8',name='~',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='9',name='~',do_erc=True),
            Pin(num='10',name='~',do_erc=True),
            Pin(num='11',name='~',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='12',name='~',do_erc=True),
            Pin(num='13',name='~',do_erc=True),
            Pin(num='1',name='~',do_erc=True),
            Pin(num='2',name='~',do_erc=True),
            Pin(num='3',name='~',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='4',name='~',do_erc=True),
            Pin(num='5',name='~',do_erc=True),
            Pin(num='6',name='~',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='8',name='~',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='9',name='~',do_erc=True),
            Pin(num='10',name='~',do_erc=True),
            Pin(num='11',name='~',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='12',name='~',do_erc=True),
            Pin(num='13',name='~',do_erc=True)]),
        Part(name='74LS27',dest=TEMPLATE,tool=SKIDL,keywords='TTL Nor3',description='Triple Nr 3 inputs',ref_prefix='U',num_units=3,do_erc=True,pins=[
            Pin(num='7',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='14',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='~',do_erc=True),
            Pin(num='2',name='~',do_erc=True),
            Pin(num='12',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='13',name='~',do_erc=True),
            Pin(num='3',name='~',do_erc=True),
            Pin(num='4',name='~',do_erc=True),
            Pin(num='5',name='~',do_erc=True),
            Pin(num='6',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='8',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='9',name='~',do_erc=True),
            Pin(num='10',name='~',do_erc=True),
            Pin(num='11',name='~',do_erc=True),
            Pin(num='1',name='~',do_erc=True),
            Pin(num='2',name='~',do_erc=True),
            Pin(num='12',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='13',name='~',do_erc=True),
            Pin(num='3',name='~',do_erc=True),
            Pin(num='4',name='~',do_erc=True),
            Pin(num='5',name='~',do_erc=True),
            Pin(num='6',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='8',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='9',name='~',do_erc=True),
            Pin(num='10',name='~',do_erc=True),
            Pin(num='11',name='~',do_erc=True)]),
        Part(name='74LS273',dest=TEMPLATE,tool=SKIDL,keywords='TTL DFF DFF8',description='8 bits D FlipFlop, reset',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='10',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='20',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='Mr',do_erc=True),
            Pin(num='2',name='Q0',func=Pin.OUTPUT,do_erc=True),
            Pin(num='3',name='D0',do_erc=True),
            Pin(num='4',name='D1',do_erc=True),
            Pin(num='5',name='Q1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='6',name='Q2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='7',name='D2',do_erc=True),
            Pin(num='8',name='D3',do_erc=True),
            Pin(num='9',name='Q3',func=Pin.OUTPUT,do_erc=True),
            Pin(num='11',name='Cp',do_erc=True),
            Pin(num='12',name='Q4',func=Pin.OUTPUT,do_erc=True),
            Pin(num='13',name='D4',do_erc=True),
            Pin(num='14',name='D5',do_erc=True),
            Pin(num='15',name='Q5',func=Pin.OUTPUT,do_erc=True),
            Pin(num='16',name='Q6',func=Pin.OUTPUT,do_erc=True),
            Pin(num='17',name='D6',do_erc=True),
            Pin(num='18',name='D7',do_erc=True),
            Pin(num='19',name='Q7',func=Pin.OUTPUT,do_erc=True)]),
        Part(name='74LS280',dest=TEMPLATE,tool=SKIDL,keywords='TTL ALU Arith',description='Parity Generator/Checker',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='7',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='14',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='G',do_erc=True),
            Pin(num='2',name='H',do_erc=True),
            Pin(num='4',name='I',do_erc=True),
            Pin(num='5',name='Even',func=Pin.OUTPUT,do_erc=True),
            Pin(num='6',name='Odd',func=Pin.OUTPUT,do_erc=True),
            Pin(num='8',name='A',do_erc=True),
            Pin(num='9',name='B',do_erc=True),
            Pin(num='10',name='C',do_erc=True),
            Pin(num='11',name='D',do_erc=True),
            Pin(num='12',name='E',do_erc=True),
            Pin(num='13',name='F',do_erc=True)]),
        Part(name='74LS283',dest=TEMPLATE,tool=SKIDL,keywords='TTL ADD Arith ALU',description='4 bits full Adder',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='8',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='S2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='2',name='B2',do_erc=True),
            Pin(num='3',name='A2',do_erc=True),
            Pin(num='4',name='S1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='5',name='A1',do_erc=True),
            Pin(num='6',name='B1',do_erc=True),
            Pin(num='7',name='C0',do_erc=True),
            Pin(num='9',name='C4',func=Pin.OUTPUT,do_erc=True),
            Pin(num='10',name='S4',func=Pin.OUTPUT,do_erc=True),
            Pin(num='11',name='B4',do_erc=True),
            Pin(num='12',name='A4',do_erc=True),
            Pin(num='13',name='S3',func=Pin.OUTPUT,do_erc=True),
            Pin(num='14',name='A3',do_erc=True),
            Pin(num='15',name='B3',do_erc=True)]),
        Part(name='74LS290',dest=TEMPLATE,tool=SKIDL,keywords='TTL CNT CNT4',description='4 bits binary counter',ref_prefix='U',num_units=1,do_erc=True,aliases=['74LS293'],pins=[
            Pin(num='7',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='14',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='Ms1',do_erc=True),
            Pin(num='3',name='Ms2',do_erc=True),
            Pin(num='4',name='Q2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='5',name='Q1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='8',name='Q3',func=Pin.OUTPUT,do_erc=True),
            Pin(num='9',name='Q0',func=Pin.OUTPUT,do_erc=True),
            Pin(num='10',name='Cp0',do_erc=True),
            Pin(num='11',name='Cp1',do_erc=True),
            Pin(num='12',name='Mr1',do_erc=True),
            Pin(num='13',name='Mr2',do_erc=True)]),
        Part(name='74LS295',dest=TEMPLATE,tool=SKIDL,do_erc=True),
        Part(name='74LS298',dest=TEMPLATE,tool=SKIDL,keywords='TTL MUX MUX2',description='Quad 2 to 1 multiplexer with storage',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='8',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='I1b',do_erc=True),
            Pin(num='2',name='I1a',do_erc=True),
            Pin(num='3',name='I0a',do_erc=True),
            Pin(num='4',name='I0b',do_erc=True),
            Pin(num='5',name='I1c',do_erc=True),
            Pin(num='6',name='I1d',do_erc=True),
            Pin(num='7',name='I0d',do_erc=True),
            Pin(num='9',name='I0c',do_erc=True),
            Pin(num='10',name='S',do_erc=True),
            Pin(num='11',name='Cp',do_erc=True),
            Pin(num='12',name='Qd',func=Pin.OUTPUT,do_erc=True),
            Pin(num='13',name='Qc',func=Pin.OUTPUT,do_erc=True),
            Pin(num='14',name='Qb',func=Pin.OUTPUT,do_erc=True),
            Pin(num='15',name='Qa',func=Pin.OUTPUT,do_erc=True)]),
        Part(name='74LS299',dest=TEMPLATE,tool=SKIDL,keywords='TTL REG SR SR8',description='8 bits Universer shift/storage Register',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='10',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='20',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='S0',do_erc=True),
            Pin(num='2',name='OE1',do_erc=True),
            Pin(num='3',name='OE2',do_erc=True),
            Pin(num='4',name='IO6',func=Pin.TRISTATE,do_erc=True),
            Pin(num='5',name='IO4',func=Pin.TRISTATE,do_erc=True),
            Pin(num='6',name='IO2',func=Pin.TRISTATE,do_erc=True),
            Pin(num='7',name='IO0',func=Pin.TRISTATE,do_erc=True),
            Pin(num='8',name='Q0',func=Pin.OUTPUT,do_erc=True),
            Pin(num='9',name='Mr',do_erc=True),
            Pin(num='11',name='Ds0',do_erc=True),
            Pin(num='12',name='Cp',do_erc=True),
            Pin(num='13',name='IO1',func=Pin.TRISTATE,do_erc=True),
            Pin(num='14',name='IO3',func=Pin.TRISTATE,do_erc=True),
            Pin(num='15',name='IO5',func=Pin.TRISTATE,do_erc=True),
            Pin(num='16',name='IO7',func=Pin.TRISTATE,do_erc=True),
            Pin(num='17',name='Q7',func=Pin.OUTPUT,do_erc=True),
            Pin(num='18',name='Ds7',do_erc=True),
            Pin(num='19',name='S1',do_erc=True)]),
        Part(name='74LS30',dest=TEMPLATE,tool=SKIDL,keywords='TTL Nand8',description='Nand 8 inputs',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='7',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='14',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='~',do_erc=True),
            Pin(num='2',name='~',do_erc=True),
            Pin(num='3',name='~',do_erc=True),
            Pin(num='4',name='~',do_erc=True),
            Pin(num='5',name='~',do_erc=True),
            Pin(num='6',name='~',do_erc=True),
            Pin(num='8',name='~',do_erc=True),
            Pin(num='11',name='~',do_erc=True),
            Pin(num='12',name='~',do_erc=True),
            Pin(num='1',name='~',do_erc=True),
            Pin(num='2',name='~',do_erc=True),
            Pin(num='3',name='~',do_erc=True),
            Pin(num='4',name='~',do_erc=True),
            Pin(num='5',name='~',do_erc=True),
            Pin(num='6',name='~',do_erc=True),
            Pin(num='8',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='11',name='~',do_erc=True),
            Pin(num='12',name='~',do_erc=True)]),
        Part(name='74LS32',dest=TEMPLATE,tool=SKIDL,keywords='TTL Or2',description='Quad Or 2 inputs',ref_prefix='U',num_units=4,do_erc=True,pins=[
            Pin(num='7',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='14',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='~',do_erc=True),
            Pin(num='2',name='~',do_erc=True),
            Pin(num='3',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='4',name='~',do_erc=True),
            Pin(num='5',name='~',do_erc=True),
            Pin(num='6',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='8',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='9',name='~',do_erc=True),
            Pin(num='10',name='~',do_erc=True),
            Pin(num='11',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='12',name='~',do_erc=True),
            Pin(num='13',name='~',do_erc=True),
            Pin(num='1',name='~',do_erc=True),
            Pin(num='2',name='~',do_erc=True),
            Pin(num='3',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='4',name='~',do_erc=True),
            Pin(num='5',name='~',do_erc=True),
            Pin(num='6',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='8',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='9',name='~',do_erc=True),
            Pin(num='10',name='~',do_erc=True),
            Pin(num='11',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='12',name='~',do_erc=True),
            Pin(num='13',name='~',do_erc=True)]),
        Part(name='74LS322',dest=TEMPLATE,tool=SKIDL,do_erc=True),
        Part(name='74LS323',dest=TEMPLATE,tool=SKIDL,keywords='TTL REG SR SR8',description='8 bits Universal Shift/Storage Register',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='10',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='20',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='S0',do_erc=True),
            Pin(num='2',name='OE1',do_erc=True),
            Pin(num='3',name='OE2',do_erc=True),
            Pin(num='4',name='IO6',func=Pin.TRISTATE,do_erc=True),
            Pin(num='5',name='IO4',func=Pin.TRISTATE,do_erc=True),
            Pin(num='6',name='IO2',func=Pin.TRISTATE,do_erc=True),
            Pin(num='7',name='IO0',func=Pin.TRISTATE,do_erc=True),
            Pin(num='8',name='Q0',func=Pin.OUTPUT,do_erc=True),
            Pin(num='9',name='SR',do_erc=True),
            Pin(num='11',name='DS0',do_erc=True),
            Pin(num='12',name='Cp',do_erc=True),
            Pin(num='13',name='IO1',func=Pin.TRISTATE,do_erc=True),
            Pin(num='14',name='IO3',func=Pin.TRISTATE,do_erc=True),
            Pin(num='15',name='IO5',func=Pin.TRISTATE,do_erc=True),
            Pin(num='16',name='IO7',func=Pin.TRISTATE,do_erc=True),
            Pin(num='17',name='Q7',func=Pin.OUTPUT,do_erc=True),
            Pin(num='18',name='DS7',do_erc=True),
            Pin(num='19',name='S1',do_erc=True)]),
        Part(name='74LS33',dest=TEMPLATE,tool=SKIDL,keywords='TTL Nand8 OpenCol',description='Quad Nand 2 inputs, Open collect.',ref_prefix='U',num_units=4,do_erc=True,pins=[
            Pin(num='7',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='14',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='~',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='2',name='~',do_erc=True),
            Pin(num='3',name='~',do_erc=True),
            Pin(num='4',name='~',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='5',name='~',do_erc=True),
            Pin(num='6',name='~',do_erc=True),
            Pin(num='8',name='~',do_erc=True),
            Pin(num='9',name='~',do_erc=True),
            Pin(num='10',name='~',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='11',name='~',do_erc=True),
            Pin(num='12',name='~',do_erc=True),
            Pin(num='13',name='~',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='1',name='~',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='2',name='~',do_erc=True),
            Pin(num='3',name='~',do_erc=True),
            Pin(num='4',name='~',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='5',name='~',do_erc=True),
            Pin(num='6',name='~',do_erc=True),
            Pin(num='8',name='~',do_erc=True),
            Pin(num='9',name='~',do_erc=True),
            Pin(num='10',name='~',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='11',name='~',do_erc=True),
            Pin(num='12',name='~',do_erc=True),
            Pin(num='13',name='~',func=Pin.OPENCOLL,do_erc=True)]),
        Part(name='74LS348',dest=TEMPLATE,tool=SKIDL,keywords='TTL ENCOD Arith',description='8 to 3 lines Priority Encoder',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='8',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='4',do_erc=True),
            Pin(num='2',name='5',do_erc=True),
            Pin(num='3',name='6',do_erc=True),
            Pin(num='4',name='7',do_erc=True),
            Pin(num='5',name='EI',do_erc=True),
            Pin(num='6',name='A2',func=Pin.TRISTATE,do_erc=True),
            Pin(num='7',name='A1',func=Pin.TRISTATE,do_erc=True),
            Pin(num='9',name='A0',func=Pin.TRISTATE,do_erc=True),
            Pin(num='10',name='0',do_erc=True),
            Pin(num='11',name='1',do_erc=True),
            Pin(num='12',name='2',do_erc=True),
            Pin(num='13',name='3',do_erc=True),
            Pin(num='14',name='GS',func=Pin.OUTPUT,do_erc=True),
            Pin(num='15',name='E0',func=Pin.OUTPUT,do_erc=True)]),
        Part(name='74LS352',dest=TEMPLATE,tool=SKIDL,keywords='TTL Mux MUX4',description='Dual 4 to 1 line Multiplexer',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='8',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='Ea',do_erc=True),
            Pin(num='2',name='S1',do_erc=True),
            Pin(num='3',name='I3a',do_erc=True),
            Pin(num='4',name='I2a',do_erc=True),
            Pin(num='5',name='I1a',do_erc=True),
            Pin(num='6',name='I0a',do_erc=True),
            Pin(num='7',name='Za',func=Pin.OUTPUT,do_erc=True),
            Pin(num='9',name='Zb',func=Pin.OUTPUT,do_erc=True),
            Pin(num='10',name='I0b',do_erc=True),
            Pin(num='11',name='I1b',do_erc=True),
            Pin(num='12',name='I2b',do_erc=True),
            Pin(num='13',name='I3b',do_erc=True),
            Pin(num='14',name='S0',do_erc=True),
            Pin(num='15',name='Eb',do_erc=True)]),
        Part(name='74LS353',dest=TEMPLATE,tool=SKIDL,keywords='TTL MUX MUX2',description='Dual 4 to 1 line Multiplexer, inverter',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='8',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='OEa',do_erc=True),
            Pin(num='2',name='A1',do_erc=True),
            Pin(num='3',name='I3a',do_erc=True),
            Pin(num='4',name='I2a',do_erc=True),
            Pin(num='5',name='I1a',do_erc=True),
            Pin(num='6',name='I0a',do_erc=True),
            Pin(num='7',name='Za',func=Pin.TRISTATE,do_erc=True),
            Pin(num='9',name='Zb',func=Pin.TRISTATE,do_erc=True),
            Pin(num='10',name='I0b',do_erc=True),
            Pin(num='11',name='I1b',do_erc=True),
            Pin(num='12',name='I2b',do_erc=True),
            Pin(num='13',name='I3b',do_erc=True),
            Pin(num='14',name='A0',do_erc=True),
            Pin(num='15',name='OEb',do_erc=True)]),
        Part(name='74LS365',dest=TEMPLATE,tool=SKIDL,keywords='TTL Buffer BUS 3State',description='Hex Bus Driver, 3 State Out',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='8',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='E1',do_erc=True),
            Pin(num='2',name='I1',do_erc=True),
            Pin(num='3',name='O1',func=Pin.TRISTATE,do_erc=True),
            Pin(num='4',name='I2',do_erc=True),
            Pin(num='5',name='O2',func=Pin.TRISTATE,do_erc=True),
            Pin(num='6',name='I3',do_erc=True),
            Pin(num='7',name='O3',func=Pin.TRISTATE,do_erc=True),
            Pin(num='9',name='O4',func=Pin.TRISTATE,do_erc=True),
            Pin(num='10',name='I4',do_erc=True),
            Pin(num='11',name='O5',func=Pin.TRISTATE,do_erc=True),
            Pin(num='12',name='I5',do_erc=True),
            Pin(num='13',name='O6',func=Pin.TRISTATE,do_erc=True),
            Pin(num='14',name='I6',do_erc=True),
            Pin(num='15',name='E2',do_erc=True)]),
        Part(name='74LS366',dest=TEMPLATE,tool=SKIDL,keywords='TTL Buffer BUS 3State',description='Hex Bus Driver inverter, 3 state out',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='8',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='E1',do_erc=True),
            Pin(num='2',name='I1',do_erc=True),
            Pin(num='3',name='O1',func=Pin.TRISTATE,do_erc=True),
            Pin(num='4',name='I2',do_erc=True),
            Pin(num='5',name='O2',func=Pin.TRISTATE,do_erc=True),
            Pin(num='6',name='I3',do_erc=True),
            Pin(num='7',name='O3',func=Pin.TRISTATE,do_erc=True),
            Pin(num='9',name='O4',func=Pin.TRISTATE,do_erc=True),
            Pin(num='10',name='I4',do_erc=True),
            Pin(num='11',name='O5',func=Pin.TRISTATE,do_erc=True),
            Pin(num='12',name='I5',do_erc=True),
            Pin(num='13',name='O6',func=Pin.TRISTATE,do_erc=True),
            Pin(num='14',name='I6',do_erc=True),
            Pin(num='15',name='E2',do_erc=True)]),
        Part(name='74LS367',dest=TEMPLATE,tool=SKIDL,keywords='TTL Buffer BUS 3State',description='Hex Bus Driver 3 state Out',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='8',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='OEa',do_erc=True),
            Pin(num='2',name='I1',do_erc=True),
            Pin(num='3',name='O1a',func=Pin.TRISTATE,do_erc=True),
            Pin(num='4',name='I2',do_erc=True),
            Pin(num='5',name='O2a',func=Pin.TRISTATE,do_erc=True),
            Pin(num='6',name='I3',do_erc=True),
            Pin(num='7',name='O3a',func=Pin.TRISTATE,do_erc=True),
            Pin(num='9',name='O4a',func=Pin.TRISTATE,do_erc=True),
            Pin(num='10',name='I4',do_erc=True),
            Pin(num='11',name='O5b',func=Pin.TRISTATE,do_erc=True),
            Pin(num='12',name='I5',do_erc=True),
            Pin(num='13',name='O6b',func=Pin.TRISTATE,do_erc=True),
            Pin(num='14',name='I6',do_erc=True),
            Pin(num='15',name='OEb',do_erc=True)]),
        Part(name='74LS368',dest=TEMPLATE,tool=SKIDL,keywords='TTL Buffer BUS 3State',description='Hex Bus Driver inverter, 3 state Out',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='8',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='OEa',do_erc=True),
            Pin(num='2',name='I1',do_erc=True),
            Pin(num='3',name='O1a',func=Pin.TRISTATE,do_erc=True),
            Pin(num='4',name='I2',do_erc=True),
            Pin(num='5',name='O2a',func=Pin.TRISTATE,do_erc=True),
            Pin(num='6',name='I3',do_erc=True),
            Pin(num='7',name='O3a',func=Pin.TRISTATE,do_erc=True),
            Pin(num='9',name='O4a',func=Pin.TRISTATE,do_erc=True),
            Pin(num='10',name='I4',do_erc=True),
            Pin(num='11',name='O5b',func=Pin.TRISTATE,do_erc=True),
            Pin(num='12',name='I5',do_erc=True),
            Pin(num='13',name='O6b',func=Pin.TRISTATE,do_erc=True),
            Pin(num='14',name='I6',do_erc=True),
            Pin(num='15',name='OEb',do_erc=True)]),
        Part(name='74LS373',dest=TEMPLATE,tool=SKIDL,keywords='TTL REG DFF DFF8 LATCH',description='8 bits Latch, 3 state Out',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='10',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='20',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='OE',do_erc=True),
            Pin(num='2',name='O0',func=Pin.TRISTATE,do_erc=True),
            Pin(num='3',name='D0',do_erc=True),
            Pin(num='4',name='D1',do_erc=True),
            Pin(num='5',name='O1',func=Pin.TRISTATE,do_erc=True),
            Pin(num='6',name='O2',func=Pin.TRISTATE,do_erc=True),
            Pin(num='7',name='D2',do_erc=True),
            Pin(num='8',name='D3',do_erc=True),
            Pin(num='9',name='O3',func=Pin.TRISTATE,do_erc=True),
            Pin(num='11',name='LE',do_erc=True),
            Pin(num='12',name='O4',func=Pin.TRISTATE,do_erc=True),
            Pin(num='13',name='D4',do_erc=True),
            Pin(num='14',name='D5',do_erc=True),
            Pin(num='15',name='O5',func=Pin.TRISTATE,do_erc=True),
            Pin(num='16',name='O6',func=Pin.TRISTATE,do_erc=True),
            Pin(num='17',name='D6',do_erc=True),
            Pin(num='18',name='D7',do_erc=True),
            Pin(num='19',name='O7',func=Pin.TRISTATE,do_erc=True)]),
        Part(name='74LS374',dest=TEMPLATE,tool=SKIDL,keywords='TTL DFF DFF8 REG 3State',description='8 bits Register, 3 state Out',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='10',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='20',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='OE',do_erc=True),
            Pin(num='2',name='O0',func=Pin.TRISTATE,do_erc=True),
            Pin(num='3',name='D0',do_erc=True),
            Pin(num='4',name='D1',do_erc=True),
            Pin(num='5',name='O1',func=Pin.TRISTATE,do_erc=True),
            Pin(num='6',name='O2',func=Pin.TRISTATE,do_erc=True),
            Pin(num='7',name='D2',do_erc=True),
            Pin(num='8',name='D3',do_erc=True),
            Pin(num='9',name='O3',func=Pin.TRISTATE,do_erc=True),
            Pin(num='11',name='Cp',do_erc=True),
            Pin(num='12',name='O4',func=Pin.TRISTATE,do_erc=True),
            Pin(num='13',name='D4',do_erc=True),
            Pin(num='14',name='D5',do_erc=True),
            Pin(num='15',name='O5',func=Pin.TRISTATE,do_erc=True),
            Pin(num='16',name='O6',func=Pin.TRISTATE,do_erc=True),
            Pin(num='17',name='D6',do_erc=True),
            Pin(num='18',name='D7',do_erc=True),
            Pin(num='19',name='O7',func=Pin.TRISTATE,do_erc=True)]),
        Part(name='74LS375',dest=TEMPLATE,tool=SKIDL,keywords='TTL DFF DFF4 Latch',description='4 bits Latch',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='8',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='D0',do_erc=True),
            Pin(num='2',name='~Q0',func=Pin.OUTPUT,do_erc=True),
            Pin(num='3',name='Q0',func=Pin.OUTPUT,do_erc=True),
            Pin(num='4',name='E01',do_erc=True),
            Pin(num='5',name='Q1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='6',name='~Q1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='7',name='D1',do_erc=True),
            Pin(num='9',name='D2',do_erc=True),
            Pin(num='10',name='~Q2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='11',name='Q2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='12',name='E23',do_erc=True),
            Pin(num='13',name='Q3',func=Pin.OUTPUT,do_erc=True),
            Pin(num='14',name='~Q3',func=Pin.OUTPUT,do_erc=True),
            Pin(num='15',name='D3',do_erc=True)]),
        Part(name='74LS377',dest=TEMPLATE,tool=SKIDL,keywords='TTL REG DFF DFF8',description='8 bit Register',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='10',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='20',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='EO',do_erc=True),
            Pin(num='2',name='Q0',func=Pin.OUTPUT,do_erc=True),
            Pin(num='3',name='D0',do_erc=True),
            Pin(num='4',name='D1',do_erc=True),
            Pin(num='5',name='Q1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='6',name='Q2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='7',name='D2',do_erc=True),
            Pin(num='8',name='D3',do_erc=True),
            Pin(num='9',name='Q3',func=Pin.OUTPUT,do_erc=True),
            Pin(num='11',name='Cp',do_erc=True),
            Pin(num='12',name='Q4',func=Pin.OUTPUT,do_erc=True),
            Pin(num='13',name='D4',do_erc=True),
            Pin(num='14',name='D5',do_erc=True),
            Pin(num='15',name='Q5',func=Pin.OUTPUT,do_erc=True),
            Pin(num='16',name='Q6',func=Pin.OUTPUT,do_erc=True),
            Pin(num='17',name='D6',do_erc=True),
            Pin(num='18',name='D7',do_erc=True),
            Pin(num='19',name='Q7',func=Pin.OUTPUT,do_erc=True)]),
        Part(name='74LS378',dest=TEMPLATE,tool=SKIDL,keywords='TTL REG DFF DFF6',description='6 bits Register',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='8',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='~E',do_erc=True),
            Pin(num='2',name='Q0',func=Pin.OUTPUT,do_erc=True),
            Pin(num='3',name='D0',do_erc=True),
            Pin(num='4',name='D1',do_erc=True),
            Pin(num='5',name='Q1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='6',name='D2',do_erc=True),
            Pin(num='7',name='Q2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='9',name='Cp',do_erc=True),
            Pin(num='10',name='Q3',func=Pin.OUTPUT,do_erc=True),
            Pin(num='11',name='D3',do_erc=True),
            Pin(num='12',name='Q4',func=Pin.OUTPUT,do_erc=True),
            Pin(num='13',name='D4',do_erc=True),
            Pin(num='14',name='D5',do_erc=True),
            Pin(num='15',name='Q5',func=Pin.OUTPUT,do_erc=True)]),
        Part(name='74LS379',dest=TEMPLATE,tool=SKIDL,keywords='TTL REG DFF DFF4',description='4 bits Register',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='16',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='CE',do_erc=True),
            Pin(num='2',name='Q0',func=Pin.OUTPUT,do_erc=True),
            Pin(num='3',name='~Q0',func=Pin.OUTPUT,do_erc=True),
            Pin(num='4',name='D0',do_erc=True),
            Pin(num='5',name='D1',do_erc=True),
            Pin(num='6',name='~Q1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='7',name='Q1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='8',name='GND',do_erc=True),
            Pin(num='9',name='Cp',do_erc=True),
            Pin(num='10',name='Q2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='11',name='~Q2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='12',name='D2',do_erc=True),
            Pin(num='13',name='D3',do_erc=True),
            Pin(num='14',name='~Q3',func=Pin.OUTPUT,do_erc=True),
            Pin(num='15',name='Q3',func=Pin.OUTPUT,do_erc=True)]),
        Part(name='74LS385',dest=TEMPLATE,tool=SKIDL,keywords='TTL ADD Arith ALU',description='Quad serial Adder',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='10',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='20',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='Clk',do_erc=True),
            Pin(num='2',name='1S',do_erc=True),
            Pin(num='3',name='1S/A',do_erc=True),
            Pin(num='4',name='1B',do_erc=True),
            Pin(num='5',name='1A',do_erc=True),
            Pin(num='6',name='2A',do_erc=True),
            Pin(num='7',name='2B',do_erc=True),
            Pin(num='8',name='2S/A',do_erc=True),
            Pin(num='9',name='2S',do_erc=True),
            Pin(num='11',name='Clr',do_erc=True),
            Pin(num='12',name='3S',func=Pin.OUTPUT,do_erc=True),
            Pin(num='13',name='3S/A',func=Pin.OUTPUT,do_erc=True),
            Pin(num='14',name='3B',func=Pin.OUTPUT,do_erc=True),
            Pin(num='15',name='3A',func=Pin.OUTPUT,do_erc=True),
            Pin(num='16',name='4A',func=Pin.OUTPUT,do_erc=True),
            Pin(num='17',name='4B',func=Pin.OUTPUT,do_erc=True),
            Pin(num='18',name='4S/A',func=Pin.OUTPUT,do_erc=True),
            Pin(num='19',name='4S',func=Pin.OUTPUT,do_erc=True)]),
        Part(name='74LS386',dest=TEMPLATE,tool=SKIDL,keywords='TTL XOR2',description='Quad 2 input XOR',ref_prefix='U',num_units=4,do_erc=True,pins=[
            Pin(num='7',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='14',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='~',do_erc=True),
            Pin(num='2',name='~',do_erc=True),
            Pin(num='3',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='4',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='5',name='~',do_erc=True),
            Pin(num='6',name='~',do_erc=True),
            Pin(num='8',name='~',do_erc=True),
            Pin(num='9',name='~',do_erc=True),
            Pin(num='10',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='11',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='12',name='~',do_erc=True),
            Pin(num='13',name='~',do_erc=True),
            Pin(num='1',name='~',do_erc=True),
            Pin(num='2',name='~',do_erc=True),
            Pin(num='3',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='4',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='5',name='~',do_erc=True),
            Pin(num='6',name='~',do_erc=True),
            Pin(num='8',name='~',do_erc=True),
            Pin(num='9',name='~',do_erc=True),
            Pin(num='10',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='11',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='12',name='~',do_erc=True),
            Pin(num='13',name='~',do_erc=True)]),
        Part(name='74LS390',dest=TEMPLATE,tool=SKIDL,keywords='TTL CNT CNT4',description='Dual BDC 4 bits counter',ref_prefix='U',num_units=2,do_erc=True,pins=[
            Pin(num='8',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='Cp0',do_erc=True),
            Pin(num='2',name='Mr',do_erc=True),
            Pin(num='3',name='Q0',func=Pin.OUTPUT,do_erc=True),
            Pin(num='4',name='Cp1',do_erc=True),
            Pin(num='5',name='Q1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='6',name='Q2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='7',name='Q3',func=Pin.OUTPUT,do_erc=True),
            Pin(num='9',name='Q3',func=Pin.OUTPUT,do_erc=True),
            Pin(num='10',name='Q2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='11',name='Q1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='12',name='Cp1',do_erc=True),
            Pin(num='13',name='Q0',func=Pin.OUTPUT,do_erc=True),
            Pin(num='14',name='Mr',do_erc=True),
            Pin(num='15',name='Cp0',do_erc=True)]),
        Part(name='74LS393',dest=TEMPLATE,tool=SKIDL,keywords='TTL CNT CNT4',description='Dual BDC 4 bits counter',ref_prefix='U',num_units=2,do_erc=True,pins=[
            Pin(num='7',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='14',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='Cp',do_erc=True),
            Pin(num='2',name='Mr',do_erc=True),
            Pin(num='3',name='Q0',func=Pin.OUTPUT,do_erc=True),
            Pin(num='4',name='Q1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='5',name='Q2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='6',name='Q3',func=Pin.OUTPUT,do_erc=True),
            Pin(num='8',name='Q3',func=Pin.OUTPUT,do_erc=True),
            Pin(num='9',name='Q2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='10',name='Q1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='11',name='Q0',func=Pin.OUTPUT,do_erc=True),
            Pin(num='12',name='Mr',do_erc=True),
            Pin(num='13',name='Cp',do_erc=True)]),
        Part(name='74LS395',dest=TEMPLATE,tool=SKIDL,keywords='TTL SR SR4 REG 3State',description='4 bits universal shift register, 3 state out',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='8',name='GND',do_erc=True),
            Pin(num='16',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='MR',do_erc=True),
            Pin(num='2',name='Ds',do_erc=True),
            Pin(num='3',name='P0',do_erc=True),
            Pin(num='4',name='P1',do_erc=True),
            Pin(num='5',name='P2',do_erc=True),
            Pin(num='6',name='P3',do_erc=True),
            Pin(num='7',name='L/S',do_erc=True),
            Pin(num='9',name='OE',do_erc=True),
            Pin(num='10',name='Cp',do_erc=True),
            Pin(num='11',name="Q'3",func=Pin.OUTPUT,do_erc=True),
            Pin(num='12',name='Q3',func=Pin.TRISTATE,do_erc=True),
            Pin(num='13',name='Q2',func=Pin.TRISTATE,do_erc=True),
            Pin(num='14',name='Q1',func=Pin.TRISTATE,do_erc=True),
            Pin(num='15',name='Q0',func=Pin.TRISTATE,do_erc=True)]),
        Part(name='74LS398',dest=TEMPLATE,tool=SKIDL,keywords='TTL MUX MUX2 3State',description='Quad 2 to 1 line Multiplexer, 3 state out',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='10',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='20',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='Qa',func=Pin.OUTPUT,do_erc=True),
            Pin(num='3',name='~QA',func=Pin.OUTPUT,do_erc=True),
            Pin(num='4',name='I0a',do_erc=True),
            Pin(num='5',name='I1a',do_erc=True),
            Pin(num='6',name='I1b',do_erc=True),
            Pin(num='7',name='I0b',do_erc=True),
            Pin(num='8',name='~Qb',func=Pin.OUTPUT,do_erc=True),
            Pin(num='9',name='Qb',func=Pin.OUTPUT,do_erc=True),
            Pin(num='10',name='S',do_erc=True),
            Pin(num='11',name='Cp',do_erc=True),
            Pin(num='12',name='Qc',func=Pin.OUTPUT,do_erc=True),
            Pin(num='13',name='~Qc',func=Pin.OUTPUT,do_erc=True),
            Pin(num='14',name='I0c',do_erc=True),
            Pin(num='15',name='I1c',do_erc=True),
            Pin(num='16',name='I1d',do_erc=True),
            Pin(num='17',name='I0d',do_erc=True),
            Pin(num='18',name='~Qd',func=Pin.OUTPUT,do_erc=True),
            Pin(num='19',name='Qd',func=Pin.OUTPUT,do_erc=True)]),
        Part(name='74LS399',dest=TEMPLATE,tool=SKIDL,keywords='TTL MUX MUX2',description='Quad 2 to 1 line multiplexer with storage',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='8',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='Sel',do_erc=True),
            Pin(num='2',name='Qa',func=Pin.OUTPUT,do_erc=True),
            Pin(num='3',name='I0a',do_erc=True),
            Pin(num='4',name='I1a',do_erc=True),
            Pin(num='5',name='I1b',do_erc=True),
            Pin(num='6',name='I0b',do_erc=True),
            Pin(num='7',name='Qb',func=Pin.OUTPUT,do_erc=True),
            Pin(num='9',name='Cp',do_erc=True),
            Pin(num='10',name='Qc',func=Pin.OUTPUT,do_erc=True),
            Pin(num='11',name='I0c',do_erc=True),
            Pin(num='12',name='I1c',do_erc=True),
            Pin(num='13',name='I1d',do_erc=True),
            Pin(num='14',name='I0d',do_erc=True),
            Pin(num='15',name='Qd',func=Pin.OUTPUT,do_erc=True)]),
        Part(name='74LS42',dest=TEMPLATE,tool=SKIDL,keywords='TTL DECOD DECOD10',description='4 to 10 line DECODER',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='8',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='0',func=Pin.OUTPUT,do_erc=True),
            Pin(num='2',name='1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='3',name='2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='4',name='3',func=Pin.OUTPUT,do_erc=True),
            Pin(num='5',name='4',func=Pin.OUTPUT,do_erc=True),
            Pin(num='6',name='5',func=Pin.OUTPUT,do_erc=True),
            Pin(num='7',name='6',func=Pin.OUTPUT,do_erc=True),
            Pin(num='9',name='7',func=Pin.OUTPUT,do_erc=True),
            Pin(num='10',name='8',func=Pin.OUTPUT,do_erc=True),
            Pin(num='11',name='9',func=Pin.OUTPUT,do_erc=True),
            Pin(num='12',name='A3',do_erc=True),
            Pin(num='13',name='A2',do_erc=True),
            Pin(num='14',name='A1',do_erc=True),
            Pin(num='15',name='A0',do_erc=True)]),
        Part(name='74LS47',dest=TEMPLATE,tool=SKIDL,keywords='TTL DECOD DECOD7 OpenCol',description='BCD to 7 segments Driver, Open Collect, 30V outputs',ref_prefix='U',num_units=1,do_erc=True,aliases=['74LS46'],pins=[
            Pin(num='8',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='B',do_erc=True),
            Pin(num='2',name='C',do_erc=True),
            Pin(num='3',name='LT',do_erc=True),
            Pin(num='4',name='BI',do_erc=True),
            Pin(num='5',name='RBI',do_erc=True),
            Pin(num='6',name='D',do_erc=True),
            Pin(num='7',name='A',do_erc=True),
            Pin(num='9',name='e',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='10',name='d',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='11',name='c',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='12',name='b',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='13',name='a',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='14',name='g',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='15',name='f',func=Pin.OPENCOLL,do_erc=True)]),
        Part(name='74LS48',dest=TEMPLATE,tool=SKIDL,keywords='TTL DECOD DECOD7',description='BCD to 7 segments Decoder/driver, Active High outputs',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='8',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='B',do_erc=True),
            Pin(num='2',name='C',do_erc=True),
            Pin(num='3',name='LT',do_erc=True),
            Pin(num='4',name='BI',do_erc=True),
            Pin(num='5',name='RBI',do_erc=True),
            Pin(num='6',name='D',do_erc=True),
            Pin(num='7',name='A',do_erc=True),
            Pin(num='9',name='e',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='10',name='d',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='11',name='c',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='12',name='b',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='13',name='a',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='14',name='g',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='15',name='f',func=Pin.OPENCOLL,do_erc=True)]),
        Part(name='74LS49',dest=TEMPLATE,tool=SKIDL,keywords='TTL DECOD DECOD7 OpenCol',description='BDC to 7 segments decoder/driver, Open collect.',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='8',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='B',do_erc=True),
            Pin(num='2',name='C',do_erc=True),
            Pin(num='4',name='~BI',do_erc=True),
            Pin(num='5',name='~RBI',do_erc=True),
            Pin(num='6',name='D',do_erc=True),
            Pin(num='7',name='A',do_erc=True),
            Pin(num='9',name='e',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='10',name='d',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='11',name='c',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='12',name='b',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='13',name='a',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='14',name='g',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='15',name='f',func=Pin.OPENCOLL,do_erc=True)]),
        Part(name='74LS51',dest=TEMPLATE,tool=SKIDL,keywords='TTL ANDNOR',description='Dual 3- and 2-input AND-NOR ( S = /(AB[C] + DE[F]) )',ref_prefix='U',num_units=2,fplist=['DIP-14*'],do_erc=True,pins=[
            Pin(num='7',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='14',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='~',do_erc=True),
            Pin(num='8',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='9',name='~',do_erc=True),
            Pin(num='10',name='~',do_erc=True),
            Pin(num='11',name='~',do_erc=True),
            Pin(num='12',name='~',do_erc=True),
            Pin(num='13',name='~',do_erc=True),
            Pin(num='2',name='~',do_erc=True),
            Pin(num='3',name='~',do_erc=True),
            Pin(num='4',name='~',do_erc=True),
            Pin(num='5',name='~',do_erc=True),
            Pin(num='6',name='~',func=Pin.OUTPUT,do_erc=True)]),
        Part(name='74LS54',dest=TEMPLATE,tool=SKIDL,keywords='TTL ANDNOR',description='And-Nor (S = /(AB + CD + EF + GH) )',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='7',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='14',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='~',do_erc=True),
            Pin(num='2',name='~',do_erc=True),
            Pin(num='3',name='~',do_erc=True),
            Pin(num='4',name='~',do_erc=True),
            Pin(num='5',name='~',do_erc=True),
            Pin(num='8',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='9',name='~',do_erc=True),
            Pin(num='10',name='~',do_erc=True),
            Pin(num='13',name='~',do_erc=True)]),
        Part(name='74LS540',dest=TEMPLATE,tool=SKIDL,keywords='BUFFER BUS TTL 3State',description='8 bits Buffer/Line driver Inverter, 3 state Out',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='10',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='20',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='G1',do_erc=True),
            Pin(num='2',name='A0',do_erc=True),
            Pin(num='3',name='A1',do_erc=True),
            Pin(num='4',name='A2',do_erc=True),
            Pin(num='5',name='A3',do_erc=True),
            Pin(num='6',name='A4',do_erc=True),
            Pin(num='7',name='A5',do_erc=True),
            Pin(num='8',name='A6',do_erc=True),
            Pin(num='9',name='A7',do_erc=True),
            Pin(num='11',name='Y7',func=Pin.TRISTATE,do_erc=True),
            Pin(num='12',name='Y6',func=Pin.TRISTATE,do_erc=True),
            Pin(num='13',name='Y5',func=Pin.TRISTATE,do_erc=True),
            Pin(num='14',name='Y4',func=Pin.TRISTATE,do_erc=True),
            Pin(num='15',name='Y3',func=Pin.TRISTATE,do_erc=True),
            Pin(num='16',name='Y2',func=Pin.TRISTATE,do_erc=True),
            Pin(num='17',name='Y1',func=Pin.TRISTATE,do_erc=True),
            Pin(num='18',name='Y0',func=Pin.TRISTATE,do_erc=True),
            Pin(num='19',name='G2',do_erc=True)]),
        Part(name='74LS541',dest=TEMPLATE,tool=SKIDL,keywords='TTL BUFFER 3State BUS',description='8bits Buffer/Line Driver 3 state Out',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='10',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='20',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='G1',do_erc=True),
            Pin(num='2',name='A0',do_erc=True),
            Pin(num='3',name='A1',do_erc=True),
            Pin(num='4',name='A2',do_erc=True),
            Pin(num='5',name='A3',do_erc=True),
            Pin(num='6',name='A4',do_erc=True),
            Pin(num='7',name='A5',do_erc=True),
            Pin(num='8',name='A6',do_erc=True),
            Pin(num='9',name='A7',do_erc=True),
            Pin(num='11',name='Y7',func=Pin.TRISTATE,do_erc=True),
            Pin(num='12',name='Y6',func=Pin.TRISTATE,do_erc=True),
            Pin(num='13',name='Y5',func=Pin.TRISTATE,do_erc=True),
            Pin(num='14',name='Y4',func=Pin.TRISTATE,do_erc=True),
            Pin(num='15',name='Y3',func=Pin.TRISTATE,do_erc=True),
            Pin(num='16',name='Y2',func=Pin.TRISTATE,do_erc=True),
            Pin(num='17',name='Y1',func=Pin.TRISTATE,do_erc=True),
            Pin(num='18',name='Y0',func=Pin.TRISTATE,do_erc=True),
            Pin(num='19',name='G2',do_erc=True)]),
        Part(name='74LS55',dest=TEMPLATE,tool=SKIDL,keywords='TTL ANDNOR',description='AND-NOR ( S = / (ABCD + EFGH) )',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='7',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='14',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='~',do_erc=True),
            Pin(num='2',name='~',do_erc=True),
            Pin(num='3',name='~',do_erc=True),
            Pin(num='4',name='~',do_erc=True),
            Pin(num='8',name='Y',func=Pin.OUTPUT,do_erc=True),
            Pin(num='10',name='~',do_erc=True),
            Pin(num='11',name='~',do_erc=True),
            Pin(num='12',name='~',do_erc=True),
            Pin(num='13',name='~',do_erc=True)]),
        Part(name='74LS573',dest=TEMPLATE,tool=SKIDL,keywords='TTL DFF DFF8 LATCH 3State',description='8 bits Latch 3 state Out',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='10',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='20',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='OE',do_erc=True),
            Pin(num='2',name='D0',do_erc=True),
            Pin(num='3',name='D1',do_erc=True),
            Pin(num='4',name='D2',do_erc=True),
            Pin(num='5',name='D3',do_erc=True),
            Pin(num='6',name='D4',do_erc=True),
            Pin(num='7',name='D5',do_erc=True),
            Pin(num='8',name='D6',do_erc=True),
            Pin(num='9',name='D7',do_erc=True),
            Pin(num='11',name='Load',do_erc=True),
            Pin(num='12',name='Q7',func=Pin.TRISTATE,do_erc=True),
            Pin(num='13',name='Q6',func=Pin.TRISTATE,do_erc=True),
            Pin(num='14',name='Q5',func=Pin.TRISTATE,do_erc=True),
            Pin(num='15',name='Q4',func=Pin.TRISTATE,do_erc=True),
            Pin(num='16',name='Q3',func=Pin.TRISTATE,do_erc=True),
            Pin(num='17',name='Q2',func=Pin.TRISTATE,do_erc=True),
            Pin(num='18',name='Q1',func=Pin.TRISTATE,do_erc=True),
            Pin(num='19',name='Q0',func=Pin.TRISTATE,do_erc=True)]),
        Part(name='74LS574',dest=TEMPLATE,tool=SKIDL,keywords='TTL REG DFF DFF8 3State',description='8 bits Register, 3 state Out',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='10',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='20',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='OE',do_erc=True),
            Pin(num='2',name='D0',do_erc=True),
            Pin(num='3',name='D1',do_erc=True),
            Pin(num='4',name='D2',do_erc=True),
            Pin(num='5',name='D3',do_erc=True),
            Pin(num='6',name='D4',do_erc=True),
            Pin(num='7',name='D5',do_erc=True),
            Pin(num='8',name='D6',do_erc=True),
            Pin(num='9',name='D7',do_erc=True),
            Pin(num='11',name='Cp',do_erc=True),
            Pin(num='12',name='Q7',func=Pin.TRISTATE,do_erc=True),
            Pin(num='13',name='Q6',func=Pin.TRISTATE,do_erc=True),
            Pin(num='14',name='Q5',func=Pin.TRISTATE,do_erc=True),
            Pin(num='15',name='Q4',func=Pin.TRISTATE,do_erc=True),
            Pin(num='16',name='Q3',func=Pin.TRISTATE,do_erc=True),
            Pin(num='17',name='Q2',func=Pin.TRISTATE,do_erc=True),
            Pin(num='18',name='Q1',func=Pin.TRISTATE,do_erc=True),
            Pin(num='19',name='Q0',func=Pin.TRISTATE,do_erc=True)]),
        Part(name='74LS629',dest=TEMPLATE,tool=SKIDL,do_erc=True),
        Part(name='74LS688',dest=TEMPLATE,tool=SKIDL,keywords='TTL DECOD Arith',description='8 bits Comparator',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='10',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='20',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='G',do_erc=True),
            Pin(num='2',name='P0',do_erc=True),
            Pin(num='3',name='R0',do_erc=True),
            Pin(num='4',name='P1',do_erc=True),
            Pin(num='5',name='R1',do_erc=True),
            Pin(num='6',name='P2',do_erc=True),
            Pin(num='7',name='R2',do_erc=True),
            Pin(num='8',name='P3',do_erc=True),
            Pin(num='9',name='R3',do_erc=True),
            Pin(num='11',name='P4',do_erc=True),
            Pin(num='12',name='R4',do_erc=True),
            Pin(num='13',name='P5',do_erc=True),
            Pin(num='14',name='R5',do_erc=True),
            Pin(num='15',name='P6',do_erc=True),
            Pin(num='16',name='R6',do_erc=True),
            Pin(num='17',name='P7',do_erc=True),
            Pin(num='18',name='R7',do_erc=True),
            Pin(num='19',name='P=R',func=Pin.OUTPUT,do_erc=True)]),
        Part(name='74LS73',dest=TEMPLATE,tool=SKIDL,keywords='TTL JK JKFF',description='Dual JK FlipFlop, reset',ref_prefix='U',num_units=2,do_erc=True,pins=[
            Pin(num='4',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='Cp',do_erc=True),
            Pin(num='6',name='Cd',do_erc=True),
            Pin(num='7',name='J',do_erc=True),
            Pin(num='8',name='~Q',func=Pin.OUTPUT,do_erc=True),
            Pin(num='9',name='Q',func=Pin.OUTPUT,do_erc=True),
            Pin(num='10',name='K',do_erc=True),
            Pin(num='1',name='Cp',do_erc=True),
            Pin(num='2',name='Cd',do_erc=True),
            Pin(num='3',name='K',do_erc=True),
            Pin(num='12',name='Q',func=Pin.OUTPUT,do_erc=True),
            Pin(num='13',name='~Q',func=Pin.OUTPUT,do_erc=True),
            Pin(num='14',name='J',do_erc=True)]),
        Part(name='74LS74',dest=TEMPLATE,tool=SKIDL,keywords='TTL DFF',description='Dual D FlipFlop, Set & Reset',ref_prefix='U',num_units=2,do_erc=True,aliases=['74HC74'],pins=[
            Pin(num='7',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='14',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='Cd',do_erc=True),
            Pin(num='2',name='D',do_erc=True),
            Pin(num='3',name='Cp',do_erc=True),
            Pin(num='4',name='Sd',do_erc=True),
            Pin(num='5',name='Q',func=Pin.OUTPUT,do_erc=True),
            Pin(num='6',name='~Q',func=Pin.OUTPUT,do_erc=True),
            Pin(num='8',name='~Q',func=Pin.OUTPUT,do_erc=True),
            Pin(num='9',name='Q',func=Pin.OUTPUT,do_erc=True),
            Pin(num='10',name='Sd',do_erc=True),
            Pin(num='11',name='Cp',do_erc=True),
            Pin(num='12',name='D',do_erc=True),
            Pin(num='13',name='Cd',do_erc=True)]),
        Part(name='74LS75',dest=TEMPLATE,tool=SKIDL,keywords='TTL DFF Latch',description='4 bits Latch',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='5',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='~Q0',func=Pin.OUTPUT,do_erc=True),
            Pin(num='2',name='D0',do_erc=True),
            Pin(num='3',name='D1',do_erc=True),
            Pin(num='4',name='E23',do_erc=True),
            Pin(num='6',name='D2',do_erc=True),
            Pin(num='7',name='D3',do_erc=True),
            Pin(num='8',name='~Q3',func=Pin.OUTPUT,do_erc=True),
            Pin(num='9',name='Q3',func=Pin.OUTPUT,do_erc=True),
            Pin(num='10',name='Q2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='11',name='~Q2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='12',name='GND',do_erc=True),
            Pin(num='13',name='E01',do_erc=True),
            Pin(num='14',name='~Q1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='15',name='Q1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='16',name='Q0',func=Pin.OUTPUT,do_erc=True)]),
        Part(name='74LS76',dest=TEMPLATE,tool=SKIDL,keywords='TTL JK JKFF',description='Dual JK FlipFlop, Set & Reset',ref_prefix='U',num_units=2,do_erc=True,pins=[
            Pin(num='5',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='13',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='Cp',do_erc=True),
            Pin(num='2',name='Sd',do_erc=True),
            Pin(num='3',name='Cd',do_erc=True),
            Pin(num='4',name='J',do_erc=True),
            Pin(num='14',name='~Q',func=Pin.OUTPUT,do_erc=True),
            Pin(num='15',name='Q',func=Pin.OUTPUT,do_erc=True),
            Pin(num='16',name='K',do_erc=True),
            Pin(num='6',name='Cp',do_erc=True),
            Pin(num='7',name='Sd',do_erc=True),
            Pin(num='8',name='Cd',do_erc=True),
            Pin(num='9',name='J',do_erc=True),
            Pin(num='10',name='~Q',func=Pin.OUTPUT,do_erc=True),
            Pin(num='11',name='Q',func=Pin.OUTPUT,do_erc=True),
            Pin(num='12',name='K',do_erc=True)]),
        Part(name='74LS77',dest=TEMPLATE,tool=SKIDL,keywords='TTL DFF Latch',description='4 bits Latch',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='4',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='D0',do_erc=True),
            Pin(num='2',name='D1',do_erc=True),
            Pin(num='3',name='E23',do_erc=True),
            Pin(num='5',name='D2',do_erc=True),
            Pin(num='6',name='D3',do_erc=True),
            Pin(num='8',name='Q3',func=Pin.OUTPUT,do_erc=True),
            Pin(num='9',name='Q2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='12',name='E01',do_erc=True),
            Pin(num='13',name='Q1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='14',name='Q0',func=Pin.OUTPUT,do_erc=True)]),
        Part(name='74LS78',dest=TEMPLATE,tool=SKIDL,keywords='TTL JK JKFF',description='Dual JK FlipFlop, preset , common clock & reset',ref_prefix='U',num_units=2,do_erc=True,pins=[
            Pin(num='4',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='Cp',do_erc=True),
            Pin(num='5',name='Clr',do_erc=True),
            Pin(num='2',name='Set',do_erc=True),
            Pin(num='3',name='J',do_erc=True),
            Pin(num='12',name='~Q',func=Pin.OUTPUT,do_erc=True),
            Pin(num='13',name='Q',func=Pin.OUTPUT,do_erc=True),
            Pin(num='14',name='K',do_erc=True),
            Pin(num='6',name='Set',do_erc=True),
            Pin(num='7',name='K',do_erc=True),
            Pin(num='8',name='Q',func=Pin.OUTPUT,do_erc=True),
            Pin(num='9',name='~Q',func=Pin.OUTPUT,do_erc=True),
            Pin(num='10',name='J',do_erc=True)]),
        Part(name='74LS83',dest=TEMPLATE,tool=SKIDL,keywords='TTL ADD ARITH ALU',description='4 bits Full Adder',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='5',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='12',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='A4',do_erc=True),
            Pin(num='2',name='S3',func=Pin.OUTPUT,do_erc=True),
            Pin(num='3',name='A3',do_erc=True),
            Pin(num='4',name='B3',do_erc=True),
            Pin(num='6',name='S2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='7',name='B2',do_erc=True),
            Pin(num='8',name='A2',do_erc=True),
            Pin(num='9',name='S1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='10',name='A1',do_erc=True),
            Pin(num='11',name='B1',do_erc=True),
            Pin(num='13',name='C0',do_erc=True),
            Pin(num='14',name='C4',func=Pin.OUTPUT,do_erc=True),
            Pin(num='15',name='S4',func=Pin.OUTPUT,do_erc=True),
            Pin(num='16',name='B4',do_erc=True)]),
        Part(name='74LS85',dest=TEMPLATE,tool=SKIDL,keywords='TTL COMP ARITH',description='4 bits Comparateur',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='8',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='B3',do_erc=True),
            Pin(num='2',name='Ia<b',do_erc=True),
            Pin(num='3',name='Ia=b',do_erc=True),
            Pin(num='4',name='Ia>b',do_erc=True),
            Pin(num='5',name='Oa>b',func=Pin.OUTPUT,do_erc=True),
            Pin(num='6',name='Oa=b',func=Pin.OUTPUT,do_erc=True),
            Pin(num='7',name='Oa<b',func=Pin.OUTPUT,do_erc=True),
            Pin(num='9',name='B0',do_erc=True),
            Pin(num='10',name='A0',do_erc=True),
            Pin(num='11',name='B1',do_erc=True),
            Pin(num='12',name='A1',do_erc=True),
            Pin(num='13',name='A2',do_erc=True),
            Pin(num='14',name='B2',do_erc=True),
            Pin(num='15',name='A3',do_erc=True)]),
        Part(name='74LS86',dest=TEMPLATE,tool=SKIDL,keywords='TTL XOR2',description='Quad XOR 2 inputs',ref_prefix='U',num_units=4,do_erc=True,aliases=['74HC86'],pins=[
            Pin(num='7',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='14',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='IN1',do_erc=True),
            Pin(num='2',name='IN2',do_erc=True),
            Pin(num='3',name='OUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='4',name='IN1',do_erc=True),
            Pin(num='5',name='IN2',do_erc=True),
            Pin(num='6',name='OUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='8',name='OUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='9',name='IN1',do_erc=True),
            Pin(num='10',name='IN2',do_erc=True),
            Pin(num='11',name='OUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='12',name='IN1',do_erc=True),
            Pin(num='13',name='IN2',do_erc=True)]),
        Part(name='74LS90',dest=TEMPLATE,tool=SKIDL,keywords='TTL CNT CNT4',description='BCD Counter ( div 2 & div 5 )',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='5',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='10',name='GND',do_erc=True),
            Pin(num='1',name='CP1..3',do_erc=True),
            Pin(num='2',name='R0(1)',do_erc=True),
            Pin(num='3',name='R0(2)',do_erc=True),
            Pin(num='6',name='R9(1)',do_erc=True),
            Pin(num='7',name='R9(2)',do_erc=True),
            Pin(num='8',name='Q2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='9',name='Q1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='11',name='Q3',func=Pin.OUTPUT,do_erc=True),
            Pin(num='12',name='Q0',func=Pin.OUTPUT,do_erc=True),
            Pin(num='14',name='CP0',do_erc=True)]),
        Part(name='74LS91',dest=TEMPLATE,tool=SKIDL,keywords='TTL SR SR8',description='8 bits Serial Register',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='5',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='10',name='GND',do_erc=True),
            Pin(num='9',name='Ck',do_erc=True),
            Pin(num='11',name='B',do_erc=True),
            Pin(num='12',name='A',do_erc=True),
            Pin(num='13',name='Qh',func=Pin.OUTPUT,do_erc=True),
            Pin(num='14',name='~Qh',func=Pin.OUTPUT,do_erc=True)]),
        Part(name='74LS92',dest=TEMPLATE,tool=SKIDL,keywords='TTL CNT CNT4',description='Divide by 12 counter',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='5',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='10',name='GND',do_erc=True),
            Pin(num='1',name='CP1..3',do_erc=True),
            Pin(num='6',name='R0(1)',do_erc=True),
            Pin(num='7',name='R0(2)',do_erc=True),
            Pin(num='8',name='Q3',func=Pin.OUTPUT,do_erc=True),
            Pin(num='9',name='Q2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='11',name='Q1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='12',name='Q0',func=Pin.OUTPUT,do_erc=True),
            Pin(num='14',name='CP0',do_erc=True)]),
        Part(name='74LS93',dest=TEMPLATE,tool=SKIDL,keywords='TTL CNT CNT4',description='Divide by 2 & 8 counter',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='5',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='10',name='GND',do_erc=True),
            Pin(num='1',name='CP1..3',do_erc=True),
            Pin(num='2',name='R0(1)',do_erc=True),
            Pin(num='3',name='R0(2)',do_erc=True),
            Pin(num='8',name='Q2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='9',name='Q1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='11',name='Q3',func=Pin.OUTPUT,do_erc=True),
            Pin(num='12',name='Q0',func=Pin.OUTPUT,do_erc=True),
            Pin(num='14',name='CP0',do_erc=True)]),
        Part(name='74LS95',dest=TEMPLATE,tool=SKIDL,keywords='TTL SR SR4',description='Shift Register 5 bits ( // in // out )',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='7',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='14',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='Ds',do_erc=True),
            Pin(num='2',name='P0',do_erc=True),
            Pin(num='3',name='P1',do_erc=True),
            Pin(num='4',name='P2',do_erc=True),
            Pin(num='5',name='P3',do_erc=True),
            Pin(num='6',name='Mode',do_erc=True),
            Pin(num='8',name='Cp2.Lshift',do_erc=True),
            Pin(num='9',name='Cp1.Rshift',do_erc=True),
            Pin(num='10',name='Q3',func=Pin.OUTPUT,do_erc=True),
            Pin(num='11',name='Q2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='12',name='Q1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='13',name='Q0',func=Pin.OUTPUT,do_erc=True)]),
        Part(name='74LV14',dest=TEMPLATE,tool=SKIDL,keywords='TTL not inv',description='Hex Inverseur',ref_prefix='U',num_units=6,do_erc=True,pins=[
            Pin(num='7',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='14',name='3.3V',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='~',do_erc=True),
            Pin(num='2',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='3',name='~',do_erc=True),
            Pin(num='4',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='5',name='~',do_erc=True),
            Pin(num='6',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='8',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='9',name='~',do_erc=True),
            Pin(num='10',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='11',name='~',do_erc=True),
            Pin(num='12',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='13',name='~',do_erc=True),
            Pin(num='1',name='~',do_erc=True),
            Pin(num='2',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='3',name='~',do_erc=True),
            Pin(num='4',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='5',name='~',do_erc=True),
            Pin(num='6',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='8',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='9',name='~',do_erc=True),
            Pin(num='10',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='11',name='~',do_erc=True),
            Pin(num='12',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='13',name='~',do_erc=True)]),
        Part(name='MM74C923',dest=TEMPLATE,tool=SKIDL,do_erc=True),
        Part(name='SN74LVC1G332',dest=TEMPLATE,tool=SKIDL,keywords='3 input OR',description='3-input OR Gate',ref_prefix='U',num_units=1,fplist=['SOT-23*', 'SC70*'],do_erc=True,pins=[
            Pin(num='2',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='Vcc',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='~',do_erc=True),
            Pin(num='3',name='~',do_erc=True),
            Pin(num='4',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='6',name='~',do_erc=True),
            Pin(num='1',name='~',do_erc=True),
            Pin(num='2',name='~',do_erc=True),
            Pin(num='3',name='~',func=Pin.OUTPUT,do_erc=True)])])
