from skidl import SKIDL, TEMPLATE, Part, Pin, SchLib

SKIDL_lib_version = '0.0.1'

Altera = SchLib(tool=SKIDL).add_parts(*[
        Part(name='EP1210',dest=TEMPLATE,tool=SKIDL,keywords='EPLD',description='EPLD',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='CLK1',do_erc=True),
            Pin(num='2',name='I0',do_erc=True),
            Pin(num='3',name='I1',do_erc=True),
            Pin(num='4',name='I2',do_erc=True),
            Pin(num='5',name='I3',do_erc=True),
            Pin(num='6',name='I4',do_erc=True),
            Pin(num='7',name='I5',do_erc=True),
            Pin(num='8',name='B10',do_erc=True),
            Pin(num='9',name='B11',do_erc=True),
            Pin(num='10',name='B12',do_erc=True),
            Pin(num='20',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='30',name='A12',do_erc=True),
            Pin(num='40',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='B13',do_erc=True),
            Pin(num='21',name='A33',do_erc=True),
            Pin(num='31',name='A11',do_erc=True),
            Pin(num='12',name='B20',do_erc=True),
            Pin(num='22',name='A32',do_erc=True),
            Pin(num='32',name='A10',do_erc=True),
            Pin(num='13',name='B21',do_erc=True),
            Pin(num='23',name='A31',do_erc=True),
            Pin(num='33',name='I11',do_erc=True),
            Pin(num='14',name='B22',do_erc=True),
            Pin(num='24',name='A30',do_erc=True),
            Pin(num='34',name='I10',do_erc=True),
            Pin(num='15',name='B23',do_erc=True),
            Pin(num='25',name='A23',do_erc=True),
            Pin(num='35',name='I9',do_erc=True),
            Pin(num='16',name='B30',do_erc=True),
            Pin(num='26',name='A22',do_erc=True),
            Pin(num='36',name='I8',do_erc=True),
            Pin(num='17',name='B31',do_erc=True),
            Pin(num='27',name='A21',do_erc=True),
            Pin(num='37',name='I7',do_erc=True),
            Pin(num='18',name='B32',do_erc=True),
            Pin(num='28',name='A20',do_erc=True),
            Pin(num='38',name='I6',do_erc=True),
            Pin(num='19',name='B33',do_erc=True),
            Pin(num='29',name='A13',do_erc=True),
            Pin(num='39',name='VCC',func=Pin.PWRIN,do_erc=True)]),
        Part(name='EP1810',dest=TEMPLATE,tool=SKIDL,keywords='EPLD',description='EPLD',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='I/O_1A',do_erc=True),
            Pin(num='3',name='I/O_2A',do_erc=True),
            Pin(num='4',name='I/O_3A',do_erc=True),
            Pin(num='5',name='I/O_4A',do_erc=True),
            Pin(num='6',name='I/O_5A',do_erc=True),
            Pin(num='7',name='I/O_6A',do_erc=True),
            Pin(num='8',name='I/O_7A',do_erc=True),
            Pin(num='9',name='I/O_8A',do_erc=True),
            Pin(num='10',name='I/O_9A',do_erc=True),
            Pin(num='20',name='INP6',do_erc=True),
            Pin(num='30',name='I/O_20B',do_erc=True),
            Pin(num='40',name='I/O_29C',do_erc=True),
            Pin(num='50',name='INP11',do_erc=True),
            Pin(num='60',name='I/O_40D',do_erc=True),
            Pin(num='11',name='I/O_10A',do_erc=True),
            Pin(num='21',name='INP7',do_erc=True),
            Pin(num='31',name='I/O_21B',do_erc=True),
            Pin(num='41',name='I/O_30C',do_erc=True),
            Pin(num='51',name='CLK3/INP12',do_erc=True),
            Pin(num='61',name='I/O_41D',do_erc=True),
            Pin(num='12',name='I/O_11A',do_erc=True),
            Pin(num='22',name='INP8',do_erc=True),
            Pin(num='32',name='I/O_22B',do_erc=True),
            Pin(num='42',name='I/O_31C',do_erc=True),
            Pin(num='52',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='62',name='I/O_42D',do_erc=True),
            Pin(num='13',name='I/O_12A',do_erc=True),
            Pin(num='23',name='I/O_13B',do_erc=True),
            Pin(num='33',name='I/O_23B',do_erc=True),
            Pin(num='43',name='I/O_32C',do_erc=True),
            Pin(num='53',name='CLK4/INP13',do_erc=True),
            Pin(num='63',name='I/O_43D',do_erc=True),
            Pin(num='14',name='INP1',do_erc=True),
            Pin(num='24',name='I/O_14B',do_erc=True),
            Pin(num='34',name='I/O_24B',do_erc=True),
            Pin(num='44',name='I/O_33C',do_erc=True),
            Pin(num='54',name='INP14',do_erc=True),
            Pin(num='64',name='I/O_44D',do_erc=True),
            Pin(num='15',name='INP2',do_erc=True),
            Pin(num='25',name='I/O_15B',do_erc=True),
            Pin(num='35',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='45',name='I/O_34C',do_erc=True),
            Pin(num='55',name='INP15',do_erc=True),
            Pin(num='65',name='I/O_45D',do_erc=True),
            Pin(num='16',name='INP3',do_erc=True),
            Pin(num='26',name='I/O_16B',do_erc=True),
            Pin(num='36',name='I/O_25C',do_erc=True),
            Pin(num='46',name='I/O_35C',do_erc=True),
            Pin(num='56',name='INP16',do_erc=True),
            Pin(num='66',name='I/O_46D',do_erc=True),
            Pin(num='17',name='INP4/CLK1',do_erc=True),
            Pin(num='27',name='I/O_17B',do_erc=True),
            Pin(num='37',name='I/O_26C',do_erc=True),
            Pin(num='47',name='I/O_36C',do_erc=True),
            Pin(num='57',name='I/O_37D',do_erc=True),
            Pin(num='67',name='I/O_47D',do_erc=True),
            Pin(num='18',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='28',name='I/O_18B',do_erc=True),
            Pin(num='38',name='I/O_27C',do_erc=True),
            Pin(num='48',name='INP9',do_erc=True),
            Pin(num='58',name='I/O_38D',do_erc=True),
            Pin(num='68',name='I/O_48D',do_erc=True),
            Pin(num='19',name='INP5/CLK2',do_erc=True),
            Pin(num='29',name='I/O_19B',do_erc=True),
            Pin(num='39',name='I/O_28C',do_erc=True),
            Pin(num='49',name='INP10',do_erc=True),
            Pin(num='59',name='I/O_39D',do_erc=True)]),
        Part(name='EP300',dest=TEMPLATE,tool=SKIDL,keywords='EPLD',description='EPLD, 8 Macrocell, DIP-20',ref_prefix='U',num_units=1,fplist=['DIP*W7.62mm*'],do_erc=True,aliases=['EP310'],pins=[
            Pin(num='1',name='CLK',do_erc=True),
            Pin(num='2',name='IN1',do_erc=True),
            Pin(num='3',name='IN2',do_erc=True),
            Pin(num='4',name='IN3',do_erc=True),
            Pin(num='5',name='IN4',do_erc=True),
            Pin(num='6',name='IN5',do_erc=True),
            Pin(num='7',name='IN6',do_erc=True),
            Pin(num='8',name='IN7',do_erc=True),
            Pin(num='9',name='IN9',do_erc=True),
            Pin(num='10',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='20',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='IN10',do_erc=True),
            Pin(num='12',name='IO1',do_erc=True),
            Pin(num='13',name='IO2',do_erc=True),
            Pin(num='14',name='IO3',do_erc=True),
            Pin(num='15',name='IO4',do_erc=True),
            Pin(num='16',name='IO5',do_erc=True),
            Pin(num='17',name='IO6',do_erc=True),
            Pin(num='18',name='IO7',do_erc=True),
            Pin(num='19',name='IO8',do_erc=True)]),
        Part(name='EP320',dest=TEMPLATE,tool=SKIDL,keywords='EPLD',description='EPLD',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='CK/IN',do_erc=True),
            Pin(num='2',name='IN2',do_erc=True),
            Pin(num='3',name='IN3',do_erc=True),
            Pin(num='4',name='IN4',do_erc=True),
            Pin(num='5',name='IN5',do_erc=True),
            Pin(num='6',name='IN6',do_erc=True),
            Pin(num='7',name='IN7',do_erc=True),
            Pin(num='8',name='IN8',do_erc=True),
            Pin(num='9',name='IN9',do_erc=True),
            Pin(num='10',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='20',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='I/O11',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='I/O12',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='I/O13',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='I/O14',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='I/O15',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='I/O16',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='I/O17',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='I/O18',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='I/O19',func=Pin.BIDIR,do_erc=True)]),
        Part(name='EP600',dest=TEMPLATE,tool=SKIDL,keywords='EPLD',description='EPLD',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='CLK1',do_erc=True),
            Pin(num='2',name='IN2',do_erc=True),
            Pin(num='3',name='I/O3',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='I/O4',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='I/O5',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='I/O6',func=Pin.PASSIVE,do_erc=True),
            Pin(num='7',name='I/O7',func=Pin.PASSIVE,do_erc=True),
            Pin(num='8',name='I/O8',func=Pin.PASSIVE,do_erc=True),
            Pin(num='9',name='I/O9',func=Pin.PASSIVE,do_erc=True),
            Pin(num='10',name='I/O10',func=Pin.PASSIVE,do_erc=True),
            Pin(num='20',name='I/O20',func=Pin.PASSIVE,do_erc=True),
            Pin(num='11',name='IN11',do_erc=True),
            Pin(num='21',name='I/O21',func=Pin.PASSIVE,do_erc=True),
            Pin(num='12',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='22',name='I/O22',func=Pin.PASSIVE,do_erc=True),
            Pin(num='13',name='CLK2',do_erc=True),
            Pin(num='23',name='IN23',do_erc=True),
            Pin(num='14',name='IN14',do_erc=True),
            Pin(num='24',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='15',name='I/O15',func=Pin.PASSIVE,do_erc=True),
            Pin(num='16',name='I/O16',func=Pin.PASSIVE,do_erc=True),
            Pin(num='17',name='I/O17',func=Pin.PASSIVE,do_erc=True),
            Pin(num='18',name='I/O18',func=Pin.PASSIVE,do_erc=True),
            Pin(num='19',name='I/O19',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='EP910',dest=TEMPLATE,tool=SKIDL,keywords='EPLD',description='EPLD',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='CLK1',do_erc=True),
            Pin(num='2',name='I0',do_erc=True),
            Pin(num='3',name='I1',do_erc=True),
            Pin(num='4',name='I2',do_erc=True),
            Pin(num='5',name='IO0',do_erc=True),
            Pin(num='6',name='IO1',do_erc=True),
            Pin(num='7',name='IO2',do_erc=True),
            Pin(num='8',name='IO3',do_erc=True),
            Pin(num='9',name='IO4',do_erc=True),
            Pin(num='10',name='IO5',do_erc=True),
            Pin(num='20',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='30',name='IO18',do_erc=True),
            Pin(num='40',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='IO6',do_erc=True),
            Pin(num='21',name='CLK2',do_erc=True),
            Pin(num='31',name='IO17',do_erc=True),
            Pin(num='12',name='IO7',do_erc=True),
            Pin(num='22',name='I11',do_erc=True),
            Pin(num='32',name='IO16',do_erc=True),
            Pin(num='13',name='IO8',do_erc=True),
            Pin(num='23',name='I10',do_erc=True),
            Pin(num='33',name='IO15',do_erc=True),
            Pin(num='14',name='IO9',do_erc=True),
            Pin(num='24',name='I9',do_erc=True),
            Pin(num='34',name='IO14',do_erc=True),
            Pin(num='15',name='IO10',do_erc=True),
            Pin(num='25',name='IO23',do_erc=True),
            Pin(num='35',name='IO13',do_erc=True),
            Pin(num='16',name='IO11',do_erc=True),
            Pin(num='26',name='IO22',do_erc=True),
            Pin(num='36',name='IO12',do_erc=True),
            Pin(num='17',name='I3',do_erc=True),
            Pin(num='27',name='IO21',do_erc=True),
            Pin(num='37',name='I8',do_erc=True),
            Pin(num='18',name='I4',do_erc=True),
            Pin(num='28',name='IO20',do_erc=True),
            Pin(num='38',name='I7',do_erc=True),
            Pin(num='19',name='I5',do_erc=True),
            Pin(num='29',name='IO19',do_erc=True),
            Pin(num='39',name='I6',do_erc=True)])])
