from skidl import SKIDL, TEMPLATE, Part, Pin, SchLib

SKIDL_lib_version = '0.0.1'

Xicor = SchLib(tool=SKIDL).add_parts(*[
        Part(name='X9118',dest=TEMPLATE,tool=SKIDL,keywords='digital potentiometer',description='100k Digital Potentiometer, 1024 steps, TSSOP-14',ref_prefix='U',num_units=1,fplist=['TSSOP*4.4x5mm*Pitch0.65mm*'],do_erc=True,pins=[
            Pin(num='1',name='V+',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='A0',do_erc=True),
            Pin(num='4',name='SCL',do_erc=True),
            Pin(num='6',name='SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='V-',func=Pin.PASSIVE,do_erc=True),
            Pin(num='9',name='A1',do_erc=True),
            Pin(num='14',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='~WP',do_erc=True),
            Pin(num='11',name='RW0',func=Pin.PASSIVE,do_erc=True),
            Pin(num='12',name='RH0',func=Pin.PASSIVE,do_erc=True),
            Pin(num='13',name='RL0',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='X9250',dest=TEMPLATE,tool=SKIDL,description='Quad 100k Digital Potentiometer, 256 steps, TSSOP-24/SOIC-24',ref_prefix='U',num_units=1,fplist=['SOIC*7.5x15.4mm*Pitch1.27mm*', 'TSSOP*4.4x7.8mm*Pitch0.65mm*'],do_erc=True,pins=[
            Pin(num='2',name='A0',do_erc=True),
            Pin(num='6',name='V+',func=Pin.PASSIVE,do_erc=True),
            Pin(num='7',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='~CS',do_erc=True),
            Pin(num='13',name='SIN',do_erc=True),
            Pin(num='23',name='SCL',do_erc=True),
            Pin(num='14',name='A1',do_erc=True),
            Pin(num='24',name='~HOLD',do_erc=True),
            Pin(num='18',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='19',name='V-',func=Pin.PASSIVE,do_erc=True),
            Pin(num='1',name='SOUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='3',name='RW3',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='RH3',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='RL3',func=Pin.PASSIVE,do_erc=True),
            Pin(num='8',name='RL0',func=Pin.PASSIVE,do_erc=True),
            Pin(num='9',name='RH0',func=Pin.PASSIVE,do_erc=True),
            Pin(num='10',name='RW0',func=Pin.PASSIVE,do_erc=True),
            Pin(num='20',name='RW2',func=Pin.PASSIVE,do_erc=True),
            Pin(num='21',name='RH2',func=Pin.PASSIVE,do_erc=True),
            Pin(num='12',name='~WP',do_erc=True),
            Pin(num='22',name='RL2',func=Pin.PASSIVE,do_erc=True),
            Pin(num='15',name='RL1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='16',name='RH1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='17',name='RW1',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='X9258',dest=TEMPLATE,tool=SKIDL,description='Quad 50k Digital Potentiometer, 256 steps, TSSOP-24/SOIC-24',ref_prefix='U',num_units=1,fplist=['SOIC*7.5x15.4mm*Pitch1.27mm*', 'TSSOP*4.4x7.8mm*Pitch0.65mm*'],do_erc=True,pins=[
            Pin(num='2',name='A0',do_erc=True),
            Pin(num='6',name='V+',func=Pin.PASSIVE,do_erc=True),
            Pin(num='7',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='A2',do_erc=True),
            Pin(num='13',name='SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='SCL',do_erc=True),
            Pin(num='14',name='A1',do_erc=True),
            Pin(num='24',name='A3',do_erc=True),
            Pin(num='18',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='19',name='V-',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='RW3',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='RH3',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='RL3',func=Pin.PASSIVE,do_erc=True),
            Pin(num='8',name='RL0',func=Pin.PASSIVE,do_erc=True),
            Pin(num='9',name='RH0',func=Pin.PASSIVE,do_erc=True),
            Pin(num='10',name='RW0',func=Pin.PASSIVE,do_erc=True),
            Pin(num='20',name='RW2',func=Pin.PASSIVE,do_erc=True),
            Pin(num='21',name='RH2',func=Pin.PASSIVE,do_erc=True),
            Pin(num='12',name='~WP',do_erc=True),
            Pin(num='22',name='RL2',func=Pin.PASSIVE,do_erc=True),
            Pin(num='15',name='RL1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='16',name='RH1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='17',name='RW1',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='X9258-PART',dest=TEMPLATE,tool=SKIDL,description='X9258, Quad 50k Digital Potentiometer, 256 steps, TSSOP-24/SOIC-24',ref_prefix='U',num_units=5,fplist=['SOIC*7.5x15.4mm*Pitch1.27mm*', 'TSSOP*4.4x7.8mm*Pitch0.65mm*'],do_erc=True,pins=[
            Pin(num='2',name='A0',do_erc=True),
            Pin(num='6',name='V+',func=Pin.PASSIVE,do_erc=True),
            Pin(num='7',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='A2',do_erc=True),
            Pin(num='12',name='~WP',do_erc=True),
            Pin(num='13',name='SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='SCL',do_erc=True),
            Pin(num='14',name='A1',do_erc=True),
            Pin(num='24',name='A3',do_erc=True),
            Pin(num='18',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='19',name='V-',func=Pin.PASSIVE,do_erc=True),
            Pin(num='8',name='RL0',func=Pin.PASSIVE,do_erc=True),
            Pin(num='9',name='RH0',func=Pin.PASSIVE,do_erc=True),
            Pin(num='10',name='RW0',func=Pin.PASSIVE,do_erc=True),
            Pin(num='15',name='RL1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='16',name='RH1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='17',name='RW1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='20',name='RW2',func=Pin.PASSIVE,do_erc=True),
            Pin(num='21',name='RH2',func=Pin.PASSIVE,do_erc=True),
            Pin(num='22',name='RL2',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='RW3',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='RH3',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='RL3',func=Pin.PASSIVE,do_erc=True)])])
