from skidl import SKIDL, TEMPLATE, Part, Pin, SchLib

SKIDL_lib_version = '0.0.1'

maxim = SchLib(tool=SKIDL).add_parts(*[
        Part(name='DS1267_DIP',dest=TEMPLATE,tool=SKIDL,keywords='Dual Digital Potentiometer Maxim',description='Dual Digital Potentiometer, Serial, 256 Steps, DIP-14',ref_prefix='U',num_units=1,fplist=['DIP*W7.62mm*'],do_erc=True,pins=[
            Pin(num='1',name='VB',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='H1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='L1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='W1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='~Reset',do_erc=True),
            Pin(num='6',name='CLK',do_erc=True),
            Pin(num='7',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='DQ',do_erc=True),
            Pin(num='9',name='COUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='10',name='L0',func=Pin.PASSIVE,do_erc=True),
            Pin(num='11',name='H0',func=Pin.PASSIVE,do_erc=True),
            Pin(num='12',name='W0',func=Pin.PASSIVE,do_erc=True),
            Pin(num='13',name='SOUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='14',name='VCC',func=Pin.PWRIN,do_erc=True)]),
        Part(name='DS1267_SOIC',dest=TEMPLATE,tool=SKIDL,keywords='Dual Digital Potentiometer Maxim',description='Dual Digital Potentiometer, Serial, 256 Steps, SOIC-16',ref_prefix='U',num_units=1,fplist=['SOIC*3.9x9.9mm*1.27mm'],do_erc=True,pins=[
            Pin(num='1',name='VB',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='3',name='H1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='L1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='W1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='~Reset',do_erc=True),
            Pin(num='7',name='CLK',do_erc=True),
            Pin(num='8',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='DQ',do_erc=True),
            Pin(num='10',name='COUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='11',name='L0',func=Pin.PASSIVE,do_erc=True),
            Pin(num='12',name='W0',func=Pin.PASSIVE,do_erc=True),
            Pin(num='13',name='H0',func=Pin.PASSIVE,do_erc=True),
            Pin(num='14',name='SOUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='15',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='16',name='VCC',func=Pin.PWRIN,do_erc=True)]),
        Part(name='DS1267_TSSOP',dest=TEMPLATE,tool=SKIDL,keywords='Dual Digital Potentiometer Maxim',description='Dual Digital Potentiometer, Serial, 256 Steps, TSSOP-20',ref_prefix='U',num_units=1,fplist=['TSSOP*4.4x6.5mm*0.65mm*'],do_erc=True,pins=[
            Pin(num='1',name='VB',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='3',name='H1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='L1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='W1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='~Reset',do_erc=True),
            Pin(num='7',name='CLK',do_erc=True),
            Pin(num='8',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='9',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='10',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='20',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='DQ',do_erc=True),
            Pin(num='12',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='13',name='COUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='14',name='L0',func=Pin.PASSIVE,do_erc=True),
            Pin(num='15',name='H0',func=Pin.PASSIVE,do_erc=True),
            Pin(num='16',name='W0',func=Pin.PASSIVE,do_erc=True),
            Pin(num='17',name='SOUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='18',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='19',name='NC',func=Pin.NOCONNECT,do_erc=True)]),
        Part(name='DS1302',dest=TEMPLATE,tool=SKIDL,do_erc=True),
        Part(name='DS1307+',dest=TEMPLATE,tool=SKIDL,do_erc=True,aliases=['DS1307N+', 'DS1307Z+']),
        Part(name='DS1602',dest=TEMPLATE,tool=SKIDL,do_erc=True),
        Part(name='DS1621',dest=TEMPLATE,tool=SKIDL,do_erc=True),
        Part(name='DS1804',dest=TEMPLATE,tool=SKIDL,do_erc=True),
        Part(name='DS1822Z',dest=TEMPLATE,tool=SKIDL,keywords='OneWire 1Wire Dallas Maxim',description='High-Precision 1-Wire Digital Thermometer SOIC-8',ref_prefix='U',num_units=1,fplist=['SOIC-8_3.9x4.9mm_Pitch1.27mm', 'SOIC-8_3.9x4.9mm_Pitch1.27mm*'],do_erc=True,aliases=['DS18B20Z', 'DS18S20Z'],pins=[
            Pin(num='3',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='DQ',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='GND',func=Pin.PWRIN,do_erc=True)]),
        Part(name='DS1825',dest=TEMPLATE,tool=SKIDL,keywords='1Wire OneWire Maxim Dallas',description='Programmable Resolution 1-Wire Digital Thermometer With 4-Bit ID',ref_prefix='U',num_units=1,fplist=['MSOP-8_3x3mm_Pitch0.65mm', 'MSOP-8_3x3mm_Pitch0.65mm*'],do_erc=True,pins=[
            Pin(num='1',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='DQ',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='AD0',do_erc=True),
            Pin(num='6',name='AD1',do_erc=True),
            Pin(num='7',name='AD2',do_erc=True),
            Pin(num='8',name='AD3',do_erc=True)]),
        Part(name='DS18B20U',dest=TEMPLATE,tool=SKIDL,keywords='OneWire 1-Wire 1Wire Maxim Dallas',description='Programmable Resolution 1-Wire Digital Thermometer MSOP-8',ref_prefix='U',num_units=1,fplist=['MSOP-8_3x3mm_Pitch0.65mm', 'MSOP-8_3x3mm_Pitch0.65mm*'],do_erc=True,pins=[
            Pin(num='1',name='DQ',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='VDD',func=Pin.PWRIN,do_erc=True)]),
        Part(name='DS2401P',dest=TEMPLATE,tool=SKIDL,keywords='OneWire 1-Wire 1Wire Maxim Dallas ID',description='Silicon Serial Number TSSOP-6',ref_prefix='U',num_units=1,fplist=['TSSOP-6'],do_erc=True,pins=[
            Pin(num='1',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='DQ',func=Pin.BIDIR,do_erc=True)]),
        Part(name='DS2401Z',dest=TEMPLATE,tool=SKIDL,keywords='OneWire 1-Wire 1Wire Maxim Dallas ID',description='Silicon Serial Number SOT-223',ref_prefix='U',num_units=1,fplist=['SOT-223', 'SOT-223*'],do_erc=True,pins=[
            Pin(num='1',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='DQ',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='GND',func=Pin.PWRIN,do_erc=True)]),
        Part(name='DS2482-100',dest=TEMPLATE,tool=SKIDL,keywords='1-Wire I2C',description='Single-Channel 1-Wire Master, SOIC-8',ref_prefix='U',num_units=1,fplist=['SOIC*3.9x4.9mm*Pitch1.27mm*'],do_erc=True,pins=[
            Pin(num='1',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='SCL',do_erc=True),
            Pin(num='5',name='SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='PCTLZ',func=Pin.OUTPUT,do_erc=True),
            Pin(num='7',name='AD1',do_erc=True),
            Pin(num='8',name='AD0',do_erc=True)]),
        Part(name='DS28EA00',dest=TEMPLATE,tool=SKIDL,keywords='1Wire OneWire Maxim Dallas',description='1-Wire Digital Thermometer with Sequence Detect and PIO',ref_prefix='U',num_units=1,fplist=['MSOP-8_3x3mm_Pitch0.65mm', 'MSOP-8_3x3mm_Pitch0.65mm*'],do_erc=True,pins=[
            Pin(num='1',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='PIOA',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='PIOB',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='VCC',func=Pin.PWRIN,do_erc=True)]),
        Part(name='DS3231',dest=TEMPLATE,tool=SKIDL,keywords='RTC TCXO Realtime Time Clock Crystal Oscillator I2C',description='Extremely Accurate I2C-Integrated RTC/TCXO/Crystal SOIC-16',ref_prefix='U',num_units=1,fplist=['SOIC-*_7.5x10.3mm_Pitch1.27mm*'],do_erc=True,pins=[
            Pin(num='1',name='32KHZ',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='2',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='~INT~/SQW',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='4',name='~RST',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='NC',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='NC',func=Pin.PASSIVE,do_erc=True),
            Pin(num='7',name='NC',func=Pin.PASSIVE,do_erc=True),
            Pin(num='8',name='NC',func=Pin.PASSIVE,do_erc=True),
            Pin(num='9',name='NC',func=Pin.PASSIVE,do_erc=True),
            Pin(num='10',name='NC',func=Pin.PASSIVE,do_erc=True),
            Pin(num='11',name='NC',func=Pin.PASSIVE,do_erc=True),
            Pin(num='12',name='NC',func=Pin.PASSIVE,do_erc=True),
            Pin(num='13',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='14',name='VBAT',func=Pin.PWRIN,do_erc=True),
            Pin(num='15',name='SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='SCL',do_erc=True)]),
        Part(name='DS3231MZ',dest=TEMPLATE,tool=SKIDL,keywords='RTC TCXO Realtime Time Clock MEMS I2C',description='±5ppm, I2C Real-Time Clock SOIC-8',ref_prefix='U',num_units=1,fplist=['SOIC*3.9x4.9mm*Pitch1.27mm*'],do_erc=True,pins=[
            Pin(num='1',name='32KHZ',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='2',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='~INT~/SQW',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='4',name='~RST',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='VBAT',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='SCL',do_erc=True)]),
        Part(name='DS3232M',dest=TEMPLATE,tool=SKIDL,keywords='RTC TCXO Realtime Time Clock MEMS SRAM I2C',description='±5ppm, I2C Real-Time Clock with SRAM SOIC-8',ref_prefix='U',num_units=1,fplist=['SOIC-*_3.9x4.9mm_Pitch1.27mm*'],do_erc=True,pins=[
            Pin(num='1',name='32KHZ',func=Pin.OUTPUT,do_erc=True),
            Pin(num='2',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='~INT~/SQW',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='4',name='~RST',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='VBAT',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='SCL',do_erc=True)]),
        Part(name='MAX1248',dest=TEMPLATE,tool=SKIDL,keywords='10-Bit ADC Serial 4-Channel Maxim',description='4-Channel 10-Bit ADC with Serial Interface, +2.7V to +5.25V, Low-Power',ref_prefix='U',num_units=1,fplist=['DIP*', 'QSOP*'],do_erc=True,aliases=['MAX1249'],pins=[
            Pin(num='1',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='CH0',do_erc=True),
            Pin(num='3',name='CH1',do_erc=True),
            Pin(num='4',name='CH2',do_erc=True),
            Pin(num='5',name='CH3',do_erc=True),
            Pin(num='6',name='COM',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='~SHDN',func=Pin.TRISTATE,do_erc=True),
            Pin(num='8',name='VREF',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='REFADJ',do_erc=True),
            Pin(num='10',name='AGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='DGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='12',name='DOUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='13',name='SSTRB',func=Pin.OUTPUT,do_erc=True),
            Pin(num='14',name='DIN',do_erc=True),
            Pin(num='15',name='~CS',do_erc=True),
            Pin(num='16',name='SCLK',do_erc=True)]),
        Part(name='MAX2606',dest=TEMPLATE,tool=SKIDL,do_erc=True,aliases=['MAX2505', 'MAX2507', 'MAX2508', 'MAX2509']),
        Part(name='MAX31820',dest=TEMPLATE,tool=SKIDL,keywords='OneWire 1-Wire 1Wire Maxim Dallas',description='1-Wire Ambient Temperature Sensor',ref_prefix='U',num_units=1,fplist=['TO-92_*'],do_erc=True,aliases=['DS1822', 'DS18B20', 'DS18S20', 'DS1821C'],pins=[
            Pin(num='1',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='DQ',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='VDD',func=Pin.PWRIN,do_erc=True)]),
        Part(name='MAX31820PAR',dest=TEMPLATE,tool=SKIDL,keywords='OneWire 1-Wire 1Wire Maxim Dallas',description='1-Wire, Parasite-Power, Ambient Temperature Sensor',ref_prefix='U',num_units=1,fplist=['TO-92_*'],do_erc=True,aliases=['DS1822-PAR', 'DS18B20-PAR', 'DS18S20-PAR', 'DS2401'],pins=[
            Pin(num='1',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='DQ',func=Pin.BIDIR,do_erc=True)]),
        Part(name='MAX31826',dest=TEMPLATE,tool=SKIDL,keywords='1Wire OneWire Maxim Dallas',description='1-Wire Digital Temperature Sensor with 1Kb Lockable EEPROM',ref_prefix='U',num_units=1,fplist=['MSOP-8_3x3mm_Pitch0.65mm', 'MSOP-8_3x3mm_Pitch0.65mm*'],do_erc=True,pins=[
            Pin(num='1',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='DQ',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='AD0',do_erc=True),
            Pin(num='6',name='AD1',do_erc=True),
            Pin(num='7',name='AD2',do_erc=True),
            Pin(num='8',name='AD3',do_erc=True)]),
        Part(name='MAX453',dest=TEMPLATE,tool=SKIDL,do_erc=True),
        Part(name='MAX5436',dest=TEMPLATE,tool=SKIDL,do_erc=True),
        Part(name='MAX6355',dest=TEMPLATE,tool=SKIDL,do_erc=True),
        Part(name='MAX7325AEG+',dest=TEMPLATE,tool=SKIDL,do_erc=True),
        Part(name='Max691',dest=TEMPLATE,tool=SKIDL,do_erc=True)])
