from skidl import SKIDL, TEMPLATE, Part, Pin, SchLib

SKIDL_lib_version = '0.0.1'

microchip_pic24mcu = SchLib(tool=SKIDL).add_parts(*[
        Part(name='PIC24FV32KA304-I/PT',dest=TEMPLATE,tool=SKIDL,keywords='Flash-Based 16-Bit Microcontroller',description='32K Flash, 2048B SRAM, 512B EEPROM, nanoWatt XLP, 12-bit ADC, PWM, RTCC, TQFP44',ref_prefix='IC',num_units=1,fplist=['TQFP*10x10mm*Pitch0.8mm*'],do_erc=True,pins=[
            Pin(num='1',name='RB9/DA1/T1CK/~U1RTS~/CTED4/CN21',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='U1RX/CN18/RC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='U1TX/CN17/RC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='OC2/CN20/RC8',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='IC2/CTED7/CN19/RC9',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='RA7/IC1/CTED3/CN9',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='RA6/C2OUT/OC1/CTED1/INT2/CN8',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='RB10/PGED2/SDI1/CTED11/CN16',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='RB11/PGEC2/SCK1/CTED9/CN15',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='RB12/N12/HLVDIN/CTED2/CN14',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='RA1/CVREF-/VREF-/AN1/CN3',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='RA2/OSCI/AN13/CLKI/CN30',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='Vdd',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='RB13/AN11/SDO1/CTPLS/CN13',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='RB0/PGED1/AN2/ULPWU/CTCMP/C1IND/C2INB/C3IND/U2TX/CN4',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='RA3/OSCO/AN14/CLKO/CN29',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='RB5/PGED3/ASDA1*/CN27',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='RA10/OC3/CN35',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='RB1/PGEC1/AN3/C1INC/C2INA/U2RX/CTED12/CN5',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='RA8/OCFB/CN33',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='RB6/PGEC3/ASCL1*/CN24',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='RA11/IC3/CTED8/CN36',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='RB2/AN4/C1INB/C2IND/SDA2/T5CK/T4CK/CTED13/CN6',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='RB4/SOSCI/AN15/~U2RTS~/CN1',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='RB7/INT0/CN23',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='RB14/CVREF/AN10/C3INB/RTCC/C1OUT/OCFA/CTED5/INT1/CN12',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='RB3/AN5/C1INA/C2INC/SCL2/CN7',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='RA4/SOSCO/SCLKI/U2CTS/CN0',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='RB8/SCL1/U1CTS/C3OUT/CTED10',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='RB15/AN9/C3INA/T3CK/T2CK/REFO/SS1/CTED6/CN11',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='AN6/CN32/RC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='RA9/~SS2~/CN34',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='Vss/AVss',func=Pin.PWRIN,do_erc=True),
            Pin(num='26',name='AN7/CN31/RC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='SDI2/CN28/RC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='AVdd/Vdd',func=Pin.PWRIN,do_erc=True),
            Pin(num='27',name='AN8/CN10/RC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='SDO2/CN25/RC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='RA5/~MCLR~/Vpp',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='Vdd',func=Pin.PWRIN,do_erc=True),
            Pin(num='38',name='SCK2/CN26/RC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='RA0/VREF+/CVREF+/AN0/C3INC/CN2',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='Vss',func=Pin.PWRIN,do_erc=True),
            Pin(num='39',name='Vss',func=Pin.PWRIN,do_erc=True)])])
