from skidl import SKIDL, TEMPLATE, Alias, Part, Pin, SchLib

SKIDL_lib_version = "0.0.1"

StickIt_VGA_lib = SchLib(tool=SKIDL).add_parts(
    *[
        Part(
            **{
                "name": "PMOD-12",
                "dest": TEMPLATE,
                "tool": SKIDL,
                "symtx": "H",
                "_match_pin_regex": False,
                "tool_version": "kicad",
                "value_str": "PMOD-12",
                "keywords": "",
                "description": "",
                "datasheet": "",
                "ref_prefix": "PM",
                "num_units": 1,
                "fplist": [],
                "do_erc": True,
                "aliases": Alias(),
                "pin": None,
                "footprint": "xesscorp/xess.pretty:PMOD-12-MALE",
                "pins": [
                    Pin(num="D0", name="D0", func=Pin.types.BIDIR, do_erc=True),
                    Pin(num="D1", name="D1", func=Pin.types.BIDIR, do_erc=True),
                    Pin(num="D2", name="D2", func=Pin.types.BIDIR, do_erc=True),
                    Pin(num="D3", name="D3", func=Pin.types.BIDIR, do_erc=True),
                    Pin(num="D4", name="D4", func=Pin.types.BIDIR, do_erc=True),
                    Pin(num="D5", name="D5", func=Pin.types.BIDIR, do_erc=True),
                    Pin(num="D6", name="D6", func=Pin.types.BIDIR, do_erc=True),
                    Pin(num="D7", name="D7", func=Pin.types.BIDIR, do_erc=True),
                    Pin(num="VCC", name="VCC", func=Pin.types.PWROUT, do_erc=True),
                    Pin(num="GND", name="GND", func=Pin.types.PWROUT, do_erc=True),
                ],
            }
        ),
        Part(
            **{
                "name": "Conn_01x18_Male",
                "dest": TEMPLATE,
                "tool": SKIDL,
                "value_str": "Conn_01x18_Male",
                "_match_pin_regex": False,
                "tool_version": "kicad",
                "keywords": "connector",
                "description": "Generic connector, single row, 01x18, script generated (kicad-library-utils/schlib/autogen/connector/)",
                "datasheet": "~",
                "ref_prefix": "J",
                "num_units": 1,
                "fplist": ["Connector*:*_1x??_*"],
                "do_erc": True,
                "aliases": Alias(),
                "pin": None,
                "footprint": "KiCad_V5/Connector_PinHeader_2.54mm.pretty:Pin_Header_1x18_P2.54mm_Vertical",
                "pins": [
                    Pin(num="1", name="Pin_1", func=Pin.types.PASSIVE, do_erc=True),
                    Pin(num="10", name="Pin_10", func=Pin.types.PASSIVE, do_erc=True),
                    Pin(num="11", name="Pin_11", func=Pin.types.PASSIVE, do_erc=True),
                    Pin(num="12", name="Pin_12", func=Pin.types.PASSIVE, do_erc=True),
                    Pin(num="13", name="Pin_13", func=Pin.types.PASSIVE, do_erc=True),
                    Pin(num="14", name="Pin_14", func=Pin.types.PASSIVE, do_erc=True),
                    Pin(num="15", name="Pin_15", func=Pin.types.PASSIVE, do_erc=True),
                    Pin(num="16", name="Pin_16", func=Pin.types.PASSIVE, do_erc=True),
                    Pin(num="17", name="Pin_17", func=Pin.types.PASSIVE, do_erc=True),
                    Pin(num="18", name="Pin_18", func=Pin.types.PASSIVE, do_erc=True),
                    Pin(num="2", name="Pin_2", func=Pin.types.PASSIVE, do_erc=True),
                    Pin(num="3", name="Pin_3", func=Pin.types.PASSIVE, do_erc=True),
                    Pin(num="4", name="Pin_4", func=Pin.types.PASSIVE, do_erc=True),
                    Pin(num="5", name="Pin_5", func=Pin.types.PASSIVE, do_erc=True),
                    Pin(num="6", name="Pin_6", func=Pin.types.PASSIVE, do_erc=True),
                    Pin(num="7", name="Pin_7", func=Pin.types.PASSIVE, do_erc=True),
                    Pin(num="8", name="Pin_8", func=Pin.types.PASSIVE, do_erc=True),
                    Pin(num="9", name="Pin_9", func=Pin.types.PASSIVE, do_erc=True),
                ],
            }
        ),
        Part(
            **{
                "name": "RN4",
                "dest": TEMPLATE,
                "tool": SKIDL,
                "value_str": "8635",
                "_match_pin_regex": False,
                "tool_version": "kicad",
                "keywords": "",
                "description": "",
                "datasheet": "",
                "ref_prefix": "RN",
                "num_units": 4,
                "fplist": [],
                "do_erc": True,
                "aliases": Alias(),
                "pin": None,
                "footprint": "xesscorp/xess.pretty:CTS_742C083",
                "pins": [
                    Pin(num="1", name="~", func=Pin.types.PASSIVE, do_erc=True),
                    Pin(num="8", name="~", func=Pin.types.PASSIVE, do_erc=True),
                    Pin(num="2", name="~", func=Pin.types.PASSIVE, do_erc=True),
                    Pin(num="7", name="~", func=Pin.types.PASSIVE, do_erc=True),
                    Pin(num="3", name="~", func=Pin.types.PASSIVE, do_erc=True),
                    Pin(num="6", name="~", func=Pin.types.PASSIVE, do_erc=True),
                    Pin(num="4", name="~", func=Pin.types.PASSIVE, do_erc=True),
                    Pin(num="5", name="~", func=Pin.types.PASSIVE, do_erc=True),
                ],
            }
        ),
        Part(
            **{
                "name": "DB15_Female_HighDensity_MountingHoles",
                "dest": TEMPLATE,
                "tool": SKIDL,
                "value_str": "DB15_Female_HighDensity_MountingHoles",
                "_match_pin_regex": False,
                "tool_version": "kicad",
                "keywords": "connector db15 female D-SUB VGA",
                "description": "15-pin female D-SUB connector, High density (3 columns), Triple Row, Generic, VGA-connector, Mounting Hole",
                "datasheet": "~",
                "ref_prefix": "J",
                "num_units": 1,
                "fplist": ["DSUB*Female*"],
                "do_erc": True,
                "aliases": Alias(),
                "pin": None,
                "footprint": "xesscorp/xess.pretty:DB15-3.08mm-HD-FEMALE",
                "pins": [
                    Pin(num="0", name="~", func=Pin.types.PASSIVE, do_erc=True),
                    Pin(num="1", name="~", func=Pin.types.PASSIVE, do_erc=True),
                    Pin(num="10", name="~", func=Pin.types.PASSIVE, do_erc=True),
                    Pin(num="11", name="~", func=Pin.types.PASSIVE, do_erc=True),
                    Pin(num="12", name="~", func=Pin.types.PASSIVE, do_erc=True),
                    Pin(num="13", name="~", func=Pin.types.PASSIVE, do_erc=True),
                    Pin(num="14", name="~", func=Pin.types.PASSIVE, do_erc=True),
                    Pin(num="15", name="~", func=Pin.types.PASSIVE, do_erc=True),
                    Pin(num="2", name="~", func=Pin.types.PASSIVE, do_erc=True),
                    Pin(num="3", name="~", func=Pin.types.PASSIVE, do_erc=True),
                    Pin(num="4", name="~", func=Pin.types.PASSIVE, do_erc=True),
                    Pin(num="5", name="~", func=Pin.types.PASSIVE, do_erc=True),
                    Pin(num="6", name="~", func=Pin.types.PASSIVE, do_erc=True),
                    Pin(num="7", name="~", func=Pin.types.PASSIVE, do_erc=True),
                    Pin(num="8", name="~", func=Pin.types.PASSIVE, do_erc=True),
                    Pin(num="9", name="~", func=Pin.types.PASSIVE, do_erc=True),
                ],
            }
        ),
    ]
)
