# Anti-Cursor

**Anti-Cursor** is a Python CLI utility designed to generate Markdown prompts that provide a comprehensive overview of a project's source code. This tool is particularly useful for interacting with large language models (LLMs), such as GPT, by enabling them to reason about the structure and implementation of a project.

The generated prompt includes:
- A detailed **file structure** to help LLMs understand how the project is organized.
- The **source code** of each file, allowing LLMs to analyze and reason about the project's functionality.

This utility is ideal for tasks such as:
- Debugging or reviewing code with LLMs.
- Generating documentation for projects.
- Summarizing project structure and implementation.

---

## Features

- Accepts either a **local directory path** or a **GitHub repository URL** as input.
- Generates a Markdown prompt with:
  - A clear introduction to assist LLMs in understanding the context.
  - A detailed, tree-like representation of the project's file structure.
  - Code listings from individual source files (excluding files ignored by `.gitignore`).
- Supports multiple output targets:
  - Save the prompt to a file (`prompt.md`).
  - Output the prompt directly to the terminal.
  - Copy the prompt to the clipboard for easy sharing.
- Clean architecture with clear separation between CLI, core logic, and file parsing.
- Unit tests ensure proper functionality.

---

## Installation

### From Source

1. **Clone the repository:**
   ```bash
   git clone https://github.com/Alexander-Ploskin/anti-cursor.git
   ```

2. **Install dependencies:**
   ```bash
   sudo apt-get install xclip  # Required for clipboard functionality on Linux
   pip install poetry
   poetry install
   ```

### From PyPI

Install the package directly from PyPI:
```bash
pip install anti-cursor
```

---

## Usage

Run the CLI tool using:
```bash
anti-cursor <source> [--target <target>]
```

Where `<source>` is either a local directory path or a GitHub repository URL, and `<target>` specifies where to save or display the generated prompt.

### Target Options
The `--target` option allows you to specify where the generated prompt should go:
- `file`: Save the prompt to a file named `prompt.md`.
- `terminal`: Output the prompt directly in the terminal.
- `clipboard`: Copy the prompt to your system clipboard (default).

---

### Examples

1. **Generate a prompt from a local directory and output it to the terminal:**
   ```bash
   anti-cursor . --target terminal
   ```

2. **Generate a prompt from a GitHub repository and copy it to the clipboard:**
   ```bash
   anti-cursor https://github.com/Alexander-Ploskin/anti-cursor --target clipboard
   ```

3. **Generate a prompt from a local directory and save it to `prompt.md`:**
   ```bash
   anti-cursor ./my_project --target file
   ```

### Example of Generated Prompt

Below is an example of what the generated Markdown prompt might look like:

```
## Project Source Code Prompt

Below is the source code of the considered project. The prompt begins with an organized view of the project's file structure, showing how the code is organized across directories and files. Following this overview, the complete source code for each file is provided, allowing for an in-depth understanding of the project's implementation.

### Project Structure

./
├── .gitignore
├── LICENSE
├── README.md
├── pyproject.toml
└── src/
    ├── __init__.py
    ├── cli.py
    ├── project_parser.py
    └── prompt_generator.py

### Source Code Files

#### README.md

#### src/cli.py

import click
from src.prompt_generator import generate_prompt...
...
```

This example demonstrates how Anti-Cursor organizes and presents both project structure and source code in an LLM-friendly format.

---

## Contributing

Contributions are welcome! If you have suggestions or find issues, feel free to open an issue or submit a pull request on GitHub.

---

## License

This project is licensed under the Apache License 2.0. See [LICENSE](./LICENSE) for details.
