"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.LinuxBastion = exports.LinuxPackageManager = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const security_tag_1 = require("./security-tag");
var LinuxPackageManager;
(function (LinuxPackageManager) {
    LinuxPackageManager["APT"] = "apt-get";
    LinuxPackageManager["YUM"] = "yum";
    LinuxPackageManager["DNF"] = "dnf";
})(LinuxPackageManager = exports.LinuxPackageManager || (exports.LinuxPackageManager = {}));
class LinuxBastion extends aws_cdk_lib_1.Resource {
    constructor(scope, id, props) {
        super(scope, id);
        const securityTag = (props === null || props === void 0 ? void 0 : props.securityTag) ? props.securityTag
            : security_tag_1.DefaultSecurityTag;
        this.securityGroup = new aws_cdk_lib_1.aws_ec2.SecurityGroup(this, 'BastionSecurityGroup', {
            vpc: props.vpc,
            allowAllOutbound: true,
        });
        if (props.machineImage &&
            props.machineImage.getImage(this).osType !=
                aws_cdk_lib_1.aws_ec2.OperatingSystemType.LINUX)
            throw 'machineImage is not Linux based';
        const instanceType = props.instanceType
            ? props.instanceType
            : aws_cdk_lib_1.aws_ec2.InstanceType.of(aws_cdk_lib_1.aws_ec2.InstanceClass.T3A, aws_cdk_lib_1.aws_ec2.InstanceSize.LARGE);
        let amazonLinuxCpuType = aws_cdk_lib_1.aws_ec2.AmazonLinuxCpuType.ARM_64;
        if (instanceType.architecture == 'x86_64')
            amazonLinuxCpuType = aws_cdk_lib_1.aws_ec2.AmazonLinuxCpuType.X86_64;
        const machineImage = props.machineImage
            ? props.machineImage
            : aws_cdk_lib_1.aws_ec2.MachineImage.latestAmazonLinux({
                generation: aws_cdk_lib_1.aws_ec2.AmazonLinuxGeneration.AMAZON_LINUX_2,
                cpuType: amazonLinuxCpuType,
            });
        const instanceProps = {
            ...props,
            propagateTagsToVolumeOnCreation: true,
            userDataCausesReplacement: true,
            machineImage,
            instanceType,
        };
        const bastionInstance = new aws_cdk_lib_1.aws_ec2.Instance(this, 'BastionInstance', instanceProps);
        const packageManager = props.packageManager
            ? props.packageManager
            : LinuxPackageManager.DNF;
        bastionInstance.addUserData(`${packageManager} update -y`, `${packageManager} upgrade -y`);
        if (props.packages)
            bastionInstance.addUserData(`${packageManager} install -y ${props.packages.join(' ')}`);
        aws_cdk_lib_1.Tags.of(bastionInstance.instance).add(securityTag.key, securityTag.value);
        bastionInstance.role.addManagedPolicy(aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName('AmazonSSMManagedInstanceCore'));
        this.instanceId = bastionInstance.instanceId;
        this.instanceAvailabilityZone = bastionInstance.instanceAvailabilityZone;
        this.instancePrivateDnsName = bastionInstance.instancePrivateDnsName;
        this.instancePrivateIp = bastionInstance.instancePrivateIp;
        this.grantPrincipal = bastionInstance.grantPrincipal;
        this.instancePublicDnsName = bastionInstance.instancePublicDnsName;
        this.instancePublicIp = bastionInstance.instancePublicIp;
        this.connections = bastionInstance.connections;
        this.role = bastionInstance.role;
    }
}
exports.LinuxBastion = LinuxBastion;
_a = JSII_RTTI_SYMBOL_1;
LinuxBastion[_a] = { fqn: "pwed-cdk.bastion.LinuxBastion", version: "0.0.52" };
//# sourceMappingURL=data:application/json;base64,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